# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LoadBalancingSettingsUpdateParameters(Model):
    """Round-Robin load balancing settings for a backend pool.

    :param sample_size: The number of samples to consider for load balancing
     decisions
    :type sample_size: int
    :param successful_samples_required: The number of samples within the
     sample period that must succeed
    :type successful_samples_required: int
    :param additional_latency_milliseconds: The additional latency in
     milliseconds for probes to fall into the lowest latency bucket
    :type additional_latency_milliseconds: int
    """

    _attribute_map = {
        'sample_size': {'key': 'sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'successfulSamplesRequired', 'type': 'int'},
        'additional_latency_milliseconds': {'key': 'additionalLatencyMilliseconds', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(LoadBalancingSettingsUpdateParameters, self).__init__(**kwargs)
        self.sample_size = kwargs.get('sample_size', None)
        self.successful_samples_required = kwargs.get('successful_samples_required', None)
        self.additional_latency_milliseconds = kwargs.get('additional_latency_milliseconds', None)
