# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CacheConfiguration(Model):
    """Caching settings for a caching-type route. To disable caching, do not
    provide a cacheConfiguration object.

    :param query_parameter_strip_directive: Treatment of URL query terms when
     forming the cache key. Possible values include: 'StripNone', 'StripAll'
    :type query_parameter_strip_directive: str or
     ~azure.mgmt.frontdoor.models.FrontDoorQuery
    :param dynamic_compression: Whether to use dynamic compression for cached
     content. Possible values include: 'Enabled', 'Disabled'
    :type dynamic_compression: str or
     ~azure.mgmt.frontdoor.models.DynamicCompressionEnabled
    """

    _attribute_map = {
        'query_parameter_strip_directive': {'key': 'queryParameterStripDirective', 'type': 'str'},
        'dynamic_compression': {'key': 'dynamicCompression', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CacheConfiguration, self).__init__(**kwargs)
        self.query_parameter_strip_directive = kwargs.get('query_parameter_strip_directive', None)
        self.dynamic_compression = kwargs.get('dynamic_compression', None)
