# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OriginParameters(Model):
    """
    Origin properties needed for origin creation or update

    :param str host_name: The host name of the origin
    :param int http_port: The value of the http port, must be between 1 and
     65535
    :param int https_port: The value of the https port, must be between 1 and
     65535
    """

    _required = ['host_name']

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str', 'flatten': True},
        'http_port': {'key': 'properties.httpPort', 'type': 'int', 'flatten': True},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int', 'flatten': True},
    }

    def __init__(self, host_name, http_port=None, https_port=None):
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
