# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Age Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    YEAR = "Year"
    MONTH = "Month"
    WEEK = "Week"
    DAY = "Day"

class AnalyzeTextLROResultsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported Text Analysis long-running operation task results.
    """

    SENTIMENT_ANALYSIS_LRO_RESULTS = "SentimentAnalysisLROResults"
    ENTITY_RECOGNITION_LRO_RESULTS = "EntityRecognitionLROResults"
    PII_ENTITY_RECOGNITION_LRO_RESULTS = "PiiEntityRecognitionLROResults"
    KEY_PHRASE_EXTRACTION_LRO_RESULTS = "KeyPhraseExtractionLROResults"
    ENTITY_LINKING_LRO_RESULTS = "EntityLinkingLROResults"
    HEALTHCARE_LRO_RESULTS = "HealthcareLROResults"
    EXTRACTIVE_SUMMARIZATION_LRO_RESULTS = "ExtractiveSummarizationLROResults"
    CUSTOM_ENTITY_RECOGNITION_LRO_RESULTS = "CustomEntityRecognitionLROResults"
    CUSTOM_SINGLE_LABEL_CLASSIFICATION_LRO_RESULTS = "CustomSingleLabelClassificationLROResults"
    CUSTOM_MULTI_LABEL_CLASSIFICATION_LRO_RESULTS = "CustomMultiLabelClassificationLROResults"
    ABSTRACTIVE_SUMMARIZATION_LRO_RESULTS = "AbstractiveSummarizationLROResults"

class AnalyzeTextLROTaskKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported long-running Text Analysis tasks.
    """

    SENTIMENT_ANALYSIS = "SentimentAnalysis"
    ENTITY_RECOGNITION = "EntityRecognition"
    PII_ENTITY_RECOGNITION = "PiiEntityRecognition"
    KEY_PHRASE_EXTRACTION = "KeyPhraseExtraction"
    ENTITY_LINKING = "EntityLinking"
    HEALTHCARE = "Healthcare"
    EXTRACTIVE_SUMMARIZATION = "ExtractiveSummarization"
    CUSTOM_ENTITY_RECOGNITION = "CustomEntityRecognition"
    CUSTOM_SINGLE_LABEL_CLASSIFICATION = "CustomSingleLabelClassification"
    CUSTOM_MULTI_LABEL_CLASSIFICATION = "CustomMultiLabelClassification"
    ABSTRACTIVE_SUMMARIZATION = "AbstractiveSummarization"

class AnalyzeTextTaskKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported Text Analysis tasks.
    """

    SENTIMENT_ANALYSIS = "SentimentAnalysis"
    ENTITY_RECOGNITION = "EntityRecognition"
    PII_ENTITY_RECOGNITION = "PiiEntityRecognition"
    KEY_PHRASE_EXTRACTION = "KeyPhraseExtraction"
    LANGUAGE_DETECTION = "LanguageDetection"
    ENTITY_LINKING = "EntityLinking"
    DYNAMIC_CLASSIFICATION = "DynamicClassification"

class AnalyzeTextTaskResultsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported Text Analysis task results.
    """

    SENTIMENT_ANALYSIS_RESULTS = "SentimentAnalysisResults"
    ENTITY_RECOGNITION_RESULTS = "EntityRecognitionResults"
    PII_ENTITY_RECOGNITION_RESULTS = "PiiEntityRecognitionResults"
    KEY_PHRASE_EXTRACTION_RESULTS = "KeyPhraseExtractionResults"
    LANGUAGE_DETECTION_RESULTS = "LanguageDetectionResults"
    ENTITY_LINKING_RESULTS = "EntityLinkingResults"
    DYNAMIC_CLASSIFICATION_RESULTS = "DynamicClassificationResults"

class AreaUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The area Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    SQUARE_KILOMETER = "SquareKilometer"
    SQUARE_HECTOMETER = "SquareHectometer"
    SQUARE_DECAMETER = "SquareDecameter"
    SQUARE_DECIMETER = "SquareDecimeter"
    SQUARE_METER = "SquareMeter"
    SQUARE_CENTIMETER = "SquareCentimeter"
    SQUARE_MILLIMETER = "SquareMillimeter"
    SQUARE_INCH = "SquareInch"
    SQUARE_FOOT = "SquareFoot"
    SQUARE_MILE = "SquareMile"
    SQUARE_YARD = "SquareYard"
    ACRE = "Acre"

class Association(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes if the entity is the subject of the text or if it describes someone else.
    """

    SUBJECT = "subject"
    OTHER = "other"

class Certainty(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the entities certainty and polarity.
    """

    POSITIVE = "positive"
    POSITIVE_POSSIBLE = "positivePossible"
    NEUTRAL_POSSIBLE = "neutralPossible"
    NEGATIVE_POSSIBLE = "negativePossible"
    NEGATIVE = "negative"

class ClassificationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies either one or multiple categories per document. Defaults to multi classification
    which may return more than one class for each document.
    """

    SINGLE = "Single"
    MULTI = "Multi"

class Conditionality(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes any conditionality on the entity.
    """

    HYPOTHETICAL = "hypothetical"
    CONDITIONAL = "conditional"

class DateTimeSubKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The DateTime SubKind.
    """

    TIME = "Time"
    DATE = "Date"
    DATE_TIME = "DateTime"
    DURATION = "Duration"
    SET = "Set"

class DocumentSentimentValue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
    """

    POSITIVE = "positive"
    NEUTRAL = "neutral"
    NEGATIVE = "negative"
    MIXED = "mixed"

class ErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code.
    """

    INVALID_REQUEST = "InvalidRequest"
    INVALID_ARGUMENT = "InvalidArgument"
    UNAUTHORIZED = "Unauthorized"
    FORBIDDEN = "Forbidden"
    NOT_FOUND = "NotFound"
    PROJECT_NOT_FOUND = "ProjectNotFound"
    OPERATION_NOT_FOUND = "OperationNotFound"
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    AZURE_COGNITIVE_SEARCH_INDEX_NOT_FOUND = "AzureCognitiveSearchIndexNotFound"
    TOO_MANY_REQUESTS = "TooManyRequests"
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    AZURE_COGNITIVE_SEARCH_INDEX_LIMIT_REACHED = "AzureCognitiveSearchIndexLimitReached"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    TIMEOUT = "Timeout"
    QUOTA_EXCEEDED = "QuotaExceeded"
    CONFLICT = "Conflict"
    WARNING = "Warning"

class ExtractiveSummarizationSortingCriteria(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sorting criteria to use for the results of Extractive Summarization.
    """

    #: Indicates that results should be sorted in order of appearance in the text.
    OFFSET = "Offset"
    #: Indicates that results should be sorted in order of importance (i.e. rank score) according to
    #: the model.
    RANK = "Rank"

class FhirVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The FHIR Spec version that the result will use to format the fhirBundle. For additional
    information see https://www.hl7.org/fhir/overview.html.
    """

    FOUR0_1 = "4.0.1"

class HealthcareDocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Document type that can be provided as input for Fhir Documents. Expect to have fhirVersion
    provided when used. Behavior of using None enum is the same as not using the documentType
    parameter.
    """

    NONE = "None"
    CLINICAL_TRIAL = "ClinicalTrial"
    DISCHARGE_SUMMARY = "DischargeSummary"
    PROGRESS_NOTE = "ProgressNote"
    HISTORY_AND_PHYSICAL = "HistoryAndPhysical"
    CONSULT = "Consult"
    IMAGING = "Imaging"
    PATHOLOGY = "Pathology"
    PROCEDURE_NOTE = "ProcedureNote"

class HealthcareEntityCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Healthcare Entity Category.
    """

    BODY_STRUCTURE = "BodyStructure"
    AGE = "Age"
    GENDER = "Gender"
    EXAMINATION_NAME = "ExaminationName"
    DATE = "Date"
    DIRECTION = "Direction"
    FREQUENCY = "Frequency"
    MEASUREMENT_VALUE = "MeasurementValue"
    MEASUREMENT_UNIT = "MeasurementUnit"
    RELATIONAL_OPERATOR = "RelationalOperator"
    TIME = "Time"
    GENE_OR_PROTEIN = "GeneOrProtein"
    VARIANT = "Variant"
    ADMINISTRATIVE_EVENT = "AdministrativeEvent"
    CARE_ENVIRONMENT = "CareEnvironment"
    HEALTHCARE_PROFESSION = "HealthcareProfession"
    DIAGNOSIS = "Diagnosis"
    SYMPTOM_OR_SIGN = "SymptomOrSign"
    CONDITION_QUALIFIER = "ConditionQualifier"
    MEDICATION_CLASS = "MedicationClass"
    MEDICATION_NAME = "MedicationName"
    DOSAGE = "Dosage"
    MEDICATION_FORM = "MedicationForm"
    MEDICATION_ROUTE = "MedicationRoute"
    FAMILY_RELATION = "FamilyRelation"
    TREATMENT_NAME = "TreatmentName"

class InformationUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The information (data) Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    BIT = "Bit"
    KILOBIT = "Kilobit"
    MEGABIT = "Megabit"
    GIGABIT = "Gigabit"
    TERABIT = "Terabit"
    PETABIT = "Petabit"
    BYTE = "Byte"
    KILOBYTE = "Kilobyte"
    MEGABYTE = "Megabyte"
    GIGABYTE = "Gigabyte"
    TERABYTE = "Terabyte"
    PETABYTE = "Petabyte"

class InnerErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code.
    """

    INVALID_REQUEST = "InvalidRequest"
    INVALID_PARAMETER_VALUE = "InvalidParameterValue"
    KNOWLEDGE_BASE_NOT_FOUND = "KnowledgeBaseNotFound"
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    EXTRACTION_FAILURE = "ExtractionFailure"
    INVALID_REQUEST_BODY_FORMAT = "InvalidRequestBodyFormat"
    EMPTY_REQUEST = "EmptyRequest"
    MISSING_INPUT_DOCUMENTS = "MissingInputDocuments"
    INVALID_DOCUMENT = "InvalidDocument"
    MODEL_VERSION_INCORRECT = "ModelVersionIncorrect"
    INVALID_DOCUMENT_BATCH = "InvalidDocumentBatch"
    UNSUPPORTED_LANGUAGE_CODE = "UnsupportedLanguageCode"
    INVALID_COUNTRY_HINT = "InvalidCountryHint"

class LengthUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The length Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    KILOMETER = "Kilometer"
    HECTOMETER = "Hectometer"
    DECAMETER = "Decameter"
    METER = "Meter"
    DECIMETER = "Decimeter"
    CENTIMETER = "Centimeter"
    MILLIMETER = "Millimeter"
    MICROMETER = "Micrometer"
    NANOMETER = "Nanometer"
    PICOMETER = "Picometer"
    MILE = "Mile"
    YARD = "Yard"
    INCH = "Inch"
    FOOT = "Foot"
    LIGHT_YEAR = "LightYear"
    PT = "Pt"

class NumberKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the extracted number entity.
    """

    INTEGER = "Integer"
    DECIMAL = "Decimal"
    POWER = "Power"
    FRACTION = "Fraction"
    PERCENT = "Percent"
    UNSPECIFIED = "Unspecified"

class PiiCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PiiCategory.
    """

    ABA_ROUTING_NUMBER = "ABARoutingNumber"
    AR_NATIONAL_IDENTITY_NUMBER = "ARNationalIdentityNumber"
    AU_BANK_ACCOUNT_NUMBER = "AUBankAccountNumber"
    AU_DRIVERS_LICENSE_NUMBER = "AUDriversLicenseNumber"
    AU_MEDICAL_ACCOUNT_NUMBER = "AUMedicalAccountNumber"
    AU_PASSPORT_NUMBER = "AUPassportNumber"
    AU_TAX_FILE_NUMBER = "AUTaxFileNumber"
    AU_BUSINESS_NUMBER = "AUBusinessNumber"
    AU_COMPANY_NUMBER = "AUCompanyNumber"
    AT_IDENTITY_CARD = "ATIdentityCard"
    AT_TAX_IDENTIFICATION_NUMBER = "ATTaxIdentificationNumber"
    AT_VALUE_ADDED_TAX_NUMBER = "ATValueAddedTaxNumber"
    AZURE_DOCUMENT_DB_AUTH_KEY = "AzureDocumentDBAuthKey"
    AZURE_IAAS_DATABASE_CONNECTION_AND_SQL_STRING = "AzureIAASDatabaseConnectionAndSQLString"
    AZURE_IO_T_CONNECTION_STRING = "AzureIoTConnectionString"
    AZURE_PUBLISH_SETTING_PASSWORD = "AzurePublishSettingPassword"
    AZURE_REDIS_CACHE_STRING = "AzureRedisCacheString"
    AZURE_SAS = "AzureSAS"
    AZURE_SERVICE_BUS_STRING = "AzureServiceBusString"
    AZURE_STORAGE_ACCOUNT_KEY = "AzureStorageAccountKey"
    AZURE_STORAGE_ACCOUNT_GENERIC = "AzureStorageAccountGeneric"
    BE_NATIONAL_NUMBER = "BENationalNumber"
    BE_NATIONAL_NUMBER_V2 = "BENationalNumberV2"
    BE_VALUE_ADDED_TAX_NUMBER = "BEValueAddedTaxNumber"
    BRCPF_NUMBER = "BRCPFNumber"
    BR_LEGAL_ENTITY_NUMBER = "BRLegalEntityNumber"
    BR_NATIONAL_IDRG = "BRNationalIDRG"
    BG_UNIFORM_CIVIL_NUMBER = "BGUniformCivilNumber"
    CA_BANK_ACCOUNT_NUMBER = "CABankAccountNumber"
    CA_DRIVERS_LICENSE_NUMBER = "CADriversLicenseNumber"
    CA_HEALTH_SERVICE_NUMBER = "CAHealthServiceNumber"
    CA_PASSPORT_NUMBER = "CAPassportNumber"
    CA_PERSONAL_HEALTH_IDENTIFICATION = "CAPersonalHealthIdentification"
    CA_SOCIAL_INSURANCE_NUMBER = "CASocialInsuranceNumber"
    CL_IDENTITY_CARD_NUMBER = "CLIdentityCardNumber"
    CN_RESIDENT_IDENTITY_CARD_NUMBER = "CNResidentIdentityCardNumber"
    CREDIT_CARD_NUMBER = "CreditCardNumber"
    HR_IDENTITY_CARD_NUMBER = "HRIdentityCardNumber"
    HR_NATIONAL_ID_NUMBER = "HRNationalIDNumber"
    HR_PERSONAL_IDENTIFICATION_NUMBER = "HRPersonalIdentificationNumber"
    HR_PERSONAL_IDENTIFICATION_OIB_NUMBER_V2 = "HRPersonalIdentificationOIBNumberV2"
    CY_IDENTITY_CARD = "CYIdentityCard"
    CY_TAX_IDENTIFICATION_NUMBER = "CYTaxIdentificationNumber"
    CZ_PERSONAL_IDENTITY_NUMBER = "CZPersonalIdentityNumber"
    CZ_PERSONAL_IDENTITY_V2 = "CZPersonalIdentityV2"
    DK_PERSONAL_IDENTIFICATION_NUMBER = "DKPersonalIdentificationNumber"
    DK_PERSONAL_IDENTIFICATION_V2 = "DKPersonalIdentificationV2"
    DRUG_ENFORCEMENT_AGENCY_NUMBER = "DrugEnforcementAgencyNumber"
    EE_PERSONAL_IDENTIFICATION_CODE = "EEPersonalIdentificationCode"
    EU_DEBIT_CARD_NUMBER = "EUDebitCardNumber"
    EU_DRIVERS_LICENSE_NUMBER = "EUDriversLicenseNumber"
    EUGPS_COORDINATES = "EUGPSCoordinates"
    EU_NATIONAL_IDENTIFICATION_NUMBER = "EUNationalIdentificationNumber"
    EU_PASSPORT_NUMBER = "EUPassportNumber"
    EU_SOCIAL_SECURITY_NUMBER = "EUSocialSecurityNumber"
    EU_TAX_IDENTIFICATION_NUMBER = "EUTaxIdentificationNumber"
    FI_EUROPEAN_HEALTH_NUMBER = "FIEuropeanHealthNumber"
    FI_NATIONAL_ID = "FINationalID"
    FI_NATIONAL_IDV2 = "FINationalIDV2"
    FI_PASSPORT_NUMBER = "FIPassportNumber"
    FR_DRIVERS_LICENSE_NUMBER = "FRDriversLicenseNumber"
    FR_HEALTH_INSURANCE_NUMBER = "FRHealthInsuranceNumber"
    FR_NATIONAL_ID = "FRNationalID"
    FR_PASSPORT_NUMBER = "FRPassportNumber"
    FR_SOCIAL_SECURITY_NUMBER = "FRSocialSecurityNumber"
    FR_TAX_IDENTIFICATION_NUMBER = "FRTaxIdentificationNumber"
    FR_VALUE_ADDED_TAX_NUMBER = "FRValueAddedTaxNumber"
    DE_DRIVERS_LICENSE_NUMBER = "DEDriversLicenseNumber"
    DE_PASSPORT_NUMBER = "DEPassportNumber"
    DE_IDENTITY_CARD_NUMBER = "DEIdentityCardNumber"
    DE_TAX_IDENTIFICATION_NUMBER = "DETaxIdentificationNumber"
    DE_VALUE_ADDED_NUMBER = "DEValueAddedNumber"
    GR_NATIONAL_ID_CARD = "GRNationalIDCard"
    GR_NATIONAL_IDV2 = "GRNationalIDV2"
    GR_TAX_IDENTIFICATION_NUMBER = "GRTaxIdentificationNumber"
    HK_IDENTITY_CARD_NUMBER = "HKIdentityCardNumber"
    HU_VALUE_ADDED_NUMBER = "HUValueAddedNumber"
    HU_PERSONAL_IDENTIFICATION_NUMBER = "HUPersonalIdentificationNumber"
    HU_TAX_IDENTIFICATION_NUMBER = "HUTaxIdentificationNumber"
    IN_PERMANENT_ACCOUNT = "INPermanentAccount"
    IN_UNIQUE_IDENTIFICATION_NUMBER = "INUniqueIdentificationNumber"
    ID_IDENTITY_CARD_NUMBER = "IDIdentityCardNumber"
    INTERNATIONAL_BANKING_ACCOUNT_NUMBER = "InternationalBankingAccountNumber"
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER = "IEPersonalPublicServiceNumber"
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER_V2 = "IEPersonalPublicServiceNumberV2"
    IL_BANK_ACCOUNT_NUMBER = "ILBankAccountNumber"
    IL_NATIONAL_ID = "ILNationalID"
    IT_DRIVERS_LICENSE_NUMBER = "ITDriversLicenseNumber"
    IT_FISCAL_CODE = "ITFiscalCode"
    IT_VALUE_ADDED_TAX_NUMBER = "ITValueAddedTaxNumber"
    JP_BANK_ACCOUNT_NUMBER = "JPBankAccountNumber"
    JP_DRIVERS_LICENSE_NUMBER = "JPDriversLicenseNumber"
    JP_PASSPORT_NUMBER = "JPPassportNumber"
    JP_RESIDENT_REGISTRATION_NUMBER = "JPResidentRegistrationNumber"
    JP_SOCIAL_INSURANCE_NUMBER = "JPSocialInsuranceNumber"
    JP_MY_NUMBER_CORPORATE = "JPMyNumberCorporate"
    JP_MY_NUMBER_PERSONAL = "JPMyNumberPersonal"
    JP_RESIDENCE_CARD_NUMBER = "JPResidenceCardNumber"
    LV_PERSONAL_CODE = "LVPersonalCode"
    LT_PERSONAL_CODE = "LTPersonalCode"
    LU_NATIONAL_IDENTIFICATION_NUMBER_NATURAL = "LUNationalIdentificationNumberNatural"
    LU_NATIONAL_IDENTIFICATION_NUMBER_NON_NATURAL = "LUNationalIdentificationNumberNonNatural"
    MY_IDENTITY_CARD_NUMBER = "MYIdentityCardNumber"
    MT_IDENTITY_CARD_NUMBER = "MTIdentityCardNumber"
    MT_TAX_ID_NUMBER = "MTTaxIDNumber"
    NL_CITIZENS_SERVICE_NUMBER = "NLCitizensServiceNumber"
    NL_CITIZENS_SERVICE_NUMBER_V2 = "NLCitizensServiceNumberV2"
    NL_TAX_IDENTIFICATION_NUMBER = "NLTaxIdentificationNumber"
    NL_VALUE_ADDED_TAX_NUMBER = "NLValueAddedTaxNumber"
    NZ_BANK_ACCOUNT_NUMBER = "NZBankAccountNumber"
    NZ_DRIVERS_LICENSE_NUMBER = "NZDriversLicenseNumber"
    NZ_INLAND_REVENUE_NUMBER = "NZInlandRevenueNumber"
    NZ_MINISTRY_OF_HEALTH_NUMBER = "NZMinistryOfHealthNumber"
    NZ_SOCIAL_WELFARE_NUMBER = "NZSocialWelfareNumber"
    NO_IDENTITY_NUMBER = "NOIdentityNumber"
    PH_UNIFIED_MULTI_PURPOSE_ID_NUMBER = "PHUnifiedMultiPurposeIDNumber"
    PL_IDENTITY_CARD = "PLIdentityCard"
    PL_NATIONAL_ID = "PLNationalID"
    PL_NATIONAL_IDV2 = "PLNationalIDV2"
    PL_PASSPORT_NUMBER = "PLPassportNumber"
    PL_TAX_IDENTIFICATION_NUMBER = "PLTaxIdentificationNumber"
    PLREGON_NUMBER = "PLREGONNumber"
    PT_CITIZEN_CARD_NUMBER = "PTCitizenCardNumber"
    PT_CITIZEN_CARD_NUMBER_V2 = "PTCitizenCardNumberV2"
    PT_TAX_IDENTIFICATION_NUMBER = "PTTaxIdentificationNumber"
    RO_PERSONAL_NUMERICAL_CODE = "ROPersonalNumericalCode"
    RU_PASSPORT_NUMBER_DOMESTIC = "RUPassportNumberDomestic"
    RU_PASSPORT_NUMBER_INTERNATIONAL = "RUPassportNumberInternational"
    SA_NATIONAL_ID = "SANationalID"
    SG_NATIONAL_REGISTRATION_IDENTITY_CARD_NUMBER = "SGNationalRegistrationIdentityCardNumber"
    SK_PERSONAL_NUMBER = "SKPersonalNumber"
    SI_TAX_IDENTIFICATION_NUMBER = "SITaxIdentificationNumber"
    SI_UNIQUE_MASTER_CITIZEN_NUMBER = "SIUniqueMasterCitizenNumber"
    ZA_IDENTIFICATION_NUMBER = "ZAIdentificationNumber"
    KR_RESIDENT_REGISTRATION_NUMBER = "KRResidentRegistrationNumber"
    ESDNI = "ESDNI"
    ES_SOCIAL_SECURITY_NUMBER = "ESSocialSecurityNumber"
    ES_TAX_IDENTIFICATION_NUMBER = "ESTaxIdentificationNumber"
    SQL_SERVER_CONNECTION_STRING = "SQLServerConnectionString"
    SE_NATIONAL_ID = "SENationalID"
    SE_NATIONAL_IDV2 = "SENationalIDV2"
    SE_PASSPORT_NUMBER = "SEPassportNumber"
    SE_TAX_IDENTIFICATION_NUMBER = "SETaxIdentificationNumber"
    SWIFT_CODE = "SWIFTCode"
    CH_SOCIAL_SECURITY_NUMBER = "CHSocialSecurityNumber"
    TW_NATIONAL_ID = "TWNationalID"
    TW_PASSPORT_NUMBER = "TWPassportNumber"
    TW_RESIDENT_CERTIFICATE = "TWResidentCertificate"
    TH_POPULATION_IDENTIFICATION_CODE = "THPopulationIdentificationCode"
    TR_NATIONAL_IDENTIFICATION_NUMBER = "TRNationalIdentificationNumber"
    UK_DRIVERS_LICENSE_NUMBER = "UKDriversLicenseNumber"
    UK_ELECTORAL_ROLL_NUMBER = "UKElectoralRollNumber"
    UK_NATIONAL_HEALTH_NUMBER = "UKNationalHealthNumber"
    UK_NATIONAL_INSURANCE_NUMBER = "UKNationalInsuranceNumber"
    UK_UNIQUE_TAXPAYER_NUMBER = "UKUniqueTaxpayerNumber"
    USUK_PASSPORT_NUMBER = "USUKPassportNumber"
    US_BANK_ACCOUNT_NUMBER = "USBankAccountNumber"
    US_DRIVERS_LICENSE_NUMBER = "USDriversLicenseNumber"
    US_INDIVIDUAL_TAXPAYER_IDENTIFICATION = "USIndividualTaxpayerIdentification"
    US_SOCIAL_SECURITY_NUMBER = "USSocialSecurityNumber"
    UA_PASSPORT_NUMBER_DOMESTIC = "UAPassportNumberDomestic"
    UA_PASSPORT_NUMBER_INTERNATIONAL = "UAPassportNumberInternational"
    ORGANIZATION = "Organization"
    EMAIL = "Email"
    URL = "URL"
    AGE = "Age"
    PHONE_NUMBER = "PhoneNumber"
    IP_ADDRESS = "IPAddress"
    DATE = "Date"
    PERSON = "Person"
    ADDRESS = "Address"
    ALL = "All"
    DEFAULT = "Default"

class PiiDomain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The PII domain used for PII Entity Recognition.
    """

    #: Indicates that entities in the Personal Health Information domain should be redacted.
    PHI = "phi"
    #: Indicates that no domain is specified.
    NONE = "none"

class RangeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of range that the resolution object represents.
    """

    NUMBER = "Number"
    SPEED = "Speed"
    WEIGHT = "Weight"
    LENGTH = "Length"
    VOLUME = "Volume"
    AREA = "Area"
    AGE = "Age"
    INFORMATION = "Information"
    TEMPERATURE = "Temperature"
    CURRENCY = "Currency"

class RelationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of relation. Examples include: ``DosageOfMedication`` or 'FrequencyOfMedication', etc.
    """

    ABBREVIATION = "Abbreviation"
    DIRECTION_OF_BODY_STRUCTURE = "DirectionOfBodyStructure"
    DIRECTION_OF_CONDITION = "DirectionOfCondition"
    DIRECTION_OF_EXAMINATION = "DirectionOfExamination"
    DIRECTION_OF_TREATMENT = "DirectionOfTreatment"
    DOSAGE_OF_MEDICATION = "DosageOfMedication"
    FORM_OF_MEDICATION = "FormOfMedication"
    FREQUENCY_OF_MEDICATION = "FrequencyOfMedication"
    FREQUENCY_OF_TREATMENT = "FrequencyOfTreatment"
    QUALIFIER_OF_CONDITION = "QualifierOfCondition"
    RELATION_OF_EXAMINATION = "RelationOfExamination"
    ROUTE_OF_MEDICATION = "RouteOfMedication"
    TIME_OF_CONDITION = "TimeOfCondition"
    TIME_OF_EVENT = "TimeOfEvent"
    TIME_OF_EXAMINATION = "TimeOfExamination"
    TIME_OF_MEDICATION = "TimeOfMedication"
    TIME_OF_TREATMENT = "TimeOfTreatment"
    UNIT_OF_CONDITION = "UnitOfCondition"
    UNIT_OF_EXAMINATION = "UnitOfExamination"
    VALUE_OF_CONDITION = "ValueOfCondition"
    VALUE_OF_EXAMINATION = "ValueOfExamination"

class RelativeTo(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reference point that the ordinal number denotes.
    """

    CURRENT = "Current"
    END = "End"
    START = "Start"

class ResolutionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The entity resolution object kind.
    """

    DATE_TIME_RESOLUTION = "DateTimeResolution"
    NUMBER_RESOLUTION = "NumberResolution"
    ORDINAL_RESOLUTION = "OrdinalResolution"
    SPEED_RESOLUTION = "SpeedResolution"
    WEIGHT_RESOLUTION = "WeightResolution"
    LENGTH_RESOLUTION = "LengthResolution"
    VOLUME_RESOLUTION = "VolumeResolution"
    AREA_RESOLUTION = "AreaResolution"
    AGE_RESOLUTION = "AgeResolution"
    INFORMATION_RESOLUTION = "InformationResolution"
    TEMPERATURE_RESOLUTION = "TemperatureResolution"
    CURRENCY_RESOLUTION = "CurrencyResolution"
    NUMERIC_RANGE_RESOLUTION = "NumericRangeResolution"
    TEMPORAL_SPAN_RESOLUTION = "TemporalSpanResolution"

class ScriptKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifies the script of the input document.
    """

    LATIN = "Latin"

class SentenceSentimentValue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The predicted Sentiment for the sentence.
    """

    POSITIVE = "positive"
    NEUTRAL = "neutral"
    NEGATIVE = "negative"

class SpeedUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The speed Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    METER_PER_SECOND = "MeterPerSecond"
    KILOMETER_PER_HOUR = "KilometerPerHour"
    KILOMETER_PER_MINUTE = "KilometerPerMinute"
    KILOMETER_PER_SECOND = "KilometerPerSecond"
    MILE_PER_HOUR = "MilePerHour"
    KNOT = "Knot"
    FOOT_PER_SECOND = "FootPerSecond"
    FOOT_PER_MINUTE = "FootPerMinute"
    YARD_PER_MINUTE = "YardPerMinute"
    YARD_PER_SECOND = "YardPerSecond"
    METER_PER_MILLISECOND = "MeterPerMillisecond"
    CENTIMETER_PER_MILLISECOND = "CentimeterPerMillisecond"
    KILOMETER_PER_MILLISECOND = "KilometerPerMillisecond"

class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the task at the mentioned last update time.
    """

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    CANCELLED = "cancelled"
    CANCELLING = "cancelling"
    PARTIALLY_COMPLETED = "partiallyCompleted"

class StringIndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes)
    according to Unicode v8.0.0. For additional information see
    https://aka.ms/text-analytics-offsets.
    """

    #: Returned offset and length values will correspond to TextElements (Graphemes and Grapheme
    #: clusters) confirming to the Unicode 8.0.0 standard. Use this option if your application is
    #: written in .Net Framework or .Net Core and you will be using StringInfo.
    TEXT_ELEMENTS_V8 = "TextElements_v8"
    #: Returned offset and length values will correspond to Unicode code points. Use this option if
    #: your application is written in a language that support Unicode, for example Python.
    UNICODE_CODE_POINT = "UnicodeCodePoint"
    #: Returned offset and length values will correspond to UTF-16 code units. Use this option if your
    #: application is written in a language that support Unicode, for example Java, JavaScript.
    UTF16_CODE_UNIT = "Utf16CodeUnit"

class TargetRelationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type related to the target.
    """

    ASSESSMENT = "assessment"
    TARGET = "target"

class TemperatureUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The temperature Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    FAHRENHEIT = "Fahrenheit"
    KELVIN = "Kelvin"
    RANKINE = "Rankine"
    CELSIUS = "Celsius"

class TemporalModifier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An optional modifier of a date/time instance.
    """

    AFTER_APPROX = "AfterApprox"
    BEFORE = "Before"
    BEFORE_START = "BeforeStart"
    APPROX = "Approx"
    REFERENCE_UNDEFINED = "ReferenceUndefined"
    SINCE_END = "SinceEnd"
    AFTER_MID = "AfterMid"
    START = "Start"
    AFTER = "After"
    BEFORE_END = "BeforeEnd"
    UNTIL = "Until"
    END = "End"
    LESS = "Less"
    SINCE = "Since"
    AFTER_START = "AfterStart"
    BEFORE_APPROX = "BeforeApprox"
    MID = "Mid"
    MORE = "More"

class TokenSentimentValue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Targeted sentiment in the sentence.
    """

    POSITIVE = "positive"
    MIXED = "mixed"
    NEGATIVE = "negative"

class VolumeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Volume Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    CUBIC_METER = "CubicMeter"
    CUBIC_CENTIMETER = "CubicCentimeter"
    CUBIC_MILLIMETER = "CubicMillimeter"
    HECTOLITER = "Hectoliter"
    DECALITER = "Decaliter"
    LITER = "Liter"
    CENTILITER = "Centiliter"
    MILLILITER = "Milliliter"
    CUBIC_YARD = "CubicYard"
    CUBIC_INCH = "CubicInch"
    CUBIC_FOOT = "CubicFoot"
    CUBIC_MILE = "CubicMile"
    FLUID_OUNCE = "FluidOunce"
    TEASPOON = "Teaspoon"
    TABLESPOON = "Tablespoon"
    PINT = "Pint"
    QUART = "Quart"
    CUP = "Cup"
    GILL = "Gill"
    PINCH = "Pinch"
    FLUID_DRAM = "FluidDram"
    BARREL = "Barrel"
    MINIM = "Minim"
    CORD = "Cord"
    PECK = "Peck"
    BUSHEL = "Bushel"
    HOGSHEAD = "Hogshead"

class WarningCodeValue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Error code.
    """

    LONG_WORDS_IN_DOCUMENT = "LongWordsInDocument"
    DOCUMENT_TRUNCATED = "DocumentTruncated"

class WeightUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The weight Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    KILOGRAM = "Kilogram"
    GRAM = "Gram"
    MILLIGRAM = "Milligram"
    GALLON = "Gallon"
    METRIC_TON = "MetricTon"
    TON = "Ton"
    POUND = "Pound"
    OUNCE = "Ounce"
    GRAIN = "Grain"
    PENNY_WEIGHT = "PennyWeight"
    LONG_TON_BRITISH = "LongTonBritish"
    SHORT_TON_US = "ShortTonUS"
    SHORT_HUNDRED_WEIGHT_US = "ShortHundredWeightUS"
    STONE = "Stone"
    DRAM = "Dram"
