/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared;

import be.fedict.eid.applet.shared.AbstractProtocolMessage;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.annotation.Description;
import be.fedict.eid.applet.shared.annotation.HttpBody;
import be.fedict.eid.applet.shared.annotation.HttpHeader;
import be.fedict.eid.applet.shared.annotation.MessageDiscriminator;
import be.fedict.eid.applet.shared.annotation.NotNull;
import be.fedict.eid.applet.shared.annotation.PostConstruct;
import be.fedict.eid.applet.shared.annotation.ProtocolStateAllowed;
import be.fedict.eid.applet.shared.annotation.ResponsesAllowed;
import be.fedict.eid.applet.shared.protocol.ProtocolState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResponsesAllowed(value={FinishedMessage.class})
@ProtocolStateAllowed(value=ProtocolState.SIGN)
public class SignatureDataMessage
extends AbstractProtocolMessage {
    @HttpHeader(value="X-AppletProtocol-Type")
    @MessageDiscriminator
    public static final String TYPE = SignatureDataMessage.class.getSimpleName();
    @HttpHeader(value="X-AppletProtocol-SignatureValueSize")
    @NotNull
    public Integer signatureValueSize;
    @HttpHeader(value="X-AppletProtocol-SignCertFileSize")
    @NotNull
    public Integer signCertFileSize;
    @HttpHeader(value="X-AppletProtocol-CaCertFileSize")
    @NotNull
    public Integer caCertFileSize;
    @HttpHeader(value="X-AppletProtocol-RootCaCertFileSize")
    @NotNull
    public Integer rootCertFileSize;
    @HttpBody
    @NotNull
    @Description(value="Contains concatenation of signature value and sign cert chain.")
    public byte[] body;
    public byte[] signatureValue;
    public List<X509Certificate> certificateChain;

    public SignatureDataMessage() {
    }

    public SignatureDataMessage(byte[] signatureValue, List<X509Certificate> signCertChain) throws IOException, CertificateEncodingException {
        this(signatureValue, signCertChain.get(0).getEncoded(), signCertChain.get(1).getEncoded(), signCertChain.get(2).getEncoded());
    }

    public SignatureDataMessage(byte[] signatureValue, byte[] signCertFile, byte[] citizenCaCertFile, byte[] rootCaCertFile) throws IOException, CertificateEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.signatureValueSize = signatureValue.length;
        baos.write(signatureValue);
        baos.write(signCertFile);
        baos.write(citizenCaCertFile);
        baos.write(rootCaCertFile);
        this.body = baos.toByteArray();
        this.signCertFileSize = signCertFile.length;
        this.caCertFileSize = citizenCaCertFile.length;
        this.rootCertFileSize = rootCaCertFile.length;
    }

    private byte[] copy(byte[] source, int idx, int count) {
        byte[] result = new byte[count];
        System.arraycopy(source, idx, result, 0, count);
        return result;
    }

    @PostConstruct
    public void postConstruct() {
        int idx = 0;
        this.signatureValue = this.copy(this.body, idx, this.signatureValueSize);
        byte[] signCertFile = this.copy(this.body, idx += this.signatureValueSize.intValue(), this.signCertFileSize);
        X509Certificate signCert = this.getCertificate(signCertFile);
        byte[] citizenCaCertFile = this.copy(this.body, idx += this.signCertFileSize.intValue(), this.caCertFileSize);
        X509Certificate citizenCaCert = this.getCertificate(citizenCaCertFile);
        byte[] rootCaCertFile = this.copy(this.body, idx += this.caCertFileSize.intValue(), this.rootCertFileSize);
        idx += this.rootCertFileSize.intValue();
        X509Certificate rootCaCert = this.getCertificate(rootCaCertFile);
        this.certificateChain = new LinkedList<X509Certificate>();
        this.certificateChain.add(signCert);
        this.certificateChain.add(citizenCaCert);
        this.certificateChain.add(rootCaCert);
    }

    private X509Certificate getCertificate(byte[] certData) {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("cert factory error: " + e.getMessage(), e);
        }
        try {
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certData));
            return certificate;
        }
        catch (CertificateException e) {
            return null;
        }
    }
}

