/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;

public class AuthenticationContract {
    public static final int SALT_TAG = 1;
    public static final int HOSTNAME_TAG = 2;
    public static final int INET_ADDRESS_TAG = 3;
    public static final int LEGAL_NOTICE_TAG = 4;
    public static final int SESSION_ID_TAG = 5;
    public static final int ENCODED_SERVER_CERTIFICATE_TAG = 6;
    public static final int CHALLENGE_TAG = 7;
    private final byte[] salt;
    private final String hostname;
    private final InetAddress inetAddress;
    public static final String LEGAL_NOTICE = "Declaration of authentication intension.\nThe following data should be interpreted as an authentication challenge.\n";
    private final byte[] sessionId;
    private final byte[] encodedServerCertificate;
    private final byte[] challenge;

    public AuthenticationContract(byte[] salt, String hostname, InetAddress inetAddress, byte[] sessionId, byte[] encodedServerCertificate, byte[] challenge) {
        this.salt = salt;
        this.hostname = hostname;
        this.inetAddress = inetAddress;
        this.sessionId = sessionId;
        this.encodedServerCertificate = encodedServerCertificate;
        this.challenge = challenge;
    }

    public byte[] calculateToBeSigned() throws IOException {
        ByteArrayOutputStream toBeSignedOutputStream = new ByteArrayOutputStream();
        this.writeTag(1, this.salt, toBeSignedOutputStream);
        if (null != this.hostname) {
            this.writeTag(2, this.hostname.getBytes(), toBeSignedOutputStream);
        }
        if (null != this.inetAddress) {
            byte[] address = this.inetAddress.getAddress();
            this.writeTag(3, address, toBeSignedOutputStream);
        }
        this.writeTag(4, LEGAL_NOTICE.getBytes(), toBeSignedOutputStream);
        if (null != this.sessionId) {
            this.writeTag(5, this.sessionId, toBeSignedOutputStream);
        }
        if (null != this.encodedServerCertificate) {
            this.writeTag(6, this.encodedServerCertificate, toBeSignedOutputStream);
        }
        this.writeTag(7, this.challenge, toBeSignedOutputStream);
        byte[] toBeSigned = toBeSignedOutputStream.toByteArray();
        return toBeSigned;
    }

    private void writeTag(int tag, byte[] value, OutputStream outputStream) throws IOException {
        outputStream.write(this.intToByteArray(tag));
        if (null == value) {
            outputStream.write(this.intToByteArray(0));
        } else {
            outputStream.write(this.intToByteArray(value.length));
            outputStream.write(value);
        }
    }

    private byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }
}

