from __future__ import annotations

from dataclasses import asdict, dataclass, field

POSSIBLE_TYPES = [
    "Network",
    "HostNetwork",
    "OpaqueNetwork",
    "DistributedVirtualPortgroup",
    "VirtualMachine",
    "Folder",
]


class Empty:
    pass


@dataclass
class CategorySpec:
    name: str
    description: str = "Autogenerated by Cloudshell"
    cardinality: str = "MULTIPLE"
    associable_types: list[str] = field(default_factory=lambda: POSSIBLE_TYPES)

    def to_dict(self):
        return asdict(self)


@dataclass
class Category(CategorySpec):
    id: str = Empty  # noqa: A003
    used_by: list[str] = Empty


@dataclass
class TagSpec:
    name: str
    category_id: str
    description: str = ""

    def to_dict(self):
        return asdict(self)


@dataclass
class Tag(TagSpec):
    id: str = Empty  # noqa: A003
    used_by: list[str] = Empty
