/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.ma;

import java.util.ArrayList;
import org.snu.ids.ha.constants.POSTag;
import org.snu.ids.ha.constants.Symbol;
import org.snu.ids.ha.ma.CharSetType;
import org.snu.ids.ha.ma.Token;
import org.snu.ids.ha.util.Util;

public class Morpheme
extends Token {
    protected long infoEnc = 0L;
    ArrayList<String> compNounList = null;

    protected Morpheme() {
    }

    public Morpheme(String string, int index) {
        this.index = index;
        this.string = string;
        this.charSet = CharSetType.HANGUL;
        this.infoEnc = POSTag.UN;
    }

    public Morpheme(String string, long tagNum) {
        this.string = string;
        this.charSet = CharSetType.HANGUL;
        this.infoEnc = tagNum;
    }

    public Morpheme(String string, String tag, String compType) {
        this.string = string;
        this.charSet = CharSetType.HANGUL;
        this.infoEnc = POSTag.getTagNum(tag);
        this.setComposed(compType);
    }

    public Morpheme(Token token) {
        this.index = token.index;
        this.string = token.string;
        this.charSet = token.charSet;
        this.infoEnc = token.isCharSetOf(CharSetType.HANGUL) ? POSTag.UN : (token.isCharSetOf(CharSetType.NUMBER) ? POSTag.NR : (token.isCharSetOf(CharSetType.ENGLISH) || token.isCharSetOf(CharSetType.COMBINED) ? POSTag.OL : (token.isCharSetOf(CharSetType.HANMUN) ? POSTag.OH : (token.isCharSetOf(CharSetType.EMOTICON) ? POSTag.EMO : Symbol.getSymbolTag(token.string)))));
    }

    public Morpheme(Morpheme mp) {
        this.index = mp.index;
        this.string = mp.string;
        this.charSet = mp.charSet;
        this.infoEnc = mp.infoEnc;
    }

    public String getTag() {
        return POSTag.getTag(this.getTagNum());
    }

    public void setTag(String tag) {
        this.setTag(POSTag.getTagNum(tag));
    }

    public void setTag(long tagNum) {
        this.infoEnc = this.infoEnc & Long.MIN_VALUE | Long.MAX_VALUE & tagNum;
    }

    public long getTagNum() {
        return this.infoEnc & Long.MAX_VALUE;
    }

    public boolean isComposed() {
        return this.infoEnc < 0L;
    }

    public String getComposed() {
        return this.isComposed() ? "C" : "S";
    }

    public void setComposed(boolean composed) {
        this.infoEnc = composed ? (this.infoEnc |= Long.MIN_VALUE) : (this.infoEnc &= Long.MAX_VALUE);
    }

    public void setComposed(String compType) {
        this.setComposed(Util.valid(compType) && compType.equals("C"));
    }

    public boolean isTag(long tagNum) {
        return this.getTagNum() == tagNum;
    }

    public boolean isTagOf(long tagNum) {
        return (this.infoEnc & Long.MAX_VALUE & tagNum) > 0L;
    }

    public void append(Morpheme mp) {
        if (mp.isTag(POSTag.XSM)) {
            this.setTag(POSTag.MAG);
        } else if (!mp.isTag(POSTag.EFR)) {
            this.setTag(mp.getTagNum());
        } else if (mp.isTag(POSTag.EFR) && this.isTagOf(POSTag.EC) && (this.string.equals("\uc544") || this.string.equals("\uc5b4") || this.string.equals("\uad6c") || this.string.equals("\uace0"))) {
            this.setTag(POSTag.EFN);
        }
        this.string = String.valueOf(this.string) + mp.string;
        this.setComposed(false);
    }

    @Override
    public Morpheme copy() {
        Morpheme copy = new Morpheme();
        copy.string = this.string;
        copy.charSet = this.charSet;
        copy.index = this.index;
        copy.infoEnc = this.infoEnc;
        return copy;
    }

    static Morpheme create(String source) {
        Morpheme ret = null;
        if (source.startsWith("/")) {
            ret = new Morpheme("/", "SY", null);
        } else {
            String[] arr = source.split("/");
            ret = new Morpheme(arr[0], arr[1], arr.length > 2 ? arr[2] : null);
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.index) + "/" + this.string + "/" + this.getTag() + (this.isComposed() ? "/C" : ""));
        return sb.toString();
    }

    public String getSmplStr() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.string) + "/" + this.getTag());
        return sb.toString();
    }

    public String getSmplStr2() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.string) + "/" + this.getTag() + (this.isComposed() ? "/C" : ""));
        return sb.toString();
    }

    String getEncStr() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.string) + "/" + this.infoEnc);
        return sb.toString();
    }
}

