/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.util.Set;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public final class ArgCheck {
    private ArgCheck() {
    }

    public static <T> T requireNonNull(T obj) throws NullPointerException {
        return ArgCheck.requireNonNull(obj, "Reference cannot be null");
    }

    public static <T> T requireNonNull(T obj, String errMsg) throws NullPointerException {
        if (obj == null) {
            throw new NullPointerException(errMsg);
        }
        return obj;
    }

    public static long requirePostive(long l) throws IllegalArgumentException {
        return ArgCheck.requirePostive(l, "long value must be positive");
    }

    public static long requirePostive(long l, String msg) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException(msg);
        }
        return l;
    }

    public static long requireStrictlyPostive(long l) throws IllegalArgumentException {
        return ArgCheck.requireStrictlyPostive(l, "long value must be strictly positive");
    }

    public static long requireStrictlyPostive(long l, String msg) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(msg);
        }
        return l;
    }

    public static int requirePostive(int i) throws IllegalArgumentException {
        return ArgCheck.requirePostive(i, "integer value must be positive");
    }

    public static int requirePostive(int i, String msg) throws IllegalArgumentException {
        if (i < 0) {
            throw new IllegalArgumentException(msg);
        }
        return i;
    }

    public static int requireStrictlyPostive(int i) throws IllegalArgumentException {
        return ArgCheck.requireStrictlyPostive(i, "long value must be strictly positive");
    }

    public static int requireStrictlyPostive(int i, String msg) throws IllegalArgumentException {
        if (i <= 0) {
            throw new IllegalArgumentException(msg);
        }
        return i;
    }

    public static <T> Set<T> setWithoutNull(Set<T> set) throws NullPointerException {
        return ArgCheck.setWithoutNull(set, "Set cannot contains null value");
    }

    public static <T> Set<T> setWithoutNull(Set<T> set, String msg) throws NullPointerException {
        boolean b;
        try {
            b = set.contains(null);
        }
        catch (NullPointerException e) {
            return set;
        }
        if (b) {
            throw new NullPointerException(msg);
        }
        return set;
    }
}

