
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class DocumentTree(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getTreeDocumentContent(self,documentListName, documentName):
		""" Retrieve the content associated with the document, such as a product image or PDF specifications file.
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| documentName (string) - The name of the document in the site.
		
		Returns:
			| Stream 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documentTree/{documentName}/content", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("documentName", documentName);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getTreeDocument(self,documentListName, documentName, responseFields = None):
		""" Retrieves a document based on its document list and folder path in the document hierarchy.
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| documentName (string) - The name of the document in the site.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Document 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documentTree/{documentName}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("documentName", documentName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateTreeDocumentContent(self,stream, documentListName, documentName, contentType = None):
		""" Updates the content associated with a document, such as a product image or PDF specifications file, based on the document's position in the document hierarchy.
		
		Args:
			| stream(stream) - Data stream that delivers information. Used to input and output data.
			| documentListName (string) - Name of content documentListName to delete
			| documentName (string) - The name of the document in the site.
			| contentType (string) - set content type of the data uploaded|
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documentTree/{documentName}/content?folderPath={folderPath}&folderId={folderId}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("documentName", documentName);
		self.client.withResourceUrl(url).withBody(stream).withContentType(contentType).execute();

	
		
	def deleteTreeDocumentContent(self,stream, documentListName, documentName, contentType = None):
		""" Deletes the content associated with a document, such as a product image or PDF specifications file.
		
		Args:
			| stream(stream) - Data stream that delivers information. Used to input and output data.
			| documentListName (string) - Name of content documentListName to delete
			| documentName (string) - The name of the document in the site.
			| contentType (string) - set content type of the data uploaded|
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documentTree/{documentName}/content?folderPath={folderPath}&folderId={folderId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("documentName", documentName);
		self.client.withResourceUrl(url).withBody(stream).withContentType(contentType).execute();

	
	
	