
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class TaxableTerritory(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def getTaxableTerritories(self,):
		""" Retrieves a list of the taxable territories configured for the site.
		
		Returns:
			| array of TaxableTerritory 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/general/taxableterritories", "GET", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addTaxableTerritory(self,taxableTerritory, responseFields = None):
		""" Creates a new territory for which to calculate sales tax.
		
		Args:
			| taxableTerritory(taxableTerritory) - Properties of the territory which is subject to sales tax.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| TaxableTerritory 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/general/taxableterritories?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(taxableTerritory).execute();
		return self.client.result();

	
		
	def updateTaxableTerritories(self,taxableterritories):
		""" Updates one or more taxable territories configured for a site.
		
		Args:
			| taxableterritories(array|taxableterritories) - Properties of the territory which is subject to sales tax.
		
		Returns:
			| array of TaxableTerritory 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/general/taxableterritories", "PUT", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).withBody(taxableterritories).execute();
		return self.client.result();

	
	
	