
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Package(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def getPackageLabel(self,returnId, packageId):
		""" Retrieves the package label image supplied by the carrier for a return replacement.
		
		Args:
			| returnId (string) - Unique identifier of the return whose items you want to get.
			| packageId (string) - Unique identifier of the package for which to retrieve the label.
		
		Returns:
			| Stream 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/returns/{returnId}/packages/{packageId}/label", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("packageId", packageId);
		url.formatUrl("returnId", returnId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getPackage(self,returnId, packageId, responseFields = None):
		""" Retrieves the details of a package of return replacement items.
		
		Args:
			| returnId (string) - Unique identifier of the return whose items you want to get.
			| packageId (string) - Unique identifier of the package for which to retrieve the label.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Package 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/returns/{returnId}/packages/{packageId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("packageId", packageId);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("returnId", returnId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createPackage(self,package, returnId, responseFields = None):
		""" Creates a new physical package of return replacement items.
		
		Args:
			| package(package) - Properties of a physical package shipped for an order.
			| returnId (string) - Unique identifier of the return whose items you want to get.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Package 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/returns/{returnId}/packages?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("returnId", returnId);
		self.client.withResourceUrl(url).withBody(package).execute();
		return self.client.result();

	
		
	def updatePackage(self,package, returnId, packageId, responseFields = None):
		""" Updates one or more properties of a package associated with a return replacement.
		
		Args:
			| package(package) - Properties of a physical package shipped for an order.
			| returnId (string) - Unique identifier of the return whose items you want to get.
			| packageId (string) - Unique identifier of the package for which to retrieve the label.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Package 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/returns/{returnId}/packages/{packageId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("packageId", packageId);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("returnId", returnId);
		self.client.withResourceUrl(url).withBody(package).execute();
		return self.client.result();

	
		
	def deletePackage(self,returnId, packageId):
		""" Deletes a package associated with a return replacement.
		
		Args:
			| returnId (string) - Unique identifier of the return whose items you want to get.
			| packageId (string) - Unique identifier of the package for which to retrieve the label.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/returns/{returnId}/packages/{packageId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("packageId", packageId);
		url.formatUrl("returnId", returnId);
		self.client.withResourceUrl(url).execute();

	
	
	