
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class ProductVariation(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getProductVariationLocalizedDeltaPrices(self,productCode, variationKey):
		""" Retrieves a collection of the localized delta price values for a product variation. Localized delta prices are deltas between two differing monetary conversion amounts between countries, such as US Dollar vs Euro.
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
		
		Returns:
			| array of ProductVariationDeltaPrice 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}/localizedDeltaPrice", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getProductVariationLocalizedDeltaPrice(self,productCode, variationKey, currencyCode, responseFields = None):
		""" Retrieves the localized delta price value for a product variation. Localized delta prices are deltas between two differing monetary conversion amounts between countries, such as US Dollar vs Euro.
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
			| currencyCode (string) - The three character ISO currency code, such as USD for US Dollars.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductVariationDeltaPrice 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}/localizedDeltaPrice/{currencyCode}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("currencyCode", currencyCode);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getProductVariation(self,productCode, variationKey, responseFields = None):
		""" Retrieves the details of a product variation based on the supplied product code and variation key.
		
		Args:
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductVariation 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getProductVariations(self,productCode, startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieves a list of the product variations configured for the specified product code.
		
		Args:
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - The property by which to sort results and whether the results appear in ascending (a-z) order, represented by ASC or in descending (z-a) order, represented by DESC. The sortBy parameter follows an available property. For example: "sortBy=productCode+asc"
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductVariationPagedCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addProductVariationLocalizedDeltaPrice(self,localizedDeltaPrice, productCode, variationKey, responseFields = None):
		""" Adds the localized delta price value for a product variation. Localized delta prices are deltas between two differing monetary conversion amounts between countries, such as US Dollar vs Euro.
		
		Args:
			| localizedDeltaPrice(localizedDeltaPrice) - The difference between the base price for the product and this variation of the product, which can be a positive or negative decimal value. For example, if the base price for a t-shirt product is $10, but the XL variation should cost $12, the DeltaPrice value should be "2". However, if the XS variation should only cost $8, the DeltaPrice value should be "-2".
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductVariationDeltaPrice 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}/localizedDeltaPrice?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).withBody(localizedDeltaPrice).execute();
		return self.client.result();

	
		
	def updateProductVariationLocalizedDeltaPrices(self,localizedDeltaPrice, productCode, variationKey):
		""" Updates all localized delta price values for a product variation. Localized delta prices are deltas between two differing monetary conversion amounts between countries, such as US Dollar vs Euro.
		
		Args:
			| localizedDeltaPrice(array|localizedDeltaPrice) - The difference between the base price for the product and this variation of the product, which can be a positive or negative decimal value. For example, if the base price for a t-shirt product is $10, but the XL variation should cost $12, the DeltaPrice value should be "2". However, if the XS variation should only cost $8, the DeltaPrice value should be "-2".
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
		
		Returns:
			| array of ProductVariationDeltaPrice 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}/localizedDeltaPrice", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).withBody(localizedDeltaPrice).execute();
		return self.client.result();

	
		
	def updateProductVariationLocalizedDeltaPrice(self,localizedDeltaPrice, productCode, variationKey, currencyCode, responseFields = None):
		""" Updatesthe localized delta price value for a product variation. Localized delta prices are deltas between two differing monetary conversion amounts between countries, such as US Dollar vs Euro.
		
		Args:
			| localizedDeltaPrice(localizedDeltaPrice) - The difference between the base price for the product and this variation of the product, which can be a positive or negative decimal value. For example, if the base price for a t-shirt product is $10, but the XL variation should cost $12, the DeltaPrice value should be "2". However, if the XS variation should only cost $8, the DeltaPrice value should be "-2".
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
			| currencyCode (string) - The three character ISO currency code, such as USD for US Dollars.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductVariationDeltaPrice 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}/localizedDeltaPrice/{currencyCode}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("currencyCode", currencyCode);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).withBody(localizedDeltaPrice).execute();
		return self.client.result();

	
		
	def updateProductVariation(self,productVariation, productCode, variationKey, responseFields = None):
		""" Modifies the details of a variation, based on the supplied variation key, for the specified product code.
		
		Args:
			| productVariation(productVariation) - Properties of a specific product variation.
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductVariation 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).withBody(productVariation).execute();
		return self.client.result();

	
		
	def updateProductVariations(self,productVariations, productCode, responseFields = None):
		""" Modifies the collection of variations for the specified product code. Because this PUT replaces the existing resource, supply all information necessary to maintain for the product variation.
		
		Args:
			| productVariations(productVariations) - Collection of variations configured for a product.
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| ProductVariationCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(productVariations).execute();
		return self.client.result();

	
		
	def deleteProductVariation(self,productCode, variationKey):
		""" Deletes a variation, based on the supplied variation key, for the specified product code.
		
		Args:
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).execute();

	
		
	def deleteProductVariationLocalizedDeltaPrice(self,productCode, variationKey, currencyCode):
		""" Deletes the localized delta price value for a product variation. Localized delta prices are deltas between two differing monetary conversion amounts between countries, such as US Dollar vs Euro.
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| variationKey (string) - System-generated key that represents the attribute values that uniquely identify a specific product variation.
			| currencyCode (string) - The three character ISO currency code, such as USD for US Dollars.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/variations/{variationKey}/localizedDeltaPrice/{currencyCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("currencyCode", currencyCode);
		url.formatUrl("productCode", productCode);
		url.formatUrl("variationKey", variationKey);
		self.client.withResourceUrl(url).execute();

	
	
	