
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class AttributeVocabularyValue(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def getAttributeVocabularyValues(self,attributeFQN):
		""" Retrieves a list of vocabulary values defined for the attribute specified in the request.
		
		Args:
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
		
		Returns:
			| array of AttributeVocabularyValue 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getAttributeVocabularyValueLocalizedContents(self,attributeFQN, value):
		""" Retrieves a collection of localized content for vocabulary value attributes based on a  localeCode . 
		
		Args:
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
		
		Returns:
			| array of AttributeVocabularyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}/LocalizedContent", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getAttributeVocabularyValueLocalizedContent(self,attributeFQN, value, localeCode, responseFields = None):
		""" Retrieves the localized content for a vocabulary value attribute based on a  localeCode . 
		
		Args:
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeVocabularyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}/LocalizedContent/{localeCode}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getAttributeVocabularyValue(self,attributeFQN, value, responseFields = None):
		""" Retrieves the details of a vocabulary value defined for an attribute by providing the attribute's fully qualified name and the value to retrieve.
		
		Args:
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| value (string) - The value string to create.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeVocabularyValue 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addAttributeVocabularyValueLocalizedContent(self,localizedContent, attributeFQN, value, responseFields = None):
		""" Creates and saves localized vocabulary value content for an attribute, based on the  localeCode .
		
		Args:
			| localizedContent(localizedContent) - The localized text for the string value of a product attribute.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeVocabularyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}/localizedContent?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def addAttributeVocabularyValue(self,attributeVocabularyValue, attributeFQN, responseFields = None):
		""" Creates a vocabulary value for a defined product attribute.
		
		Args:
			| attributeVocabularyValue(attributeVocabularyValue) - Properties of a vocabulary value defined for an extensible attribute.
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeVocabularyValue 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(attributeVocabularyValue).execute();
		return self.client.result();

	
		
	def updateAttributeVocabularyValues(self,vocabularyValues, attributeFQN):
		""" Update existing vocabulary values for an attribute.
		
		Args:
			| vocabularyValues(array|vocabularyValues) - Properties of a vocabulary value defined for an extensible attribute.
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
		
		Returns:
			| array of AttributeVocabularyValue 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		self.client.withResourceUrl(url).withBody(vocabularyValues).execute();
		return self.client.result();

	
		
	def updateAttributeVocabularyValueLocalizedContents(self,localizedContent, attributeFQN, value):
		""" Updates a collection of localized vocabulary value content for existing attributes, based on the  localeCode .
		
		Args:
			| localizedContent(array|localizedContent) - The localized text for the string value of a product attribute.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
		
		Returns:
			| array of AttributeVocabularyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}/LocalizedContent", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def updateAttributeVocabularyValueLocalizedContent(self,localizedContent, attributeFQN, value, localeCode, responseFields = None):
		""" Updates localized vocabulary value content for an existing attribute, based on the  localeCode .
		
		Args:
			| localizedContent(localizedContent) - The localized text for the string value of a product attribute.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| localeCode (string) - The two character country code that sets the locale, such as US for United States. Sites, tenants, and catalogs use locale codes for localizing content, such as translated product text per supported country.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeVocabularyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}/LocalizedContent/{localeCode}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def updateAttributeVocabularyValue(self,attributeVocabularyValue, attributeFQN, value, responseFields = None):
		""" Updates existing attribute vocabulary values.
		
		Args:
			| attributeVocabularyValue(attributeVocabularyValue) - Properties of a vocabulary value defined for an extensible attribute.
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| value (string) - The value string to create.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| AttributeVocabularyValue 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).withBody(attributeVocabularyValue).execute();
		return self.client.result();

	
		
	def deleteAttributeVocabularyValue(self,attributeFQN, value):
		""" Deletes an attribute's vocabulary value.
		
		Args:
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| value (string) - The value string to create.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();

	
		
	def deleteAttributeVocabularyValueLocalizedContent(self,attributeFQN, value, localeCode):
		""" Removes localized content for a vocabulary value attribute. 
		
		Args:
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/attributedefinition/attributes/{attributeFQN}/VocabularyValues/{value}/LocalizedContent/{localeCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();

	
	
	