# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError

from .. import models


class DatabaseVulnerabilityAssessmentRuleBaselinesOperations(object):
    """DatabaseVulnerabilityAssessmentRuleBaselinesOperations operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar vulnerability_assessment_name: The name of the vulnerability assessment. Constant value: "default".
    :ivar api_version: The API version to use for the request. Constant value: "2020-11-01-preview".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.vulnerability_assessment_name = "default"
        self.api_version = "2020-11-01-preview"

        self.config = config

    def get(
            self, resource_group_name, server_name, database_name, rule_id, baseline_name, custom_headers=None, raw=False, **operation_config):
        """Gets a database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that
         contains the resource. You can obtain this value from the Azure
         Resource Manager API or the portal.
        :type resource_group_name: str
        :param server_name: The name of the server.
        :type server_name: str
        :param database_name: The name of the database for which the
         vulnerability assessment rule baseline is defined.
        :type database_name: str
        :param rule_id: The vulnerability assessment rule ID.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule
         baseline (default implies a baseline on a database level rule and
         master for server level rule). Possible values include: 'master',
         'default'
        :type baseline_name: str or
         ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: DatabaseVulnerabilityAssessmentRuleBaseline or
         ClientRawResponse if raw=true
        :rtype:
         ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        # Construct URL
        url = self.get.metadata['url']
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'serverName': self._serialize.url("server_name", server_name, 'str'),
            'databaseName': self._serialize.url("database_name", database_name, 'str'),
            'vulnerabilityAssessmentName': self._serialize.url("self.vulnerability_assessment_name", self.vulnerability_assessment_name, 'str'),
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'baselineName': self._serialize.url("baseline_name", baseline_name, 'VulnerabilityAssessmentPolicyBaselineName'),
            'subscriptionId': self._serialize.url("self.config.subscription_id", self.config.subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DatabaseVulnerabilityAssessmentRuleBaseline', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}'}

    def create_or_update(
            self, resource_group_name, server_name, database_name, rule_id, baseline_name, baseline_results, custom_headers=None, raw=False, **operation_config):
        """Creates or updates a database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that
         contains the resource. You can obtain this value from the Azure
         Resource Manager API or the portal.
        :type resource_group_name: str
        :param server_name: The name of the server.
        :type server_name: str
        :param database_name: The name of the database for which the
         vulnerability assessment rule baseline is defined.
        :type database_name: str
        :param rule_id: The vulnerability assessment rule ID.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule
         baseline (default implies a baseline on a database level rule and
         master for server level rule). Possible values include: 'master',
         'default'
        :type baseline_name: str or
         ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :param baseline_results: The rule baseline result
        :type baseline_results:
         list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: DatabaseVulnerabilityAssessmentRuleBaseline or
         ClientRawResponse if raw=true
        :rtype:
         ~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaseline or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        parameters = models.DatabaseVulnerabilityAssessmentRuleBaseline(baseline_results=baseline_results)

        # Construct URL
        url = self.create_or_update.metadata['url']
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'serverName': self._serialize.url("server_name", server_name, 'str'),
            'databaseName': self._serialize.url("database_name", database_name, 'str'),
            'vulnerabilityAssessmentName': self._serialize.url("self.vulnerability_assessment_name", self.vulnerability_assessment_name, 'str'),
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'baselineName': self._serialize.url("baseline_name", baseline_name, 'VulnerabilityAssessmentPolicyBaselineName'),
            'subscriptionId': self._serialize.url("self.config.subscription_id", self.config.subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'DatabaseVulnerabilityAssessmentRuleBaseline')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DatabaseVulnerabilityAssessmentRuleBaseline', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_or_update.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}'}

    def delete(
            self, resource_group_name, server_name, database_name, rule_id, baseline_name, custom_headers=None, raw=False, **operation_config):
        """Removes the database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group that
         contains the resource. You can obtain this value from the Azure
         Resource Manager API or the portal.
        :type resource_group_name: str
        :param server_name: The name of the server.
        :type server_name: str
        :param database_name: The name of the database for which the
         vulnerability assessment rule baseline is defined.
        :type database_name: str
        :param rule_id: The vulnerability assessment rule ID.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule
         baseline (default implies a baseline on a database level rule and
         master for server level rule). Possible values include: 'master',
         'default'
        :type baseline_name: str or
         ~azure.mgmt.sql.models.VulnerabilityAssessmentPolicyBaselineName
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        # Construct URL
        url = self.delete.metadata['url']
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'serverName': self._serialize.url("server_name", server_name, 'str'),
            'databaseName': self._serialize.url("database_name", database_name, 'str'),
            'vulnerabilityAssessmentName': self._serialize.url("self.vulnerability_assessment_name", self.vulnerability_assessment_name, 'str'),
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'baselineName': self._serialize.url("baseline_name", baseline_name, 'VulnerabilityAssessmentPolicyBaselineName'),
            'subscriptionId': self._serialize.url("self.config.subscription_id", self.config.subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}'}
