# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CsmSiteRecoveryEntity(Model):
    """Details about app recovery operation.

    :param snapshot_time: Point in time in which the app recovery should be
     attempted.
    :type snapshot_time: datetime
    :param site_name: [Optional] Destination app name into which app should be
     recovered. This is case when new app should be created instead.
    :type site_name: str
    :param slot_name: [Optional] Destination app slot name into which app
     should be recovered.
    :type slot_name: str
    """

    _attribute_map = {
        'snapshot_time': {'key': 'snapshotTime', 'type': 'iso-8601'},
        'site_name': {'key': 'siteName', 'type': 'str'},
        'slot_name': {'key': 'slotName', 'type': 'str'},
    }

    def __init__(self, snapshot_time=None, site_name=None, slot_name=None):
        self.snapshot_time = snapshot_time
        self.site_name = site_name
        self.slot_name = slot_name
