# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RequiredResourceAccess(Model):
    """Specifies the set of OAuth 2.0 permission scopes and app roles under the
    specified resource that an application requires access to. The specified
    OAuth 2.0 permission scopes may be requested by client applications
    (through the requiredResourceAccess collection) when calling a resource
    application. The requiredResourceAccess property of the Application entity
    is a collection of ReqiredResourceAccess.

    :param resource_access: The list of OAuth2.0 permission scopes and app
     roles that the application requires from the specified resource.
    :type resource_access: list[~azure.graphrbac.models.ResourceAccess]
    :param resource_app_id: The unique identifier for the resource that the
     application requires access to. This should be equal to the appId declared
     on the target resource application.
    :type resource_app_id: str
    """

    _validation = {
        'resource_access': {'required': True},
    }

    _attribute_map = {
        'resource_access': {'key': 'resourceAccess', 'type': '[ResourceAccess]'},
        'resource_app_id': {'key': 'resourceAppId', 'type': 'str'},
    }

    def __init__(self, resource_access, resource_app_id=None):
        self.resource_access = resource_access
        self.resource_app_id = resource_app_id
