# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GetObjectsParameters(Model):
    """Request parameters for the GetObjectsByObjectIds API.

    :param object_ids: The requested object IDs.
    :type object_ids: list[str]
    :param types: The requested object types.
    :type types: list[str]
    :param include_directory_object_references: If true, also searches for
     object IDs in the partner tenant.
    :type include_directory_object_references: bool
    """

    _validation = {
        'include_directory_object_references': {'required': True},
    }

    _attribute_map = {
        'object_ids': {'key': 'objectIds', 'type': '[str]'},
        'types': {'key': 'types', 'type': '[str]'},
        'include_directory_object_references': {'key': 'includeDirectoryObjectReferences', 'type': 'bool'},
    }

    def __init__(self, include_directory_object_references, object_ids=None, types=None):
        self.object_ids = object_ids
        self.types = types
        self.include_directory_object_references = include_directory_object_references
