# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
import uuid

from .. import models


class PoolOperations(object):
    """PoolOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def list_pool_usage_metrics(
            self, pool_list_pool_usage_metrics_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Lists the usage metrics, aggregated by pool across individual time
        intervals, for the specified account.

        :param pool_list_pool_usage_metrics_options: Additional parameters
         for the operation
        :type pool_list_pool_usage_metrics_options:
         :class:`PoolListPoolUsageMetricsOptions
         <azure.batch.models.PoolListPoolUsageMetricsOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PoolUsageMetricsPaged
         <azure.batch.models.PoolUsageMetricsPaged>`
        """
        start_time = None
        if pool_list_pool_usage_metrics_options is not None:
            start_time = pool_list_pool_usage_metrics_options.start_time
        end_time = None
        if pool_list_pool_usage_metrics_options is not None:
            end_time = pool_list_pool_usage_metrics_options.end_time
        filter = None
        if pool_list_pool_usage_metrics_options is not None:
            filter = pool_list_pool_usage_metrics_options.filter
        max_results = None
        if pool_list_pool_usage_metrics_options is not None:
            max_results = pool_list_pool_usage_metrics_options.max_results
        timeout = None
        if pool_list_pool_usage_metrics_options is not None:
            timeout = pool_list_pool_usage_metrics_options.timeout
        client_request_id = None
        if pool_list_pool_usage_metrics_options is not None:
            client_request_id = pool_list_pool_usage_metrics_options.client_request_id
        return_client_request_id = None
        if pool_list_pool_usage_metrics_options is not None:
            return_client_request_id = pool_list_pool_usage_metrics_options.return_client_request_id
        ocp_date = None
        if pool_list_pool_usage_metrics_options is not None:
            ocp_date = pool_list_pool_usage_metrics_options.ocp_date

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/poolusagemetrics'

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
                if start_time is not None:
                    query_parameters['starttime'] = self._serialize.query("start_time", start_time, 'iso-8601')
                if end_time is not None:
                    query_parameters['endtime'] = self._serialize.query("end_time", end_time, 'iso-8601')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int')
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.PoolUsageMetricsPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.PoolUsageMetricsPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized

    def get_all_pools_lifetime_statistics(
            self, pool_get_all_pools_lifetime_statistics_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Gets lifetime summary statistics for all of the pools in the specified
        account. Statistics are aggregated across all pools that have ever
        existed in the account, from account creation to the last update time
        of the statistics.

        :param pool_get_all_pools_lifetime_statistics_options: Additional
         parameters for the operation
        :type pool_get_all_pools_lifetime_statistics_options:
         :class:`PoolGetAllPoolsLifetimeStatisticsOptions
         <azure.batch.models.PoolGetAllPoolsLifetimeStatisticsOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`PoolStatistics <azure.batch.models.PoolStatistics>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_get_all_pools_lifetime_statistics_options is not None:
            timeout = pool_get_all_pools_lifetime_statistics_options.timeout
        client_request_id = None
        if pool_get_all_pools_lifetime_statistics_options is not None:
            client_request_id = pool_get_all_pools_lifetime_statistics_options.client_request_id
        return_client_request_id = None
        if pool_get_all_pools_lifetime_statistics_options is not None:
            return_client_request_id = pool_get_all_pools_lifetime_statistics_options.return_client_request_id
        ocp_date = None
        if pool_get_all_pools_lifetime_statistics_options is not None:
            ocp_date = pool_get_all_pools_lifetime_statistics_options.ocp_date

        # Construct URL
        url = '/lifetimepoolstats'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('PoolStatistics', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def add(
            self, pool, pool_add_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Adds a pool to the specified account.

        :param pool: The pool to be added.
        :type pool: :class:`PoolAddParameter
         <azure.batch.models.PoolAddParameter>`
        :param pool_add_options: Additional parameters for the operation
        :type pool_add_options: :class:`PoolAddOptions
         <azure.batch.models.PoolAddOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_add_options is not None:
            timeout = pool_add_options.timeout
        client_request_id = None
        if pool_add_options is not None:
            client_request_id = pool_add_options.client_request_id
        return_client_request_id = None
        if pool_add_options is not None:
            return_client_request_id = pool_add_options.return_client_request_id
        ocp_date = None
        if pool_add_options is not None:
            ocp_date = pool_add_options.ocp_date

        # Construct URL
        url = '/pools'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(pool, 'PoolAddParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [201]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def list(
            self, pool_list_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Lists all of the pools in the specified account.

        :param pool_list_options: Additional parameters for the operation
        :type pool_list_options: :class:`PoolListOptions
         <azure.batch.models.PoolListOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudPoolPaged <azure.batch.models.CloudPoolPaged>`
        """
        filter = None
        if pool_list_options is not None:
            filter = pool_list_options.filter
        select = None
        if pool_list_options is not None:
            select = pool_list_options.select
        expand = None
        if pool_list_options is not None:
            expand = pool_list_options.expand
        max_results = None
        if pool_list_options is not None:
            max_results = pool_list_options.max_results
        timeout = None
        if pool_list_options is not None:
            timeout = pool_list_options.timeout
        client_request_id = None
        if pool_list_options is not None:
            client_request_id = pool_list_options.client_request_id
        return_client_request_id = None
        if pool_list_options is not None:
            return_client_request_id = pool_list_options.return_client_request_id
        ocp_date = None
        if pool_list_options is not None:
            ocp_date = pool_list_options.ocp_date

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/pools'

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int')
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.CloudPoolPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.CloudPoolPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized

    def delete(
            self, pool_id, pool_delete_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Deletes a pool from the specified account.

        :param pool_id: The id of the pool to delete.
        :type pool_id: str
        :param pool_delete_options: Additional parameters for the operation
        :type pool_delete_options: :class:`PoolDeleteOptions
         <azure.batch.models.PoolDeleteOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_delete_options is not None:
            timeout = pool_delete_options.timeout
        client_request_id = None
        if pool_delete_options is not None:
            client_request_id = pool_delete_options.client_request_id
        return_client_request_id = None
        if pool_delete_options is not None:
            return_client_request_id = pool_delete_options.return_client_request_id
        ocp_date = None
        if pool_delete_options is not None:
            ocp_date = pool_delete_options.ocp_date
        if_match = None
        if pool_delete_options is not None:
            if_match = pool_delete_options.if_match
        if_none_match = None
        if pool_delete_options is not None:
            if_none_match = pool_delete_options.if_none_match
        if_modified_since = None
        if pool_delete_options is not None:
            if_modified_since = pool_delete_options.if_modified_since
        if_unmodified_since = None
        if pool_delete_options is not None:
            if_unmodified_since = pool_delete_options.if_unmodified_since

        # Construct URL
        url = '/pools/{poolId}'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
            })
            return client_raw_response

    def exists(
            self, pool_id, pool_exists_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Gets basic properties of a pool.

        :param pool_id: The id of the pool to get.
        :type pool_id: str
        :param pool_exists_options: Additional parameters for the operation
        :type pool_exists_options: :class:`PoolExistsOptions
         <azure.batch.models.PoolExistsOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: bool
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_exists_options is not None:
            timeout = pool_exists_options.timeout
        client_request_id = None
        if pool_exists_options is not None:
            client_request_id = pool_exists_options.client_request_id
        return_client_request_id = None
        if pool_exists_options is not None:
            return_client_request_id = pool_exists_options.return_client_request_id
        ocp_date = None
        if pool_exists_options is not None:
            ocp_date = pool_exists_options.ocp_date
        if_match = None
        if pool_exists_options is not None:
            if_match = pool_exists_options.if_match
        if_none_match = None
        if pool_exists_options is not None:
            if_none_match = pool_exists_options.if_none_match
        if_modified_since = None
        if pool_exists_options is not None:
            if_modified_since = pool_exists_options.if_modified_since
        if_unmodified_since = None
        if pool_exists_options is not None:
            if_unmodified_since = pool_exists_options.if_unmodified_since

        # Construct URL
        url = '/pools/{poolId}'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.head(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200, 404]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = (response.status_code == 200)
        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                })
            return client_raw_response
        return deserialized

    def get(
            self, pool_id, pool_get_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Gets information about the specified pool.

        :param pool_id: The id of the pool to get.
        :type pool_id: str
        :param pool_get_options: Additional parameters for the operation
        :type pool_get_options: :class:`PoolGetOptions
         <azure.batch.models.PoolGetOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudPool <azure.batch.models.CloudPool>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        select = None
        if pool_get_options is not None:
            select = pool_get_options.select
        expand = None
        if pool_get_options is not None:
            expand = pool_get_options.expand
        timeout = None
        if pool_get_options is not None:
            timeout = pool_get_options.timeout
        client_request_id = None
        if pool_get_options is not None:
            client_request_id = pool_get_options.client_request_id
        return_client_request_id = None
        if pool_get_options is not None:
            return_client_request_id = pool_get_options.return_client_request_id
        ocp_date = None
        if pool_get_options is not None:
            ocp_date = pool_get_options.ocp_date
        if_match = None
        if pool_get_options is not None:
            if_match = pool_get_options.if_match
        if_none_match = None
        if pool_get_options is not None:
            if_none_match = pool_get_options.if_none_match
        if_modified_since = None
        if pool_get_options is not None:
            if_modified_since = pool_get_options.if_modified_since
        if_unmodified_since = None
        if pool_get_options is not None:
            if_unmodified_since = pool_get_options.if_unmodified_since

        # Construct URL
        url = '/pools/{poolId}'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if expand is not None:
            query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('CloudPool', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def patch(
            self, pool_id, pool_patch_parameter, pool_patch_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Updates the properties of a pool.

        :param pool_id: The id of the pool to update.
        :type pool_id: str
        :param pool_patch_parameter: The parameters for the request.
        :type pool_patch_parameter: :class:`PoolPatchParameter
         <azure.batch.models.PoolPatchParameter>`
        :param pool_patch_options: Additional parameters for the operation
        :type pool_patch_options: :class:`PoolPatchOptions
         <azure.batch.models.PoolPatchOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_patch_options is not None:
            timeout = pool_patch_options.timeout
        client_request_id = None
        if pool_patch_options is not None:
            client_request_id = pool_patch_options.client_request_id
        return_client_request_id = None
        if pool_patch_options is not None:
            return_client_request_id = pool_patch_options.return_client_request_id
        ocp_date = None
        if pool_patch_options is not None:
            ocp_date = pool_patch_options.ocp_date
        if_match = None
        if pool_patch_options is not None:
            if_match = pool_patch_options.if_match
        if_none_match = None
        if pool_patch_options is not None:
            if_none_match = pool_patch_options.if_none_match
        if_modified_since = None
        if pool_patch_options is not None:
            if_modified_since = pool_patch_options.if_modified_since
        if_unmodified_since = None
        if pool_patch_options is not None:
            if_unmodified_since = pool_patch_options.if_unmodified_since

        # Construct URL
        url = '/pools/{poolId}'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(pool_patch_parameter, 'PoolPatchParameter')

        # Construct and send request
        request = self._client.patch(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def disable_auto_scale(
            self, pool_id, pool_disable_auto_scale_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Disables automatic scaling for a pool.

        :param pool_id: The id of the pool on which to disable automatic
         scaling.
        :type pool_id: str
        :param pool_disable_auto_scale_options: Additional parameters for the
         operation
        :type pool_disable_auto_scale_options:
         :class:`PoolDisableAutoScaleOptions
         <azure.batch.models.PoolDisableAutoScaleOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_disable_auto_scale_options is not None:
            timeout = pool_disable_auto_scale_options.timeout
        client_request_id = None
        if pool_disable_auto_scale_options is not None:
            client_request_id = pool_disable_auto_scale_options.client_request_id
        return_client_request_id = None
        if pool_disable_auto_scale_options is not None:
            return_client_request_id = pool_disable_auto_scale_options.return_client_request_id
        ocp_date = None
        if pool_disable_auto_scale_options is not None:
            ocp_date = pool_disable_auto_scale_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/disableautoscale'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def enable_auto_scale(
            self, pool_id, pool_enable_auto_scale_options=None, auto_scale_formula=None, auto_scale_evaluation_interval=None, custom_headers=None, raw=False, **operation_config):
        """
        Enables automatic scaling for a pool.

        :param pool_id: The id of the pool on which to enable automatic
         scaling.
        :type pool_id: str
        :param pool_enable_auto_scale_options: Additional parameters for the
         operation
        :type pool_enable_auto_scale_options:
         :class:`PoolEnableAutoScaleOptions
         <azure.batch.models.PoolEnableAutoScaleOptions>`
        :param auto_scale_formula: The formula for the desired number of
         compute nodes in the pool.
        :type auto_scale_formula: str
        :param auto_scale_evaluation_interval: A time interval for the
         desired autoscale evaluation period in the pool.
        :type auto_scale_evaluation_interval: timedelta
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_enable_auto_scale_options is not None:
            timeout = pool_enable_auto_scale_options.timeout
        client_request_id = None
        if pool_enable_auto_scale_options is not None:
            client_request_id = pool_enable_auto_scale_options.client_request_id
        return_client_request_id = None
        if pool_enable_auto_scale_options is not None:
            return_client_request_id = pool_enable_auto_scale_options.return_client_request_id
        ocp_date = None
        if pool_enable_auto_scale_options is not None:
            ocp_date = pool_enable_auto_scale_options.ocp_date
        if_match = None
        if pool_enable_auto_scale_options is not None:
            if_match = pool_enable_auto_scale_options.if_match
        if_none_match = None
        if pool_enable_auto_scale_options is not None:
            if_none_match = pool_enable_auto_scale_options.if_none_match
        if_modified_since = None
        if pool_enable_auto_scale_options is not None:
            if_modified_since = pool_enable_auto_scale_options.if_modified_since
        if_unmodified_since = None
        if pool_enable_auto_scale_options is not None:
            if_unmodified_since = pool_enable_auto_scale_options.if_unmodified_since
        pool_enable_auto_scale_parameter = models.PoolEnableAutoScaleParameter(auto_scale_formula=auto_scale_formula, auto_scale_evaluation_interval=auto_scale_evaluation_interval)

        # Construct URL
        url = '/pools/{poolId}/enableautoscale'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(pool_enable_auto_scale_parameter, 'PoolEnableAutoScaleParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def evaluate_auto_scale(
            self, pool_id, auto_scale_formula, pool_evaluate_auto_scale_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Gets the result of evaluating an automatic scaling formula on the pool.

        :param pool_id: The id of the pool on which to evaluate the automatic
         scaling formula.
        :type pool_id: str
        :param auto_scale_formula: A formula for the desired number of
         compute nodes in the pool.
        :type auto_scale_formula: str
        :param pool_evaluate_auto_scale_options: Additional parameters for
         the operation
        :type pool_evaluate_auto_scale_options:
         :class:`PoolEvaluateAutoScaleOptions
         <azure.batch.models.PoolEvaluateAutoScaleOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`AutoScaleRun <azure.batch.models.AutoScaleRun>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_evaluate_auto_scale_options is not None:
            timeout = pool_evaluate_auto_scale_options.timeout
        client_request_id = None
        if pool_evaluate_auto_scale_options is not None:
            client_request_id = pool_evaluate_auto_scale_options.client_request_id
        return_client_request_id = None
        if pool_evaluate_auto_scale_options is not None:
            return_client_request_id = pool_evaluate_auto_scale_options.return_client_request_id
        ocp_date = None
        if pool_evaluate_auto_scale_options is not None:
            ocp_date = pool_evaluate_auto_scale_options.ocp_date
        pool_evaluate_auto_scale_parameter = models.PoolEvaluateAutoScaleParameter(auto_scale_formula=auto_scale_formula)

        # Construct URL
        url = '/pools/{poolId}/evaluateautoscale'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(pool_evaluate_auto_scale_parameter, 'PoolEvaluateAutoScaleParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('AutoScaleRun', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def resize(
            self, pool_id, pool_resize_parameter, pool_resize_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Changes the number of compute nodes that are assigned to a pool.

        :param pool_id: The id of the pool to resize.
        :type pool_id: str
        :param pool_resize_parameter: The parameters for the request.
        :type pool_resize_parameter: :class:`PoolResizeParameter
         <azure.batch.models.PoolResizeParameter>`
        :param pool_resize_options: Additional parameters for the operation
        :type pool_resize_options: :class:`PoolResizeOptions
         <azure.batch.models.PoolResizeOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_resize_options is not None:
            timeout = pool_resize_options.timeout
        client_request_id = None
        if pool_resize_options is not None:
            client_request_id = pool_resize_options.client_request_id
        return_client_request_id = None
        if pool_resize_options is not None:
            return_client_request_id = pool_resize_options.return_client_request_id
        ocp_date = None
        if pool_resize_options is not None:
            ocp_date = pool_resize_options.ocp_date
        if_match = None
        if pool_resize_options is not None:
            if_match = pool_resize_options.if_match
        if_none_match = None
        if pool_resize_options is not None:
            if_none_match = pool_resize_options.if_none_match
        if_modified_since = None
        if pool_resize_options is not None:
            if_modified_since = pool_resize_options.if_modified_since
        if_unmodified_since = None
        if pool_resize_options is not None:
            if_unmodified_since = pool_resize_options.if_unmodified_since

        # Construct URL
        url = '/pools/{poolId}/resize'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(pool_resize_parameter, 'PoolResizeParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def stop_resize(
            self, pool_id, pool_stop_resize_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Stops an ongoing resize operation on the pool. This does not restore
        the pool to its previous state before the resize operation: it only
        stops any further changes being made, and the pool maintains its
        current state.

        :param pool_id: The id of the pool whose resizing you want to stop.
        :type pool_id: str
        :param pool_stop_resize_options: Additional parameters for the
         operation
        :type pool_stop_resize_options: :class:`PoolStopResizeOptions
         <azure.batch.models.PoolStopResizeOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_stop_resize_options is not None:
            timeout = pool_stop_resize_options.timeout
        client_request_id = None
        if pool_stop_resize_options is not None:
            client_request_id = pool_stop_resize_options.client_request_id
        return_client_request_id = None
        if pool_stop_resize_options is not None:
            return_client_request_id = pool_stop_resize_options.return_client_request_id
        ocp_date = None
        if pool_stop_resize_options is not None:
            ocp_date = pool_stop_resize_options.ocp_date
        if_match = None
        if pool_stop_resize_options is not None:
            if_match = pool_stop_resize_options.if_match
        if_none_match = None
        if pool_stop_resize_options is not None:
            if_none_match = pool_stop_resize_options.if_none_match
        if_modified_since = None
        if pool_stop_resize_options is not None:
            if_modified_since = pool_stop_resize_options.if_modified_since
        if_unmodified_since = None
        if pool_stop_resize_options is not None:
            if_unmodified_since = pool_stop_resize_options.if_unmodified_since

        # Construct URL
        url = '/pools/{poolId}/stopresize'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def update_properties(
            self, pool_id, pool_update_properties_parameter, pool_update_properties_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Updates the properties of a pool.

        :param pool_id: The id of the pool to update.
        :type pool_id: str
        :param pool_update_properties_parameter: The parameters for the
         request.
        :type pool_update_properties_parameter:
         :class:`PoolUpdatePropertiesParameter
         <azure.batch.models.PoolUpdatePropertiesParameter>`
        :param pool_update_properties_options: Additional parameters for the
         operation
        :type pool_update_properties_options:
         :class:`PoolUpdatePropertiesOptions
         <azure.batch.models.PoolUpdatePropertiesOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_update_properties_options is not None:
            timeout = pool_update_properties_options.timeout
        client_request_id = None
        if pool_update_properties_options is not None:
            client_request_id = pool_update_properties_options.client_request_id
        return_client_request_id = None
        if pool_update_properties_options is not None:
            return_client_request_id = pool_update_properties_options.return_client_request_id
        ocp_date = None
        if pool_update_properties_options is not None:
            ocp_date = pool_update_properties_options.ocp_date

        # Construct URL
        url = '/pools/{poolId}/updateproperties'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(pool_update_properties_parameter, 'PoolUpdatePropertiesParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [204]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def upgrade_os(
            self, pool_id, target_os_version, pool_upgrade_os_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Upgrades the operating system of the specified pool.

        :param pool_id: The id of the pool to upgrade.
        :type pool_id: str
        :param target_os_version: The Azure Guest OS version to be installed
         on the virtual machines in the pool.
        :type target_os_version: str
        :param pool_upgrade_os_options: Additional parameters for the
         operation
        :type pool_upgrade_os_options: :class:`PoolUpgradeOSOptions
         <azure.batch.models.PoolUpgradeOSOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_upgrade_os_options is not None:
            timeout = pool_upgrade_os_options.timeout
        client_request_id = None
        if pool_upgrade_os_options is not None:
            client_request_id = pool_upgrade_os_options.client_request_id
        return_client_request_id = None
        if pool_upgrade_os_options is not None:
            return_client_request_id = pool_upgrade_os_options.return_client_request_id
        ocp_date = None
        if pool_upgrade_os_options is not None:
            ocp_date = pool_upgrade_os_options.ocp_date
        if_match = None
        if pool_upgrade_os_options is not None:
            if_match = pool_upgrade_os_options.if_match
        if_none_match = None
        if pool_upgrade_os_options is not None:
            if_none_match = pool_upgrade_os_options.if_none_match
        if_modified_since = None
        if pool_upgrade_os_options is not None:
            if_modified_since = pool_upgrade_os_options.if_modified_since
        if_unmodified_since = None
        if pool_upgrade_os_options is not None:
            if_unmodified_since = pool_upgrade_os_options.if_unmodified_since
        pool_upgrade_os_parameter = models.PoolUpgradeOSParameter(target_os_version=target_os_version)

        # Construct URL
        url = '/pools/{poolId}/upgradeos'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(pool_upgrade_os_parameter, 'PoolUpgradeOSParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def remove_nodes(
            self, pool_id, node_remove_parameter, pool_remove_nodes_options=None, custom_headers=None, raw=False, **operation_config):
        """
        Removes compute nodes from the specified pool.

        :param pool_id: The id of the pool from which you want to remove
         nodes.
        :type pool_id: str
        :param node_remove_parameter: The parameters for the request.
        :type node_remove_parameter: :class:`NodeRemoveParameter
         <azure.batch.models.NodeRemoveParameter>`
        :param pool_remove_nodes_options: Additional parameters for the
         operation
        :type pool_remove_nodes_options: :class:`PoolRemoveNodesOptions
         <azure.batch.models.PoolRemoveNodesOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        timeout = None
        if pool_remove_nodes_options is not None:
            timeout = pool_remove_nodes_options.timeout
        client_request_id = None
        if pool_remove_nodes_options is not None:
            client_request_id = pool_remove_nodes_options.client_request_id
        return_client_request_id = None
        if pool_remove_nodes_options is not None:
            return_client_request_id = pool_remove_nodes_options.return_client_request_id
        ocp_date = None
        if pool_remove_nodes_options is not None:
            ocp_date = pool_remove_nodes_options.ocp_date
        if_match = None
        if pool_remove_nodes_options is not None:
            if_match = pool_remove_nodes_options.if_match
        if_none_match = None
        if pool_remove_nodes_options is not None:
            if_none_match = pool_remove_nodes_options.if_none_match
        if_modified_since = None
        if pool_remove_nodes_options is not None:
            if_modified_since = pool_remove_nodes_options.if_modified_since
        if_unmodified_since = None
        if pool_remove_nodes_options is not None:
            if_unmodified_since = pool_remove_nodes_options.if_unmodified_since

        # Construct URL
        url = '/pools/{poolId}/removenodes'
        path_format_arguments = {
            'poolId': self._serialize.url("pool_id", pool_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(node_remove_parameter, 'NodeRemoveParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response
