# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ActivationProperties(msrest.serialization.Model):
    """The activation properties of the connected registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The activation status of the connected registry. Possible values include:
     "Active", "Inactive".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ActivationStatus
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActivationProperties, self).__init__(**kwargs)
        self.status = None


class ActiveDirectoryObject(msrest.serialization.Model):
    """The Active Directory Object that will be used for authenticating the token of a container registry.

    :param object_id: The user/group/application object ID for Active Directory Object that will be
     used for authenticating the token of a container registry.
    :type object_id: str
    :param tenant_id: The tenant ID of user/group/application object Active Directory Object that
     will be used for authenticating the token of a container registry.
    :type tenant_id: str
    """

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActiveDirectoryObject, self).__init__(**kwargs)
        self.object_id = kwargs.get('object_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class Actor(msrest.serialization.Model):
    """The agent that initiated the event. For most situations, this could be from the authorization context of the request.

    :param name: The subject or username associated with the request context that generated the
     event.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Actor, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CallbackConfig(msrest.serialization.Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to Azure.

    :param service_uri: Required. The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    """

    _validation = {
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'customHeaders', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CallbackConfig, self).__init__(**kwargs)
        self.service_uri = kwargs['service_uri']
        self.custom_headers = kwargs.get('custom_headers', None)


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ConnectedRegistry(ProxyResource):
    """An object that represents a connected registry for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    :param mode: The mode of the connected registry resource that indicates the permissions of the
     registry. Possible values include: "Registry", "Mirror".
    :type mode: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ConnectedRegistryMode
    :ivar version: The current version of ACR runtime on the connected registry.
    :vartype version: str
    :ivar connection_state: The current connection state of the connected registry. Possible values
     include: "Online", "Offline", "Syncing", "Unhealthy".
    :vartype connection_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ConnectionState
    :ivar last_activity_time: The last activity time of the connected registry.
    :vartype last_activity_time: ~datetime.datetime
    :ivar activation: The activation properties of the connected registry.
    :vartype activation:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ActivationProperties
    :param parent: The parent of the connected registry.
    :type parent: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ParentProperties
    :param client_token_ids: The list of the ACR token resource IDs used to authenticate clients to
     the connected registry.
    :type client_token_ids: list[str]
    :param login_server: The login server properties of the connected registry.
    :type login_server:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.LoginServerProperties
    :param logging: The logging properties of the connected registry.
    :type logging: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.LoggingProperties
    :ivar status_details: The list of current statuses of the connected registry.
    :vartype status_details:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.StatusDetailProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'version': {'readonly': True},
        'connection_state': {'readonly': True},
        'last_activity_time': {'readonly': True},
        'activation': {'readonly': True},
        'status_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'connection_state': {'key': 'properties.connectionState', 'type': 'str'},
        'last_activity_time': {'key': 'properties.lastActivityTime', 'type': 'iso-8601'},
        'activation': {'key': 'properties.activation', 'type': 'ActivationProperties'},
        'parent': {'key': 'properties.parent', 'type': 'ParentProperties'},
        'client_token_ids': {'key': 'properties.clientTokenIds', 'type': '[str]'},
        'login_server': {'key': 'properties.loginServer', 'type': 'LoginServerProperties'},
        'logging': {'key': 'properties.logging', 'type': 'LoggingProperties'},
        'status_details': {'key': 'properties.statusDetails', 'type': '[StatusDetailProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectedRegistry, self).__init__(**kwargs)
        self.provisioning_state = None
        self.mode = kwargs.get('mode', None)
        self.version = None
        self.connection_state = None
        self.last_activity_time = None
        self.activation = None
        self.parent = kwargs.get('parent', None)
        self.client_token_ids = kwargs.get('client_token_ids', None)
        self.login_server = kwargs.get('login_server', None)
        self.logging = kwargs.get('logging', None)
        self.status_details = None


class ConnectedRegistryListResult(msrest.serialization.Model):
    """The result of a request to list connected registries for a container registry.

    :param value: The list of connected registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of connected registries.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.ConnectedRegistry]
    :param next_link: The URI that can be used to request the next list of connected registries.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConnectedRegistry]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectedRegistryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ConnectedRegistryUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a connected registry.

    :param sync_properties: The sync properties of the connected registry with its parent.
    :type sync_properties:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SyncUpdateProperties
    :param logging: The logging properties of the connected registry.
    :type logging: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.LoggingProperties
    :param client_token_ids: The list of the ACR token resource IDs used to authenticate clients to
     the connected registry.
    :type client_token_ids: list[str]
    """

    _attribute_map = {
        'sync_properties': {'key': 'properties.syncProperties', 'type': 'SyncUpdateProperties'},
        'logging': {'key': 'properties.logging', 'type': 'LoggingProperties'},
        'client_token_ids': {'key': 'properties.clientTokenIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectedRegistryUpdateParameters, self).__init__(**kwargs)
        self.sync_properties = kwargs.get('sync_properties', None)
        self.logging = kwargs.get('logging', None)
        self.client_token_ids = kwargs.get('client_token_ids', None)


class EncryptionProperty(msrest.serialization.Model):
    """EncryptionProperty.

    :param status: Indicates whether or not the encryption is enabled for container registry.
     Possible values include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.EncryptionStatus
    :param key_vault_properties: Key vault properties.
    :type key_vault_properties:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.KeyVaultProperties
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionProperty, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)


class ErrorResponse(msrest.serialization.Model):
    """An error response from the Azure Container Registry service.

    :param error: Azure container registry build API error body.
    :type error: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ErrorResponseBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseBody(msrest.serialization.Model):
    """An error response from the Azure Container Registry service.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. error code.
    :type code: str
    :param message: Required. error message.
    :type message: str
    :param target: target of the particular error.
    :type target: str
    :param details: an array of additional nested error response info objects, as described by this
     contract.
    :type details: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.InnerErrorDescription
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': 'InnerErrorDescription'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class EventInfo(msrest.serialization.Model):
    """The basic information of an event.

    :param id: The event ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class Event(EventInfo):
    """The event for a webhook.

    :param id: The event ID.
    :type id: str
    :param event_request_message: The event request message sent to the service URI.
    :type event_request_message:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.EventRequestMessage
    :param event_response_message: The event response message received from the service URI.
    :type event_response_message:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.EventResponseMessage
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_request_message': {'key': 'eventRequestMessage', 'type': 'EventRequestMessage'},
        'event_response_message': {'key': 'eventResponseMessage', 'type': 'EventResponseMessage'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Event, self).__init__(**kwargs)
        self.event_request_message = kwargs.get('event_request_message', None)
        self.event_response_message = kwargs.get('event_response_message', None)


class EventContent(msrest.serialization.Model):
    """The content of the event request message.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Target
    :param request: The request that generated the event.
    :type request: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Request
    :param actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :type actor: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Actor
    :param source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :type source: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Source
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'Target'},
        'request': {'key': 'request', 'type': 'Request'},
        'actor': {'key': 'actor', 'type': 'Actor'},
        'source': {'key': 'source', 'type': 'Source'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventContent, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.action = kwargs.get('action', None)
        self.target = kwargs.get('target', None)
        self.request = kwargs.get('request', None)
        self.actor = kwargs.get('actor', None)
        self.source = kwargs.get('source', None)


class EventListResult(msrest.serialization.Model):
    """The result of a request to list events for a webhook.

    :param value: The list of events. Since this list may be incomplete, the nextLink field should
     be used to request the next list of events.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.Event]
    :param next_link: The URI that can be used to request the next list of events.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Event]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class EventRequestMessage(msrest.serialization.Model):
    """The event request message sent to the service URI.

    :param content: The content of the event request message.
    :type content: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.EventContent
    :param headers: The headers of the event request message.
    :type headers: dict[str, str]
    :param method: The HTTP method used to send the event request message.
    :type method: str
    :param request_uri: The URI used to send the event request message.
    :type request_uri: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'EventContent'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'method': {'key': 'method', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventRequestMessage, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)
        self.headers = kwargs.get('headers', None)
        self.method = kwargs.get('method', None)
        self.request_uri = kwargs.get('request_uri', None)
        self.version = kwargs.get('version', None)


class EventResponseMessage(msrest.serialization.Model):
    """The event response message received from the service URI.

    :param content: The content of the event response message.
    :type content: str
    :param headers: The headers of the event response message.
    :type headers: dict[str, str]
    :param reason_phrase: The reason phrase of the event response message.
    :type reason_phrase: str
    :param status_code: The status code of the event response message.
    :type status_code: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'reason_phrase': {'key': 'reasonPhrase', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventResponseMessage, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)
        self.headers = kwargs.get('headers', None)
        self.reason_phrase = kwargs.get('reason_phrase', None)
        self.status_code = kwargs.get('status_code', None)
        self.version = kwargs.get('version', None)


class ExportPipeline(ProxyResource):
    """An object that represents an export pipeline for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :param location: The location of the export pipeline.
    :type location: str
    :param identity: The identity of the export pipeline.
    :type identity: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.IdentityProperties
    :param target: The target properties of the export pipeline.
    :type target:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ExportPipelineTargetProperties
    :param options: The list of all options configured for the pipeline.
    :type options: list[str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineOptions]
    :ivar provisioning_state: The provisioning state of the pipeline at the time the operation was
     called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'target': {'key': 'properties.target', 'type': 'ExportPipelineTargetProperties'},
        'options': {'key': 'properties.options', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportPipeline, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.identity = kwargs.get('identity', None)
        self.target = kwargs.get('target', None)
        self.options = kwargs.get('options', None)
        self.provisioning_state = None


class ExportPipelineListResult(msrest.serialization.Model):
    """The result of a request to list export pipelines for a container registry.

    :param value: The list of export pipelines. Since this list may be incomplete, the nextLink
     field should be used to request the next list of export pipelines.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.ExportPipeline]
    :param next_link: The URI that can be used to request the next list of pipeline runs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExportPipeline]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportPipelineListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExportPipelineTargetProperties(msrest.serialization.Model):
    """The properties of the export pipeline target.

    All required parameters must be populated in order to send to Azure.

    :param type: The type of target for the export pipeline.
    :type type: str
    :param uri: The target uri of the export pipeline.
     When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName".
    :type uri: str
    :param key_vault_uri: Required. They key vault secret uri to obtain the target storage SAS
     token.
    :type key_vault_uri: str
    """

    _validation = {
        'key_vault_uri': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportPipelineTargetProperties, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.uri = kwargs.get('uri', None)
        self.key_vault_uri = kwargs['key_vault_uri']


class GenerateCredentialsParameters(msrest.serialization.Model):
    """The parameters used to generate credentials for a specified token or user of a container registry.

    :param token_id: The resource ID of the token for which credentials have to be generated.
    :type token_id: str
    :param expiry: The expiry date of the generated credentials after which the credentials become
     invalid.
    :type expiry: ~datetime.datetime
    :param name: Specifies name of the password which should be regenerated if any -- password1 or
     password2. Possible values include: "password1", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenPasswordName
    """

    _attribute_map = {
        'token_id': {'key': 'tokenId', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GenerateCredentialsParameters, self).__init__(**kwargs)
        self.token_id = kwargs.get('token_id', None)
        self.expiry = kwargs.get('expiry', None)
        self.name = kwargs.get('name', None)


class GenerateCredentialsResult(msrest.serialization.Model):
    """The response from the GenerateCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[TokenPassword]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GenerateCredentialsResult, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.passwords = kwargs.get('passwords', None)


class IdentityProperties(msrest.serialization.Model):
    """Managed identity for the resource.

    :param principal_id: The principal ID of resource identity.
    :type principal_id: str
    :param tenant_id: The tenant ID of resource.
    :type tenant_id: str
    :param type: The identity type. Possible values include: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", "None".
    :type type: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
         providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.UserIdentityProperties]
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProperties, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ImportImageParameters(msrest.serialization.Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The source of the image.
    :type source: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ImportSource
    :param target_tags: List of strings of the form repo[:tag]. When tag is omitted the source will
     be used (or 'latest' if source tag is also omitted).
    :type target_tags: list[str]
    :param untagged_target_repositories: List of strings of repository names to do a manifest only
     copy. No tag will be created.
    :type untagged_target_repositories: list[str]
    :param mode: When Force, any existing target tags will be overwritten. When NoForce, any
     existing target tags will fail the operation before any copying begins. Possible values
     include: "NoForce", "Force". Default value: "NoForce".
    :type mode: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ImportMode
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ImportSource'},
        'target_tags': {'key': 'targetTags', 'type': '[str]'},
        'untagged_target_repositories': {'key': 'untaggedTargetRepositories', 'type': '[str]'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportImageParameters, self).__init__(**kwargs)
        self.source = kwargs['source']
        self.target_tags = kwargs.get('target_tags', None)
        self.untagged_target_repositories = kwargs.get('untagged_target_repositories', None)
        self.mode = kwargs.get('mode', "NoForce")


class ImportPipeline(ProxyResource):
    """An object that represents an import pipeline for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :param location: The location of the import pipeline.
    :type location: str
    :param identity: The identity of the import pipeline.
    :type identity: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.IdentityProperties
    :param source: The source properties of the import pipeline.
    :type source:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ImportPipelineSourceProperties
    :param trigger: The properties that describe the trigger of the import pipeline.
    :type trigger:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineTriggerProperties
    :param options: The list of all options configured for the pipeline.
    :type options: list[str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineOptions]
    :ivar provisioning_state: The provisioning state of the pipeline at the time the operation was
     called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'source': {'key': 'properties.source', 'type': 'ImportPipelineSourceProperties'},
        'trigger': {'key': 'properties.trigger', 'type': 'PipelineTriggerProperties'},
        'options': {'key': 'properties.options', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportPipeline, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.identity = kwargs.get('identity', None)
        self.source = kwargs.get('source', None)
        self.trigger = kwargs.get('trigger', None)
        self.options = kwargs.get('options', None)
        self.provisioning_state = None


class ImportPipelineListResult(msrest.serialization.Model):
    """The result of a request to list import pipelines for a container registry.

    :param value: The list of import pipelines. Since this list may be incomplete, the nextLink
     field should be used to request the next list of import pipelines.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.ImportPipeline]
    :param next_link: The URI that can be used to request the next list of pipeline runs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ImportPipeline]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportPipelineListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ImportPipelineSourceProperties(msrest.serialization.Model):
    """The properties of the import pipeline source.

    All required parameters must be populated in order to send to Azure.

    :param type: The type of source for the import pipeline. Possible values include:
     "AzureStorageBlobContainer". Default value: "AzureStorageBlobContainer".
    :type type: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineSourceType
    :param uri: The source uri of the import pipeline.
     When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName".
    :type uri: str
    :param key_vault_uri: Required. They key vault secret uri to obtain the source storage SAS
     token.
    :type key_vault_uri: str
    """

    _validation = {
        'key_vault_uri': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportPipelineSourceProperties, self).__init__(**kwargs)
        self.type = kwargs.get('type', "AzureStorageBlobContainer")
        self.uri = kwargs.get('uri', None)
        self.key_vault_uri = kwargs['key_vault_uri']


class ImportSource(msrest.serialization.Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: The resource identifier of the source Azure Container Registry.
    :type resource_id: str
    :param registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
    :type registry_uri: str
    :param credentials: Credentials used when importing from a registry uri.
    :type credentials:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ImportSourceCredentials
    :param source_image: Required. Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
    :type source_image: str
    """

    _validation = {
        'source_image': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'registry_uri': {'key': 'registryUri', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'ImportSourceCredentials'},
        'source_image': {'key': 'sourceImage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportSource, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.registry_uri = kwargs.get('registry_uri', None)
        self.credentials = kwargs.get('credentials', None)
        self.source_image = kwargs['source_image']


class ImportSourceCredentials(msrest.serialization.Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to Azure.

    :param username: The username to authenticate with the source registry.
    :type username: str
    :param password: Required. The password used to authenticate with the source registry.
    :type password: str
    """

    _validation = {
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportSourceCredentials, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs['password']


class InnerErrorDescription(msrest.serialization.Model):
    """inner error.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. error code.
    :type code: str
    :param message: Required. error message.
    :type message: str
    :param target: target of the particular error.
    :type target: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InnerErrorDescription, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)


class IPRule(msrest.serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of IP ACL rule. Possible values include: "Allow".
    :type action: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Action
    :param ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
     address is allowed.
    :type ip_address_or_range: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPRule, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.ip_address_or_range = kwargs['ip_address_or_range']


class KeyVaultProperties(msrest.serialization.Model):
    """KeyVaultProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param key_identifier: Key vault uri to access the encryption key.
    :type key_identifier: str
    :ivar versioned_key_identifier: The fully qualified key identifier that includes the version of
     the key that is actually used for encryption.
    :vartype versioned_key_identifier: str
    :param identity: The client id of the identity which will be used to access key vault.
    :type identity: str
    :ivar key_rotation_enabled: Auto key rotation status for a CMK enabled registry.
    :vartype key_rotation_enabled: bool
    :ivar last_key_rotation_timestamp: Timestamp of the last successful key rotation.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    """

    _validation = {
        'versioned_key_identifier': {'readonly': True},
        'key_rotation_enabled': {'readonly': True},
        'last_key_rotation_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'versioned_key_identifier': {'key': 'versionedKeyIdentifier', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'key_rotation_enabled': {'key': 'keyRotationEnabled', 'type': 'bool'},
        'last_key_rotation_timestamp': {'key': 'lastKeyRotationTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_identifier = kwargs.get('key_identifier', None)
        self.versioned_key_identifier = None
        self.identity = kwargs.get('identity', None)
        self.key_rotation_enabled = None
        self.last_key_rotation_timestamp = None


class LoggingProperties(msrest.serialization.Model):
    """The logging properties of the connected registry.

    :param log_level: The verbosity of logs persisted on the connected registry. Possible values
     include: "Debug", "Information", "Warning", "Error", "None". Default value: "Information".
    :type log_level: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.LogLevel
    :param audit_log_status: Indicates whether audit logs are enabled on the connected registry.
     Possible values include: "Enabled", "Disabled". Default value: "Disabled".
    :type audit_log_status: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.AuditLogStatus
    """

    _attribute_map = {
        'log_level': {'key': 'logLevel', 'type': 'str'},
        'audit_log_status': {'key': 'auditLogStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoggingProperties, self).__init__(**kwargs)
        self.log_level = kwargs.get('log_level', "Information")
        self.audit_log_status = kwargs.get('audit_log_status', "Disabled")


class LoginServerProperties(msrest.serialization.Model):
    """The login server properties of the connected registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar host: The host of the connected registry. Can be FQDN or IP.
    :vartype host: str
    :ivar tls: The TLS properties of the connected registry login server.
    :vartype tls: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TlsProperties
    """

    _validation = {
        'host': {'readonly': True},
        'tls': {'readonly': True},
    }

    _attribute_map = {
        'host': {'key': 'host', 'type': 'str'},
        'tls': {'key': 'tls', 'type': 'TlsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoginServerProperties, self).__init__(**kwargs)
        self.host = None
        self.tls = None


class NetworkRuleSet(msrest.serialization.Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to Azure.

    :param default_action: Required. The default action of allow or deny when no other rules match.
     Possible values include: "Allow", "Deny". Default value: "Allow".
    :type default_action: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.DefaultAction
    :param virtual_network_rules: The virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.VirtualNetworkRule]
    :param ip_rules: The IP ACL rules.
    :type ip_rules: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.IPRule]
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.default_action = kwargs.get('default_action', "Allow")
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.ip_rules = kwargs.get('ip_rules', None)


class OperationDefinition(msrest.serialization.Model):
    """The definition of a container registry operation.

    :param origin: The origin information of the container registry operation.
    :type origin: str
    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The display information for the container registry operation.
    :type display:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.OperationDisplayDefinition
    :param service_specification: The definition of Azure Monitoring service.
    :type service_specification:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayDefinition'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationServiceSpecificationDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDefinition, self).__init__(**kwargs)
        self.origin = kwargs.get('origin', None)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplayDefinition(msrest.serialization.Model):
    """The display information for a container registry operation.

    :param provider: The resource provider name: Microsoft.ContainerRegistry.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that users can perform.
    :type operation: str
    :param description: The description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplayDefinition, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """The result of a request to list container registry operations.

    :param value: The list of container registry operations. Since this list may be incomplete, the
     nextLink field should be used to request the next list of operations.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.OperationDefinition]
    :param next_link: The URI that can be used to request the next list of container registry
     operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationLogSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring log.

    :param name: Log name.
    :type name: str
    :param display_name: Log display name.
    :type display_name: str
    :param blob_duration: Log blob duration.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationLogSpecificationDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class OperationMetricSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring metric.

    :param name: Metric name.
    :type name: str
    :param display_name: Metric display name.
    :type display_name: str
    :param display_description: Metric description.
    :type display_description: str
    :param unit: Metric unit.
    :type unit: str
    :param aggregation_type: Metric aggregation type.
    :type aggregation_type: str
    :param internal_metric_name: Internal metric name.
    :type internal_metric_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetricSpecificationDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.internal_metric_name = kwargs.get('internal_metric_name', None)


class OperationServiceSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring list.

    :param metric_specifications: A list of Azure Monitoring metrics definition.
    :type metric_specifications:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.OperationMetricSpecificationDefinition]
    :param log_specifications: A list of Azure Monitoring log definitions.
    :type log_specifications:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.OperationLogSpecificationDefinition]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetricSpecificationDefinition]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[OperationLogSpecificationDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationServiceSpecificationDefinition, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)
        self.log_specifications = kwargs.get('log_specifications', None)


class ParentProperties(msrest.serialization.Model):
    """The properties of the connected registry parent.

    All required parameters must be populated in order to send to Azure.

    :param id: The resource ID of the parent to which the connected registry will be associated.
    :type id: str
    :param sync_properties: Required. The sync properties of the connected registry with its
     parent.
    :type sync_properties: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SyncProperties
    """

    _validation = {
        'sync_properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sync_properties': {'key': 'syncProperties', 'type': 'SyncProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParentProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.sync_properties = kwargs['sync_properties']


class PipelineRun(ProxyResource):
    """An object that represents a pipeline run for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :ivar provisioning_state: The provisioning state of a pipeline run. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    :param request: The request parameters for a pipeline run.
    :type request: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineRunRequest
    :ivar response: The response of a pipeline run.
    :vartype response: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineRunResponse
    :param force_update_tag: How the pipeline run should be forced to recreate even if the pipeline
     run configuration has not changed.
    :type force_update_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'response': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'request': {'key': 'properties.request', 'type': 'PipelineRunRequest'},
        'response': {'key': 'properties.response', 'type': 'PipelineRunResponse'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineRun, self).__init__(**kwargs)
        self.provisioning_state = None
        self.request = kwargs.get('request', None)
        self.response = None
        self.force_update_tag = kwargs.get('force_update_tag', None)


class PipelineRunListResult(msrest.serialization.Model):
    """The result of a request to list pipeline runs for a container registry.

    :param value: The list of pipeline runs. Since this list may be incomplete, the nextLink field
     should be used to request the next list of pipeline runs.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineRun]
    :param next_link: The URI that can be used to request the next list of pipeline runs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PipelineRun]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineRunListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PipelineRunRequest(msrest.serialization.Model):
    """The request properties provided for a pipeline run.

    :param pipeline_resource_id: The resource ID of the pipeline to run.
    :type pipeline_resource_id: str
    :param artifacts: List of source artifacts to be transferred by the pipeline.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
    :type artifacts: list[str]
    :param source: The source properties of the pipeline run.
    :type source:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineRunSourceProperties
    :param target: The target properties of the pipeline run.
    :type target:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineRunTargetProperties
    :param catalog_digest: The digest of the tar used to transfer the artifacts.
    :type catalog_digest: str
    """

    _attribute_map = {
        'pipeline_resource_id': {'key': 'pipelineResourceId', 'type': 'str'},
        'artifacts': {'key': 'artifacts', 'type': '[str]'},
        'source': {'key': 'source', 'type': 'PipelineRunSourceProperties'},
        'target': {'key': 'target', 'type': 'PipelineRunTargetProperties'},
        'catalog_digest': {'key': 'catalogDigest', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineRunRequest, self).__init__(**kwargs)
        self.pipeline_resource_id = kwargs.get('pipeline_resource_id', None)
        self.artifacts = kwargs.get('artifacts', None)
        self.source = kwargs.get('source', None)
        self.target = kwargs.get('target', None)
        self.catalog_digest = kwargs.get('catalog_digest', None)


class PipelineRunResponse(msrest.serialization.Model):
    """The response properties returned for a pipeline run.

    :param status: The current status of the pipeline run.
    :type status: str
    :param imported_artifacts: The artifacts imported in the pipeline run.
    :type imported_artifacts: list[str]
    :param progress: The current progress of the copy operation.
    :type progress: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProgressProperties
    :param start_time: The time the pipeline run started.
    :type start_time: ~datetime.datetime
    :param finish_time: The time the pipeline run finished.
    :type finish_time: ~datetime.datetime
    :param source: The source of the pipeline run.
    :type source:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ImportPipelineSourceProperties
    :param target: The target of the pipeline run.
    :type target:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ExportPipelineTargetProperties
    :param catalog_digest: The digest of the tar used to transfer the artifacts.
    :type catalog_digest: str
    :param trigger: The trigger that caused the pipeline run.
    :type trigger:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineTriggerDescriptor
    :param pipeline_run_error_message: The detailed error message for the pipeline run in the case
     of failure.
    :type pipeline_run_error_message: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'imported_artifacts': {'key': 'importedArtifacts', 'type': '[str]'},
        'progress': {'key': 'progress', 'type': 'ProgressProperties'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'source': {'key': 'source', 'type': 'ImportPipelineSourceProperties'},
        'target': {'key': 'target', 'type': 'ExportPipelineTargetProperties'},
        'catalog_digest': {'key': 'catalogDigest', 'type': 'str'},
        'trigger': {'key': 'trigger', 'type': 'PipelineTriggerDescriptor'},
        'pipeline_run_error_message': {'key': 'pipelineRunErrorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineRunResponse, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.imported_artifacts = kwargs.get('imported_artifacts', None)
        self.progress = kwargs.get('progress', None)
        self.start_time = kwargs.get('start_time', None)
        self.finish_time = kwargs.get('finish_time', None)
        self.source = kwargs.get('source', None)
        self.target = kwargs.get('target', None)
        self.catalog_digest = kwargs.get('catalog_digest', None)
        self.trigger = kwargs.get('trigger', None)
        self.pipeline_run_error_message = kwargs.get('pipeline_run_error_message', None)


class PipelineRunSourceProperties(msrest.serialization.Model):
    """PipelineRunSourceProperties.

    :param type: The type of the source. Possible values include: "AzureStorageBlob". Default
     value: "AzureStorageBlob".
    :type type: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineRunSourceType
    :param name: The name of the source.
    :type name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineRunSourceProperties, self).__init__(**kwargs)
        self.type = kwargs.get('type', "AzureStorageBlob")
        self.name = kwargs.get('name', None)


class PipelineRunTargetProperties(msrest.serialization.Model):
    """PipelineRunTargetProperties.

    :param type: The type of the target. Possible values include: "AzureStorageBlob". Default
     value: "AzureStorageBlob".
    :type type: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineRunTargetType
    :param name: The name of the target.
    :type name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineRunTargetProperties, self).__init__(**kwargs)
        self.type = kwargs.get('type', "AzureStorageBlob")
        self.name = kwargs.get('name', None)


class PipelineSourceTriggerDescriptor(msrest.serialization.Model):
    """PipelineSourceTriggerDescriptor.

    :param timestamp: The timestamp when the source update happened.
    :type timestamp: ~datetime.datetime
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineSourceTriggerDescriptor, self).__init__(**kwargs)
        self.timestamp = kwargs.get('timestamp', None)


class PipelineSourceTriggerProperties(msrest.serialization.Model):
    """PipelineSourceTriggerProperties.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The current status of the source trigger. Possible values include:
     "Enabled", "Disabled". Default value: "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TriggerStatus
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineSourceTriggerProperties, self).__init__(**kwargs)
        self.status = kwargs.get('status', "Enabled")


class PipelineTriggerDescriptor(msrest.serialization.Model):
    """PipelineTriggerDescriptor.

    :param source_trigger: The source trigger that caused the pipeline run.
    :type source_trigger:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineSourceTriggerDescriptor
    """

    _attribute_map = {
        'source_trigger': {'key': 'sourceTrigger', 'type': 'PipelineSourceTriggerDescriptor'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineTriggerDescriptor, self).__init__(**kwargs)
        self.source_trigger = kwargs.get('source_trigger', None)


class PipelineTriggerProperties(msrest.serialization.Model):
    """PipelineTriggerProperties.

    :param source_trigger: The source trigger properties of the pipeline.
    :type source_trigger:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PipelineSourceTriggerProperties
    """

    _attribute_map = {
        'source_trigger': {'key': 'sourceTrigger', 'type': 'PipelineSourceTriggerProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineTriggerProperties, self).__init__(**kwargs)
        self.source_trigger = kwargs.get('source_trigger', None)


class Policies(msrest.serialization.Model):
    """The policies for a container registry.

    :param quarantine_policy: The quarantine policy for a container registry.
    :type quarantine_policy:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.QuarantinePolicy
    :param trust_policy: The content trust policy for a container registry.
    :type trust_policy: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TrustPolicy
    :param retention_policy: The retention policy for a container registry.
    :type retention_policy:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.RetentionPolicy
    """

    _attribute_map = {
        'quarantine_policy': {'key': 'quarantinePolicy', 'type': 'QuarantinePolicy'},
        'trust_policy': {'key': 'trustPolicy', 'type': 'TrustPolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Policies, self).__init__(**kwargs)
        self.quarantine_policy = kwargs.get('quarantine_policy', None)
        self.trust_policy = kwargs.get('trust_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    :param id: This is private endpoint resource created with Microsoft.Network resource provider.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class PrivateEndpointConnection(ProxyResource):
    """An object that represents a private endpoint connection for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :param private_endpoint: The resource of private endpoint.
    :type private_endpoint:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of private endpoint connection resource.
     Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """The result of a request to list private endpoint connections for a container registry.

    :param value: The list of private endpoint connections. Since this list may be incomplete, the
     nextLink field should be used to request the next list of private endpoint connections.
    :type value:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.PrivateEndpointConnection]
    :param next_link: The URI that can be used to request the next list of private endpoint
     connections.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PrivateLinkResource(msrest.serialization.Model):
    """A resource that supports private link capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The resource type is private link resource.
    :vartype type: str
    :param id: The resource ID.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param group_id: The private link resource group id.
    :type group_id: str
    :param required_members: The private link resource required member names.
    :type required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.type = None
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.group_id = kwargs.get('group_id', None)
        self.required_members = kwargs.get('required_members', None)
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """The result of a request to list private link resources for a container registry.

    :param value: The list of private link resources. Since this list may be incomplete, the
     nextLink field should be used to request the next list of private link resources.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.PrivateLinkResource]
    :param next_link: The URI that can be used to request the next list of private link resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """The state of a private link service connection.

    :param status: The private link service connection status. Possible values include: "Approved",
     "Pending", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ConnectionStatus
    :param description: The description for connection status. For example if connection is
     rejected it can indicate reason for rejection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. Possible values include: "None", "Recreate".
    :type actions_required: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ActionsRequired
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class ProgressProperties(msrest.serialization.Model):
    """ProgressProperties.

    :param percentage: The percentage complete of the copy operation.
    :type percentage: str
    """

    _attribute_map = {
        'percentage': {'key': 'percentage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProgressProperties, self).__init__(**kwargs)
        self.percentage = kwargs.get('percentage', None)


class QuarantinePolicy(msrest.serialization.Model):
    """The quarantine policy for a container registry.

    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PolicyStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuarantinePolicy, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)


class RegenerateCredentialParameters(msrest.serialization.Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Specifies name of the password which should be regenerated -- password
     or password2. Possible values include: "password", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PasswordName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegenerateCredentialParameters, self).__init__(**kwargs)
        self.name = kwargs['name']


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.system_data = None


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :param sku: Required. The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Sku
    :param identity: The identity of the container registry.
    :type identity: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.IdentityProperties
    :ivar login_server: The URL that can be used to log into the container registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in ISO8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the container registry at the time the
     operation was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded",
     "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    :ivar status: The status of the container registry at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Status
    :param admin_user_enabled: The value that indicates whether the admin user is enabled.
    :type admin_user_enabled: bool
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Policies
    :param encryption: The encryption settings of container registry.
    :type encryption: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.EncryptionProperty
    :param data_endpoint_enabled: Enable a single data endpoint per region for serving data.
    :type data_endpoint_enabled: bool
    :ivar data_endpoint_host_names: List of host names that will serve data when
     dataEndpointEnabled is true.
    :vartype data_endpoint_host_names: list[str]
    :ivar private_endpoint_connections: List of private endpoint connections for a container
     registry.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.PrivateEndpointConnection]
    :param public_network_access: Whether or not public network access is allowed for the container
     registry. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PublicNetworkAccess
    :param network_rule_bypass_options: Whether to allow trusted Azure services to access a network
     restricted registry. Possible values include: "AzureServices", "None".
    :type network_rule_bypass_options: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.NetworkRuleBypassOptions
    :param zone_redundancy: Whether or not zone redundancy is enabled for this container registry.
     Possible values include: "Enabled", "Disabled".
    :type zone_redundancy: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ZoneRedundancy
    :param anonymous_pull_enabled: Enables registry-wide pull from unauthenticated clients.
    :type anonymous_pull_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'sku': {'required': True},
        'login_server': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'data_endpoint_host_names': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'login_server': {'key': 'properties.loginServer', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperty'},
        'data_endpoint_enabled': {'key': 'properties.dataEndpointEnabled', 'type': 'bool'},
        'data_endpoint_host_names': {'key': 'properties.dataEndpointHostNames', 'type': '[str]'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'network_rule_bypass_options': {'key': 'properties.networkRuleBypassOptions', 'type': 'str'},
        'zone_redundancy': {'key': 'properties.zoneRedundancy', 'type': 'str'},
        'anonymous_pull_enabled': {'key': 'properties.anonymousPullEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Registry, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.identity = kwargs.get('identity', None)
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.status = None
        self.admin_user_enabled = kwargs.get('admin_user_enabled', False)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.policies = kwargs.get('policies', None)
        self.encryption = kwargs.get('encryption', None)
        self.data_endpoint_enabled = kwargs.get('data_endpoint_enabled', None)
        self.data_endpoint_host_names = None
        self.private_endpoint_connections = None
        self.public_network_access = kwargs.get('public_network_access', None)
        self.network_rule_bypass_options = kwargs.get('network_rule_bypass_options', None)
        self.zone_redundancy = kwargs.get('zone_redundancy', None)
        self.anonymous_pull_enabled = kwargs.get('anonymous_pull_enabled', False)


class RegistryListCredentialsResult(msrest.serialization.Model):
    """The response from the ListCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.RegistryPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[RegistryPassword]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.passwords = kwargs.get('passwords', None)


class RegistryListResult(msrest.serialization.Model):
    """The result of a request to list container registries.

    :param value: The list of container registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of container registries.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.Registry]
    :param next_link: The URI that can be used to request the next list of container registries.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Registry]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RegistryNameCheckRequest(msrest.serialization.Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the container registry.
    :type name: str
    :ivar type: Required. The resource type of the container registry. This field must be set to
     'Microsoft.ContainerRegistry/registries'. Default value:
     "Microsoft.ContainerRegistry/registries".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 5, 'pattern': r'^[a-zA-Z0-9]*$'},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryNameCheckRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class RegistryNameStatus(msrest.serialization.Model):
    """The result of a request to check the availability of a container registry name.

    :param name_available: The value that indicates whether the name is available.
    :type name_available: bool
    :param reason: If any, the reason that the name is not available.
    :type reason: str
    :param message: If any, the error message that provides more detail for the reason that the
     name is not available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryNameStatus, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class RegistryPassword(msrest.serialization.Model):
    """The login password for the container registry.

    :param name: The password name. Possible values include: "password", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PasswordName
    :param value: The password value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryPassword, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class RegistryUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a container registry.

    :param identity: The identity of the container registry.
    :type identity: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.IdentityProperties
    :param tags: A set of tags. The tags for the container registry.
    :type tags: dict[str, str]
    :param sku: The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Sku
    :param admin_user_enabled: The value that indicates whether the admin user is enabled.
    :type admin_user_enabled: bool
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Policies
    :param encryption: The encryption settings of container registry.
    :type encryption: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.EncryptionProperty
    :param data_endpoint_enabled: Enable a single data endpoint per region for serving data.
    :type data_endpoint_enabled: bool
    :param public_network_access: Whether or not public network access is allowed for the container
     registry. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PublicNetworkAccess
    :param network_rule_bypass_options: Whether to allow trusted Azure services to access a network
     restricted registry. Possible values include: "AzureServices", "None".
    :type network_rule_bypass_options: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.NetworkRuleBypassOptions
    :param anonymous_pull_enabled: Enables registry-wide pull from unauthenticated clients.
    :type anonymous_pull_enabled: bool
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperty'},
        'data_endpoint_enabled': {'key': 'properties.dataEndpointEnabled', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'network_rule_bypass_options': {'key': 'properties.networkRuleBypassOptions', 'type': 'str'},
        'anonymous_pull_enabled': {'key': 'properties.anonymousPullEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUpdateParameters, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)
        self.admin_user_enabled = kwargs.get('admin_user_enabled', None)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.policies = kwargs.get('policies', None)
        self.encryption = kwargs.get('encryption', None)
        self.data_endpoint_enabled = kwargs.get('data_endpoint_enabled', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.network_rule_bypass_options = kwargs.get('network_rule_bypass_options', None)
        self.anonymous_pull_enabled = kwargs.get('anonymous_pull_enabled', None)


class RegistryUsage(msrest.serialization.Model):
    """The quota usage for a container registry.

    :param name: The name of the usage.
    :type name: str
    :param limit: The limit of the usage.
    :type limit: long
    :param current_value: The current value of the usage.
    :type current_value: long
    :param unit: The unit of measurement. Possible values include: "Count", "Bytes".
    :type unit: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.RegistryUsageUnit
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUsage, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.limit = kwargs.get('limit', None)
        self.current_value = kwargs.get('current_value', None)
        self.unit = kwargs.get('unit', None)


class RegistryUsageListResult(msrest.serialization.Model):
    """The result of a request to get container registry quota usages.

    :param value: The list of container registry quota usages.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.RegistryUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegistryUsage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUsageListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :ivar provisioning_state: The provisioning state of the replication at the time the operation
     was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Status
    :param region_endpoint_enabled: Specifies whether the replication's regional endpoint is
     enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
     however its data will continue to be synced with other replications.
    :type region_endpoint_enabled: bool
    :param zone_redundancy: Whether or not zone redundancy is enabled for this container registry
     replication. Possible values include: "Enabled", "Disabled".
    :type zone_redundancy: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ZoneRedundancy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'region_endpoint_enabled': {'key': 'properties.regionEndpointEnabled', 'type': 'bool'},
        'zone_redundancy': {'key': 'properties.zoneRedundancy', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Replication, self).__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.region_endpoint_enabled = kwargs.get('region_endpoint_enabled', True)
        self.zone_redundancy = kwargs.get('zone_redundancy', None)


class ReplicationListResult(msrest.serialization.Model):
    """The result of a request to list replications for a container registry.

    :param value: The list of replications. Since this list may be incomplete, the nextLink field
     should be used to request the next list of replications.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.Replication]
    :param next_link: The URI that can be used to request the next list of replications.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Replication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ReplicationUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a replication.

    :param tags: A set of tags. The tags for the replication.
    :type tags: dict[str, str]
    :param region_endpoint_enabled: Specifies whether the replication's regional endpoint is
     enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
     however its data will continue to be synced with other replications.
    :type region_endpoint_enabled: bool
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'region_endpoint_enabled': {'key': 'properties.regionEndpointEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.region_endpoint_enabled = kwargs.get('region_endpoint_enabled', None)


class Request(msrest.serialization.Model):
    """The request that generated the event.

    :param id: The ID of the request that initiated the event.
    :type id: str
    :param addr: The IP or hostname and possibly port of the client connection that initiated the
     event. This is the RemoteAddr from the standard http request.
    :type addr: str
    :param host: The externally accessible hostname of the registry instance, as specified by the
     http host header on incoming requests.
    :type host: str
    :param method: The request method that generated the event.
    :type method: str
    :param useragent: The user agent header of the request.
    :type useragent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'addr': {'key': 'addr', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'useragent': {'key': 'useragent', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Request, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.addr = kwargs.get('addr', None)
        self.host = kwargs.get('host', None)
        self.method = kwargs.get('method', None)
        self.useragent = kwargs.get('useragent', None)


class RetentionPolicy(msrest.serialization.Model):
    """The retention policy for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param days: The number of days to retain an untagged manifest after which it gets purged.
    :type days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PolicyStatus
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.days = kwargs.get('days', 7)
        self.last_updated_time = None
        self.status = kwargs.get('status', None)


class ScopeMap(ProxyResource):
    """An object that represents a scope map for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :param description: The user friendly description of the scope map.
    :type description: str
    :ivar type_properties_type: The type of the scope map. E.g. BuildIn scope map.
    :vartype type_properties_type: str
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    :param actions: The list of scoped permissions for registry artifacts.
     E.g. repositories/repository-name/content/read,
     repositories/repository-name/metadata/write.
    :type actions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'type_properties_type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScopeMap, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.type_properties_type = None
        self.creation_date = None
        self.provisioning_state = None
        self.actions = kwargs.get('actions', None)


class ScopeMapListResult(msrest.serialization.Model):
    """The result of a request to list scope maps for a container registry.

    :param value: The list of scope maps. Since this list may be incomplete, the nextLink field
     should be used to request the next list of scope maps.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.ScopeMap]
    :param next_link: The URI that can be used to request the next list of scope maps.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ScopeMap]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScopeMapListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ScopeMapUpdateParameters(msrest.serialization.Model):
    """The properties for updating the scope map.

    :param description: The user friendly description of the scope map.
    :type description: str
    :param actions: The list of scope permissions for registry artifacts.
     E.g. repositories/repository-name/pull,
     repositories/repository-name/delete.
    :type actions: list[str]
    """

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScopeMapUpdateParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.actions = kwargs.get('actions', None)


class Sku(msrest.serialization.Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name of the container registry. Required for registry creation.
     Possible values include: "Classic", "Basic", "Standard", "Premium".
    :type name: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Possible values include: "Classic", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None


class Source(msrest.serialization.Model):
    """The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.

    :param addr: The IP or hostname and the port of the registry node that generated the event.
     Generally, this will be resolved by os.Hostname() along with the running port.
    :type addr: str
    :param instance_id: The running instance of an application. Changes after each restart.
    :type instance_id: str
    """

    _attribute_map = {
        'addr': {'key': 'addr', 'type': 'str'},
        'instance_id': {'key': 'instanceID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Source, self).__init__(**kwargs)
        self.addr = kwargs.get('addr', None)
        self.instance_id = kwargs.get('instance_id', None)


class Status(msrest.serialization.Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current value.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'timestamp': {'readonly': True},
    }

    _attribute_map = {
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Status, self).__init__(**kwargs)
        self.display_status = None
        self.message = None
        self.timestamp = None


class StatusDetailProperties(msrest.serialization.Model):
    """The status detail properties of the connected registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The component of the connected registry corresponding to the status.
    :vartype type: str
    :ivar code: The code of the status.
    :vartype code: str
    :ivar description: The description of the status.
    :vartype description: str
    :ivar timestamp: The timestamp of the status.
    :vartype timestamp: ~datetime.datetime
    :ivar correlation_id: The correlation ID of the status.
    :vartype correlation_id: str
    """

    _validation = {
        'type': {'readonly': True},
        'code': {'readonly': True},
        'description': {'readonly': True},
        'timestamp': {'readonly': True},
        'correlation_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatusDetailProperties, self).__init__(**kwargs)
        self.type = None
        self.code = None
        self.description = None
        self.timestamp = None
        self.correlation_id = None


class SyncProperties(msrest.serialization.Model):
    """The sync properties of the connected registry with its parent.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param token_id: Required. The resource ID of the ACR token used to authenticate the connected
     registry to its parent during sync.
    :type token_id: str
    :param schedule: The cron expression indicating the schedule that the connected registry will
     sync with its parent.
    :type schedule: str
    :param sync_window: The time window during which sync is enabled for each schedule occurrence.
     Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
    :type sync_window: ~datetime.timedelta
    :param message_ttl: Required. The period of time for which a message is available to sync
     before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per
     ISO8601.
    :type message_ttl: ~datetime.timedelta
    :ivar last_sync_time: The last time a sync occurred between the connected registry and its
     parent.
    :vartype last_sync_time: ~datetime.datetime
    :ivar gateway_endpoint: The gateway endpoint used by the connected registry to communicate with
     its parent.
    :vartype gateway_endpoint: str
    """

    _validation = {
        'token_id': {'required': True},
        'message_ttl': {'required': True},
        'last_sync_time': {'readonly': True},
        'gateway_endpoint': {'readonly': True},
    }

    _attribute_map = {
        'token_id': {'key': 'tokenId', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'str'},
        'sync_window': {'key': 'syncWindow', 'type': 'duration'},
        'message_ttl': {'key': 'messageTtl', 'type': 'duration'},
        'last_sync_time': {'key': 'lastSyncTime', 'type': 'iso-8601'},
        'gateway_endpoint': {'key': 'gatewayEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncProperties, self).__init__(**kwargs)
        self.token_id = kwargs['token_id']
        self.schedule = kwargs.get('schedule', None)
        self.sync_window = kwargs.get('sync_window', None)
        self.message_ttl = kwargs['message_ttl']
        self.last_sync_time = None
        self.gateway_endpoint = None


class SyncUpdateProperties(msrest.serialization.Model):
    """The parameters for updating the sync properties of the connected registry with its parent.

    :param schedule: The cron expression indicating the schedule that the connected registry will
     sync with its parent.
    :type schedule: str
    :param sync_window: The time window during which sync is enabled for each schedule occurrence.
     Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
    :type sync_window: ~datetime.timedelta
    :param message_ttl: The period of time for which a message is available to sync before it is
     expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
    :type message_ttl: ~datetime.timedelta
    """

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'sync_window': {'key': 'syncWindow', 'type': 'duration'},
        'message_ttl': {'key': 'messageTtl', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncUpdateProperties, self).__init__(**kwargs)
        self.schedule = kwargs.get('schedule', None)
        self.sync_window = kwargs.get('sync_window', None)
        self.message_ttl = kwargs.get('message_ttl', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.LastModifiedByType
    :param last_modified_at: The timestamp of resource modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class Target(msrest.serialization.Model):
    """The target of the event.

    :param media_type: The MIME type of the referenced object.
    :type media_type: str
    :param size: The number of bytes of the content. Same as Length field.
    :type size: long
    :param digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :type digest: str
    :param length: The number of bytes of the content. Same as Size field.
    :type length: long
    :param repository: The repository name.
    :type repository: str
    :param url: The direct URL to the content.
    :type url: str
    :param tag: The tag name.
    :type tag: str
    :param name: The name of the artifact.
    :type name: str
    :param version: The version of the artifact.
    :type version: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'length': {'key': 'length', 'type': 'long'},
        'repository': {'key': 'repository', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Target, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.size = kwargs.get('size', None)
        self.digest = kwargs.get('digest', None)
        self.length = kwargs.get('length', None)
        self.repository = kwargs.get('repository', None)
        self.url = kwargs.get('url', None)
        self.tag = kwargs.get('tag', None)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)


class TlsCertificateProperties(msrest.serialization.Model):
    """The TLS certificate properties of the connected registry login server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of certificate location. Possible values include: "LocalDirectory".
    :vartype type: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.CertificateType
    :ivar location: Indicates the location of the certificates.
    :vartype location: str
    """

    _validation = {
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TlsCertificateProperties, self).__init__(**kwargs)
        self.type = None
        self.location = None


class TlsProperties(msrest.serialization.Model):
    """The TLS properties of the connected registry login server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Indicates whether HTTPS is enabled for the login server. Possible values include:
     "Enabled", "Disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TlsStatus
    :ivar certificate: The certificate used to configure HTTPS for the login server.
    :vartype certificate:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TlsCertificateProperties
    """

    _validation = {
        'status': {'readonly': True},
        'certificate': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'TlsCertificateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TlsProperties, self).__init__(**kwargs)
        self.status = None
        self.certificate = None


class Token(ProxyResource):
    """An object that represents a token for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    :param scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :type scope_map_id: str
    :param credentials: The credentials that can be used for authenticating the token.
    :type credentials:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenCredentialsProperties
    :param status: The status of the token example enabled or disabled. Possible values include:
     "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'scope_map_id': {'key': 'properties.scopeMapId', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'TokenCredentialsProperties'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Token, self).__init__(**kwargs)
        self.creation_date = None
        self.provisioning_state = None
        self.scope_map_id = kwargs.get('scope_map_id', None)
        self.credentials = kwargs.get('credentials', None)
        self.status = kwargs.get('status', None)


class TokenCertificate(msrest.serialization.Model):
    """The properties of a certificate used for authenticating a token.

    :param name:  Possible values include: "certificate1", "certificate2".
    :type name: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenCertificateName
    :param expiry: The expiry datetime of the certificate.
    :type expiry: ~datetime.datetime
    :param thumbprint: The thumbprint of the certificate.
    :type thumbprint: str
    :param encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM format
     that will be used for authenticating the token.
    :type encoded_pem_certificate: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'encoded_pem_certificate': {'key': 'encodedPemCertificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.expiry = kwargs.get('expiry', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.encoded_pem_certificate = kwargs.get('encoded_pem_certificate', None)


class TokenCredentialsProperties(msrest.serialization.Model):
    """The properties of the credentials that can be used for authenticating the token.

    :param certificates:
    :type certificates:
     list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenCertificate]
    :param passwords:
    :type passwords: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        'certificates': {'key': 'certificates', 'type': '[TokenCertificate]'},
        'passwords': {'key': 'passwords', 'type': '[TokenPassword]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenCredentialsProperties, self).__init__(**kwargs)
        self.certificates = kwargs.get('certificates', None)
        self.passwords = kwargs.get('passwords', None)


class TokenListResult(msrest.serialization.Model):
    """The result of a request to list tokens for a container registry.

    :param value: The list of tokens. Since this list may be incomplete, the nextLink field should
     be used to request the next list of tokens.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.Token]
    :param next_link: The URI that can be used to request the next list of tokens.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Token]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TokenPassword(msrest.serialization.Model):
    """The password that will be used for authenticating the token of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param creation_time: The creation datetime of the password.
    :type creation_time: ~datetime.datetime
    :param expiry: The expiry datetime of the password.
    :type expiry: ~datetime.datetime
    :param name: The password name "password1" or "password2". Possible values include:
     "password1", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenPasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenPassword, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.expiry = kwargs.get('expiry', None)
        self.name = kwargs.get('name', None)
        self.value = None


class TokenUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a token.

    :param scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :type scope_map_id: str
    :param status: The status of the token example enabled or disabled. Possible values include:
     "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenStatus
    :param credentials: The credentials that can be used for authenticating the token.
    :type credentials:
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TokenCredentialsProperties
    """

    _attribute_map = {
        'scope_map_id': {'key': 'properties.scopeMapId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'TokenCredentialsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenUpdateParameters, self).__init__(**kwargs)
        self.scope_map_id = kwargs.get('scope_map_id', None)
        self.status = kwargs.get('status', None)
        self.credentials = kwargs.get('credentials', None)


class TrustPolicy(msrest.serialization.Model):
    """The content trust policy for a container registry.

    :param type: The type of trust policy. Possible values include: "Notary". Default value:
     "Notary".
    :type type: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.TrustPolicyType
    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.PolicyStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrustPolicy, self).__init__(**kwargs)
        self.type = kwargs.get('type', "Notary")
        self.status = kwargs.get('status', None)


class UserIdentityProperties(msrest.serialization.Model):
    """UserIdentityProperties.

    :param principal_id: The principal id of user assigned identity.
    :type principal_id: str
    :param client_id: The client id of user assigned identity.
    :type client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.client_id = kwargs.get('client_id', None)


class VirtualNetworkRule(msrest.serialization.Model):
    """Virtual network rule.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of virtual network rule. Possible values include: "Allow".
    :type action: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.Action
    :param virtual_network_resource_id: Required. Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_resource_id: str
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.virtual_network_resource_id = kwargs['virtual_network_resource_id']


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2020_11_01_preview.models.SystemData
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the time the operation was
     called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Webhook, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)
        self.provisioning_state = None


class WebhookCreateParameters(msrest.serialization.Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to Azure.

    :param tags: A set of tags. The tags for the webhook.
    :type tags: dict[str, str]
    :param location: Required. The location of the webhook. This cannot be changed after the
     resource is created.
    :type location: str
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.WebhookAction]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookCreateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']
        self.service_uri = kwargs.get('service_uri', None)
        self.custom_headers = kwargs.get('custom_headers', None)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)


class WebhookListResult(msrest.serialization.Model):
    """The result of a request to list webhooks for a container registry.

    :param value: The list of webhooks. Since this list may be incomplete, the nextLink field
     should be used to request the next list of webhooks.
    :type value: list[~azure.mgmt.containerregistry.v2020_11_01_preview.models.Webhook]
    :param next_link: The URI that can be used to request the next list of webhooks.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Webhook]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class WebhookUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a webhook.

    :param tags: A set of tags. The tags for the webhook.
    :type tags: dict[str, str]
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2020_11_01_preview.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2020_11_01_preview.models.WebhookAction]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.custom_headers = kwargs.get('custom_headers', None)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)
