# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class Actor(msrest.serialization.Model):
    """The agent that initiated the event. For most situations, this could be from the authorization context of the request.

    :param name: The subject or username associated with the request context that generated the
     event.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Actor, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CallbackConfig(msrest.serialization.Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to Azure.

    :param service_uri: Required. The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    """

    _validation = {
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'customHeaders', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CallbackConfig, self).__init__(**kwargs)
        self.service_uri = kwargs['service_uri']
        self.custom_headers = kwargs.get('custom_headers', None)


class EventInfo(msrest.serialization.Model):
    """The basic information of an event.

    :param id: The event ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class Event(EventInfo):
    """The event for a webhook.

    :param id: The event ID.
    :type id: str
    :param event_request_message: The event request message sent to the service URI.
    :type event_request_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventRequestMessage
    :param event_response_message: The event response message received from the service URI.
    :type event_response_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventResponseMessage
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_request_message': {'key': 'eventRequestMessage', 'type': 'EventRequestMessage'},
        'event_response_message': {'key': 'eventResponseMessage', 'type': 'EventResponseMessage'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Event, self).__init__(**kwargs)
        self.event_request_message = kwargs.get('event_request_message', None)
        self.event_response_message = kwargs.get('event_response_message', None)


class EventContent(msrest.serialization.Model):
    """The content of the event request message.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: ~datetime.datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~azure.mgmt.containerregistry.v2019_05_01.models.Target
    :param request: The request that generated the event.
    :type request: ~azure.mgmt.containerregistry.v2019_05_01.models.Request
    :param actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :type actor: ~azure.mgmt.containerregistry.v2019_05_01.models.Actor
    :param source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :type source: ~azure.mgmt.containerregistry.v2019_05_01.models.Source
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'Target'},
        'request': {'key': 'request', 'type': 'Request'},
        'actor': {'key': 'actor', 'type': 'Actor'},
        'source': {'key': 'source', 'type': 'Source'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventContent, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.action = kwargs.get('action', None)
        self.target = kwargs.get('target', None)
        self.request = kwargs.get('request', None)
        self.actor = kwargs.get('actor', None)
        self.source = kwargs.get('source', None)


class EventListResult(msrest.serialization.Model):
    """The result of a request to list events for a webhook.

    :param value: The list of events. Since this list may be incomplete, the nextLink field should
     be used to request the next list of events.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Event]
    :param next_link: The URI that can be used to request the next list of events.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Event]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class EventRequestMessage(msrest.serialization.Model):
    """The event request message sent to the service URI.

    :param content: The content of the event request message.
    :type content: ~azure.mgmt.containerregistry.v2019_05_01.models.EventContent
    :param headers: The headers of the event request message.
    :type headers: dict[str, str]
    :param method: The HTTP method used to send the event request message.
    :type method: str
    :param request_uri: The URI used to send the event request message.
    :type request_uri: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'EventContent'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'method': {'key': 'method', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventRequestMessage, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)
        self.headers = kwargs.get('headers', None)
        self.method = kwargs.get('method', None)
        self.request_uri = kwargs.get('request_uri', None)
        self.version = kwargs.get('version', None)


class EventResponseMessage(msrest.serialization.Model):
    """The event response message received from the service URI.

    :param content: The content of the event response message.
    :type content: str
    :param headers: The headers of the event response message.
    :type headers: dict[str, str]
    :param reason_phrase: The reason phrase of the event response message.
    :type reason_phrase: str
    :param status_code: The status code of the event response message.
    :type status_code: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'reason_phrase': {'key': 'reasonPhrase', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventResponseMessage, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)
        self.headers = kwargs.get('headers', None)
        self.reason_phrase = kwargs.get('reason_phrase', None)
        self.status_code = kwargs.get('status_code', None)
        self.version = kwargs.get('version', None)


class ImportImageParameters(msrest.serialization.Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The source of the image.
    :type source: ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSource
    :param target_tags: List of strings of the form repo[:tag]. When tag is omitted the source will
     be used (or 'latest' if source tag is also omitted).
    :type target_tags: list[str]
    :param untagged_target_repositories: List of strings of repository names to do a manifest only
     copy. No tag will be created.
    :type untagged_target_repositories: list[str]
    :param mode: When Force, any existing target tags will be overwritten. When NoForce, any
     existing target tags will fail the operation before any copying begins. Possible values
     include: "NoForce", "Force". Default value: "NoForce".
    :type mode: str or ~azure.mgmt.containerregistry.v2019_05_01.models.ImportMode
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ImportSource'},
        'target_tags': {'key': 'targetTags', 'type': '[str]'},
        'untagged_target_repositories': {'key': 'untaggedTargetRepositories', 'type': '[str]'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportImageParameters, self).__init__(**kwargs)
        self.source = kwargs['source']
        self.target_tags = kwargs.get('target_tags', None)
        self.untagged_target_repositories = kwargs.get('untagged_target_repositories', None)
        self.mode = kwargs.get('mode', "NoForce")


class ImportSource(msrest.serialization.Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: The resource identifier of the source Azure Container Registry.
    :type resource_id: str
    :param registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
    :type registry_uri: str
    :param credentials: Credentials used when importing from a registry uri.
    :type credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSourceCredentials
    :param source_image: Required. Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
    :type source_image: str
    """

    _validation = {
        'source_image': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'registry_uri': {'key': 'registryUri', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'ImportSourceCredentials'},
        'source_image': {'key': 'sourceImage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportSource, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.registry_uri = kwargs.get('registry_uri', None)
        self.credentials = kwargs.get('credentials', None)
        self.source_image = kwargs['source_image']


class ImportSourceCredentials(msrest.serialization.Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to Azure.

    :param username: The username to authenticate with the source registry.
    :type username: str
    :param password: Required. The password used to authenticate with the source registry.
    :type password: str
    """

    _validation = {
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportSourceCredentials, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs['password']


class IPRule(msrest.serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of IP ACL rule. Possible values include: "Allow".
    :type action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :param ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
     address is allowed.
    :type ip_address_or_range: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPRule, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.ip_address_or_range = kwargs['ip_address_or_range']


class NetworkRuleSet(msrest.serialization.Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to Azure.

    :param default_action: Required. The default action of allow or deny when no other rules match.
     Possible values include: "Allow", "Deny". Default value: "Allow".
    :type default_action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.DefaultAction
    :param virtual_network_rules: The virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.VirtualNetworkRule]
    :param ip_rules: The IP ACL rules.
    :type ip_rules: list[~azure.mgmt.containerregistry.v2019_05_01.models.IPRule]
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.default_action = kwargs.get('default_action', "Allow")
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.ip_rules = kwargs.get('ip_rules', None)


class OperationDefinition(msrest.serialization.Model):
    """The definition of a container registry operation.

    :param origin: The origin information of the container registry operation.
    :type origin: str
    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The display information for the container registry operation.
    :type display: ~azure.mgmt.containerregistry.v2019_05_01.models.OperationDisplayDefinition
    :param service_specification: The definition of Azure Monitoring service.
    :type service_specification:
     ~azure.mgmt.containerregistry.v2019_05_01.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayDefinition'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationServiceSpecificationDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDefinition, self).__init__(**kwargs)
        self.origin = kwargs.get('origin', None)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplayDefinition(msrest.serialization.Model):
    """The display information for a container registry operation.

    :param provider: The resource provider name: Microsoft.ContainerRegistry.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that users can perform.
    :type operation: str
    :param description: The description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplayDefinition, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """The result of a request to list container registry operations.

    :param value: The list of container registry operations. Since this list may be incomplete, the
     nextLink field should be used to request the next list of operations.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationDefinition]
    :param next_link: The URI that can be used to request the next list of container registry
     operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationMetricSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring metric.

    :param name: Metric name.
    :type name: str
    :param display_name: Metric display name.
    :type display_name: str
    :param display_description: Metric description.
    :type display_description: str
    :param unit: Metric unit.
    :type unit: str
    :param aggregation_type: Metric aggregation type.
    :type aggregation_type: str
    :param internal_metric_name: Internal metric name.
    :type internal_metric_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetricSpecificationDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.internal_metric_name = kwargs.get('internal_metric_name', None)


class OperationServiceSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring list.

    :param metric_specifications: A list of Azure Monitoring metrics definition.
    :type metric_specifications:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationMetricSpecificationDefinition]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetricSpecificationDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationServiceSpecificationDefinition, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class Policies(msrest.serialization.Model):
    """The policies for a container registry.

    :param quarantine_policy: The quarantine policy for a container registry.
    :type quarantine_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.QuarantinePolicy
    :param trust_policy: The content trust policy for a container registry.
    :type trust_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicy
    :param retention_policy: The retention policy for a container registry.
    :type retention_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.RetentionPolicy
    """

    _attribute_map = {
        'quarantine_policy': {'key': 'quarantinePolicy', 'type': 'QuarantinePolicy'},
        'trust_policy': {'key': 'trustPolicy', 'type': 'TrustPolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Policies, self).__init__(**kwargs)
        self.quarantine_policy = kwargs.get('quarantine_policy', None)
        self.trust_policy = kwargs.get('trust_policy', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class QuarantinePolicy(msrest.serialization.Model):
    """The quarantine policy for a container registry.

    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuarantinePolicy, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)


class RegenerateCredentialParameters(msrest.serialization.Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Specifies name of the password which should be regenerated -- password
     or password2. Possible values include: "password", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegenerateCredentialParameters, self).__init__(**kwargs)
        self.name = kwargs['name']


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param sku: Required. The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :ivar login_server: The URL that can be used to log into the container registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in ISO8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the container registry at the time the
     operation was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded",
     "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the container registry at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    :param admin_user_enabled: The value that indicates whether the admin user is enabled.
    :type admin_user_enabled: bool
    :param storage_account: The properties of the storage account for the container registry. Only
     applicable to Classic SKU.
    :type storage_account:
     ~azure.mgmt.containerregistry.v2019_05_01.models.StorageAccountProperties
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'login_server': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'login_server': {'key': 'properties.loginServer', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccountProperties'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Registry, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.status = None
        self.admin_user_enabled = kwargs.get('admin_user_enabled', False)
        self.storage_account = kwargs.get('storage_account', None)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.policies = kwargs.get('policies', None)


class RegistryListCredentialsResult(msrest.serialization.Model):
    """The response from the ListCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[RegistryPassword]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.passwords = kwargs.get('passwords', None)


class RegistryListResult(msrest.serialization.Model):
    """The result of a request to list container registries.

    :param value: The list of container registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of container registries.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Registry]
    :param next_link: The URI that can be used to request the next list of container registries.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Registry]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RegistryNameCheckRequest(msrest.serialization.Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the container registry.
    :type name: str
    :ivar type: Required. The resource type of the container registry. This field must be set to
     'Microsoft.ContainerRegistry/registries'. Default value:
     "Microsoft.ContainerRegistry/registries".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 5, 'pattern': r'^[a-zA-Z0-9]*$'},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryNameCheckRequest, self).__init__(**kwargs)
        self.name = kwargs['name']


class RegistryNameStatus(msrest.serialization.Model):
    """The result of a request to check the availability of a container registry name.

    :param name_available: The value that indicates whether the name is available.
    :type name_available: bool
    :param reason: If any, the reason that the name is not available.
    :type reason: str
    :param message: If any, the error message that provides more detail for the reason that the
     name is not available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryNameStatus, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class RegistryPassword(msrest.serialization.Model):
    """The login password for the container registry.

    :param name: The password name. Possible values include: "password", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    :param value: The password value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryPassword, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class RegistryUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a container registry.

    :param tags: A set of tags. The tags for the container registry.
    :type tags: dict[str, str]
    :param sku: The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :param admin_user_enabled: The value that indicates whether the admin user is enabled.
    :type admin_user_enabled: bool
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)
        self.admin_user_enabled = kwargs.get('admin_user_enabled', None)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.policies = kwargs.get('policies', None)


class RegistryUsage(msrest.serialization.Model):
    """The quota usage for a container registry.

    :param name: The name of the usage.
    :type name: str
    :param limit: The limit of the usage.
    :type limit: long
    :param current_value: The current value of the usage.
    :type current_value: long
    :param unit: The unit of measurement. Possible values include: "Count", "Bytes".
    :type unit: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsageUnit
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUsage, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.limit = kwargs.get('limit', None)
        self.current_value = kwargs.get('current_value', None)
        self.unit = kwargs.get('unit', None)


class RegistryUsageListResult(msrest.serialization.Model):
    """The result of a request to get container registry quota usages.

    :param value: The list of container registry quota usages.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegistryUsage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryUsageListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the replication at the time the operation
     was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Replication, self).__init__(**kwargs)
        self.provisioning_state = None
        self.status = None


class ReplicationListResult(msrest.serialization.Model):
    """The result of a request to list replications for a container registry.

    :param value: The list of replications. Since this list may be incomplete, the nextLink field
     should be used to request the next list of replications.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Replication]
    :param next_link: The URI that can be used to request the next list of replications.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Replication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ReplicationUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a replication.

    :param tags: A set of tags. The tags for the replication.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class Request(msrest.serialization.Model):
    """The request that generated the event.

    :param id: The ID of the request that initiated the event.
    :type id: str
    :param addr: The IP or hostname and possibly port of the client connection that initiated the
     event. This is the RemoteAddr from the standard http request.
    :type addr: str
    :param host: The externally accessible hostname of the registry instance, as specified by the
     http host header on incoming requests.
    :type host: str
    :param method: The request method that generated the event.
    :type method: str
    :param useragent: The user agent header of the request.
    :type useragent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'addr': {'key': 'addr', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'useragent': {'key': 'useragent', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Request, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.addr = kwargs.get('addr', None)
        self.host = kwargs.get('host', None)
        self.method = kwargs.get('method', None)
        self.useragent = kwargs.get('useragent', None)


class RetentionPolicy(msrest.serialization.Model):
    """The retention policy for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param days: The number of days to retain an untagged manifest after which it gets purged.
    :type days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.days = kwargs.get('days', 7)
        self.last_updated_time = None
        self.status = kwargs.get('status', None)


class Sku(msrest.serialization.Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name of the container registry. Required for registry creation.
     Possible values include: "Classic", "Basic", "Standard", "Premium".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Possible values include: "Classic", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None


class Source(msrest.serialization.Model):
    """The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.

    :param addr: The IP or hostname and the port of the registry node that generated the event.
     Generally, this will be resolved by os.Hostname() along with the running port.
    :type addr: str
    :param instance_id: The running instance of an application. Changes after each restart.
    :type instance_id: str
    """

    _attribute_map = {
        'addr': {'key': 'addr', 'type': 'str'},
        'instance_id': {'key': 'instanceID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Source, self).__init__(**kwargs)
        self.addr = kwargs.get('addr', None)
        self.instance_id = kwargs.get('instance_id', None)


class Status(msrest.serialization.Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current value.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'timestamp': {'readonly': True},
    }

    _attribute_map = {
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Status, self).__init__(**kwargs)
        self.display_status = None
        self.message = None
        self.timestamp = None


class StorageAccountProperties(msrest.serialization.Model):
    """The properties of a storage account for a container registry. Only applicable to Classic SKU.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The resource ID of the storage account.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountProperties, self).__init__(**kwargs)
        self.id = kwargs['id']


class Target(msrest.serialization.Model):
    """The target of the event.

    :param media_type: The MIME type of the referenced object.
    :type media_type: str
    :param size: The number of bytes of the content. Same as Length field.
    :type size: long
    :param digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :type digest: str
    :param length: The number of bytes of the content. Same as Size field.
    :type length: long
    :param repository: The repository name.
    :type repository: str
    :param url: The direct URL to the content.
    :type url: str
    :param tag: The tag name.
    :type tag: str
    :param name: The name of the artifact.
    :type name: str
    :param version: The version of the artifact.
    :type version: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'length': {'key': 'length', 'type': 'long'},
        'repository': {'key': 'repository', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Target, self).__init__(**kwargs)
        self.media_type = kwargs.get('media_type', None)
        self.size = kwargs.get('size', None)
        self.digest = kwargs.get('digest', None)
        self.length = kwargs.get('length', None)
        self.repository = kwargs.get('repository', None)
        self.url = kwargs.get('url', None)
        self.tag = kwargs.get('tag', None)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)


class TrustPolicy(msrest.serialization.Model):
    """The content trust policy for a container registry.

    :param type: The type of trust policy. Possible values include: "Notary". Default value:
     "Notary".
    :type type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicyType
    :param status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrustPolicy, self).__init__(**kwargs)
        self.type = kwargs.get('type', "Notary")
        self.status = kwargs.get('status', None)


class VirtualNetworkRule(msrest.serialization.Model):
    """Virtual network rule.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of virtual network rule. Possible values include: "Allow".
    :type action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :param virtual_network_resource_id: Required. Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_resource_id: str
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.virtual_network_resource_id = kwargs['virtual_network_resource_id']


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the time the operation was
     called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Webhook, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)
        self.provisioning_state = None


class WebhookCreateParameters(msrest.serialization.Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to Azure.

    :param tags: A set of tags. The tags for the webhook.
    :type tags: dict[str, str]
    :param location: Required. The location of the webhook. This cannot be changed after the
     resource is created.
    :type location: str
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookCreateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']
        self.service_uri = kwargs.get('service_uri', None)
        self.custom_headers = kwargs.get('custom_headers', None)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)


class WebhookListResult(msrest.serialization.Model):
    """The result of a request to list webhooks for a container registry.

    :param value: The list of webhooks. Since this list may be incomplete, the nextLink field
     should be used to request the next list of webhooks.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Webhook]
    :param next_link: The URI that can be used to request the next list of webhooks.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Webhook]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class WebhookUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a webhook.

    :param tags: A set of tags. The tags for the webhook.
    :type tags: dict[str, str]
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post notifications.
    :type actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.custom_headers = kwargs.get('custom_headers', None)
        self.status = kwargs.get('status', None)
        self.scope = kwargs.get('scope', None)
        self.actions = kwargs.get('actions', None)
