from flopy.mbase import Package

class ModflowPks(Package):
    '''Pks Package
    Only programmed to work with the default values; may need work for other options'''
    def __init__(self, model, mxiter=100, innerit=50, \
                 isolver=1, npc=2, iscl=0, iord=0, ncoresm=1, ncoresv=1, \
                 damp=1.0, dampt=1.0, relax=0.97, \
                 ifill=0, droptol=0.0, \
                 hclose=1e-3, rclose=1e-1, l2norm=None, \
                 iprpks=0, mutpks=3,
                 mpi=False, partopt=0, novlapimpsol=1, stenimpsol=2, verbose=0, partdata=None, \
                 extension='pks', unitnumber=27):
        Package.__init__(self, model, extension, 'PKS', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# PKS for MODFLOW, generated by Flopy.'
        self.url = 'pks.htm'
        self.mxiter = mxiter
        self.innerit = innerit
        self.isolver = isolver
        self.npc = npc
        self.iscl = iscl
        self.iord = iord
        self.ncoresm = ncoresm
        self.ncoresv = ncoresv
        self.damp = damp
        self.dampt = dampt
        self.relax = relax
        self.ifill = ifill
        self.droptol = droptol
        self.hclose = hclose
        self.rclose = rclose
        self.l2norm = l2norm
        self.iprpks = iprpks
        self.mutpks = mutpks
        # MPI
        self.mpi          = mpi
        self.partopt      = partopt
        self.novlapimpsol = novlapimpsol
        self.stenimpsol   = stenimpsol
        self.verbose      = verbose
        self.partdata     = partdata

        self.parent.add_package(self)
    def __repr__( self ):
        return 'Parallel Krylov solver package class'
    def write_file(self):
        # Open file for writing
        f_pks = open(self.fn_path, 'w')
        f_pks.write('%s\n' % self.heading)
        f_pks.write('MXITER {0}\n'.format(self.mxiter))
        f_pks.write('INNERIT {0}\n'.format(self.innerit))
        f_pks.write('ISOLVER {0}\n'.format(self.isolver))
        f_pks.write('NPC {0}\n'.format(self.npc))
        f_pks.write('ISCL {0}\n'.format(self.iscl))
        f_pks.write('IORD {0}\n'.format(self.iord))
        if self.ncoresm > 1:
        	f_pks.write('NCORESM {0}\n'.format(self.ncoresm))
        if self.ncoresv > 1:
        	f_pks.write('NCORESV {0}\n'.format(self.ncoresv))
        f_pks.write('DAMP {0}\n'.format(self.damp))
        f_pks.write('DAMPT {0}\n'.format(self.dampt))
        if self.npc > 0:
        	f_pks.write('RELAX {0}\n'.format(self.relax))
        if self.npc == 3:
	        f_pks.write('IFILL {0}\n'.format(self.ifill))
	        f_pks.write('DROPTOL {0}\n'.format(self.droptol))
        f_pks.write('HCLOSEPKS {0}\n'.format(self.hclose))
        f_pks.write('RCLOSEPKS {0}\n'.format(self.rclose))
        if self.l2norm != None:
            if self.l2norm.lower() == 'l2norm' or self.l2norm == '1':
            	f_pks.write('L2NORM\n')
            elif self.l2norm.lower() == 'rl2norm' or self.l2norm == '2':
            	f_pks.write('RELATIVE-L2NORM\n')
        f_pks.write('IPRPKS {0}\n'.format(self.iprpks))
        f_pks.write('MUTPKS {0}\n'.format(self.mutpks))
        # MPI
        if self.mpi:
            f_pks.write('PARTOPT {0}\n'.format(self.partopt))
            f_pks.write('NOVLAPIMPSOL {0}\n'.format(self.novlapimpsol))
            f_pks.write('STENIMPSOL {0}\n'.format(self.stenimpsol))
            f_pks.write('VERBOSE {0}\n'.format(self.verbose))
            if self.partopt == 1 | 2:
                pass
                # to be implemented

        f_pks.write('END\n')
        f_pks.close()

