'''OpenGL extension SGIX.shadow_ambient

Overview (from the spec)
	
	This extension allows a value other than 0.0 to be returned by the
	SGIX_shadow operation in the case when the shadow test passes.
	With this extension any floating point value in the range [0.0,
	1.0] can be returned as the texture value when an object is in
	shadow.  This allows the (untextured) ambient lighting and direct
	shadowed lighting from a single light source to be computed in a
	single pass.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/SGIX/shadow_ambient.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIX_shadow_ambient'
_DEPRECATED = False
GL_SHADOW_AMBIENT_SGIX = constant.Constant( 'GL_SHADOW_AMBIENT_SGIX', 0x80BF )


def glInitShadowAmbientSGIX():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
