'''OpenGL extension ARB.matrix_palette

Overview (from the spec)
	
	This extension extends the abilities of ARB_vertex_blend to include 
	a palette of modelview matrices.  The n vertex units use a palette
	of m modelview matrices.  (Where n and m are constrained to
	implementation defined maxima.)  Each vertex has a set of n
	indices into the palette, and a corresponding set of n weights.
	Matrix indices can be changed for each vertex (between Begin and
	End).  
	
	When this extension is utilized, the enabled units transform each
	vertex by the modelview matrices specified by the vertices'
	respective indices.  These results are subsequently scaled by the
	weights of the respective units and then summed to create the
	eyespace vertex.   
	
	A similar procedure is followed for normals.  Normals, however,
	are transformed by the inverse transpose of the modelview matrix.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/ARB/matrix_palette.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ARB_matrix_palette'
_DEPRECATED = False
GL_MATRIX_PALETTE_ARB = constant.Constant( 'GL_MATRIX_PALETTE_ARB', 0x8840 )
GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = constant.Constant( 'GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB', 0x8841 )
GL_MAX_PALETTE_MATRICES_ARB = constant.Constant( 'GL_MAX_PALETTE_MATRICES_ARB', 0x8842 )
GL_CURRENT_PALETTE_MATRIX_ARB = constant.Constant( 'GL_CURRENT_PALETTE_MATRIX_ARB', 0x8843 )
GL_MATRIX_INDEX_ARRAY_ARB = constant.Constant( 'GL_MATRIX_INDEX_ARRAY_ARB', 0x8844 )
GL_CURRENT_MATRIX_INDEX_ARB = constant.Constant( 'GL_CURRENT_MATRIX_INDEX_ARB', 0x8845 )
GL_MATRIX_INDEX_ARRAY_SIZE_ARB = constant.Constant( 'GL_MATRIX_INDEX_ARRAY_SIZE_ARB', 0x8846 )
glget.addGLGetConstant( GL_MATRIX_INDEX_ARRAY_SIZE_ARB, (1,) )
GL_MATRIX_INDEX_ARRAY_TYPE_ARB = constant.Constant( 'GL_MATRIX_INDEX_ARRAY_TYPE_ARB', 0x8847 )
glget.addGLGetConstant( GL_MATRIX_INDEX_ARRAY_TYPE_ARB, (1,) )
GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = constant.Constant( 'GL_MATRIX_INDEX_ARRAY_STRIDE_ARB', 0x8848 )
glget.addGLGetConstant( GL_MATRIX_INDEX_ARRAY_STRIDE_ARB, (1,) )
GL_MATRIX_INDEX_ARRAY_POINTER_ARB = constant.Constant( 'GL_MATRIX_INDEX_ARRAY_POINTER_ARB', 0x8849 )
glCurrentPaletteMatrixARB = platform.createExtensionFunction( 
'glCurrentPaletteMatrixARB',dll=platform.GL,
extension=EXTENSION_NAME,
resultType=None, 
argTypes=(constants.GLint,),
doc='glCurrentPaletteMatrixARB(GLint(index)) -> None',
argNames=('index',),
deprecated=_DEPRECATED,
)

glMatrixIndexubvARB = platform.createExtensionFunction( 
'glMatrixIndexubvARB',dll=platform.GL,
extension=EXTENSION_NAME,
resultType=None, 
argTypes=(constants.GLint,arrays.GLubyteArray,),
doc='glMatrixIndexubvARB(GLint(size), GLubyteArray(indices)) -> None',
argNames=('size','indices',),
deprecated=_DEPRECATED,
)

glMatrixIndexusvARB = platform.createExtensionFunction( 
'glMatrixIndexusvARB',dll=platform.GL,
extension=EXTENSION_NAME,
resultType=None, 
argTypes=(constants.GLint,arrays.GLushortArray,),
doc='glMatrixIndexusvARB(GLint(size), GLushortArray(indices)) -> None',
argNames=('size','indices',),
deprecated=_DEPRECATED,
)

glMatrixIndexuivARB = platform.createExtensionFunction( 
'glMatrixIndexuivARB',dll=platform.GL,
extension=EXTENSION_NAME,
resultType=None, 
argTypes=(constants.GLint,arrays.GLuintArray,),
doc='glMatrixIndexuivARB(GLint(size), GLuintArray(indices)) -> None',
argNames=('size','indices',),
deprecated=_DEPRECATED,
)

glMatrixIndexPointerARB = platform.createExtensionFunction( 
'glMatrixIndexPointerARB',dll=platform.GL,
extension=EXTENSION_NAME,
resultType=None, 
argTypes=(constants.GLint,constants.GLenum,constants.GLsizei,ctypes.c_void_p,),
doc='glMatrixIndexPointerARB(GLint(size), GLenum(type), GLsizei(stride), c_void_p(pointer)) -> None',
argNames=('size','type','stride','pointer',),
deprecated=_DEPRECATED,
)


def glInitMatrixPaletteARB():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
