# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .linked_service import LinkedService


class SalesforceLinkedService(LinkedService):
    """Linked service for Salesforce.

    :param connect_via: The integration runtime reference.
    :type connect_via: :class:`IntegrationRuntimeReference
     <azure.mgmt.datafactory.models.IntegrationRuntimeReference>`
    :param description: Linked service description.
    :type description: str
    :param type: Polymorphic Discriminator
    :type type: str
    :param environment_url: The URL of Salesforce instance. Default is
     'https://login.salesforce.com'. To copy data from sandbox, specify
     'https://test.salesforce.com'. To copy data from custom domain, specify,
     for example, 'https://[domain].my.salesforce.com'. Type: string (or
     Expression with resultType string).
    :type environment_url: object
    :param username: The username for Basic authentication of the Salesforce
     source. Type: string (or Expression with resultType string).
    :type username: object
    :param password: The password for Basic authentication of the Salesforce
     source.
    :type password: :class:`SecureString
     <azure.mgmt.datafactory.models.SecureString>`
    :param security_token: The security token is required to remotely access
     Salesforce source.
    :type security_token: :class:`SecureString
     <azure.mgmt.datafactory.models.SecureString>`
    :param encrypted_credential: The encrypted credential used for
     authentication. Credentials are encrypted using the integration runtime
     credential manager. Type: string (or Expression with resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'environment_url': {'key': 'typeProperties.environmentUrl', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecureString'},
        'security_token': {'key': 'typeProperties.securityToken', 'type': 'SecureString'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(self, connect_via=None, description=None, environment_url=None, username=None, password=None, security_token=None, encrypted_credential=None):
        super(SalesforceLinkedService, self).__init__(connect_via=connect_via, description=description)
        self.environment_url = environment_url
        self.username = username
        self.password = password
        self.security_token = security_token
        self.encrypted_credential = encrypted_credential
        self.type = 'Salesforce'
