# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset import Dataset


class AzureSearchIndexDataset(Dataset):
    """The Azure Search Index.

    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type:
     array (or Expression with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param linked_service_name: Linked service reference.
    :type linked_service_name: :class:`LinkedServiceReference
     <azure.mgmt.datafactory.models.LinkedServiceReference>`
    :param parameters: Parameters for dataset.
    :type parameters: dict
    :param type: Polymorphic Discriminator
    :type type: str
    :param index_name: The name of the Azure Search Index. Type: string (or
     Expression with resultType string).
    :type index_name: object
    """

    _validation = {
        'linked_service_name': {'required': True},
        'type': {'required': True},
        'index_name': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'type': {'key': 'type', 'type': 'str'},
        'index_name': {'key': 'typeProperties.indexName', 'type': 'object'},
    }

    def __init__(self, linked_service_name, index_name, description=None, structure=None, parameters=None):
        super(AzureSearchIndexDataset, self).__init__(description=description, structure=structure, linked_service_name=linked_service_name, parameters=parameters)
        self.index_name = index_name
        self.type = 'AzureSearchIndex'
