# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .azure_key_vault_reference import AzureKeyVaultReference


class AzureKeyVaultSecretReference(AzureKeyVaultReference):
    """Azure Key Vault Secret properties.

    :param store: The Azure Key Vault LinkedService.
    :type store: :class:`LinkedServiceReference
     <azure.mgmt.datafactory.models.LinkedServiceReference>`
    :param type: Polymorphic Discriminator
    :type type: str
    :param secret_name: The name of secret in Azure Key Vault. Type: string
     (or Expression with resultType string).
    :type secret_name: object
    :param secret_version: The version of the secret in Azure Key Vault. The
     default value is the latest version of the secret. Type: string (or
     Expression with resultType string).
    :type secret_version: object
    """

    _validation = {
        'store': {'required': True},
        'type': {'required': True},
        'secret_name': {'required': True},
    }

    _attribute_map = {
        'store': {'key': 'store', 'type': 'LinkedServiceReference'},
        'type': {'key': 'type', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'object'},
        'secret_version': {'key': 'secretVersion', 'type': 'object'},
    }

    def __init__(self, store, secret_name, secret_version=None):
        super(AzureKeyVaultSecretReference, self).__init__(store=store)
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.type = 'AzureKeyVaultSecret'
