# Copyright 2016 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Google Cloud Dataflow SDK for Python setup configuration.

The Apache Beam Python SDK code can be found at:
https://github.com/apache/incubator-beam/tree/python-sdk/sdks/python
"""

import os
import platform
import setuptools


def get_version():
  global_names = {}
  execfile(os.path.normpath('./apache_beam/version.py'),
           global_names)
  return global_names['__version__']

PACKAGE_NAME = 'apache-beam-sdk'
PACKAGE_VERSION = get_version()
PACKAGE_DESCRIPTION = 'Apache Beam SDK for Python'
PACKAGE_URL = 'https://beam.incubator.apache.org'
PACKAGE_DOWNLOAD_URL = 'TBD'
PACKAGE_AUTHOR = 'Apache Software Foundation'
PACKAGE_EMAIL = 'dev@beam.incubator.apache.org'
PACKAGE_KEYWORDS = 'apache beam'
PACKAGE_LONG_DESCRIPTION = '''
TBD
'''

# BEGIN: Code inserted for Google distribution only
def get_google_cloud_dataflow_version():
  global_names = {}
  execfile(os.path.normpath('./apache_beam/google_version.py'),
           global_names)
  return global_names['__version__']


PACKAGE_NAME = 'google-cloud-dataflow'
PACKAGE_VERSION = get_google_cloud_dataflow_version()
PACKAGE_DESCRIPTION = '...'
PACKAGE_URL = 'https://cloud.google.com/dataflow/'
PACKAGE_DOWNLOAD_URL = 'https://pypi.python.org/pypi/google-cloud-dataflow'
PACKAGE_AUTHOR = 'Google, Inc.'
PACKAGE_EMAIL = 'dataflow-sdk@google.com'
PACKAGE_KEYWORDS = 'google cloud dataflow apache beam'
PACKAGE_LONG_DESCRIPTION = '''
Google distribution of Apache Beam SDK.

The Apache Beam Python SDK code can be found at:
https://github.com/apache/incubator-beam/tree/python-sdk/sdks/python
'''
# END: Code inserted for Google distribution only

# Currently all compiled modules are optional  (for performance only).
if platform.system() == 'Windows':
  # Windows doesn't always provide int64_t.
  cythonize = lambda *args, **kwargs: []
else:
  try:
    # pylint: disable=g-statement-before-imports,g-import-not-at-top
    from Cython.Build import cythonize
  except ImportError:
    cythonize = lambda *args, **kwargs: []


REQUIRED_PACKAGES = [
    'avro>=1.7.7',
    'dill>=0.2.5',
    'google-apitools>=0.5.2',
    'httplib2>=0.8',
    'mock>=1.0.1',
    'oauth2client>=2.0.1',
    'protorpc>=0.9.1',
    'python-gflags>=2.0',
    'pyyaml>=3.10',
    ]


setuptools.setup(
    name=PACKAGE_NAME,
    version=PACKAGE_VERSION,
    description=PACKAGE_DESCRIPTION,
    long_description=PACKAGE_LONG_DESCRIPTION,
    url=PACKAGE_URL,
    download_url=PACKAGE_DOWNLOAD_URL,
    author=PACKAGE_AUTHOR,
    author_email=PACKAGE_EMAIL,
    packages=setuptools.find_packages(),
    package_data={'apache_beam': ['**/*.pyx', '**/*.pxd']},
    ext_modules=cythonize([
        '**/*.pyx',
        'apache_beam/coders/coder_impl.py',
        'apache_beam/runners/common.py',
        'apache_beam/transforms/cy_combiners.py',
        'apache_beam/utils/counters.py',
        'apache_beam/utils/windowed_value.py',
    ]),
    setup_requires=['nose>=1.0'],
    install_requires=REQUIRED_PACKAGES,
    test_suite='nose.collector',
    zip_safe=False,
    # PyPI package information.
    classifiers=[
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 2.7',
        'Topic :: Software Development :: Libraries',
        'Topic :: Software Development :: Libraries :: Python Modules',
        ],
    license='Apache 2.0',
    keywords=PACKAGE_KEYWORDS,
    )
