# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class ApplicationDefinitionKind(Enum):

    invalid = "Invalid"
    service_fabric_application_description = "ServiceFabricApplicationDescription"
    compose = "Compose"


class HealthState(Enum):

    invalid = "Invalid"
    ok = "Ok"
    warning = "Warning"
    error = "Error"
    unknown = "Unknown"


class ApplicationStatus(Enum):

    invalid = "Invalid"
    ready = "Ready"
    upgrading = "Upgrading"
    creating = "Creating"
    deleting = "Deleting"
    failed = "Failed"


class ApplicationTypeDefinitionKind(Enum):

    invalid = "Invalid"
    service_fabric_application_package = "ServiceFabricApplicationPackage"
    compose = "Compose"


class ApplicationTypeStatus(Enum):

    invalid = "Invalid"
    provisioning = "Provisioning"
    available = "Available"
    unprovisioning = "Unprovisioning"
    failed = "Failed"


class UpgradeKind(Enum):

    invalid = "Invalid"
    rolling = "Rolling"


class UpgradeMode(Enum):

    invalid = "Invalid"
    unmonitored_auto = "UnmonitoredAuto"
    unmonitored_manual = "UnmonitoredManual"
    monitored = "Monitored"


class FailureAction(Enum):

    invalid = "Invalid"
    rollback = "Rollback"
    manual = "Manual"


class UpgradeDomainState(Enum):

    invalid = "Invalid"
    pending = "Pending"
    in_progress = "InProgress"
    completed = "Completed"


class UpgradeState(Enum):

    invalid = "Invalid"
    rolling_back_in_progress = "RollingBackInProgress"
    rolling_back_completed = "RollingBackCompleted"
    rolling_forward_pending = "RollingForwardPending"
    rolling_forward_in_progress = "RollingForwardInProgress"
    rolling_forward_completed = "RollingForwardCompleted"
    failed = "Failed"


class NodeUpgradePhase(Enum):

    invalid = "Invalid"
    pre_upgrade_safety_check = "PreUpgradeSafetyCheck"
    upgrading = "Upgrading"
    post_upgrade_safety_check = "PostUpgradeSafetyCheck"


class FailureReason(Enum):

    none = "None"
    interrupted = "Interrupted"
    health_check = "HealthCheck"
    upgrade_domain_timeout = "UpgradeDomainTimeout"
    overall_upgrade_timeout = "OverallUpgradeTimeout"


class DeactivationIntent(Enum):

    pause = "Pause"
    restart = "Restart"
    remove_data = "RemoveData"


class DeployedApplicationStatus(Enum):

    invalid = "Invalid"
    downloading = "Downloading"
    activating = "Activating"
    active = "Active"
    upgrading = "Upgrading"
    deactivating = "Deactivating"


class ReplicaRole(Enum):

    unknown = "Unknown"
    none = "None"
    primary = "Primary"
    idle_secondary = "IdleSecondary"
    active_secondary = "ActiveSecondary"


class ReconfigurationPhase(Enum):

    unknown = "Unknown"
    none = "None"
    phase0 = "Phase0"
    phase1 = "Phase1"
    phase2 = "Phase2"
    phase3 = "Phase3"
    phase4 = "Phase4"
    abort_phase_zero = "AbortPhaseZero"


class ReconfigurationType(Enum):

    unknown = "Unknown"
    swap_primary = "SwapPrimary"
    failover = "Failover"
    other = "Other"


class EntityKind(Enum):

    invalid = "Invalid"
    node = "Node"
    partition = "Partition"
    service = "Service"
    application = "Application"
    replica = "Replica"
    deployed_application = "DeployedApplication"
    deployed_service_package = "DeployedServicePackage"
    cluster = "Cluster"


class HealthEvaluationKind(Enum):

    invalid = "Invalid"
    event = "Event"
    replicas = "Replicas"
    partitions = "Partitions"
    deployed_service_packages = "DeployedServicePackages"
    deployed_applications = "DeployedApplications"
    services = "Services"
    nodes = "Nodes"
    applications = "Applications"
    system_application = "SystemApplication"
    upgrade_domain_deployed_applications = "UpgradeDomainDeployedApplications"
    upgrade_domain_nodes = "UpgradeDomainNodes"
    replica = "Replica"
    partition = "Partition"
    deployed_service_package = "DeployedServicePackage"
    deployed_application = "DeployedApplication"
    service = "Service"
    node = "Node"
    application = "Application"
    delta_nodes_check = "DeltaNodesCheck"
    upgrade_domain_delta_nodes_check = "UpgradeDomainDeltaNodesCheck"
    application_type_applications = "ApplicationTypeApplications"


class NodeDeactivationIntent(Enum):

    invalid = "Invalid"
    pause = "Pause"
    restart = "Restart"
    remove_data = "RemoveData"
    remove_node = "RemoveNode"


class NodeDeactivationStatus(Enum):

    none = "None"
    safety_check_in_progress = "SafetyCheckInProgress"
    safety_check_complete = "SafetyCheckComplete"
    completed = "Completed"


class NodeDeactivationTaskType(Enum):

    invalid = "Invalid"
    infrastructure = "Infrastructure"
    repair = "Repair"
    client = "Client"


class NodeStatus(Enum):

    invalid = "Invalid"
    up = "Up"
    down = "Down"
    enabling = "Enabling"
    disabling = "Disabling"
    disabled = "Disabled"
    unknown = "Unknown"
    removed = "Removed"


class ServicePartitionStatus(Enum):

    invalid = "Invalid"
    ready = "Ready"
    not_ready = "NotReady"
    in_quorum_loss = "InQuorumLoss"
    reconfiguring = "Reconfiguring"
    deleting = "Deleting"


class ServiceStatus(Enum):

    unknown = "Unknown"
    active = "Active"
    upgrading = "Upgrading"
    deleting = "Deleting"
    creating = "Creating"
    failed = "Failed"


class ProvisionApplicationTypeKind(Enum):

    invalid = "Invalid"
    image_store_path = "ImageStorePath"
    external_store = "ExternalStore"


class UpgradeType(Enum):

    invalid = "Invalid"
    rolling = "Rolling"
    rolling_force_restart = "Rolling_ForceRestart"


class SafetyCheckKind(Enum):

    invalid = "Invalid"
    ensure_seed_node_quorum = "EnsureSeedNodeQuorum"
    ensure_partition_quorum = "EnsurePartitionQuorum"
    wait_for_primary_placement = "WaitForPrimaryPlacement"
    wait_for_primary_swap = "WaitForPrimarySwap"
    wait_for_reconfiguration = "WaitForReconfiguration"
    wait_for_inbuild_replica = "WaitForInbuildReplica"
    ensure_availability = "EnsureAvailability"


class CreateFabricDump(Enum):

    false = "False"
    true = "True"


class ServicePackageActivationMode(Enum):

    shared_process = "SharedProcess"
    exclusive_process = "ExclusiveProcess"


class ServiceKind(Enum):

    invalid = "Invalid"
    stateless = "Stateless"
    stateful = "Stateful"


class ServicePlacementPolicyType(Enum):

    invalid = "Invalid"
    invalid_domain = "InvalidDomain"
    required_domain = "RequiredDomain"
    preferred_primary_domain = "PreferredPrimaryDomain"
    required_domain_distribution = "RequiredDomainDistribution"
    non_partially_place_service = "NonPartiallyPlaceService"


class HostType(Enum):

    invalid = "Invalid"
    exe_host = "ExeHost"
    container_host = "ContainerHost"


class HostIsolationMode(Enum):

    none = "None"
    process = "Process"
    hyper_v = "HyperV"


class DeploymentStatus(Enum):

    invalid = "Invalid"
    downloading = "Downloading"
    activating = "Activating"
    active = "Active"
    upgrading = "Upgrading"
    deactivating = "Deactivating"


class EntryPointStatus(Enum):

    invalid = "Invalid"
    pending = "Pending"
    starting = "Starting"
    started = "Started"
    stopping = "Stopping"
    stopped = "Stopped"


class ChaosEventKind(Enum):

    invalid = "Invalid"
    started = "Started"
    executing_faults = "ExecutingFaults"
    waiting = "Waiting"
    validation_failed = "ValidationFailed"
    test_error = "TestError"
    stopped = "Stopped"


class Status(Enum):

    invalid = "Invalid"
    running = "Running"
    stopped = "Stopped"


class ComposeDeploymentStatus(Enum):

    invalid = "Invalid"
    provisioning = "Provisioning"
    creating = "Creating"
    ready = "Ready"
    unprovisioning = "Unprovisioning"
    deleting = "Deleting"
    failed = "Failed"
    upgrading = "Upgrading"


class ComposeDeploymentUpgradeState(Enum):

    invalid = "Invalid"
    provisioning_target = "ProvisioningTarget"
    rolling_forward_in_progress = "RollingForwardInProgress"
    rolling_forward_pending = "RollingForwardPending"
    unprovisioning_current = "UnprovisioningCurrent"
    rolling_forward_completed = "RollingForwardCompleted"
    rolling_back_in_progress = "RollingBackInProgress"
    unprovisioning_target = "UnprovisioningTarget"
    rolling_back_completed = "RollingBackCompleted"
    failed = "Failed"


class ServiceCorrelationScheme(Enum):

    invalid = "Invalid"
    affinity = "Affinity"
    aligned_affinity = "AlignedAffinity"
    non_aligned_affinity = "NonAlignedAffinity"


class MoveCost(Enum):

    zero = "Zero"
    low = "Low"
    medium = "Medium"
    high = "High"


class PartitionScheme(Enum):

    invalid = "Invalid"
    singleton = "Singleton"
    uniform_int64_range = "UniformInt64Range"
    named = "Named"


class ServiceLoadMetricWeight(Enum):

    zero = "Zero"
    low = "Low"
    medium = "Medium"
    high = "High"


class ServiceOperationName(Enum):

    unknown = "Unknown"
    none = "None"
    open = "Open"
    change_role = "ChangeRole"
    close = "Close"
    abort = "Abort"


class ReplicatorOperationName(Enum):

    invalid = "Invalid"
    none = "None"
    open = "Open"
    change_role = "ChangeRole"
    update_epoch = "UpdateEpoch"
    close = "Close"
    abort = "Abort"
    on_data_loss = "OnDataLoss"
    wait_for_catchup = "WaitForCatchup"
    build = "Build"


class PartitionAccessStatus(Enum):

    invalid = "Invalid"
    granted = "Granted"
    reconfiguration_pending = "ReconfigurationPending"
    not_primary = "NotPrimary"
    no_write_quorum = "NoWriteQuorum"


class FabricReplicaStatus(Enum):

    invalid = "Invalid"
    down = "Down"
    up = "Up"


class ReplicaKind(Enum):

    invalid = "Invalid"
    key_value_store = "KeyValueStore"


class ServiceTypeRegistrationStatus(Enum):

    invalid = "Invalid"
    disabled = "Disabled"
    enabled = "Enabled"
    registered = "Registered"


class ServiceEndpointRole(Enum):

    invalid = "Invalid"
    stateless = "Stateless"
    stateful_primary = "StatefulPrimary"
    stateful_secondary = "StatefulSecondary"


class OperationState(Enum):

    invalid = "Invalid"
    running = "Running"
    rolling_back = "RollingBack"
    completed = "Completed"
    faulted = "Faulted"
    cancelled = "Cancelled"
    force_cancelled = "ForceCancelled"


class OperationType(Enum):

    invalid = "Invalid"
    partition_data_loss = "PartitionDataLoss"
    partition_quorum_loss = "PartitionQuorumLoss"
    partition_restart = "PartitionRestart"
    node_transition = "NodeTransition"


class PackageSharingPolicyScope(Enum):

    none = "None"
    all = "All"
    code = "Code"
    config = "Config"
    data = "Data"


class PropertyValueKind(Enum):

    invalid = "Invalid"
    binary = "Binary"
    int64 = "Int64"
    double = "Double"
    string = "String"
    guid = "Guid"


class PropertyBatchOperationKind(Enum):

    invalid = "Invalid"
    put = "Put"
    get = "Get"
    check_exists = "CheckExists"
    check_sequence = "CheckSequence"
    delete = "Delete"
    check_value = "CheckValue"


class PropertyBatchInfoKind(Enum):

    invalid = "Invalid"
    successful = "Successful"
    failed = "Failed"


class ImpactLevel(Enum):

    invalid = "Invalid"
    none = "None"
    restart = "Restart"
    remove_data = "RemoveData"
    remove_node = "RemoveNode"


class RepairImpactKind(Enum):

    invalid = "Invalid"
    node = "Node"


class RepairTargetKind(Enum):

    invalid = "Invalid"
    node = "Node"


class State(Enum):

    invalid = "Invalid"
    created = "Created"
    claimed = "Claimed"
    preparing = "Preparing"
    approved = "Approved"
    executing = "Executing"
    restoring = "Restoring"
    completed = "Completed"


class ResultStatus(Enum):

    invalid = "Invalid"
    succeeded = "Succeeded"
    cancelled = "Cancelled"
    interrupted = "Interrupted"
    failed = "Failed"
    pending = "Pending"


class RepairTaskHealthCheckState(Enum):

    not_started = "NotStarted"
    in_progress = "InProgress"
    succeeded = "Succeeded"
    skipped = "Skipped"
    timed_out = "TimedOut"


class NodeStatusFilterOptionalQueryParam(Enum):

    default = "default"
    all = "all"
    up = "up"
    down = "down"
    enabling = "enabling"
    disabling = "disabling"
    disabled = "disabled"
    unknown = "unknown"
    removed = "removed"


class ReplicaHealthReportServiceKindRequiredQueryParam(Enum):

    stateless = "Stateless"
    stateful = "Stateful"


class DataLossModeRequiredQueryParam(Enum):

    invalid = "Invalid"
    partial_data_loss = "PartialDataLoss"
    full_data_loss = "FullDataLoss"


class NodeTransitionTypeRequiredQueryParam(Enum):

    invalid = "Invalid"
    start = "Start"
    stop = "Stop"


class QuorumLossModeRequiredQueryParam(Enum):

    invalid = "Invalid"
    quorum_replicas = "QuorumReplicas"
    all_replicas = "AllReplicas"


class RestartPartitionModeRequiredQueryParam(Enum):

    invalid = "Invalid"
    all_replicas_or_instances = "AllReplicasOrInstances"
    only_active_secondaries = "OnlyActiveSecondaries"
