/* Copyright 2017 - 2021 R. Thomas
 * Copyright 2017 - 2021 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_MSVCP110_DLL_LOOKUP_H_
#define LIEF_PE_MSVCP110_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> msvcp110_dll_lookup {
    { 0x0001, "??$_Getvals@_W@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAX_WAEBV_Locinfo@1@@Z"                                                                       },
    { 0x0002, "??$_Getvals@_W@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAX_WAEBV_Locinfo@1@@Z"                                                                       },
    { 0x0003, "??$_Getvals@_W@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAX_WAEBV_Locinfo@1@@Z"                                                                    },
    { 0x0004, "??0?$_Yarn@D@std@@QEAA@AEBV01@@Z"                                                                                                                                                    },
    { 0x0005, "??0?$_Yarn@D@std@@QEAA@PEBD@Z"                                                                                                                                                       },
    { 0x0006, "??0?$_Yarn@D@std@@QEAA@XZ"                                                                                                                                                           },
    { 0x0007, "??0?$_Yarn@_W@std@@QEAA@XZ"                                                                                                                                                          },
    { 0x0008, "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ"                                                                                                                                 },
    { 0x0009, "??0?$basic_ios@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                                 },
    { 0x000a, "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IEAA@XZ"                                                                                                                                 },
    { 0x000b, "??0?$basic_ios@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                                 },
    { 0x000c, "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"                                                                                                                               },
    { 0x000d, "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                             },
    { 0x000e, "??0?$basic_iostream@DU?$char_traits@D@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                   },
    { 0x000f, "??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                            },
    { 0x0010, "??0?$basic_iostream@GU?$char_traits@G@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                   },
    { 0x0011, "??0?$basic_iostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                            },
    { 0x0012, "??0?$basic_iostream@_WU?$char_traits@_W@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                 },
    { 0x0013, "??0?$basic_iostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                        },
    { 0x0014, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0015, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N1@Z"                                                                          },
    { 0x0016, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"                                                                           },
    { 0x0017, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@W4_Uninitialized@1@@Z"                                                                                                          },
    { 0x0018, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0019, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N1@Z"                                                                          },
    { 0x001a, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"                                                                           },
    { 0x001b, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@W4_Uninitialized@1@@Z"                                                                                                          },
    { 0x001c, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                  },
    { 0x001d, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N1@Z"                                                                      },
    { 0x001e, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"                                                                       },
    { 0x001f, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@W4_Uninitialized@1@@Z"                                                                                                        },
    { 0x0020, "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0021, "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"                                                                           },
    { 0x0022, "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@W4_Uninitialized@1@_N@Z"                                                                                                        },
    { 0x0023, "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0024, "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"                                                                           },
    { 0x0025, "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@W4_Uninitialized@1@_N@Z"                                                                                                        },
    { 0x0026, "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                  },
    { 0x0027, "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"                                                                       },
    { 0x0028, "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@W4_Uninitialized@1@_N@Z"                                                                                                      },
    { 0x0029, "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@AEBV01@@Z"                                                                                                                    },
    { 0x002a, "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@W4_Uninitialized@1@@Z"                                                                                                        },
    { 0x002b, "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ"                                                                                                                           },
    { 0x002c, "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@AEBV01@@Z"                                                                                                                    },
    { 0x002d, "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@W4_Uninitialized@1@@Z"                                                                                                        },
    { 0x002e, "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@XZ"                                                                                                                           },
    { 0x002f, "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@AEBV01@@Z"                                                                                                                  },
    { 0x0030, "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@W4_Uninitialized@1@@Z"                                                                                                      },
    { 0x0031, "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"                                                                                                                         },
    { 0x0032, "??0?$codecvt@DDH@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                      },
    { 0x0033, "??0?$codecvt@DDH@std@@QEAA@_K@Z"                                                                                                                                                     },
    { 0x0034, "??0?$codecvt@GDH@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                      },
    { 0x0035, "??0?$codecvt@GDH@std@@QEAA@_K@Z"                                                                                                                                                     },
    { 0x0036, "??0?$codecvt@_WDH@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                     },
    { 0x0037, "??0?$codecvt@_WDH@std@@QEAA@_K@Z"                                                                                                                                                    },
    { 0x0038, "??0?$ctype@D@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                          },
    { 0x0039, "??0?$ctype@D@std@@QEAA@PEBF_N_K@Z"                                                                                                                                                   },
    { 0x003a, "??0?$ctype@G@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                          },
    { 0x003b, "??0?$ctype@G@std@@QEAA@_K@Z"                                                                                                                                                         },
    { 0x003c, "??0?$ctype@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                         },
    { 0x003d, "??0?$ctype@_W@std@@QEAA@_K@Z"                                                                                                                                                        },
    { 0x003e, "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x003f, "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0040, "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x0041, "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0042, "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                 },
    { 0x0043, "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                                },
    { 0x0044, "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x0045, "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0046, "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x0047, "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0048, "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                 },
    { 0x0049, "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                                },
    { 0x004a, "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                              },
    { 0x004b, "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x004c, "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x004d, "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                              },
    { 0x004e, "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x004f, "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x0050, "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                           },
    { 0x0051, "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                },
    { 0x0052, "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                               },
    { 0x0053, "??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x0054, "??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x0055, "??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                              },
    { 0x0056, "??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x0057, "??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x0058, "??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                           },
    { 0x0059, "??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                },
    { 0x005a, "??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                               },
    { 0x005b, "??0Init@ios_base@std@@QEAA@XZ"                                                                                                                                                       },
    { 0x005c, "??0_Concurrent_queue_base_v4@details@Concurrency@@IEAA@_K@Z"                                                                                                                         },
    { 0x005d, "??0_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAA@AEBV_Concurrent_queue_base_v4@12@@Z"                                                                                 },
    { 0x005e, "??0_Container_base12@std@@QEAA@AEBU01@@Z"                                                                                                                                            },
    { 0x005f, "??0_Container_base12@std@@QEAA@XZ"                                                                                                                                                   },
    { 0x0060, "??0_Facet_base@std@@QEAA@AEBV01@@Z"                                                                                                                                                  },
    { 0x0061, "??0_Facet_base@std@@QEAA@XZ"                                                                                                                                                         },
    { 0x0062, "??0_Init_locks@std@@QEAA@XZ"                                                                                                                                                         },
    { 0x0063, "??0_Locimp@locale@std@@AEAA@AEBV012@@Z"                                                                                                                                              },
    { 0x0064, "??0_Locimp@locale@std@@AEAA@_N@Z"                                                                                                                                                    },
    { 0x0065, "??0_Locinfo@std@@QEAA@HPEBD@Z"                                                                                                                                                       },
    { 0x0066, "??0_Locinfo@std@@QEAA@PEBD@Z"                                                                                                                                                        },
    { 0x0067, "??0_Lockit@std@@QEAA@H@Z"                                                                                                                                                            },
    { 0x0068, "??0_Lockit@std@@QEAA@XZ"                                                                                                                                                             },
    { 0x0069, "??0_Pad@std@@QEAA@AEBV01@@Z"                                                                                                                                                         },
    { 0x006a, "??0_Pad@std@@QEAA@XZ"                                                                                                                                                                },
    { 0x006b, "??0_Runtime_object@details@Concurrency@@QEAA@H@Z"                                                                                                                                    },
    { 0x006c, "??0_Runtime_object@details@Concurrency@@QEAA@XZ"                                                                                                                                     },
    { 0x006d, "??0_Timevec@std@@QEAA@AEBV01@@Z"                                                                                                                                                     },
    { 0x006e, "??0_Timevec@std@@QEAA@PEAX@Z"                                                                                                                                                        },
    { 0x006f, "??0_UShinit@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x0070, "??0_Winit@std@@QEAA@XZ"                                                                                                                                                              },
    { 0x0071, "??0agent@Concurrency@@QEAA@AEAVScheduleGroup@1@@Z"                                                                                                                                   },
    { 0x0072, "??0agent@Concurrency@@QEAA@AEAVScheduler@1@@Z"                                                                                                                                       },
    { 0x0073, "??0agent@Concurrency@@QEAA@XZ"                                                                                                                                                       },
    { 0x0074, "??0codecvt_base@std@@QEAA@_K@Z"                                                                                                                                                      },
    { 0x0075, "??0ctype_base@std@@QEAA@_K@Z"                                                                                                                                                        },
    { 0x0076, "??0facet@locale@std@@IEAA@_K@Z"                                                                                                                                                      },
    { 0x0077, "??0id@locale@std@@QEAA@_K@Z"                                                                                                                                                         },
    { 0x0078, "??0ios_base@std@@IEAA@XZ"                                                                                                                                                            },
    { 0x0079, "??0time_base@std@@QEAA@_K@Z"                                                                                                                                                         },
    { 0x007a, "??1?$_Yarn@D@std@@QEAA@XZ"                                                                                                                                                           },
    { 0x007b, "??1?$_Yarn@_W@std@@QEAA@XZ"                                                                                                                                                          },
    { 0x007c, "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                                 },
    { 0x007d, "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                                 },
    { 0x007e, "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                               },
    { 0x007f, "??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                            },
    { 0x0080, "??1?$basic_iostream@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                            },
    { 0x0081, "??1?$basic_iostream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                          },
    { 0x0082, "??1?$basic_istream@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0083, "??1?$basic_istream@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0084, "??1?$basic_istream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x0085, "??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0086, "??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0087, "??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x0088, "??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x0089, "??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x008a, "??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                         },
    { 0x008b, "??1?$codecvt@DDH@std@@MEAA@XZ"                                                                                                                                                       },
    { 0x008c, "??1?$codecvt@GDH@std@@MEAA@XZ"                                                                                                                                                       },
    { 0x008d, "??1?$codecvt@_WDH@std@@MEAA@XZ"                                                                                                                                                      },
    { 0x008e, "??1?$ctype@D@std@@MEAA@XZ"                                                                                                                                                           },
    { 0x008f, "??1?$ctype@G@std@@MEAA@XZ"                                                                                                                                                           },
    { 0x0090, "??1?$ctype@_W@std@@MEAA@XZ"                                                                                                                                                          },
    { 0x0091, "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0092, "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0093, "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                  },
    { 0x0094, "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0095, "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0096, "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                  },
    { 0x0097, "??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x0098, "??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x0099, "??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                 },
    { 0x009a, "??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x009b, "??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x009c, "??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                 },
    { 0x009d, "??1Init@ios_base@std@@QEAA@XZ"                                                                                                                                                       },
    { 0x009e, "??1_Concurrent_queue_base_v4@details@Concurrency@@MEAA@XZ"                                                                                                                           },
    { 0x009f, "??1_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAA@XZ"                                                                                                                  },
    { 0x00a0, "??1_Concurrent_vector_base_v4@details@Concurrency@@IEAA@XZ"                                                                                                                          },
    { 0x00a1, "??1_Container_base12@std@@QEAA@XZ"                                                                                                                                                   },
    { 0x00a2, "??1_Facet_base@std@@UEAA@XZ"                                                                                                                                                         },
    { 0x00a3, "??1_Init_locks@std@@QEAA@XZ"                                                                                                                                                         },
    { 0x00a4, "??1_Locimp@locale@std@@MEAA@XZ"                                                                                                                                                      },
    { 0x00a5, "??1_Locinfo@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x00a6, "??1_Lockit@std@@QEAA@XZ"                                                                                                                                                             },
    { 0x00a7, "??1_Pad@std@@QEAA@XZ"                                                                                                                                                                },
    { 0x00a8, "??1_Timevec@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x00a9, "??1_UShinit@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x00aa, "??1_Winit@std@@QEAA@XZ"                                                                                                                                                              },
    { 0x00ab, "??1agent@Concurrency@@UEAA@XZ"                                                                                                                                                       },
    { 0x00ac, "??1codecvt_base@std@@UEAA@XZ"                                                                                                                                                        },
    { 0x00ad, "??1ctype_base@std@@UEAA@XZ"                                                                                                                                                          },
    { 0x00ae, "??1facet@locale@std@@MEAA@XZ"                                                                                                                                                        },
    { 0x00af, "??1ios_base@std@@UEAA@XZ"                                                                                                                                                            },
    { 0x00b0, "??1time_base@std@@UEAA@XZ"                                                                                                                                                           },
    { 0x00b1, "??4?$_Iosb@H@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                              },
    { 0x00b2, "??4?$_Yarn@D@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                              },
    { 0x00b3, "??4?$_Yarn@D@std@@QEAAAEAV01@PEBD@Z"                                                                                                                                                 },
    { 0x00b4, "??4?$_Yarn@_W@std@@QEAAAEAV01@PEB_W@Z"                                                                                                                                               },
    { 0x00b5, "??4?$basic_iostream@DU?$char_traits@D@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                             },
    { 0x00b6, "??4?$basic_iostream@GU?$char_traits@G@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                             },
    { 0x00b7, "??4?$basic_iostream@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                           },
    { 0x00b8, "??4?$basic_istream@DU?$char_traits@D@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00b9, "??4?$basic_istream@GU?$char_traits@G@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00ba, "??4?$basic_istream@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                            },
    { 0x00bb, "??4?$basic_ostream@DU?$char_traits@D@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00bc, "??4?$basic_ostream@GU?$char_traits@G@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00bd, "??4?$basic_ostream@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                            },
    { 0x00be, "??4?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAAEAV01@AEBV01@@Z"                                                                                                              },
    { 0x00bf, "??4?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAAEAV01@AEBV01@@Z"                                                                                                              },
    { 0x00c0, "??4?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@AEBV01@@Z"                                                                                                            },
    { 0x00c1, "??4Init@ios_base@std@@QEAAAEAV012@AEBV012@@Z"                                                                                                                                        },
    { 0x00c2, "??4_Container_base0@std@@QEAAAEAU01@AEBU01@@Z"                                                                                                                                       },
    { 0x00c3, "??4_Container_base12@std@@QEAAAEAU01@AEBU01@@Z"                                                                                                                                      },
    { 0x00c4, "??4_Facet_base@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                            },
    { 0x00c5, "??4_Init_locks@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                            },
    { 0x00c6, "??4_Pad@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                                   },
    { 0x00c7, "??4_Timevec@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                               },
    { 0x00c8, "??4_UShinit@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                               },
    { 0x00c9, "??4_Winit@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                                 },
    { 0x00ca, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAF@Z"                                                                                                                   },
    { 0x00cb, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAG@Z"                                                                                                                   },
    { 0x00cc, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAH@Z"                                                                                                                   },
    { 0x00cd, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAI@Z"                                                                                                                   },
    { 0x00ce, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAJ@Z"                                                                                                                   },
    { 0x00cf, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAK@Z"                                                                                                                   },
    { 0x00d0, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAM@Z"                                                                                                                   },
    { 0x00d1, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z"                                                                                                                   },
    { 0x00d2, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAO@Z"                                                                                                                   },
    { 0x00d3, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAPEAX@Z"                                                                                                                },
    { 0x00d4, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEA_J@Z"                                                                                                                  },
    { 0x00d5, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEA_K@Z"                                                                                                                  },
    { 0x00d6, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEA_N@Z"                                                                                                                  },
    { 0x00d7, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x00d8, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@DU?$char_traits@D@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x00d9, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x00da, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                       },
    { 0x00db, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAF@Z"                                                                                                                   },
    { 0x00dc, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAG@Z"                                                                                                                   },
    { 0x00dd, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAH@Z"                                                                                                                   },
    { 0x00de, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAI@Z"                                                                                                                   },
    { 0x00df, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAJ@Z"                                                                                                                   },
    { 0x00e0, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAK@Z"                                                                                                                   },
    { 0x00e1, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAM@Z"                                                                                                                   },
    { 0x00e2, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAN@Z"                                                                                                                   },
    { 0x00e3, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAO@Z"                                                                                                                   },
    { 0x00e4, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAPEAX@Z"                                                                                                                },
    { 0x00e5, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEA_J@Z"                                                                                                                  },
    { 0x00e6, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEA_K@Z"                                                                                                                  },
    { 0x00e7, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEA_N@Z"                                                                                                                  },
    { 0x00e8, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x00e9, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@GU?$char_traits@G@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x00ea, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x00eb, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                       },
    { 0x00ec, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAF@Z"                                                                                                                 },
    { 0x00ed, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAG@Z"                                                                                                                 },
    { 0x00ee, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAH@Z"                                                                                                                 },
    { 0x00ef, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAI@Z"                                                                                                                 },
    { 0x00f0, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAJ@Z"                                                                                                                 },
    { 0x00f1, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAK@Z"                                                                                                                 },
    { 0x00f2, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAM@Z"                                                                                                                 },
    { 0x00f3, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAN@Z"                                                                                                                 },
    { 0x00f4, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAO@Z"                                                                                                                 },
    { 0x00f5, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAPEAX@Z"                                                                                                              },
    { 0x00f6, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEA_J@Z"                                                                                                                },
    { 0x00f7, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEA_K@Z"                                                                                                                },
    { 0x00f8, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEA_N@Z"                                                                                                                },
    { 0x00f9, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                  },
    { 0x00fa, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@_WU?$char_traits@_W@std@@@1@AEAV21@@Z@Z"                                                             },
    { 0x00fb, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                          },
    { 0x00fc, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                   },
    { 0x00fd, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@F@Z"                                                                                                                      },
    { 0x00fe, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@G@Z"                                                                                                                      },
    { 0x00ff, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z"                                                                                                                      },
    { 0x0100, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z"                                                                                                                      },
    { 0x0101, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@J@Z"                                                                                                                      },
    { 0x0102, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@K@Z"                                                                                                                      },
    { 0x0103, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@M@Z"                                                                                                                      },
    { 0x0104, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z"                                                                                                                      },
    { 0x0105, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z"                                                                                                                      },
    { 0x0106, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x0107, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@DU?$char_traits@D@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x0108, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x0109, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                       },
    { 0x010a, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@PEBX@Z"                                                                                                                   },
    { 0x010b, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z"                                                                                                                     },
    { 0x010c, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z"                                                                                                                     },
    { 0x010d, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z"                                                                                                                     },
    { 0x010e, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@F@Z"                                                                                                                      },
    { 0x010f, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@G@Z"                                                                                                                      },
    { 0x0110, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@H@Z"                                                                                                                      },
    { 0x0111, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@I@Z"                                                                                                                      },
    { 0x0112, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@J@Z"                                                                                                                      },
    { 0x0113, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@K@Z"                                                                                                                      },
    { 0x0114, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@M@Z"                                                                                                                      },
    { 0x0115, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@N@Z"                                                                                                                      },
    { 0x0116, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@O@Z"                                                                                                                      },
    { 0x0117, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x0118, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@GU?$char_traits@G@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x0119, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x011a, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                       },
    { 0x011b, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@PEBX@Z"                                                                                                                   },
    { 0x011c, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@_J@Z"                                                                                                                     },
    { 0x011d, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@_K@Z"                                                                                                                     },
    { 0x011e, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@_N@Z"                                                                                                                     },
    { 0x011f, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@F@Z"                                                                                                                    },
    { 0x0120, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@G@Z"                                                                                                                    },
    { 0x0121, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@H@Z"                                                                                                                    },
    { 0x0122, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@I@Z"                                                                                                                    },
    { 0x0123, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@J@Z"                                                                                                                    },
    { 0x0124, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@K@Z"                                                                                                                    },
    { 0x0125, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@M@Z"                                                                                                                    },
    { 0x0126, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@N@Z"                                                                                                                    },
    { 0x0127, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@O@Z"                                                                                                                    },
    { 0x0128, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                  },
    { 0x0129, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@_WU?$char_traits@_W@std@@@1@AEAV21@@Z@Z"                                                             },
    { 0x012a, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                          },
    { 0x012b, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                   },
    { 0x012c, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@PEBX@Z"                                                                                                                 },
    { 0x012d, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@_J@Z"                                                                                                                   },
    { 0x012e, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@_K@Z"                                                                                                                   },
    { 0x012f, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@_N@Z"                                                                                                                   },
    { 0x0130, "??7ios_base@std@@QEBA_NXZ"                                                                                                                                                           },
    { 0x0131, "??Bid@locale@std@@QEAA_KXZ"                                                                                                                                                          },
    { 0x0132, "??Bios_base@std@@QEBAPEAXXZ"                                                                                                                                                         },
    { 0x0133, "??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                                    },
    { 0x0134, "??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                                    },
    { 0x0135, "??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                                  },
    { 0x0136, "??_7?$basic_iostream@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                               },
    { 0x0137, "??_7?$basic_iostream@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                               },
    { 0x0138, "??_7?$basic_iostream@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                             },
    { 0x0139, "??_7?$basic_istream@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                                },
    { 0x013a, "??_7?$basic_istream@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                                },
    { 0x013b, "??_7?$basic_istream@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                              },
    { 0x013c, "??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                                },
    { 0x013d, "??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                                },
    { 0x013e, "??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                              },
    { 0x013f, "??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                              },
    { 0x0140, "??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                              },
    { 0x0141, "??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                            },
    { 0x0142, "??_7?$codecvt@DDH@std@@6B@"                                                                                                                                                          },
    { 0x0143, "??_7?$codecvt@GDH@std@@6B@"                                                                                                                                                          },
    { 0x0144, "??_7?$codecvt@_WDH@std@@6B@"                                                                                                                                                         },
    { 0x0145, "??_7?$ctype@D@std@@6B@"                                                                                                                                                              },
    { 0x0146, "??_7?$ctype@G@std@@6B@"                                                                                                                                                              },
    { 0x0147, "??_7?$ctype@_W@std@@6B@"                                                                                                                                                             },
    { 0x0148, "??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x0149, "??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x014a, "??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                     },
    { 0x014b, "??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x014c, "??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x014d, "??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                     },
    { 0x014e, "??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x014f, "??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x0150, "??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                    },
    { 0x0151, "??_7?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x0152, "??_7?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x0153, "??_7?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                    },
    { 0x0154, "??_7_Facet_base@std@@6B@"                                                                                                                                                            },
    { 0x0155, "??_7_Locimp@locale@std@@6B@"                                                                                                                                                         },
    { 0x0156, "??_7_Pad@std@@6B@"                                                                                                                                                                   },
    { 0x0157, "??_7codecvt_base@std@@6B@"                                                                                                                                                           },
    { 0x0158, "??_7ctype_base@std@@6B@"                                                                                                                                                             },
    { 0x0159, "??_7facet@locale@std@@6B@"                                                                                                                                                           },
    { 0x015a, "??_7ios_base@std@@6B@"                                                                                                                                                               },
    { 0x015b, "??_7time_base@std@@6B@"                                                                                                                                                              },
    { 0x015c, "??_8?$basic_iostream@DU?$char_traits@D@std@@@std@@7B?$basic_istream@DU?$char_traits@D@std@@@1@@"                                                                                     },
    { 0x015d, "??_8?$basic_iostream@DU?$char_traits@D@std@@@std@@7B?$basic_ostream@DU?$char_traits@D@std@@@1@@"                                                                                     },
    { 0x015e, "??_8?$basic_iostream@GU?$char_traits@G@std@@@std@@7B?$basic_istream@GU?$char_traits@G@std@@@1@@"                                                                                     },
    { 0x015f, "??_8?$basic_iostream@GU?$char_traits@G@std@@@std@@7B?$basic_ostream@GU?$char_traits@G@std@@@1@@"                                                                                     },
    { 0x0160, "??_8?$basic_iostream@_WU?$char_traits@_W@std@@@std@@7B?$basic_istream@_WU?$char_traits@_W@std@@@1@@"                                                                                 },
    { 0x0161, "??_8?$basic_iostream@_WU?$char_traits@_W@std@@@std@@7B?$basic_ostream@_WU?$char_traits@_W@std@@@1@@"                                                                                 },
    { 0x0162, "??_8?$basic_istream@DU?$char_traits@D@std@@@std@@7B@"                                                                                                                                },
    { 0x0163, "??_8?$basic_istream@GU?$char_traits@G@std@@@std@@7B@"                                                                                                                                },
    { 0x0164, "??_8?$basic_istream@_WU?$char_traits@_W@std@@@std@@7B@"                                                                                                                              },
    { 0x0165, "??_8?$basic_ostream@DU?$char_traits@D@std@@@std@@7B@"                                                                                                                                },
    { 0x0166, "??_8?$basic_ostream@GU?$char_traits@G@std@@@std@@7B@"                                                                                                                                },
    { 0x0167, "??_8?$basic_ostream@_WU?$char_traits@_W@std@@@std@@7B@"                                                                                                                              },
    { 0x0168, "??_D?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                           },
    { 0x0169, "??_D?$basic_iostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                           },
    { 0x016a, "??_D?$basic_iostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                         },
    { 0x016b, "??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x016c, "??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x016d, "??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x016e, "??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x016f, "??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x0170, "??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x0171, "??_F?$codecvt@DDH@std@@QEAAXXZ"                                                                                                                                                      },
    { 0x0172, "??_F?$codecvt@GDH@std@@QEAAXXZ"                                                                                                                                                      },
    { 0x0173, "??_F?$codecvt@_WDH@std@@QEAAXXZ"                                                                                                                                                     },
    { 0x0174, "??_F?$ctype@D@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x0175, "??_F?$ctype@G@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x0176, "??_F?$ctype@_W@std@@QEAAXXZ"                                                                                                                                                         },
    { 0x0177, "??_F?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x0178, "??_F?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x0179, "??_F?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                 },
    { 0x017a, "??_F?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x017b, "??_F?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x017c, "??_F?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                 },
    { 0x017d, "??_F?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x017e, "??_F?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x017f, "??_F?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                },
    { 0x0180, "??_F?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x0181, "??_F?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x0182, "??_F?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                },
    { 0x0183, "??_F_Locinfo@std@@QEAAXXZ"                                                                                                                                                           },
    { 0x0184, "??_F_Timevec@std@@QEAAXXZ"                                                                                                                                                           },
    { 0x0185, "??_Fcodecvt_base@std@@QEAAXXZ"                                                                                                                                                       },
    { 0x0186, "??_Fctype_base@std@@QEAAXXZ"                                                                                                                                                         },
    { 0x0187, "??_Ffacet@locale@std@@QEAAXXZ"                                                                                                                                                       },
    { 0x0188, "??_Fid@locale@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x0189, "??_Ftime_base@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x018a, "?NFS_Allocate@details@Concurrency@@YAPEAX_K0PEAX@Z"                                                                                                                                  },
    { 0x018b, "?NFS_Free@details@Concurrency@@YAXPEAX@Z"                                                                                                                                            },
    { 0x018c, "?NFS_GetLineSize@details@Concurrency@@YA_KXZ"                                                                                                                                        },
    { 0x018d, "?_10@placeholders@std@@3V?$_Ph@$09@2@A"                                                                                                                                              },
    { 0x018e, "?_11@placeholders@std@@3V?$_Ph@$0L@@2@A"                                                                                                                                             },
    { 0x018f, "?_12@placeholders@std@@3V?$_Ph@$0M@@2@A"                                                                                                                                             },
    { 0x0190, "?_13@placeholders@std@@3V?$_Ph@$0N@@2@A"                                                                                                                                             },
    { 0x0191, "?_14@placeholders@std@@3V?$_Ph@$0O@@2@A"                                                                                                                                             },
    { 0x0192, "?_15@placeholders@std@@3V?$_Ph@$0P@@2@A"                                                                                                                                             },
    { 0x0193, "?_16@placeholders@std@@3V?$_Ph@$0BA@@2@A"                                                                                                                                            },
    { 0x0194, "?_17@placeholders@std@@3V?$_Ph@$0BB@@2@A"                                                                                                                                            },
    { 0x0195, "?_18@placeholders@std@@3V?$_Ph@$0BC@@2@A"                                                                                                                                            },
    { 0x0196, "?_19@placeholders@std@@3V?$_Ph@$0BD@@2@A"                                                                                                                                            },
    { 0x0197, "?_1@placeholders@std@@3V?$_Ph@$00@2@A"                                                                                                                                               },
    { 0x0198, "?_20@placeholders@std@@3V?$_Ph@$0BE@@2@A"                                                                                                                                            },
    { 0x0199, "?_2@placeholders@std@@3V?$_Ph@$01@2@A"                                                                                                                                               },
    { 0x019a, "?_3@placeholders@std@@3V?$_Ph@$02@2@A"                                                                                                                                               },
    { 0x019b, "?_4@placeholders@std@@3V?$_Ph@$03@2@A"                                                                                                                                               },
    { 0x019c, "?_5@placeholders@std@@3V?$_Ph@$04@2@A"                                                                                                                                               },
    { 0x019d, "?_6@placeholders@std@@3V?$_Ph@$05@2@A"                                                                                                                                               },
    { 0x019e, "?_7@placeholders@std@@3V?$_Ph@$06@2@A"                                                                                                                                               },
    { 0x019f, "?_8@placeholders@std@@3V?$_Ph@$07@2@A"                                                                                                                                               },
    { 0x01a0, "?_9@placeholders@std@@3V?$_Ph@$08@2@A"                                                                                                                                               },
    { 0x01a1, "?_Add_vtordisp1@?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                    },
    { 0x01a2, "?_Add_vtordisp1@?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                    },
    { 0x01a3, "?_Add_vtordisp1@?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                                  },
    { 0x01a4, "?_Add_vtordisp1@?$basic_istream@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                },
    { 0x01a5, "?_Add_vtordisp1@?$basic_istream@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                },
    { 0x01a6, "?_Add_vtordisp1@?$basic_istream@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                              },
    { 0x01a7, "?_Add_vtordisp2@?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                    },
    { 0x01a8, "?_Add_vtordisp2@?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                    },
    { 0x01a9, "?_Add_vtordisp2@?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                                  },
    { 0x01aa, "?_Add_vtordisp2@?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                },
    { 0x01ab, "?_Add_vtordisp2@?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                },
    { 0x01ac, "?_Add_vtordisp2@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                              },
    { 0x01ad, "?_Addcats@_Locinfo@std@@QEAAAEAV12@HPEBD@Z"                                                                                                                                          },
    { 0x01ae, "?_Addfac@_Locimp@locale@std@@AEAAXPEAVfacet@23@_K@Z"                                                                                                                                 },
    { 0x01af, "?_Addstd@ios_base@std@@SAXPEAV12@@Z"                                                                                                                                                 },
    { 0x01b0, "?_Advance@_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAAXXZ"                                                                                                           },
    { 0x01b1, "?_Assign@_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAAXAEBV123@@Z"                                                                                                    },
    { 0x01b2, "?_Atexit@@YAXP6AXXZ@Z"                                                                                                                                                               },
    { 0x01b3, "?_BADOFF@std@@3_JB"                                                                                                                                                                  },
    { 0x01b4, "?_Byte_reverse_table@details@Concurrency@@3QBEB"                                                                                                                                     },
    { 0x01b5, "?_C_str@?$_Yarn@D@std@@QEBAPEBDXZ"                                                                                                                                                   },
    { 0x01b6, "?_C_str@?$_Yarn@_W@std@@QEBAPEB_WXZ"                                                                                                                                                 },
    { 0x01b7, "?_Callfns@ios_base@std@@AEAAXW4event@12@@Z"                                                                                                                                          },
    { 0x01b8, "?_Clocptr@_Locimp@locale@std@@0PEAV123@EA"                                                                                                                                           },
    { 0x01b9, "?_Close_dir@sys@tr2@std@@YAXPEAX@Z"                                                                                                                                                  },
    { 0x01ba, "?_Copy_file@sys@tr2@std@@YAHPEBD0_N@Z"                                                                                                                                               },
    { 0x01bb, "?_Copy_file@sys@tr2@std@@YAHPEB_W0_N@Z"                                                                                                                                              },
    { 0x01bc, "?_Current_get@sys@tr2@std@@YAPEADPEAD@Z"                                                                                                                                             },
    { 0x01bd, "?_Current_get@sys@tr2@std@@YAPEA_WPEA_W@Z"                                                                                                                                           },
    { 0x01be, "?_Current_set@sys@tr2@std@@YA_NPEBD@Z"                                                                                                                                               },
    { 0x01bf, "?_Current_set@sys@tr2@std@@YA_NPEB_W@Z"                                                                                                                                              },
    { 0x01c0, "?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ"                                                                                                                                 },
    { 0x01c1, "?_Donarrow@?$ctype@G@std@@IEBADGD@Z"                                                                                                                                                 },
    { 0x01c2, "?_Donarrow@?$ctype@_W@std@@IEBAD_WD@Z"                                                                                                                                               },
    { 0x01c3, "?_Dowiden@?$ctype@G@std@@IEBAGD@Z"                                                                                                                                                   },
    { 0x01c4, "?_Dowiden@?$ctype@_W@std@@IEBA_WD@Z"                                                                                                                                                 },
    { 0x01c5, "?_Empty@?$_Yarn@D@std@@QEBA_NXZ"                                                                                                                                                     },
    { 0x01c6, "?_Empty@?$_Yarn@_W@std@@QEBA_NXZ"                                                                                                                                                    },
    { 0x01c7, "?_Equivalent@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                },
    { 0x01c8, "?_Equivalent@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                               },
    { 0x01c9, "?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADDH@Z"                                                                                        },
    { 0x01ca, "?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAPEADPEADDH@Z"                                                                                        },
    { 0x01cb, "?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAPEADPEADDH@Z"                                                                                     },
    { 0x01cc, "?_File_size@sys@tr2@std@@YA_KPEBD@Z"                                                                                                                                                 },
    { 0x01cd, "?_File_size@sys@tr2@std@@YA_KPEB_W@Z"                                                                                                                                                },
    { 0x01ce, "?_Findarr@ios_base@std@@AEAAAEAU_Iosarray@12@H@Z"                                                                                                                                    },
    { 0x01cf, "?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z"                                                                                                                                                },
    { 0x01d0, "?_Fiopen@std@@YAPEAU_iobuf@@PEBGHH@Z"                                                                                                                                                },
    { 0x01d1, "?_Fiopen@std@@YAPEAU_iobuf@@PEB_WHH@Z"                                                                                                                                               },
    { 0x01d2, "?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBD_K333@Z"                  },
    { 0x01d3, "?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBD_K333@Z"                  },
    { 0x01d4, "?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBD_K444@Z"            },
    { 0x01d5, "?_Future_error_map@std@@YAPEBDH@Z"                                                                                                                                                   },
    { 0x01d6, "?_GetCombinableSize@details@Concurrency@@YA_KXZ"                                                                                                                                     },
    { 0x01d7, "?_GetCurrentThreadId@details@Concurrency@@YAKXZ"                                                                                                                                     },
    { 0x01d8, "?_GetNextAsyncId@details@Concurrency@@YAIXZ"                                                                                                                                         },
    { 0x01d9, "?_Get_future_error_what@std@@YAPEBDH@Z"                                                                                                                                              },
    { 0x01da, "?_Getcat@?$codecvt@DDH@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                     },
    { 0x01db, "?_Getcat@?$codecvt@GDH@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                     },
    { 0x01dc, "?_Getcat@?$codecvt@_WDH@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                    },
    { 0x01dd, "?_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                         },
    { 0x01de, "?_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                         },
    { 0x01df, "?_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                        },
    { 0x01e0, "?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01e1, "?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01e2, "?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                },
    { 0x01e3, "?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01e4, "?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01e5, "?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                },
    { 0x01e6, "?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01e7, "?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01e8, "?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                               },
    { 0x01e9, "?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01ea, "?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01eb, "?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                               },
    { 0x01ec, "?_Getcat@facet@locale@std@@SA_KPEAPEBV123@PEBV23@@Z"                                                                                                                                 },
    { 0x01ed, "?_Getcoll@_Locinfo@std@@QEBA?AU_Collvec@@XZ"                                                                                                                                         },
    { 0x01ee, "?_Getctype@_Locinfo@std@@QEBA?AU_Ctypevec@@XZ"                                                                                                                                       },
    { 0x01ef, "?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ"                                                                                                                                           },
    { 0x01f0, "?_Getdateorder@_Locinfo@std@@QEBAHXZ"                                                                                                                                                },
    { 0x01f1, "?_Getdays@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                  },
    { 0x01f2, "?_Getfalse@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                 },
    { 0x01f3, "?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z"                  },
    { 0x01f4, "?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z"                  },
    { 0x01f5, "?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z"             },
    { 0x01f6, "?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z"                 },
    { 0x01f7, "?_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z"                 },
    { 0x01f8, "?_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z"            },
    { 0x01f9, "?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD@Z"        },
    { 0x01fa, "?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD@Z"        },
    { 0x01fb, "?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD@Z"   },
    { 0x01fc, "?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ"                                                                                                                                   },
    { 0x01fd, "?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z"                       },
    { 0x01fe, "?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z"                       },
    { 0x01ff, "?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z"                  },
    { 0x0200, "?_Getint@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@0HHAEAHAEBV?$ctype@D@2@@Z"                   },
    { 0x0201, "?_Getint@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0HHAEAHAEBV?$ctype@G@2@@Z"                   },
    { 0x0202, "?_Getint@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0HHAEAHAEBV?$ctype@_W@2@@Z"             },
    { 0x0203, "?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ"                                                                                                                                          },
    { 0x0204, "?_Getmonths@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                },
    { 0x0205, "?_Getname@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                  },
    { 0x0206, "?_Getpfirst@_Container_base12@std@@QEBAPEAPEAU_Iterator_base12@2@XZ"                                                                                                                 },
    { 0x0207, "?_Getptr@_Timevec@std@@QEBAPEAXXZ"                                                                                                                                                   },
    { 0x0208, "?_Gettnames@_Locinfo@std@@QEBA?AV_Timevec@2@XZ"                                                                                                                                      },
    { 0x0209, "?_Gettrue@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                  },
    { 0x020a, "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x020b, "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x020c, "?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"                                                                                                                 },
    { 0x020d, "?_Gndec@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                   },
    { 0x020e, "?_Gndec@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                   },
    { 0x020f, "?_Gndec@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                                },
    { 0x0210, "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                   },
    { 0x0211, "?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                   },
    { 0x0212, "?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                                },
    { 0x0213, "?_Gnpreinc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                },
    { 0x0214, "?_Gnpreinc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                },
    { 0x0215, "?_Gnpreinc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                             },
    { 0x0216, "?_Id_cnt@id@locale@std@@0HA"                                                                                                                                                         },
    { 0x0217, "?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"                                                                                     },
    { 0x0218, "?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"                                                                                     },
    { 0x0219, "?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"                                                                                  },
    { 0x021a, "?_Incref@facet@locale@std@@UEAAXXZ"                                                                                                                                                  },
    { 0x021b, "?_Index@ios_base@std@@0HA"                                                                                                                                                           },
    { 0x021c, "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAPEAD0PEAH001@Z"                                                                                                        },
    { 0x021d, "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ"                                                                                                                       },
    { 0x021e, "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAPEAG0PEAH001@Z"                                                                                                        },
    { 0x021f, "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXXZ"                                                                                                                       },
    { 0x0220, "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAPEA_W0PEAH001@Z"                                                                                                     },
    { 0x0221, "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXXZ"                                                                                                                     },
    { 0x0222, "?_Init@?$codecvt@DDH@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                    },
    { 0x0223, "?_Init@?$codecvt@GDH@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                    },
    { 0x0224, "?_Init@?$codecvt@_WDH@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                   },
    { 0x0225, "?_Init@?$ctype@D@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                        },
    { 0x0226, "?_Init@?$ctype@G@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                        },
    { 0x0227, "?_Init@?$ctype@_W@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                       },
    { 0x0228, "?_Init@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x0229, "?_Init@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x022a, "?_Init@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                               },
    { 0x022b, "?_Init@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x022c, "?_Init@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x022d, "?_Init@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                               },
    { 0x022e, "?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x022f, "?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x0230, "?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                              },
    { 0x0231, "?_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x0232, "?_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x0233, "?_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                              },
    { 0x0234, "?_Init@ios_base@std@@IEAAXXZ"                                                                                                                                                        },
    { 0x0235, "?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"                                                                                                                                            },
    { 0x0236, "?_Init_cnt@Init@ios_base@std@@0HA"                                                                                                                                                   },
    { 0x0237, "?_Init_cnt@_UShinit@std@@0HA"                                                                                                                                                        },
    { 0x0238, "?_Init_cnt@_Winit@std@@0HA"                                                                                                                                                          },
    { 0x0239, "?_Init_cnt_func@Init@ios_base@std@@CAAEAHXZ"                                                                                                                                         },
    { 0x023a, "?_Init_ctor@Init@ios_base@std@@CAXPEAV123@@Z"                                                                                                                                        },
    { 0x023b, "?_Init_dtor@Init@ios_base@std@@CAXPEAV123@@Z"                                                                                                                                        },
    { 0x023c, "?_Init_locks_ctor@_Init_locks@std@@CAXPEAV12@@Z"                                                                                                                                     },
    { 0x023d, "?_Init_locks_dtor@_Init_locks@std@@CAXPEAV12@@Z"                                                                                                                                     },
    { 0x023e, "?_Internal_assign@_Concurrent_vector_base_v4@details@Concurrency@@IEAAXAEBV123@_KP6AXPEAX1@ZP6AX2PEBX1@Z5@Z"                                                                         },
    { 0x023f, "?_Internal_capacity@_Concurrent_vector_base_v4@details@Concurrency@@IEBA_KXZ"                                                                                                        },
    { 0x0240, "?_Internal_clear@_Concurrent_vector_base_v4@details@Concurrency@@IEAA_KP6AXPEAX_K@Z@Z"                                                                                               },
    { 0x0241, "?_Internal_compact@_Concurrent_vector_base_v4@details@Concurrency@@IEAAPEAX_KPEAXP6AX10@ZP6AX1PEBX0@Z@Z"                                                                             },
    { 0x0242, "?_Internal_copy@_Concurrent_vector_base_v4@details@Concurrency@@IEAAXAEBV123@_KP6AXPEAXPEBX1@Z@Z"                                                                                    },
    { 0x0243, "?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_NXZ"                                                                                                            },
    { 0x0244, "?_Internal_finish_clear@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXXZ"                                                                                                      },
    { 0x0245, "?_Internal_grow_by@_Concurrent_vector_base_v4@details@Concurrency@@IEAA_K_K0P6AXPEAXPEBX0@Z2@Z"                                                                                      },
    { 0x0246, "?_Internal_grow_to_at_least_with_result@_Concurrent_vector_base_v4@details@Concurrency@@IEAA_K_K0P6AXPEAXPEBX0@Z2@Z"                                                                 },
    { 0x0247, "?_Internal_move_push@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXPEAX@Z"                                                                                                     },
    { 0x0248, "?_Internal_pop_if_present@_Concurrent_queue_base_v4@details@Concurrency@@IEAA_NPEAX@Z"                                                                                               },
    { 0x0249, "?_Internal_push@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXPEBX@Z"                                                                                                          },
    { 0x024a, "?_Internal_push_back@_Concurrent_vector_base_v4@details@Concurrency@@IEAAPEAX_KAEA_K@Z"                                                                                              },
    { 0x024b, "?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IEAAX_K00@Z"                                                                                                      },
    { 0x024c, "?_Internal_resize@_Concurrent_vector_base_v4@details@Concurrency@@IEAAX_K00P6AXPEAX0@ZP6AX1PEBX0@Z3@Z"                                                                               },
    { 0x024d, "?_Internal_size@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_KXZ"                                                                                                             },
    { 0x024e, "?_Internal_swap@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXAEAV123@@Z"                                                                                                      },
    { 0x024f, "?_Internal_swap@_Concurrent_vector_base_v4@details@Concurrency@@IEAAXAEAV123@@Z"                                                                                                     },
    { 0x0250, "?_Internal_throw_exception@_Concurrent_queue_base_v4@details@Concurrency@@IEBAXXZ"                                                                                                   },
    { 0x0251, "?_Internal_throw_exception@_Concurrent_vector_base_v4@details@Concurrency@@IEBAX_K@Z"                                                                                                },
    { 0x0252, "?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"                                                                                                                                          },
    { 0x0253, "?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z"                                                                                                                      },
    { 0x0254, "?_Ipfx@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA_N_N@Z"                                                                                                                      },
    { 0x0255, "?_Ipfx@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA_N_N@Z"                                                                                                                    },
    { 0x0256, "?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z"                     },
    { 0x0257, "?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEAD_K@Z"                     },
    { 0x0258, "?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEAD_K@Z"               },
    { 0x0259, "?_Last_write_time@sys@tr2@std@@YAXPEBD_J@Z"                                                                                                                                          },
    { 0x025a, "?_Last_write_time@sys@tr2@std@@YAXPEB_W_J@Z"                                                                                                                                         },
    { 0x025b, "?_Last_write_time@sys@tr2@std@@YA_JPEBD@Z"                                                                                                                                           },
    { 0x025c, "?_Last_write_time@sys@tr2@std@@YA_JPEB_W@Z"                                                                                                                                          },
    { 0x025d, "?_Launch@_Pad@std@@QEAAXPEAU_Thrd_imp_t@@@Z"                                                                                                                                         },
    { 0x025e, "?_Link@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                      },
    { 0x025f, "?_Link@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                                     },
    { 0x0260, "?_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z"                                                                                                                    },
    { 0x0261, "?_Locimp_ctor@_Locimp@locale@std@@CAXPEAV123@AEBV123@@Z"                                                                                                                             },
    { 0x0262, "?_Locimp_dtor@_Locimp@locale@std@@CAXPEAV123@@Z"                                                                                                                                     },
    { 0x0263, "?_Locinfo_Addcats@_Locinfo@std@@SAAEAV12@PEAV12@HPEBD@Z"                                                                                                                             },
    { 0x0264, "?_Locinfo_ctor@_Locinfo@std@@SAXPEAV12@HPEBD@Z"                                                                                                                                      },
    { 0x0265, "?_Locinfo_ctor@_Locinfo@std@@SAXPEAV12@PEBD@Z"                                                                                                                                       },
    { 0x0266, "?_Locinfo_dtor@_Locinfo@std@@SAXPEAV12@@Z"                                                                                                                                           },
    { 0x0267, "?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                       },
    { 0x0268, "?_Lock@?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                       },
    { 0x0269, "?_Lock@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                                     },
    { 0x026a, "?_Lockit_ctor@_Lockit@std@@CAXPEAV12@@Z"                                                                                                                                             },
    { 0x026b, "?_Lockit_ctor@_Lockit@std@@CAXPEAV12@H@Z"                                                                                                                                            },
    { 0x026c, "?_Lockit_ctor@_Lockit@std@@SAXH@Z"                                                                                                                                                   },
    { 0x026d, "?_Lockit_dtor@_Lockit@std@@CAXPEAV12@@Z"                                                                                                                                             },
    { 0x026e, "?_Lockit_dtor@_Lockit@std@@SAXH@Z"                                                                                                                                                   },
    { 0x026f, "?_Lstat@sys@tr2@std@@YA?AW4file_type@123@PEBDAEAH@Z"                                                                                                                                 },
    { 0x0270, "?_Lstat@sys@tr2@std@@YA?AW4file_type@123@PEB_WAEAH@Z"                                                                                                                                },
    { 0x0271, "?_MP_Add@std@@YAXQEA_K_K@Z"                                                                                                                                                          },
    { 0x0272, "?_MP_Get@std@@YA_KQEA_K@Z"                                                                                                                                                           },
    { 0x0273, "?_MP_Mul@std@@YAXQEA_K_K1@Z"                                                                                                                                                         },
    { 0x0274, "?_MP_Rem@std@@YAXQEA_K_K@Z"                                                                                                                                                          },
    { 0x0275, "?_Make_dir@sys@tr2@std@@YAHPEBD@Z"                                                                                                                                                   },
    { 0x0276, "?_Make_dir@sys@tr2@std@@YAHPEB_W@Z"                                                                                                                                                  },
    { 0x0277, "?_Makeloc@_Locimp@locale@std@@CAPEAV123@AEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                           },
    { 0x0278, "?_Makeushloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                               },
    { 0x0279, "?_Makewloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                                 },
    { 0x027a, "?_Makexloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                                 },
    { 0x027b, "?_Mtx_delete@threads@stdext@@YAXPEAX@Z"                                                                                                                                              },
    { 0x027c, "?_Mtx_lock@threads@stdext@@YAXPEAX@Z"                                                                                                                                                },
    { 0x027d, "?_Mtx_new@threads@stdext@@YAXAEAPEAX@Z"                                                                                                                                              },
    { 0x027e, "?_Mtx_unlock@threads@stdext@@YAXPEAX@Z"                                                                                                                                              },
    { 0x027f, "?_New_Locimp@_Locimp@locale@std@@CAPEAV123@AEBV123@@Z"                                                                                                                               },
    { 0x0280, "?_New_Locimp@_Locimp@locale@std@@CAPEAV123@_N@Z"                                                                                                                                     },
    { 0x0281, "?_Open_dir@sys@tr2@std@@YAPEAXPEADPEBDAEAHAEAW4file_type@123@@Z"                                                                                                                     },
    { 0x0282, "?_Open_dir@sys@tr2@std@@YAPEAXPEA_WPEB_WAEAHAEAW4file_type@123@@Z"                                                                                                                   },
    { 0x0283, "?_Orphan_all@_Container_base0@std@@QEAAXXZ"                                                                                                                                          },
    { 0x0284, "?_Orphan_all@_Container_base12@std@@QEAAXXZ"                                                                                                                                         },
    { 0x0285, "?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                         },
    { 0x0286, "?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                         },
    { 0x0287, "?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                       },
    { 0x0288, "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x0289, "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x028a, "?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"                                                                                                                 },
    { 0x028b, "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                   },
    { 0x028c, "?_Pninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                   },
    { 0x028d, "?_Pninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                                },
    { 0x028e, "?_Ptr_cerr@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"                                                                                                                   },
    { 0x028f, "?_Ptr_cin@std@@3PEAV?$basic_istream@DU?$char_traits@D@std@@@1@EA"                                                                                                                    },
    { 0x0290, "?_Ptr_clog@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"                                                                                                                   },
    { 0x0291, "?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"                                                                                                                   },
    { 0x0292, "?_Ptr_wcerr@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"                                                                                                                  },
    { 0x0293, "?_Ptr_wcerr@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                },
    { 0x0294, "?_Ptr_wcin@std@@3PEAV?$basic_istream@GU?$char_traits@G@std@@@1@EA"                                                                                                                   },
    { 0x0295, "?_Ptr_wcin@std@@3PEAV?$basic_istream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                 },
    { 0x0296, "?_Ptr_wclog@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"                                                                                                                  },
    { 0x0297, "?_Ptr_wclog@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                },
    { 0x0298, "?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"                                                                                                                  },
    { 0x0299, "?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                },
    { 0x029a, "?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PEBD_K@Z"                                      },
    { 0x029b, "?_Put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@PEBG_K@Z"                                      },
    { 0x029c, "?_Put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@PEB_W_K@Z"                                },
    { 0x029d, "?_Raise_handler@std@@3P6AXAEBVexception@stdext@@@ZEA"                                                                                                                                },
    { 0x029e, "?_Random_device@std@@YAIXZ"                                                                                                                                                          },
    { 0x029f, "?_Read_dir@sys@tr2@std@@YAPEADPEADPEAXAEAW4file_type@123@@Z"                                                                                                                         },
    { 0x02a0, "?_Read_dir@sys@tr2@std@@YAPEA_WPEA_WPEAXAEAW4file_type@123@@Z"                                                                                                                       },
    { 0x02a1, "?_Release@_Pad@std@@QEAAXXZ"                                                                                                                                                         },
    { 0x02a2, "?_Remove_dir@sys@tr2@std@@YA_NPEBD@Z"                                                                                                                                                },
    { 0x02a3, "?_Remove_dir@sys@tr2@std@@YA_NPEB_W@Z"                                                                                                                                               },
    { 0x02a4, "?_Rename@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                    },
    { 0x02a5, "?_Rename@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                                   },
    { 0x02a6, "?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@D_K@Z"                                         },
    { 0x02a7, "?_Rep@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@G_K@Z"                                         },
    { 0x02a8, "?_Rep@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_W_K@Z"                                   },
    { 0x02a9, "?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"                                                                                                                              },
    { 0x02aa, "?_Rng_abort@std@@YAXPEBD@Z"                                                                                                                                                          },
    { 0x02ab, "?_Segment_index_of@_Concurrent_vector_base_v4@details@Concurrency@@KA_K_K@Z"                                                                                                         },
    { 0x02ac, "?_Setgloballocale@locale@std@@CAXPEAX@Z"                                                                                                                                             },
    { 0x02ad, "?_Src@?1??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"  },
    { 0x02ae, "?_Src@?1??_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"  },
    { 0x02af, "?_Src@?1??_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB" },
    { 0x02b0, "?_Src@?1??_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1HAEBVlocale@3@@Z@4QBDB"        },
    { 0x02b1, "?_Src@?1??_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1HAEBVlocale@3@@Z@4QBDB"        },
    { 0x02b2, "?_Src@?1??_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1HAEBVlocale@3@@Z@4QBDB"   },
    { 0x02b3, "?_Src@?3??_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"   },
    { 0x02b4, "?_Src@?3??_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"   },
    { 0x02b5, "?_Src@?3??_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB" },
    { 0x02b6, "?_Stat@sys@tr2@std@@YA?AW4file_type@123@PEBDAEAH@Z"                                                                                                                                  },
    { 0x02b7, "?_Stat@sys@tr2@std@@YA?AW4file_type@123@PEB_WAEAH@Z"                                                                                                                                 },
    { 0x02b8, "?_Statvfs@sys@tr2@std@@YA?AUspace_info@123@PEBD@Z"                                                                                                                                   },
    { 0x02b9, "?_Statvfs@sys@tr2@std@@YA?AUspace_info@123@PEB_W@Z"                                                                                                                                  },
    { 0x02ba, "?_Swap_all@_Container_base0@std@@QEAAXAEAU12@@Z"                                                                                                                                     },
    { 0x02bb, "?_Swap_all@_Container_base12@std@@QEAAXAEAU12@@Z"                                                                                                                                    },
    { 0x02bc, "?_Symlink@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                   },
    { 0x02bd, "?_Symlink@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                                  },
    { 0x02be, "?_Sync@ios_base@std@@0_NA"                                                                                                                                                           },
    { 0x02bf, "?_Syserror_map@std@@YAPEBDH@Z"                                                                                                                                                       },
    { 0x02c0, "?_Throw_C_error@std@@YAXH@Z"                                                                                                                                                         },
    { 0x02c1, "?_Throw_Cpp_error@std@@YAXH@Z"                                                                                                                                                       },
    { 0x02c2, "?_Throw_future_error@std@@YAXAEBVerror_code@1@@Z"                                                                                                                                    },
    { 0x02c3, "?_Throw_lock_error@threads@stdext@@YAXXZ"                                                                                                                                            },
    { 0x02c4, "?_Throw_resource_error@threads@stdext@@YAXXZ"                                                                                                                                        },
    { 0x02c5, "?_Tidy@?$_Yarn@D@std@@AEAAXXZ"                                                                                                                                                       },
    { 0x02c6, "?_Tidy@?$_Yarn@_W@std@@AEAAXXZ"                                                                                                                                                      },
    { 0x02c7, "?_Tidy@?$ctype@D@std@@IEAAXXZ"                                                                                                                                                       },
    { 0x02c8, "?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEAAXXZ"                                                                                                },
    { 0x02c9, "?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEAAXXZ"                                                                                                },
    { 0x02ca, "?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEAAXXZ"                                                                                             },
    { 0x02cb, "?_Tidy@ios_base@std@@AEAAXXZ"                                                                                                                                                        },
    { 0x02cc, "?_Unlink@sys@tr2@std@@YAHPEBD@Z"                                                                                                                                                     },
    { 0x02cd, "?_Unlink@sys@tr2@std@@YAHPEB_W@Z"                                                                                                                                                    },
    { 0x02ce, "?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                     },
    { 0x02cf, "?_Unlock@?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                     },
    { 0x02d0, "?_Unlock@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                                   },
    { 0x02d1, "?_W_Getdays@_Locinfo@std@@QEBAPEBGXZ"                                                                                                                                                },
    { 0x02d2, "?_W_Getmonths@_Locinfo@std@@QEBAPEBGXZ"                                                                                                                                              },
    { 0x02d3, "?_W_Gettnames@_Locinfo@std@@QEBA?AV_Timevec@2@XZ"                                                                                                                                    },
    { 0x02d4, "?_Winerror_map@std@@YAPEBDH@Z"                                                                                                                                                       },
    { 0x02d5, "?_XLgamma@std@@YAMM@Z"                                                                                                                                                               },
    { 0x02d6, "?_XLgamma@std@@YANN@Z"                                                                                                                                                               },
    { 0x02d7, "?_XLgamma@std@@YAOO@Z"                                                                                                                                                               },
    { 0x02d8, "?_Xbad_alloc@std@@YAXXZ"                                                                                                                                                             },
    { 0x02d9, "?_Xbad_function_call@std@@YAXXZ"                                                                                                                                                     },
    { 0x02da, "?_Xinvalid_argument@std@@YAXPEBD@Z"                                                                                                                                                  },
    { 0x02db, "?_Xlength_error@std@@YAXPEBD@Z"                                                                                                                                                      },
    { 0x02dc, "?_Xout_of_range@std@@YAXPEBD@Z"                                                                                                                                                      },
    { 0x02dd, "?_Xoverflow_error@std@@YAXPEBD@Z"                                                                                                                                                    },
    { 0x02de, "?_Xregex_error@std@@YAXW4error_type@regex_constants@1@@Z"                                                                                                                            },
    { 0x02df, "?_Xruntime_error@std@@YAXPEBD@Z"                                                                                                                                                     },
    { 0x02e0, "?adopt_lock@std@@3Uadopt_lock_t@1@B"                                                                                                                                                 },
    { 0x02e1, "?always_noconv@codecvt_base@std@@QEBA_NXZ"                                                                                                                                           },
    { 0x02e2, "?bad@ios_base@std@@QEBA_NXZ"                                                                                                                                                         },
    { 0x02e3, "?c_str@?$_Yarn@D@std@@QEBAPEBDXZ"                                                                                                                                                    },
    { 0x02e4, "?cancel@agent@Concurrency@@QEAA_NXZ"                                                                                                                                                 },
    { 0x02e5, "?cancel_current_task@Concurrency@@YAXXZ"                                                                                                                                             },
    { 0x02e6, "?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"                                                                                                                            },
    { 0x02e7, "?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A"                                                                                                                             },
    { 0x02e8, "?classic@locale@std@@SAAEBV12@XZ"                                                                                                                                                    },
    { 0x02e9, "?classic_table@?$ctype@D@std@@SAPEBFXZ"                                                                                                                                              },
    { 0x02ea, "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"                                                                                                                          },
    { 0x02eb, "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXI@Z"                                                                                                                            },
    { 0x02ec, "?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z"                                                                                                                          },
    { 0x02ed, "?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXI@Z"                                                                                                                            },
    { 0x02ee, "?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"                                                                                                                        },
    { 0x02ef, "?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXI@Z"                                                                                                                          },
    { 0x02f0, "?clear@ios_base@std@@QEAAXH@Z"                                                                                                                                                       },
    { 0x02f1, "?clear@ios_base@std@@QEAAXH_N@Z"                                                                                                                                                     },
    { 0x02f2, "?clear@ios_base@std@@QEAAXI@Z"                                                                                                                                                       },
    { 0x02f3, "?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"                                                                                                                            },
    { 0x02f4, "?copyfmt@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                              },
    { 0x02f5, "?copyfmt@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                              },
    { 0x02f6, "?copyfmt@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                            },
    { 0x02f7, "?copyfmt@ios_base@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                                                         },
    { 0x02f8, "?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"                                                                                                                            },
    { 0x02f9, "?date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ"                                                                  },
    { 0x02fa, "?date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ"                                                                  },
    { 0x02fb, "?date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ"                                                               },
    { 0x02fc, "?defer_lock@std@@3Udefer_lock_t@1@B"                                                                                                                                                 },
    { 0x02fd, "?do_always_noconv@?$codecvt@DDH@std@@MEBA_NXZ"                                                                                                                                       },
    { 0x02fe, "?do_always_noconv@?$codecvt@GDH@std@@MEBA_NXZ"                                                                                                                                       },
    { 0x02ff, "?do_always_noconv@?$codecvt@_WDH@std@@MEBA_NXZ"                                                                                                                                      },
    { 0x0300, "?do_always_noconv@codecvt_base@std@@MEBA_NXZ"                                                                                                                                        },
    { 0x0301, "?do_date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AW4dateorder@time_base@2@XZ"                                                               },
    { 0x0302, "?do_date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AW4dateorder@time_base@2@XZ"                                                               },
    { 0x0303, "?do_date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AW4dateorder@time_base@2@XZ"                                                            },
    { 0x0304, "?do_encoding@?$codecvt@GDH@std@@MEBAHXZ"                                                                                                                                             },
    { 0x0305, "?do_encoding@?$codecvt@_WDH@std@@MEBAHXZ"                                                                                                                                            },
    { 0x0306, "?do_encoding@codecvt_base@std@@MEBAHXZ"                                                                                                                                              },
    { 0x0307, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                  },
    { 0x0308, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                  },
    { 0x0309, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                  },
    { 0x030a, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                  },
    { 0x030b, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                  },
    { 0x030c, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                  },
    { 0x030d, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                  },
    { 0x030e, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"               },
    { 0x030f, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                 },
    { 0x0310, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                 },
    { 0x0311, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                 },
    { 0x0312, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                  },
    { 0x0313, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                  },
    { 0x0314, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                  },
    { 0x0315, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                  },
    { 0x0316, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                  },
    { 0x0317, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                  },
    { 0x0318, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                  },
    { 0x0319, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"               },
    { 0x031a, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                 },
    { 0x031b, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                 },
    { 0x031c, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                 },
    { 0x031d, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"             },
    { 0x031e, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"             },
    { 0x031f, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"             },
    { 0x0320, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"             },
    { 0x0321, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"             },
    { 0x0322, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"             },
    { 0x0323, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"             },
    { 0x0324, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"          },
    { 0x0325, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"            },
    { 0x0326, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"            },
    { 0x0327, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"            },
    { 0x0328, "?do_get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"           },
    { 0x0329, "?do_get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"           },
    { 0x032a, "?do_get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"      },
    { 0x032b, "?do_get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x032c, "?do_get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x032d, "?do_get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x032e, "?do_get_monthname@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x032f, "?do_get_monthname@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x0330, "?do_get_monthname@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z" },
    { 0x0331, "?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x0332, "?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x0333, "?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x0334, "?do_get_weekday@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"     },
    { 0x0335, "?do_get_weekday@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"     },
    { 0x0336, "?do_get_weekday@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z" },
    { 0x0337, "?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x0338, "?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x0339, "?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x033a, "?do_in@?$codecvt@DDH@std@@MEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                       },
    { 0x033b, "?do_in@?$codecvt@GDH@std@@MEBAHAEAHPEBD1AEAPEBDPEAG3AEAPEAG@Z"                                                                                                                       },
    { 0x033c, "?do_in@?$codecvt@_WDH@std@@MEBAHAEAHPEBD1AEAPEBDPEA_W3AEAPEA_W@Z"                                                                                                                    },
    { 0x033d, "?do_is@?$ctype@G@std@@MEBAPEBGPEBG0PEAF@Z"                                                                                                                                           },
    { 0x033e, "?do_is@?$ctype@G@std@@MEBA_NFG@Z"                                                                                                                                                    },
    { 0x033f, "?do_is@?$ctype@_W@std@@MEBAPEB_WPEB_W0PEAF@Z"                                                                                                                                        },
    { 0x0340, "?do_is@?$ctype@_W@std@@MEBA_NF_W@Z"                                                                                                                                                  },
    { 0x0341, "?do_length@?$codecvt@DDH@std@@MEBAHAEAHPEBD1_K@Z"                                                                                                                                    },
    { 0x0342, "?do_length@?$codecvt@GDH@std@@MEBAHAEAHPEBD1_K@Z"                                                                                                                                    },
    { 0x0343, "?do_length@?$codecvt@_WDH@std@@MEBAHAEAHPEBD1_K@Z"                                                                                                                                   },
    { 0x0344, "?do_max_length@?$codecvt@GDH@std@@MEBAHXZ"                                                                                                                                           },
    { 0x0345, "?do_max_length@?$codecvt@_WDH@std@@MEBAHXZ"                                                                                                                                          },
    { 0x0346, "?do_max_length@codecvt_base@std@@MEBAHXZ"                                                                                                                                            },
    { 0x0347, "?do_narrow@?$ctype@D@std@@MEBADDD@Z"                                                                                                                                                 },
    { 0x0348, "?do_narrow@?$ctype@D@std@@MEBAPEBDPEBD0DPEAD@Z"                                                                                                                                      },
    { 0x0349, "?do_narrow@?$ctype@G@std@@MEBADGD@Z"                                                                                                                                                 },
    { 0x034a, "?do_narrow@?$ctype@G@std@@MEBAPEBGPEBG0DPEAD@Z"                                                                                                                                      },
    { 0x034b, "?do_narrow@?$ctype@_W@std@@MEBAD_WD@Z"                                                                                                                                               },
    { 0x034c, "?do_narrow@?$ctype@_W@std@@MEBAPEB_WPEB_W0DPEAD@Z"                                                                                                                                   },
    { 0x034d, "?do_out@?$codecvt@DDH@std@@MEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                      },
    { 0x034e, "?do_out@?$codecvt@GDH@std@@MEBAHAEAHPEBG1AEAPEBGPEAD3AEAPEAD@Z"                                                                                                                      },
    { 0x034f, "?do_out@?$codecvt@_WDH@std@@MEBAHAEAHPEB_W1AEAPEB_WPEAD3AEAPEAD@Z"                                                                                                                   },
    { 0x0350, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DJ@Z"                         },
    { 0x0351, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DK@Z"                         },
    { 0x0352, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DN@Z"                         },
    { 0x0353, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DO@Z"                         },
    { 0x0354, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBX@Z"                      },
    { 0x0355, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_J@Z"                        },
    { 0x0356, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_K@Z"                        },
    { 0x0357, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_N@Z"                        },
    { 0x0358, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GJ@Z"                         },
    { 0x0359, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GK@Z"                         },
    { 0x035a, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GN@Z"                         },
    { 0x035b, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GO@Z"                         },
    { 0x035c, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBX@Z"                      },
    { 0x035d, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_J@Z"                        },
    { 0x035e, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_K@Z"                        },
    { 0x035f, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_N@Z"                        },
    { 0x0360, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WJ@Z"                   },
    { 0x0361, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WK@Z"                   },
    { 0x0362, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WN@Z"                   },
    { 0x0363, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WO@Z"                   },
    { 0x0364, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBX@Z"                },
    { 0x0365, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_J@Z"                  },
    { 0x0366, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_K@Z"                  },
    { 0x0367, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_N@Z"                  },
    { 0x0368, "?do_put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBUtm@@DD@Z"               },
    { 0x0369, "?do_put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBUtm@@DD@Z"               },
    { 0x036a, "?do_put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBUtm@@DD@Z"         },
    { 0x036b, "?do_scan_is@?$ctype@G@std@@MEBAPEBGFPEBG0@Z"                                                                                                                                         },
    { 0x036c, "?do_scan_is@?$ctype@_W@std@@MEBAPEB_WFPEB_W0@Z"                                                                                                                                      },
    { 0x036d, "?do_scan_not@?$ctype@G@std@@MEBAPEBGFPEBG0@Z"                                                                                                                                        },
    { 0x036e, "?do_scan_not@?$ctype@_W@std@@MEBAPEB_WFPEB_W0@Z"                                                                                                                                     },
    { 0x036f, "?do_tolower@?$ctype@D@std@@MEBADD@Z"                                                                                                                                                 },
    { 0x0370, "?do_tolower@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"                                                                                                                                       },
    { 0x0371, "?do_tolower@?$ctype@G@std@@MEBAGG@Z"                                                                                                                                                 },
    { 0x0372, "?do_tolower@?$ctype@G@std@@MEBAPEBGPEAGPEBG@Z"                                                                                                                                       },
    { 0x0373, "?do_tolower@?$ctype@_W@std@@MEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                   },
    { 0x0374, "?do_tolower@?$ctype@_W@std@@MEBA_W_W@Z"                                                                                                                                              },
    { 0x0375, "?do_toupper@?$ctype@D@std@@MEBADD@Z"                                                                                                                                                 },
    { 0x0376, "?do_toupper@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"                                                                                                                                       },
    { 0x0377, "?do_toupper@?$ctype@G@std@@MEBAGG@Z"                                                                                                                                                 },
    { 0x0378, "?do_toupper@?$ctype@G@std@@MEBAPEBGPEAGPEBG@Z"                                                                                                                                       },
    { 0x0379, "?do_toupper@?$ctype@_W@std@@MEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                   },
    { 0x037a, "?do_toupper@?$ctype@_W@std@@MEBA_W_W@Z"                                                                                                                                              },
    { 0x037b, "?do_unshift@?$codecvt@DDH@std@@MEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                              },
    { 0x037c, "?do_unshift@?$codecvt@GDH@std@@MEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                              },
    { 0x037d, "?do_unshift@?$codecvt@_WDH@std@@MEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                             },
    { 0x037e, "?do_widen@?$ctype@D@std@@MEBADD@Z"                                                                                                                                                   },
    { 0x037f, "?do_widen@?$ctype@D@std@@MEBAPEBDPEBD0PEAD@Z"                                                                                                                                        },
    { 0x0380, "?do_widen@?$ctype@G@std@@MEBAGD@Z"                                                                                                                                                   },
    { 0x0381, "?do_widen@?$ctype@G@std@@MEBAPEBDPEBD0PEAG@Z"                                                                                                                                        },
    { 0x0382, "?do_widen@?$ctype@_W@std@@MEBAPEBDPEBD0PEA_W@Z"                                                                                                                                      },
    { 0x0383, "?do_widen@?$ctype@_W@std@@MEBA_WD@Z"                                                                                                                                                 },
    { 0x0384, "?done@agent@Concurrency@@IEAA_NXZ"                                                                                                                                                   },
    { 0x0385, "?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x0386, "?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x0387, "?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x0388, "?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x0389, "?egptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x038a, "?egptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x038b, "?empty@?$_Yarn@D@std@@QEBA_NXZ"                                                                                                                                                      },
    { 0x038c, "?empty@locale@std@@SA?AV12@XZ"                                                                                                                                                       },
    { 0x038d, "?encoding@codecvt_base@std@@QEBAHXZ"                                                                                                                                                 },
    { 0x038e, "?endl@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z"                                                                                                                },
    { 0x038f, "?endl@std@@YAAEAV?$basic_ostream@GU?$char_traits@G@std@@@1@AEAV21@@Z"                                                                                                                },
    { 0x0390, "?endl@std@@YAAEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@AEAV21@@Z"                                                                                                              },
    { 0x0391, "?ends@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z"                                                                                                                },
    { 0x0392, "?ends@std@@YAAEAV?$basic_ostream@GU?$char_traits@G@std@@@1@AEAV21@@Z"                                                                                                                },
    { 0x0393, "?ends@std@@YAAEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@AEAV21@@Z"                                                                                                              },
    { 0x0394, "?eof@ios_base@std@@QEBA_NXZ"                                                                                                                                                         },
    { 0x0395, "?epptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x0396, "?epptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x0397, "?epptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x0398, "?exceptions@ios_base@std@@QEAAXH@Z"                                                                                                                                                  },
    { 0x0399, "?exceptions@ios_base@std@@QEAAXI@Z"                                                                                                                                                  },
    { 0x039a, "?exceptions@ios_base@std@@QEBAHXZ"                                                                                                                                                   },
    { 0x039b, "?fail@ios_base@std@@QEBA_NXZ"                                                                                                                                                        },
    { 0x039c, "?fill@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAADD@Z"                                                                                                                             },
    { 0x039d, "?fill@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADXZ"                                                                                                                              },
    { 0x039e, "?fill@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAGG@Z"                                                                                                                             },
    { 0x039f, "?fill@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGXZ"                                                                                                                              },
    { 0x03a0, "?fill@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAA_W_W@Z"                                                                                                                         },
    { 0x03a1, "?fill@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WXZ"                                                                                                                           },
    { 0x03a2, "?flags@ios_base@std@@QEAAHH@Z"                                                                                                                                                       },
    { 0x03a3, "?flags@ios_base@std@@QEBAHXZ"                                                                                                                                                        },
    { 0x03a4, "?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x03a5, "?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x03a6, "?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@XZ"                                                                                                                 },
    { 0x03a7, "?flush@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z"                                                                                                               },
    { 0x03a8, "?flush@std@@YAAEAV?$basic_ostream@GU?$char_traits@G@std@@@1@AEAV21@@Z"                                                                                                               },
    { 0x03a9, "?flush@std@@YAAEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@AEAV21@@Z"                                                                                                             },
    { 0x03aa, "?gbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x03ab, "?gbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x03ac, "?gbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXH@Z"                                                                                                                    },
    { 0x03ad, "?gcount@?$basic_istream@DU?$char_traits@D@std@@@std@@QEBA_JXZ"                                                                                                                       },
    { 0x03ae, "?gcount@?$basic_istream@GU?$char_traits@G@std@@@std@@QEBA_JXZ"                                                                                                                       },
    { 0x03af, "?gcount@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEBA_JXZ"                                                                                                                     },
    { 0x03b0, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z"                                                                                                                 },
    { 0x03b1, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@@Z"                                                                     },
    { 0x03b2, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@D@Z"                                                                    },
    { 0x03b3, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_J@Z"                                                                                                               },
    { 0x03b4, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_JD@Z"                                                                                                              },
    { 0x03b5, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                           },
    { 0x03b6, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEAG@Z"                                                                                                                 },
    { 0x03b7, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@@Z"                                                                     },
    { 0x03b8, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@G@Z"                                                                    },
    { 0x03b9, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_J@Z"                                                                                                               },
    { 0x03ba, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_JG@Z"                                                                                                              },
    { 0x03bb, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                           },
    { 0x03bc, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@@Z"                                                                 },
    { 0x03bd, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_W@Z"                                                               },
    { 0x03be, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEA_W@Z"                                                                                                              },
    { 0x03bf, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J@Z"                                                                                                            },
    { 0x03c0, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J_W@Z"                                                                                                          },
    { 0x03c1, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                         },
    { 0x03c2, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                     },
    { 0x03c3, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                     },
    { 0x03c4, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                     },
    { 0x03c5, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                     },
    { 0x03c6, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                     },
    { 0x03c7, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                     },
    { 0x03c8, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                     },
    { 0x03c9, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"                  },
    { 0x03ca, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                    },
    { 0x03cb, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                    },
    { 0x03cc, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                    },
    { 0x03cd, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                     },
    { 0x03ce, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                     },
    { 0x03cf, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                     },
    { 0x03d0, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                     },
    { 0x03d1, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                     },
    { 0x03d2, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                     },
    { 0x03d3, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                     },
    { 0x03d4, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"                  },
    { 0x03d5, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                    },
    { 0x03d6, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                    },
    { 0x03d7, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                    },
    { 0x03d8, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                },
    { 0x03d9, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                },
    { 0x03da, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                },
    { 0x03db, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                },
    { 0x03dc, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                },
    { 0x03dd, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                },
    { 0x03de, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                },
    { 0x03df, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"             },
    { 0x03e0, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"               },
    { 0x03e1, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"               },
    { 0x03e2, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"               },
    { 0x03e3, "?get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"              },
    { 0x03e4, "?get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD4@Z"           },
    { 0x03e5, "?get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"              },
    { 0x03e6, "?get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBG4@Z"           },
    { 0x03e7, "?get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"         },
    { 0x03e8, "?get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEB_W4@Z"     },
    { 0x03e9, "?get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03ea, "?get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03eb, "?get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03ec, "?get_monthname@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03ed, "?get_monthname@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03ee, "?get_monthname@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z" },
    { 0x03ef, "?get_new_handler@std@@YAP6AXXZXZ"                                                                                                                                                    },
    { 0x03f0, "?get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03f1, "?get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03f2, "?get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03f3, "?get_weekday@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x03f4, "?get_weekday@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x03f5, "?get_weekday@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x03f6, "?get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03f7, "?get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03f8, "?get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03f9, "?getline@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_J@Z"                                                                                                           },
    { 0x03fa, "?getline@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_JD@Z"                                                                                                          },
    { 0x03fb, "?getline@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_J@Z"                                                                                                           },
    { 0x03fc, "?getline@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_JG@Z"                                                                                                          },
    { 0x03fd, "?getline@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J@Z"                                                                                                        },
    { 0x03fe, "?getline@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J_W@Z"                                                                                                      },
    { 0x03ff, "?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ"                                                                                                           },
    { 0x0400, "?getloc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEBA?AVlocale@2@XZ"                                                                                                           },
    { 0x0401, "?getloc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEBA?AVlocale@2@XZ"                                                                                                         },
    { 0x0402, "?getloc@ios_base@std@@QEBA?AVlocale@2@XZ"                                                                                                                                            },
    { 0x0403, "?global@locale@std@@SA?AV12@AEBV12@@Z"                                                                                                                                               },
    { 0x0404, "?good@ios_base@std@@QEBA_NXZ"                                                                                                                                                        },
    { 0x0405, "?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                     },
    { 0x0406, "?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                     },
    { 0x0407, "?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                  },
    { 0x0408, "?id@?$codecvt@DDH@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x0409, "?id@?$codecvt@GDH@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x040a, "?id@?$codecvt@_WDH@std@@2V0locale@2@A"                                                                                                                                               },
    { 0x040b, "?id@?$collate@D@std@@2V0locale@2@A"                                                                                                                                                  },
    { 0x040c, "?id@?$collate@G@std@@2V0locale@2@A"                                                                                                                                                  },
    { 0x040d, "?id@?$collate@_W@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x040e, "?id@?$ctype@D@std@@2V0locale@2@A"                                                                                                                                                    },
    { 0x040f, "?id@?$ctype@G@std@@2V0locale@2@A"                                                                                                                                                    },
    { 0x0410, "?id@?$ctype@_W@std@@2V0locale@2@A"                                                                                                                                                   },
    { 0x0411, "?id@?$messages@D@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x0412, "?id@?$messages@G@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x0413, "?id@?$messages@_W@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x0414, "?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x0415, "?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x0416, "?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                         },
    { 0x0417, "?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x0418, "?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x0419, "?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                         },
    { 0x041a, "?id@?$moneypunct@D$00@std@@2V0locale@2@A"                                                                                                                                            },
    { 0x041b, "?id@?$moneypunct@D$0A@@std@@2V0locale@2@A"                                                                                                                                           },
    { 0x041c, "?id@?$moneypunct@G$00@std@@2V0locale@2@A"                                                                                                                                            },
    { 0x041d, "?id@?$moneypunct@G$0A@@std@@2V0locale@2@A"                                                                                                                                           },
    { 0x041e, "?id@?$moneypunct@_W$00@std@@2V0locale@2@A"                                                                                                                                           },
    { 0x041f, "?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A"                                                                                                                                          },
    { 0x0420, "?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x0421, "?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x0422, "?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                           },
    { 0x0423, "?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x0424, "?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x0425, "?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                           },
    { 0x0426, "?id@?$numpunct@D@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x0427, "?id@?$numpunct@G@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x0428, "?id@?$numpunct@_W@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x0429, "?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x042a, "?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x042b, "?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                          },
    { 0x042c, "?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x042d, "?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x042e, "?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                          },
    { 0x042f, "?ignore@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                               },
    { 0x0430, "?ignore@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@_JG@Z"                                                                                                               },
    { 0x0431, "?ignore@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_JG@Z"                                                                                                             },
    { 0x0432, "?imbue@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                           },
    { 0x0433, "?imbue@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                           },
    { 0x0434, "?imbue@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                         },
    { 0x0435, "?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z"                                                                                                          },
    { 0x0436, "?imbue@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAXAEBVlocale@2@@Z"                                                                                                          },
    { 0x0437, "?imbue@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAXAEBVlocale@2@@Z"                                                                                                        },
    { 0x0438, "?imbue@ios_base@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                                                      },
    { 0x0439, "?in@?$codecvt@DDH@std@@QEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                          },
    { 0x043a, "?in@?$codecvt@GDH@std@@QEBAHAEAHPEBD1AEAPEBDPEAG3AEAPEAG@Z"                                                                                                                          },
    { 0x043b, "?in@?$codecvt@_WDH@std@@QEBAHAEAHPEBD1AEAPEBDPEA_W3AEAPEA_W@Z"                                                                                                                       },
    { 0x043c, "?in_avail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JXZ"                                                                                                                   },
    { 0x043d, "?in_avail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA_JXZ"                                                                                                                   },
    { 0x043e, "?in_avail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA_JXZ"                                                                                                                 },
    { 0x043f, "?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IEAAXPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z"                                                                            },
    { 0x0440, "?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IEAAXPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z"                                                                            },
    { 0x0441, "?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAAXPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z"                                                                        },
    { 0x0442, "?intl@?$moneypunct@D$00@std@@2_NB"                                                                                                                                                   },
    { 0x0443, "?intl@?$moneypunct@D$0A@@std@@2_NB"                                                                                                                                                  },
    { 0x0444, "?intl@?$moneypunct@G$00@std@@2_NB"                                                                                                                                                   },
    { 0x0445, "?intl@?$moneypunct@G$0A@@std@@2_NB"                                                                                                                                                  },
    { 0x0446, "?intl@?$moneypunct@_W$00@std@@2_NB"                                                                                                                                                  },
    { 0x0447, "?intl@?$moneypunct@_W$0A@@std@@2_NB"                                                                                                                                                 },
    { 0x0448, "?ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z"                                                                                                                       },
    { 0x0449, "?ipfx@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA_N_N@Z"                                                                                                                       },
    { 0x044a, "?ipfx@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA_N_N@Z"                                                                                                                     },
    { 0x044b, "?is@?$ctype@D@std@@QEBAPEBDPEBD0PEAF@Z"                                                                                                                                              },
    { 0x044c, "?is@?$ctype@D@std@@QEBA_NFD@Z"                                                                                                                                                       },
    { 0x044d, "?is@?$ctype@G@std@@QEBAPEBGPEBG0PEAF@Z"                                                                                                                                              },
    { 0x044e, "?is@?$ctype@G@std@@QEBA_NFG@Z"                                                                                                                                                       },
    { 0x044f, "?is@?$ctype@_W@std@@QEBAPEB_WPEB_W0PEAF@Z"                                                                                                                                           },
    { 0x0450, "?is@?$ctype@_W@std@@QEBA_NF_W@Z"                                                                                                                                                     },
    { 0x0451, "?is_current_task_group_canceling@Concurrency@@YA_NXZ"                                                                                                                                },
    { 0x0452, "?is_task_cancellation_requested@Concurrency@@YA_NXZ"                                                                                                                                 },
    { 0x0453, "?isfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x0454, "?isfx@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x0455, "?isfx@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                        },
    { 0x0456, "?iword@ios_base@std@@QEAAAEAJH@Z"                                                                                                                                                    },
    { 0x0457, "?length@?$codecvt@DDH@std@@QEBAHAEAHPEBD1_K@Z"                                                                                                                                       },
    { 0x0458, "?length@?$codecvt@GDH@std@@QEBAHAEAHPEBD1_K@Z"                                                                                                                                       },
    { 0x0459, "?length@?$codecvt@_WDH@std@@QEBAHAEAHPEBD1_K@Z"                                                                                                                                      },
    { 0x045a, "?max_length@codecvt_base@std@@QEBAHXZ"                                                                                                                                               },
    { 0x045b, "?move@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAX$$QEAV12@@Z"                                                                                                                     },
    { 0x045c, "?move@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x045d, "?move@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAX$$QEAV12@@Z"                                                                                                                     },
    { 0x045e, "?move@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x045f, "?move@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAX$$QEAV12@@Z"                                                                                                                   },
    { 0x0460, "?move@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                     },
    { 0x0461, "?narrow@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADDD@Z"                                                                                                                          },
    { 0x0462, "?narrow@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBADGD@Z"                                                                                                                          },
    { 0x0463, "?narrow@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBAD_WD@Z"                                                                                                                       },
    { 0x0464, "?narrow@?$ctype@D@std@@QEBADDD@Z"                                                                                                                                                    },
    { 0x0465, "?narrow@?$ctype@D@std@@QEBAPEBDPEBD0DPEAD@Z"                                                                                                                                         },
    { 0x0466, "?narrow@?$ctype@G@std@@QEBADGD@Z"                                                                                                                                                    },
    { 0x0467, "?narrow@?$ctype@G@std@@QEBAPEBGPEBG0DPEAD@Z"                                                                                                                                         },
    { 0x0468, "?narrow@?$ctype@_W@std@@QEBAD_WD@Z"                                                                                                                                                  },
    { 0x0469, "?narrow@?$ctype@_W@std@@QEBAPEB_WPEB_W0DPEAD@Z"                                                                                                                                      },
    { 0x046a, "?opfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA_NXZ"                                                                                                                         },
    { 0x046b, "?opfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA_NXZ"                                                                                                                         },
    { 0x046c, "?opfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA_NXZ"                                                                                                                       },
    { 0x046d, "?osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x046e, "?osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x046f, "?osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                        },
    { 0x0470, "?out@?$codecvt@DDH@std@@QEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                         },
    { 0x0471, "?out@?$codecvt@GDH@std@@QEBAHAEAHPEBG1AEAPEBGPEAD3AEAPEAD@Z"                                                                                                                         },
    { 0x0472, "?out@?$codecvt@_WDH@std@@QEBAHAEAHPEB_W1AEAPEB_WPEAD3AEAPEAD@Z"                                                                                                                      },
    { 0x0473, "?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"                                                                                                                   },
    { 0x0474, "?overflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGG@Z"                                                                                                                   },
    { 0x0475, "?overflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGG@Z"                                                                                                                 },
    { 0x0476, "?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"                                                                                                                  },
    { 0x0477, "?pbackfail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGG@Z"                                                                                                                  },
    { 0x0478, "?pbackfail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGG@Z"                                                                                                                },
    { 0x0479, "?pbase@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x047a, "?pbase@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x047b, "?pbase@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x047c, "?pbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x047d, "?pbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x047e, "?pbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXH@Z"                                                                                                                    },
    { 0x047f, "?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                          },
    { 0x0480, "?peek@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                          },
    { 0x0481, "?peek@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                        },
    { 0x0482, "?pptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                     },
    { 0x0483, "?pptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                     },
    { 0x0484, "?pptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                  },
    { 0x0485, "?precision@ios_base@std@@QEAA_J_J@Z"                                                                                                                                                 },
    { 0x0486, "?precision@ios_base@std@@QEBA_JXZ"                                                                                                                                                   },
    { 0x0487, "?pubimbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                  },
    { 0x0488, "?pubimbue@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                  },
    { 0x0489, "?pubimbue@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                },
    { 0x048a, "?pubseekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                 },
    { 0x048b, "?pubseekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@_JII@Z"                                                                                                 },
    { 0x048c, "?pubseekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                 },
    { 0x048d, "?pubseekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@_JII@Z"                                                                                                 },
    { 0x048e, "?pubseekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@_JHH@Z"                                                                                               },
    { 0x048f, "?pubseekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@_JII@Z"                                                                                               },
    { 0x0490, "?pubseekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                },
    { 0x0491, "?pubseekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@V32@I@Z"                                                                                                },
    { 0x0492, "?pubseekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                },
    { 0x0493, "?pubseekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@V32@I@Z"                                                                                                },
    { 0x0494, "?pubseekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@V32@H@Z"                                                                                              },
    { 0x0495, "?pubseekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@V32@I@Z"                                                                                              },
    { 0x0496, "?pubsetbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAPEAV12@PEAD_J@Z"                                                                                                       },
    { 0x0497, "?pubsetbuf@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAPEAV12@PEAG_J@Z"                                                                                                       },
    { 0x0498, "?pubsetbuf@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAPEAV12@PEA_W_J@Z"                                                                                                    },
    { 0x0499, "?pubsync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                     },
    { 0x049a, "?pubsync@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAHXZ"                                                                                                                     },
    { 0x049b, "?pubsync@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAHXZ"                                                                                                                   },
    { 0x049c, "?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z"                                                                                                                    },
    { 0x049d, "?put@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@G@Z"                                                                                                                    },
    { 0x049e, "?put@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_W@Z"                                                                                                                 },
    { 0x049f, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DJ@Z"                            },
    { 0x04a0, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DK@Z"                            },
    { 0x04a1, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DN@Z"                            },
    { 0x04a2, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DO@Z"                            },
    { 0x04a3, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBX@Z"                         },
    { 0x04a4, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_J@Z"                           },
    { 0x04a5, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_K@Z"                           },
    { 0x04a6, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_N@Z"                           },
    { 0x04a7, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GJ@Z"                            },
    { 0x04a8, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GK@Z"                            },
    { 0x04a9, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GN@Z"                            },
    { 0x04aa, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GO@Z"                            },
    { 0x04ab, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBX@Z"                         },
    { 0x04ac, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_J@Z"                           },
    { 0x04ad, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_K@Z"                           },
    { 0x04ae, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_N@Z"                           },
    { 0x04af, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WJ@Z"                      },
    { 0x04b0, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WK@Z"                      },
    { 0x04b1, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WN@Z"                      },
    { 0x04b2, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WO@Z"                      },
    { 0x04b3, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBX@Z"                   },
    { 0x04b4, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_J@Z"                     },
    { 0x04b5, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_K@Z"                     },
    { 0x04b6, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_N@Z"                     },
    { 0x04b7, "?put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBUtm@@DD@Z"                  },
    { 0x04b8, "?put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBUtm@@PEBD3@Z"               },
    { 0x04b9, "?put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBUtm@@DD@Z"                  },
    { 0x04ba, "?put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBUtm@@PEBG3@Z"               },
    { 0x04bb, "?put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBUtm@@DD@Z"            },
    { 0x04bc, "?put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBUtm@@PEB_W4@Z"        },
    { 0x04bd, "?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z"                                                                                                                },
    { 0x04be, "?putback@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@G@Z"                                                                                                                },
    { 0x04bf, "?putback@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_W@Z"                                                                                                             },
    { 0x04c0, "?pword@ios_base@std@@QEAAAEAPEAXH@Z"                                                                                                                                                 },
    { 0x04c1, "?rdbuf@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@PEAV32@@Z"                                                                       },
    { 0x04c2, "?rdbuf@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBAPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@XZ"                                                                              },
    { 0x04c3, "?rdbuf@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@PEAV32@@Z"                                                                       },
    { 0x04c4, "?rdbuf@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@XZ"                                                                              },
    { 0x04c5, "?rdbuf@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@PEAV32@@Z"                                                                   },
    { 0x04c6, "?rdbuf@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBAPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@XZ"                                                                          },
    { 0x04c7, "?rdstate@ios_base@std@@QEBAHXZ"                                                                                                                                                      },
    { 0x04c8, "?read@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_J@Z"                                                                                                              },
    { 0x04c9, "?read@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_J@Z"                                                                                                              },
    { 0x04ca, "?read@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J@Z"                                                                                                           },
    { 0x04cb, "?readsome@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_JPEAD_J@Z"                                                                                                               },
    { 0x04cc, "?readsome@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA_JPEAG_J@Z"                                                                                                               },
    { 0x04cd, "?readsome@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA_JPEA_W_J@Z"                                                                                                            },
    { 0x04ce, "?register_callback@ios_base@std@@QEAAXP6AXW4event@12@AEAV12@H@ZH@Z"                                                                                                                  },
    { 0x04cf, "?resetiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"                                                                                                                                          },
    { 0x04d0, "?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                      },
    { 0x04d1, "?sbumpc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                      },
    { 0x04d2, "?sbumpc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                    },
    { 0x04d3, "?scan_is@?$ctype@D@std@@QEBAPEBDFPEBD0@Z"                                                                                                                                            },
    { 0x04d4, "?scan_is@?$ctype@G@std@@QEBAPEBGFPEBG0@Z"                                                                                                                                            },
    { 0x04d5, "?scan_is@?$ctype@_W@std@@QEBAPEB_WFPEB_W0@Z"                                                                                                                                         },
    { 0x04d6, "?scan_not@?$ctype@D@std@@QEBAPEBDFPEBD0@Z"                                                                                                                                           },
    { 0x04d7, "?scan_not@?$ctype@G@std@@QEBAPEBGFPEBG0@Z"                                                                                                                                           },
    { 0x04d8, "?scan_not@?$ctype@_W@std@@QEBAPEB_WFPEB_W0@Z"                                                                                                                                        },
    { 0x04d9, "?seekg@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04da, "?seekg@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04db, "?seekg@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04dc, "?seekg@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04dd, "?seekg@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                     },
    { 0x04de, "?seekg@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                              },
    { 0x04df, "?seekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                    },
    { 0x04e0, "?seekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                    },
    { 0x04e1, "?seekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                  },
    { 0x04e2, "?seekp@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04e3, "?seekp@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04e4, "?seekp@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04e5, "?seekp@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04e6, "?seekp@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                     },
    { 0x04e7, "?seekp@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                              },
    { 0x04e8, "?seekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                   },
    { 0x04e9, "?seekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                   },
    { 0x04ea, "?seekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                 },
    { 0x04eb, "?set_new_handler@std@@YAP6AXXZP6AXXZ@Z"                                                                                                                                              },
    { 0x04ec, "?set_rdbuf@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@@Z"                                                                         },
    { 0x04ed, "?set_rdbuf@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@@Z"                                                                         },
    { 0x04ee, "?set_rdbuf@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@@Z"                                                                     },
    { 0x04ef, "?setbase@std@@YA?AU?$_Smanip@H@1@H@Z"                                                                                                                                                },
    { 0x04f0, "?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z"                                                                                                          },
    { 0x04f1, "?setbuf@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAPEAV12@PEAG_J@Z"                                                                                                          },
    { 0x04f2, "?setbuf@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAPEAV12@PEA_W_J@Z"                                                                                                       },
    { 0x04f3, "?setf@ios_base@std@@QEAAHH@Z"                                                                                                                                                        },
    { 0x04f4, "?setf@ios_base@std@@QEAAHHH@Z"                                                                                                                                                       },
    { 0x04f5, "?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"                                                                                                                  },
    { 0x04f6, "?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG00@Z"                                                                                                                  },
    { 0x04f7, "?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W00@Z"                                                                                                               },
    { 0x04f8, "?setiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"                                                                                                                                            },
    { 0x04f9, "?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"                                                                                                                  },
    { 0x04fa, "?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD0@Z"                                                                                                                   },
    { 0x04fb, "?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG00@Z"                                                                                                                  },
    { 0x04fc, "?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG0@Z"                                                                                                                   },
    { 0x04fd, "?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W00@Z"                                                                                                               },
    { 0x04fe, "?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W0@Z"                                                                                                                },
    { 0x04ff, "?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z"                                                                                                                                         },
    { 0x0500, "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"                                                                                                                       },
    { 0x0501, "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXI@Z"                                                                                                                         },
    { 0x0502, "?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z"                                                                                                                       },
    { 0x0503, "?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXI@Z"                                                                                                                         },
    { 0x0504, "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"                                                                                                                     },
    { 0x0505, "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXI@Z"                                                                                                                       },
    { 0x0506, "?setstate@ios_base@std@@QEAAXH@Z"                                                                                                                                                    },
    { 0x0507, "?setstate@ios_base@std@@QEAAXH_N@Z"                                                                                                                                                  },
    { 0x0508, "?setstate@ios_base@std@@QEAAXI@Z"                                                                                                                                                    },
    { 0x0509, "?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z"                                                                                                                                                 },
    { 0x050a, "?sgetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                       },
    { 0x050b, "?sgetc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                       },
    { 0x050c, "?sgetc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                     },
    { 0x050d, "?sgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEAD_J@Z"                                                                                                                },
    { 0x050e, "?sgetn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA_JPEAG_J@Z"                                                                                                                },
    { 0x050f, "?sgetn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA_JPEA_W_J@Z"                                                                                                             },
    { 0x0510, "?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ"                                                                                                                  },
    { 0x0511, "?showmanyc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JXZ"                                                                                                                  },
    { 0x0512, "?showmanyc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JXZ"                                                                                                                },
    { 0x0513, "?snextc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                      },
    { 0x0514, "?snextc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                      },
    { 0x0515, "?snextc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                    },
    { 0x0516, "?sputbackc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"                                                                                                                  },
    { 0x0517, "?sputbackc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGG@Z"                                                                                                                  },
    { 0x0518, "?sputbackc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAG_W@Z"                                                                                                               },
    { 0x0519, "?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"                                                                                                                      },
    { 0x051a, "?sputc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGG@Z"                                                                                                                      },
    { 0x051b, "?sputc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAG_W@Z"                                                                                                                   },
    { 0x051c, "?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z"                                                                                                                },
    { 0x051d, "?sputn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA_JPEBG_J@Z"                                                                                                                },
    { 0x051e, "?sputn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA_JPEB_W_J@Z"                                                                                                             },
    { 0x051f, "?start@agent@Concurrency@@QEAA_NXZ"                                                                                                                                                  },
    { 0x0520, "?status@agent@Concurrency@@QEAA?AW4agent_status@2@XZ"                                                                                                                                },
    { 0x0521, "?status_port@agent@Concurrency@@QEAAPEAV?$ISource@W4agent_status@Concurrency@@@2@XZ"                                                                                                 },
    { 0x0522, "?stossc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                      },
    { 0x0523, "?stossc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                      },
    { 0x0524, "?stossc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                    },
    { 0x0525, "?sungetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                     },
    { 0x0526, "?sungetc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                     },
    { 0x0527, "?sungetc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                   },
    { 0x0528, "?swap@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x0529, "?swap@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x052a, "?swap@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                     },
    { 0x052b, "?swap@?$basic_iostream@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                  },
    { 0x052c, "?swap@?$basic_iostream@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                  },
    { 0x052d, "?swap@?$basic_iostream@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                },
    { 0x052e, "?swap@?$basic_istream@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x052f, "?swap@?$basic_istream@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x0530, "?swap@?$basic_istream@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x0531, "?swap@?$basic_ostream@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x0532, "?swap@?$basic_ostream@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x0533, "?swap@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x0534, "?swap@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x0535, "?swap@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x0536, "?swap@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                               },
    { 0x0537, "?swap@ios_base@std@@QEAAXAEAV12@@Z"                                                                                                                                                  },
    { 0x0538, "?sync@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                          },
    { 0x0539, "?sync@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAHXZ"                                                                                                                          },
    { 0x053a, "?sync@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAHXZ"                                                                                                                        },
    { 0x053b, "?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"                                                                                                                        },
    { 0x053c, "?sync@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAHXZ"                                                                                                                        },
    { 0x053d, "?sync@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAHXZ"                                                                                                                      },
    { 0x053e, "?sync_with_stdio@ios_base@std@@SA_N_N@Z"                                                                                                                                             },
    { 0x053f, "?table@?$ctype@D@std@@QEBAPEBFXZ"                                                                                                                                                    },
    { 0x0540, "?table_size@?$ctype@D@std@@2_KB"                                                                                                                                                     },
    { 0x0541, "?tellg@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x0542, "?tellg@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x0543, "?tellg@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                          },
    { 0x0544, "?tellp@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x0545, "?tellp@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x0546, "?tellp@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                          },
    { 0x0547, "?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAPEAV?$basic_ostream@DU?$char_traits@D@std@@@2@PEAV32@@Z"                                                                           },
    { 0x0548, "?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBAPEAV?$basic_ostream@DU?$char_traits@D@std@@@2@XZ"                                                                                  },
    { 0x0549, "?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAPEAV?$basic_ostream@GU?$char_traits@G@std@@@2@PEAV32@@Z"                                                                           },
    { 0x054a, "?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAPEAV?$basic_ostream@GU?$char_traits@G@std@@@2@XZ"                                                                                  },
    { 0x054b, "?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAPEAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PEAV32@@Z"                                                                       },
    { 0x054c, "?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBAPEAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@XZ"                                                                              },
    { 0x054d, "?tolower@?$ctype@D@std@@QEBADD@Z"                                                                                                                                                    },
    { 0x054e, "?tolower@?$ctype@D@std@@QEBAPEBDPEADPEBD@Z"                                                                                                                                          },
    { 0x054f, "?tolower@?$ctype@G@std@@QEBAGG@Z"                                                                                                                                                    },
    { 0x0550, "?tolower@?$ctype@G@std@@QEBAPEBGPEAGPEBG@Z"                                                                                                                                          },
    { 0x0551, "?tolower@?$ctype@_W@std@@QEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                      },
    { 0x0552, "?tolower@?$ctype@_W@std@@QEBA_W_W@Z"                                                                                                                                                 },
    { 0x0553, "?toupper@?$ctype@D@std@@QEBADD@Z"                                                                                                                                                    },
    { 0x0554, "?toupper@?$ctype@D@std@@QEBAPEBDPEADPEBD@Z"                                                                                                                                          },
    { 0x0555, "?toupper@?$ctype@G@std@@QEBAGG@Z"                                                                                                                                                    },
    { 0x0556, "?toupper@?$ctype@G@std@@QEBAPEBGPEAGPEBG@Z"                                                                                                                                          },
    { 0x0557, "?toupper@?$ctype@_W@std@@QEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                      },
    { 0x0558, "?toupper@?$ctype@_W@std@@QEBA_W_W@Z"                                                                                                                                                 },
    { 0x0559, "?try_to_lock@std@@3Utry_to_lock_t@1@B"                                                                                                                                               },
    { 0x055a, "?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"                                                                                                                       },
    { 0x055b, "?uflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGXZ"                                                                                                                       },
    { 0x055c, "?uflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ"                                                                                                                     },
    { 0x055d, "?uncaught_exception@std@@YA_NXZ"                                                                                                                                                     },
    { 0x055e, "?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"                                                                                                                   },
    { 0x055f, "?underflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGXZ"                                                                                                                   },
    { 0x0560, "?underflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ"                                                                                                                 },
    { 0x0561, "?unget@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x0562, "?unget@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x0563, "?unget@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@XZ"                                                                                                                 },
    { 0x0564, "?unsetf@ios_base@std@@QEAAXH@Z"                                                                                                                                                      },
    { 0x0565, "?unshift@?$codecvt@DDH@std@@QEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                                 },
    { 0x0566, "?unshift@?$codecvt@GDH@std@@QEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                                 },
    { 0x0567, "?unshift@?$codecvt@_WDH@std@@QEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                                },
    { 0x0568, "?wait@agent@Concurrency@@SA?AW4agent_status@2@PEAV12@I@Z"                                                                                                                            },
    { 0x0569, "?wait_for_all@agent@Concurrency@@SAX_KPEAPEAV12@PEAW4agent_status@2@I@Z"                                                                                                             },
    { 0x056a, "?wait_for_one@agent@Concurrency@@SAX_KPEAPEAV12@AEAW4agent_status@2@AEA_KI@Z"                                                                                                        },
    { 0x056b, "?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"                                                                                                                           },
    { 0x056c, "?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                         },
    { 0x056d, "?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A"                                                                                                                            },
    { 0x056e, "?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                          },
    { 0x056f, "?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"                                                                                                                           },
    { 0x0570, "?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                         },
    { 0x0571, "?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"                                                                                                                           },
    { 0x0572, "?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                         },
    { 0x0573, "?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z"                                                                                                                            },
    { 0x0574, "?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGD@Z"                                                                                                                            },
    { 0x0575, "?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WD@Z"                                                                                                                         },
    { 0x0576, "?widen@?$ctype@D@std@@QEBADD@Z"                                                                                                                                                      },
    { 0x0577, "?widen@?$ctype@D@std@@QEBAPEBDPEBD0PEAD@Z"                                                                                                                                           },
    { 0x0578, "?widen@?$ctype@G@std@@QEBAGD@Z"                                                                                                                                                      },
    { 0x0579, "?widen@?$ctype@G@std@@QEBAPEBDPEBD0PEAG@Z"                                                                                                                                           },
    { 0x057a, "?widen@?$ctype@_W@std@@QEBAPEBDPEBD0PEA_W@Z"                                                                                                                                         },
    { 0x057b, "?widen@?$ctype@_W@std@@QEBA_WD@Z"                                                                                                                                                    },
    { 0x057c, "?width@ios_base@std@@QEAA_J_J@Z"                                                                                                                                                     },
    { 0x057d, "?width@ios_base@std@@QEBA_JXZ"                                                                                                                                                       },
    { 0x057e, "?write@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEBD_J@Z"                                                                                                             },
    { 0x057f, "?write@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEBG_J@Z"                                                                                                             },
    { 0x0580, "?write@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEB_W_J@Z"                                                                                                          },
    { 0x0581, "?ws@std@@YAAEAV?$basic_istream@DU?$char_traits@D@std@@@1@AEAV21@@Z"                                                                                                                  },
    { 0x0582, "?ws@std@@YAAEAV?$basic_istream@GU?$char_traits@G@std@@@1@AEAV21@@Z"                                                                                                                  },
    { 0x0583, "?ws@std@@YAAEAV?$basic_istream@_WU?$char_traits@_W@std@@@1@AEAV21@@Z"                                                                                                                },
    { 0x0584, "?xalloc@ios_base@std@@SAHXZ"                                                                                                                                                         },
    { 0x0585, "?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z"                                                                                                               },
    { 0x0586, "?xsgetn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JPEAG_J@Z"                                                                                                               },
    { 0x0587, "?xsgetn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JPEA_W_J@Z"                                                                                                            },
    { 0x0588, "?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z"                                                                                                               },
    { 0x0589, "?xsputn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JPEBG_J@Z"                                                                                                               },
    { 0x058a, "?xsputn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JPEB_W_J@Z"                                                                                                            },
    { 0x058b, "_Call_once"                                                                                                                                                                          },
    { 0x058c, "_Call_onceEx"                                                                                                                                                                        },
    { 0x058d, "_Cnd_broadcast"                                                                                                                                                                      },
    { 0x058e, "_Cnd_destroy"                                                                                                                                                                        },
    { 0x058f, "_Cnd_do_broadcast_at_thread_exit"                                                                                                                                                    },
    { 0x0590, "_Cnd_init"                                                                                                                                                                           },
    { 0x0591, "_Cnd_register_at_thread_exit"                                                                                                                                                        },
    { 0x0592, "_Cnd_signal"                                                                                                                                                                         },
    { 0x0593, "_Cnd_timedwait"                                                                                                                                                                      },
    { 0x0594, "_Cnd_unregister_at_thread_exit"                                                                                                                                                      },
    { 0x0595, "_Cnd_wait"                                                                                                                                                                           },
    { 0x0596, "_Cosh"                                                                                                                                                                               },
    { 0x0597, "_Denorm"                                                                                                                                                                             },
    { 0x0598, "_Dint"                                                                                                                                                                               },
    { 0x0599, "_Dnorm"                                                                                                                                                                              },
    { 0x059a, "_Do_call"                                                                                                                                                                            },
    { 0x059b, "_Dscale"                                                                                                                                                                             },
    { 0x059c, "_Dtento"                                                                                                                                                                             },
    { 0x059d, "_Dtest"                                                                                                                                                                              },
    { 0x059e, "_Dunscale"                                                                                                                                                                           },
    { 0x059f, "_Eps"                                                                                                                                                                                },
    { 0x05a0, "_Exp"                                                                                                                                                                                },
    { 0x05a1, "_FCosh"                                                                                                                                                                              },
    { 0x05a2, "_FDenorm"                                                                                                                                                                            },
    { 0x05a3, "_FDint"                                                                                                                                                                              },
    { 0x05a4, "_FDnorm"                                                                                                                                                                             },
    { 0x05a5, "_FDscale"                                                                                                                                                                            },
    { 0x05a6, "_FDtento"                                                                                                                                                                            },
    { 0x05a7, "_FDtest"                                                                                                                                                                             },
    { 0x05a8, "_FDunscale"                                                                                                                                                                          },
    { 0x05a9, "_FEps"                                                                                                                                                                               },
    { 0x05aa, "_FExp"                                                                                                                                                                               },
    { 0x05ab, "_FInf"                                                                                                                                                                               },
    { 0x05ac, "_FNan"                                                                                                                                                                               },
    { 0x05ad, "_FRteps"                                                                                                                                                                             },
    { 0x05ae, "_FSinh"                                                                                                                                                                              },
    { 0x05af, "_FSnan"                                                                                                                                                                              },
    { 0x05b0, "_FXbig"                                                                                                                                                                              },
    { 0x05b1, "_FXp_addh"                                                                                                                                                                           },
    { 0x05b2, "_FXp_addx"                                                                                                                                                                           },
    { 0x05b3, "_FXp_getw"                                                                                                                                                                           },
    { 0x05b4, "_FXp_invx"                                                                                                                                                                           },
    { 0x05b5, "_FXp_ldexpx"                                                                                                                                                                         },
    { 0x05b6, "_FXp_movx"                                                                                                                                                                           },
    { 0x05b7, "_FXp_mulh"                                                                                                                                                                           },
    { 0x05b8, "_FXp_mulx"                                                                                                                                                                           },
    { 0x05b9, "_FXp_setn"                                                                                                                                                                           },
    { 0x05ba, "_FXp_setw"                                                                                                                                                                           },
    { 0x05bb, "_FXp_sqrtx"                                                                                                                                                                          },
    { 0x05bc, "_FXp_subx"                                                                                                                                                                           },
    { 0x05bd, "_FZero"                                                                                                                                                                              },
    { 0x05be, "_Getcoll"                                                                                                                                                                            },
    { 0x05bf, "_Getctype"                                                                                                                                                                           },
    { 0x05c0, "_Getcvt"                                                                                                                                                                             },
    { 0x05c1, "_Getdateorder"                                                                                                                                                                       },
    { 0x05c2, "_Getwctype"                                                                                                                                                                          },
    { 0x05c3, "_Getwctypes"                                                                                                                                                                         },
    { 0x05c4, "_Hugeval"                                                                                                                                                                            },
    { 0x05c5, "_Inf"                                                                                                                                                                                },
    { 0x05c6, "_LCosh"                                                                                                                                                                              },
    { 0x05c7, "_LDenorm"                                                                                                                                                                            },
    { 0x05c8, "_LDint"                                                                                                                                                                              },
    { 0x05c9, "_LDscale"                                                                                                                                                                            },
    { 0x05ca, "_LDtento"                                                                                                                                                                            },
    { 0x05cb, "_LDtest"                                                                                                                                                                             },
    { 0x05cc, "_LDunscale"                                                                                                                                                                          },
    { 0x05cd, "_LEps"                                                                                                                                                                               },
    { 0x05ce, "_LExp"                                                                                                                                                                               },
    { 0x05cf, "_LInf"                                                                                                                                                                               },
    { 0x05d0, "_LNan"                                                                                                                                                                               },
    { 0x05d1, "_LPoly"                                                                                                                                                                              },
    { 0x05d2, "_LRteps"                                                                                                                                                                             },
    { 0x05d3, "_LSinh"                                                                                                                                                                              },
    { 0x05d4, "_LSnan"                                                                                                                                                                              },
    { 0x05d5, "_LXbig"                                                                                                                                                                              },
    { 0x05d6, "_LXp_addh"                                                                                                                                                                           },
    { 0x05d7, "_LXp_addx"                                                                                                                                                                           },
    { 0x05d8, "_LXp_getw"                                                                                                                                                                           },
    { 0x05d9, "_LXp_invx"                                                                                                                                                                           },
    { 0x05da, "_LXp_ldexpx"                                                                                                                                                                         },
    { 0x05db, "_LXp_movx"                                                                                                                                                                           },
    { 0x05dc, "_LXp_mulh"                                                                                                                                                                           },
    { 0x05dd, "_LXp_mulx"                                                                                                                                                                           },
    { 0x05de, "_LXp_setn"                                                                                                                                                                           },
    { 0x05df, "_LXp_setw"                                                                                                                                                                           },
    { 0x05e0, "_LXp_sqrtx"                                                                                                                                                                          },
    { 0x05e1, "_LXp_subx"                                                                                                                                                                           },
    { 0x05e2, "_LZero"                                                                                                                                                                              },
    { 0x05e3, "_Lock_shared_ptr_spin_lock"                                                                                                                                                          },
    { 0x05e4, "_Mbrtowc"                                                                                                                                                                            },
    { 0x05e5, "_Mtx_clear_owner"                                                                                                                                                                    },
    { 0x05e6, "_Mtx_current_owns"                                                                                                                                                                   },
    { 0x05e7, "_Mtx_destroy"                                                                                                                                                                        },
    { 0x05e8, "_Mtx_getconcrtcs"                                                                                                                                                                    },
    { 0x05e9, "_Mtx_init"                                                                                                                                                                           },
    { 0x05ea, "_Mtx_lock"                                                                                                                                                                           },
    { 0x05eb, "_Mtx_reset_owner"                                                                                                                                                                    },
    { 0x05ec, "_Mtx_timedlock"                                                                                                                                                                      },
    { 0x05ed, "_Mtx_trylock"                                                                                                                                                                        },
    { 0x05ee, "_Mtx_unlock"                                                                                                                                                                         },
    { 0x05ef, "_Mtxdst"                                                                                                                                                                             },
    { 0x05f0, "_Mtxinit"                                                                                                                                                                            },
    { 0x05f1, "_Mtxlock"                                                                                                                                                                            },
    { 0x05f2, "_Mtxunlock"                                                                                                                                                                          },
    { 0x05f3, "_Nan"                                                                                                                                                                                },
    { 0x05f4, "_Once"                                                                                                                                                                               },
    { 0x05f5, "_Poly"                                                                                                                                                                               },
    { 0x05f6, "_Rteps"                                                                                                                                                                              },
    { 0x05f7, "_Sinh"                                                                                                                                                                               },
    { 0x05f8, "_Snan"                                                                                                                                                                               },
    { 0x05f9, "_Stod"                                                                                                                                                                               },
    { 0x05fa, "_Stodx"                                                                                                                                                                              },
    { 0x05fb, "_Stof"                                                                                                                                                                               },
    { 0x05fc, "_Stoflt"                                                                                                                                                                             },
    { 0x05fd, "_Stofx"                                                                                                                                                                              },
    { 0x05fe, "_Stold"                                                                                                                                                                              },
    { 0x05ff, "_Stoldx"                                                                                                                                                                             },
    { 0x0600, "_Stoll"                                                                                                                                                                              },
    { 0x0601, "_Stollx"                                                                                                                                                                             },
    { 0x0602, "_Stolx"                                                                                                                                                                              },
    { 0x0603, "_Stopfx"                                                                                                                                                                             },
    { 0x0604, "_Stoul"                                                                                                                                                                              },
    { 0x0605, "_Stoull"                                                                                                                                                                             },
    { 0x0606, "_Stoullx"                                                                                                                                                                            },
    { 0x0607, "_Stoulx"                                                                                                                                                                             },
    { 0x0608, "_Stoxflt"                                                                                                                                                                            },
    { 0x0609, "_Strcoll"                                                                                                                                                                            },
    { 0x060a, "_Strxfrm"                                                                                                                                                                            },
    { 0x060b, "_Thrd_abort"                                                                                                                                                                         },
    { 0x060c, "_Thrd_create"                                                                                                                                                                        },
    { 0x060d, "_Thrd_current"                                                                                                                                                                       },
    { 0x060e, "_Thrd_detach"                                                                                                                                                                        },
    { 0x060f, "_Thrd_equal"                                                                                                                                                                         },
    { 0x0610, "_Thrd_exit"                                                                                                                                                                          },
    { 0x0611, "_Thrd_join"                                                                                                                                                                          },
    { 0x0612, "_Thrd_lt"                                                                                                                                                                            },
    { 0x0613, "_Thrd_sleep"                                                                                                                                                                         },
    { 0x0614, "_Thrd_start"                                                                                                                                                                         },
    { 0x0615, "_Thrd_yield"                                                                                                                                                                         },
    { 0x0616, "_Tolower"                                                                                                                                                                            },
    { 0x0617, "_Toupper"                                                                                                                                                                            },
    { 0x0618, "_Towlower"                                                                                                                                                                           },
    { 0x0619, "_Towupper"                                                                                                                                                                           },
    { 0x061a, "_Tss_create"                                                                                                                                                                         },
    { 0x061b, "_Tss_delete"                                                                                                                                                                         },
    { 0x061c, "_Tss_get"                                                                                                                                                                            },
    { 0x061d, "_Tss_set"                                                                                                                                                                            },
    { 0x061e, "_Unlock_shared_ptr_spin_lock"                                                                                                                                                        },
    { 0x061f, "_Wcrtomb"                                                                                                                                                                            },
    { 0x0620, "_Wcscoll"                                                                                                                                                                            },
    { 0x0621, "_Wcsxfrm"                                                                                                                                                                            },
    { 0x0622, "_Xbig"                                                                                                                                                                               },
    { 0x0623, "_Xp_addh"                                                                                                                                                                            },
    { 0x0624, "_Xp_addx"                                                                                                                                                                            },
    { 0x0625, "_Xp_getw"                                                                                                                                                                            },
    { 0x0626, "_Xp_invx"                                                                                                                                                                            },
    { 0x0627, "_Xp_ldexpx"                                                                                                                                                                          },
    { 0x0628, "_Xp_movx"                                                                                                                                                                            },
    { 0x0629, "_Xp_mulh"                                                                                                                                                                            },
    { 0x062a, "_Xp_mulx"                                                                                                                                                                            },
    { 0x062b, "_Xp_setn"                                                                                                                                                                            },
    { 0x062c, "_Xp_setw"                                                                                                                                                                            },
    { 0x062d, "_Xp_sqrtx"                                                                                                                                                                           },
    { 0x062e, "_Xp_subx"                                                                                                                                                                            },
    { 0x062f, "_Xtime_diff_to_millis"                                                                                                                                                               },
    { 0x0630, "_Xtime_diff_to_millis2"                                                                                                                                                              },
    { 0x0631, "_Xtime_get_ticks"                                                                                                                                                                    },
    { 0x0632, "_Zero"                                                                                                                                                                               },
    { 0x0633, "__Wcrtomb_lk"                                                                                                                                                                        },
    { 0x0634, "towctrans"                                                                                                                                                                           },
    { 0x0635, "wctrans"                                                                                                                                                                             },
    { 0x0636, "wctype"                                                                                                                                                                              },
    { 0x0637, "xtime_get"                                                                                                                                                                           },
};


}
}

#endif

