# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import groups_pb2 as groups__pb2


class GroupsStub(object):
    """A Group is a set of principals.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.Groups/Create',
                request_serializer=groups__pb2.GroupCreateRequest.SerializeToString,
                response_deserializer=groups__pb2.GroupCreateResponse.FromString,
                )
        self.CreateFromRoles = channel.unary_unary(
                '/v1.Groups/CreateFromRoles',
                request_serializer=groups__pb2.GroupCreateFromRolesRequest.SerializeToString,
                response_deserializer=groups__pb2.GroupCreateFromRolesResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.Groups/Get',
                request_serializer=groups__pb2.GroupGetRequest.SerializeToString,
                response_deserializer=groups__pb2.GroupGetResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.Groups/Update',
                request_serializer=groups__pb2.GroupUpdateRequest.SerializeToString,
                response_deserializer=groups__pb2.GroupUpdateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.Groups/Delete',
                request_serializer=groups__pb2.GroupDeleteRequest.SerializeToString,
                response_deserializer=groups__pb2.GroupDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.Groups/List',
                request_serializer=groups__pb2.GroupListRequest.SerializeToString,
                response_deserializer=groups__pb2.GroupListResponse.FromString,
                )


class GroupsServicer(object):
    """A Group is a set of principals.
    """

    def Create(self, request, context):
        """Create registers a new Group.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateFromRoles(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one Group by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update replaces all the fields of a Group by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a Group by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of Groups matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_GroupsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=groups__pb2.GroupCreateRequest.FromString,
                    response_serializer=groups__pb2.GroupCreateResponse.SerializeToString,
            ),
            'CreateFromRoles': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateFromRoles,
                    request_deserializer=groups__pb2.GroupCreateFromRolesRequest.FromString,
                    response_serializer=groups__pb2.GroupCreateFromRolesResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=groups__pb2.GroupGetRequest.FromString,
                    response_serializer=groups__pb2.GroupGetResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=groups__pb2.GroupUpdateRequest.FromString,
                    response_serializer=groups__pb2.GroupUpdateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=groups__pb2.GroupDeleteRequest.FromString,
                    response_serializer=groups__pb2.GroupDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=groups__pb2.GroupListRequest.FromString,
                    response_serializer=groups__pb2.GroupListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.Groups', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Groups(object):
    """A Group is a set of principals.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Groups/Create',
            groups__pb2.GroupCreateRequest.SerializeToString,
            groups__pb2.GroupCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CreateFromRoles(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Groups/CreateFromRoles',
            groups__pb2.GroupCreateFromRolesRequest.SerializeToString,
            groups__pb2.GroupCreateFromRolesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Groups/Get',
            groups__pb2.GroupGetRequest.SerializeToString,
            groups__pb2.GroupGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Groups/Update',
            groups__pb2.GroupUpdateRequest.SerializeToString,
            groups__pb2.GroupUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Groups/Delete',
            groups__pb2.GroupDeleteRequest.SerializeToString,
            groups__pb2.GroupDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Groups/List',
            groups__pb2.GroupListRequest.SerializeToString,
            groups__pb2.GroupListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
