# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import identity_aliases_pb2 as identity__aliases__pb2


class IdentityAliasesStub(object):
    """IdentityAliases assign an alias to an account within an IdentitySet.
    The alias is used as the username when connecting to a identity supported resource.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.IdentityAliases/Create',
                request_serializer=identity__aliases__pb2.IdentityAliasCreateRequest.SerializeToString,
                response_deserializer=identity__aliases__pb2.IdentityAliasCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.IdentityAliases/Get',
                request_serializer=identity__aliases__pb2.IdentityAliasGetRequest.SerializeToString,
                response_deserializer=identity__aliases__pb2.IdentityAliasGetResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.IdentityAliases/Update',
                request_serializer=identity__aliases__pb2.IdentityAliasUpdateRequest.SerializeToString,
                response_deserializer=identity__aliases__pb2.IdentityAliasUpdateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.IdentityAliases/Delete',
                request_serializer=identity__aliases__pb2.IdentityAliasDeleteRequest.SerializeToString,
                response_deserializer=identity__aliases__pb2.IdentityAliasDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.IdentityAliases/List',
                request_serializer=identity__aliases__pb2.IdentityAliasListRequest.SerializeToString,
                response_deserializer=identity__aliases__pb2.IdentityAliasListResponse.FromString,
                )


class IdentityAliasesServicer(object):
    """IdentityAliases assign an alias to an account within an IdentitySet.
    The alias is used as the username when connecting to a identity supported resource.
    """

    def Create(self, request, context):
        """Create registers a new IdentityAlias.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one IdentityAlias by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update replaces all the fields of a IdentityAlias by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a IdentityAlias by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of IdentityAliases matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_IdentityAliasesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=identity__aliases__pb2.IdentityAliasCreateRequest.FromString,
                    response_serializer=identity__aliases__pb2.IdentityAliasCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=identity__aliases__pb2.IdentityAliasGetRequest.FromString,
                    response_serializer=identity__aliases__pb2.IdentityAliasGetResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=identity__aliases__pb2.IdentityAliasUpdateRequest.FromString,
                    response_serializer=identity__aliases__pb2.IdentityAliasUpdateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=identity__aliases__pb2.IdentityAliasDeleteRequest.FromString,
                    response_serializer=identity__aliases__pb2.IdentityAliasDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=identity__aliases__pb2.IdentityAliasListRequest.FromString,
                    response_serializer=identity__aliases__pb2.IdentityAliasListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.IdentityAliases', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class IdentityAliases(object):
    """IdentityAliases assign an alias to an account within an IdentitySet.
    The alias is used as the username when connecting to a identity supported resource.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentityAliases/Create',
            identity__aliases__pb2.IdentityAliasCreateRequest.SerializeToString,
            identity__aliases__pb2.IdentityAliasCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentityAliases/Get',
            identity__aliases__pb2.IdentityAliasGetRequest.SerializeToString,
            identity__aliases__pb2.IdentityAliasGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentityAliases/Update',
            identity__aliases__pb2.IdentityAliasUpdateRequest.SerializeToString,
            identity__aliases__pb2.IdentityAliasUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentityAliases/Delete',
            identity__aliases__pb2.IdentityAliasDeleteRequest.SerializeToString,
            identity__aliases__pb2.IdentityAliasDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.IdentityAliases/List',
            identity__aliases__pb2.IdentityAliasListRequest.SerializeToString,
            identity__aliases__pb2.IdentityAliasListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
