/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PAPropertiesLazyLoader {
    private static Logger logger = Logger.getLogger(PAPropertiesLazyLoader.class);
    private volatile Properties properties = null;
    private String propertiesFileName;
    private String systemPropertyForRelativeFolder;
    private String systemPropertyForFileName;
    private String pathToRelativePropertiesFile;

    public PAPropertiesLazyLoader(String systemPropertyForRelativeFolder, String systemPropertyForFileName, String pathToRelativePropertiesFile) {
        this.systemPropertyForRelativeFolder = systemPropertyForRelativeFolder;
        this.pathToRelativePropertiesFile = pathToRelativePropertiesFile;
        this.systemPropertyForFileName = systemPropertyForFileName;
    }

    public PAPropertiesLazyLoader(String systemPropertyForRelativeFolder, String systemPropertyForFileName, String pathToRelativePropertiesFile, String propertiesFileName) {
        this.systemPropertyForRelativeFolder = systemPropertyForRelativeFolder;
        this.pathToRelativePropertiesFile = pathToRelativePropertiesFile;
        this.propertiesFileName = propertiesFileName;
        this.systemPropertyForFileName = systemPropertyForFileName;
    }

    private InputStream resolvePropertiesFile() throws FileNotFoundException {
        String propertiesPath;
        boolean systemPropertyForFileNameSet = false;
        if (this.propertiesFileName == null) {
            if (System.getProperty(this.systemPropertyForFileName) != null) {
                propertiesPath = System.getProperty(this.systemPropertyForFileName);
                systemPropertyForFileNameSet = true;
            } else {
                propertiesPath = this.pathToRelativePropertiesFile;
            }
        } else {
            propertiesPath = this.propertiesFileName;
        }
        if (!new File(propertiesPath).isAbsolute()) {
            propertiesPath = System.getProperty(this.systemPropertyForRelativeFolder) + File.separator + propertiesPath;
        }
        if (new File(propertiesPath).exists()) {
            logger.debug((Object)("Loading properties from file " + propertiesPath));
            return new FileInputStream(propertiesPath);
        }
        if (systemPropertyForFileNameSet) {
            throw new RuntimeException("Properties file not found : '" + propertiesPath + "'");
        }
        logger.debug((Object)"Loading empty properties");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        Properties result = this.properties;
        if (result == null) {
            PAPropertiesLazyLoader pAPropertiesLazyLoader = this;
            synchronized (pAPropertiesLazyLoader) {
                result = this.properties;
                if (result == null) {
                    this.properties = result = new Properties();
                    try {
                        InputStream stream = this.resolvePropertiesFile();
                        if (stream != null) {
                            this.properties.load(stream);
                            stream.close();
                        }
                        PAPropertiesLazyLoader.updateWithSystemProperties(this.properties);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWithSystemProperties(Properties properties) {
        if (properties != null) {
            Properties properties2 = System.getProperties();
            synchronized (properties2) {
                for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
                    if (property.getValue() == null) continue;
                    properties.setProperty(property.getKey().toString(), property.getValue().toString());
                }
            }
        }
    }
}

