# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# @internal This file was generated by constgen. DO NOT EDIT.


# Permission Levels, shared by all entities capable of making authenticated requests against StrongDM.
class PermissionLevel:
    ROOT_ADMIN = "root-admin"
    ADMIN = "admin"
    DATABASE_ADMIN = "database-admin"
    TEAM_LEADER = "multi-team-leader"
    USER = "user"
    RELAY = "relay"
    ADMIN_TOKEN = "admin-token"
    SCIM_TOKEN = "scim-token"
    SERVICE = "service"
    SUSPENDED = "suspended"
    EMPTY = ""


# Node Lifecycle States, defining whether a node was last reported online, offline, restarting, etc.
class NodeState:
    NEW = "new"
    VERIFYING_RESTART = "verifying_restart"
    AWAITING_RESTART = "awaiting_restart"
    RESTARTING = "restarting"
    STARTED = "started"
    STOPPED = "stopped"
    DEAD = "dead"


# Providers responsible for managing roles and users.
# None, or an empty string, implies the user is managed by strongDM.
class Provider:
    NONE = ""
    OKTA = "okta"
    SAIL_POINT = "sailpoint"
    AZURE = "azure"
    GENERIC = "generic"
    ONE_LOGIN = "onelogin"
    GOOGLE = "google"
