########################################################################
# test/xslt/spec_attribute_set.py
#From the XSLT spec: http://docs.local/REC-xslt-19991116.html#attribute-sets
import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_spec_attribute_set(xslt_test):
    source = stringsource("""<chapter>
              <heading/>
              </chapter>""")
    transform = stringsource("""<xsl:stylesheet
                version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format">

              <xsl:template match="/">
                <doc>
                  <xsl:apply-templates/>
                </doc>
              </xsl:template>

              <xsl:template match="chapter/heading">
                <fo:block quadding="start" xsl:use-attribute-sets="title-style">
                  <xsl:apply-templates/>
                </fo:block>
              </xsl:template>

              <xsl:attribute-set name="title-style">
                <xsl:attribute name="font-size">12pt</xsl:attribute>
                <xsl:attribute name="font-weight">bold</xsl:attribute>
              </xsl:attribute-set>

              </xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<doc xmlns:fo='http://www.w3.org/1999/XSL/Format'>
              <fo:block font-weight='bold' font-size='12pt' quadding='start'/>
              </doc>"""

if __name__ == '__main__':
    test_main()
