########################################################################
# test/xslt/ob_20010518.py
# Oliver Becker <obecker@informatik.hu-berlin.de> wonders about 
# namespace axis conformance

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_namespace_axis_ob_20010518(xslt_test):
    source = stringsource("""\
<el xmlns:prefix="uri1" prefix:att="foo" />""")
    transform = stringsource("""\
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="el">
   <xsl:copy>
      <xsl:copy-of select="@*" />
      <xsl:attribute name="prefix:att2" 
                     namespace="uri2">bar</xsl:attribute>
   </xsl:copy>
</xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """\
<?xml version='1.0' encoding='UTF-8'?>
<el xmlns:org.4suite.4xslt.ns0='uri2' xmlns:prefix='uri1' org.4suite.4xslt.ns0:att2='bar' prefix:att='foo'/>"""

if __name__ == '__main__':
    test_main()

