########################################################################
# test/xslt/ms_20000329.py
# Martin Sevigny's Saxon bug report, 29 Mar 2000

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_saxon_bug_ms_20000329(xslt_test):
    source = stringsource("""<?xml version="1.0" ?>
<Record id='1'>
  <Field No="606">
    <Subfield No="x">Use</Subfield>
  </Field>
</Record>""")
    transform = stringsource("""<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="Record">
    <TestRecord>
      <xsl:apply-templates/>
    </TestRecord>
  </xsl:template>
  <xsl:template match="Field[@No='606']/Subfield[@No='x']">
    <GotAMatch><xsl:apply-templates/></GotAMatch>
  </xsl:template>
</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<TestRecord>
  
    <GotAMatch>Use</GotAMatch>
  
</TestRecord>"""


if __name__ == '__main__':
    test_main()

