########################################################################
# test/xslt/mb_20041215.py
# See thread "xsl:key possible bugs to check out"
# http://lists.fourthought.com/pipermail/4suite/2004-December/006734.html
# http://lists.fourthought.com/pipermail/4suite/2004-December/006741.html

from Xml.Xslt import test_harness

# for SHEET_1 only
SRC_1 = """\
<z:foo xmlns:z="planetz">sometext<bar>moretext</bar></z:foo>"""

# for all stylesheets
SRC_2 = """\
<z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar></z:foo>"""

# With this stylesheet, every node that is a child should have
# a 'foo' key with a value that is the node's string-value.
SHEET_1 = """\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:f="http://xmlns.4suite.org/ext"
  extension-element-prefixes="f">

  <xsl:output method="xml" encoding="us-ascii" indent="yes"/>
  
  <xsl:key name="foo" match="node()" use="."/>

  <xsl:template match="/">
    <f:dump-keys force-update="yes"/>
  </xsl:template>

</xsl:stylesheet>
"""

# With this stylesheet, every element should have
# a 'foo' key with a value that is the node's string-value.
SHEET_2 = """\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:f="http://xmlns.4suite.org/ext"
  extension-element-prefixes="f">

  <xsl:output method="xml" encoding="us-ascii" indent="yes"/>
  
  <xsl:key name="foo" match="*" use="."/>

  <xsl:template match="/">
    <f:dump-keys force-update="yes"/>
  </xsl:template>

</xsl:stylesheet>
"""

# With this stylesheet, every element and every attribute
# should have a 'foo' key with a value that is the node's string-value.
# (So, same as SHEET_2, but with the addition of attributes)
SHEET_3 = """\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:f="http://xmlns.4suite.org/ext"
  extension-element-prefixes="f">

  <xsl:output method="xml" encoding="us-ascii" indent="yes"/>
  
  <xsl:key name="foo" match="@*|*" use="."/>

  <xsl:template match="/">
    <f:dump-keys force-update="yes"/>
  </xsl:template>

</xsl:stylesheet>
"""

# With this stylesheet, every node that is a child should have
# a 'foo' key with a value that is the node's string-value, and
# every element should also have a 'bar' key with the same value.
SHEET_4 = """\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  xmlns:f="http://xmlns.4suite.org/ext"
  extension-element-prefixes="f"
  exclude-result-prefixes="exsl">

  <xsl:output method="xml" encoding="us-ascii" indent="yes"/>
  
  <xsl:key name="foo" match="node()" use="."/>
  <xsl:key name="bar" match="*" use="."/>

  <xsl:template match="/">
    <xsl:variable name="keys">
      <f:dump-keys force-update="yes"/>
    </xsl:variable>
    <zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
      <xsl:for-each select="exsl:node-set($keys)//zz:Key">
        <xsl:sort select="@name"/>
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </zz:KeyDump>
  </xsl:template>

</xsl:stylesheet>
"""

# With this stylesheet, every node that is a child should have
# a 'foo' key with a value that is the node's string-value, and
# every element in the "planetz" namespace should also have a
# 'bar' key with the same value.
SHEET_5 = """\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  xmlns:f="http://xmlns.4suite.org/ext"
  extension-element-prefixes="f"
  exclude-result-prefixes="exsl">

  <xsl:output method="xml" encoding="us-ascii" indent="yes"/>
  
  <xsl:key name="foo" match="node()" use="."/>
  <xsl:key name="bar" match="z:*" use="." xmlns:z="planetz"/>

  <xsl:template match="/">
    <xsl:variable name="keys">
      <f:dump-keys force-update="yes"/>
    </xsl:variable>
    <zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
      <xsl:for-each select="exsl:node-set($keys)//zz:Key">
        <xsl:sort select="@name"/>
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </zz:KeyDump>
  </xsl:template>

</xsl:stylesheet>
"""

# With this stylesheet, every element and every attribute
# should have a 'foo' key with a value that is the node's string-value.
# Every element should also have a 'bar' key with the same value.
SHEET_6 = """\
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  xmlns:f="http://xmlns.4suite.org/ext"
  extension-element-prefixes="f"
  exclude-result-prefixes="exsl">

  <xsl:output method="xml" encoding="us-ascii" indent="yes"/>
  
  <xsl:key name="foo" match="node()|@*" use="."/>
  <xsl:key name="bar" match="*" use="."/>

  <xsl:template match="/">
    <xsl:variable name="keys">
      <f:dump-keys force-update="yes"/>
    </xsl:variable>
    <zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
      <xsl:for-each select="exsl:node-set($keys)//zz:Key">
        <xsl:sort select="@name"/>
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </zz:KeyDump>
  </xsl:template>

</xsl:stylesheet>
"""

EXPECTED_1_1 = """\
<?xml version="1.0" encoding="us-ascii"?>
<zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
  <zz:Key name="foo">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="sometext">sometext</zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>moretext</zz:MatchSet>
  </zz:Key>
</zz:KeyDump>"""

EXPECTED_1_2 = """\
<?xml version="1.0" encoding="us-ascii"?>
<zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
  <zz:Key name="foo">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="sometext">sometext</zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>moretext</zz:MatchSet>
  </zz:Key>
</zz:KeyDump>"""

EXPECTED_2_2 = """\
<?xml version="1.0" encoding="us-ascii"?>
<zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
  <zz:Key name="foo">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>
    </zz:MatchSet>
  </zz:Key>
</zz:KeyDump>"""
    
EXPECTED_3_2 = """\
<?xml version="1.0" encoding="us-ascii"?>
<zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
  <zz:Key name="foo">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="b">
      <!--Attribute: a=b-->
    </zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>
    </zz:MatchSet>
  </zz:Key>
</zz:KeyDump>"""

EXPECTED_4_2 = """\
<?xml version="1.0" encoding="us-ascii"?>
<zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
  <zz:Key name="bar">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>
    </zz:MatchSet>
  </zz:Key>
  <zz:Key name="foo">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="sometext">sometext</zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>moretext</zz:MatchSet>
  </zz:Key>
</zz:KeyDump>"""

EXPECTED_5_2 = """\
<?xml version="1.0" encoding="us-ascii"?>
<zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
  <zz:Key name="bar">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
  </zz:Key>
  <zz:Key name="foo">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="sometext">sometext</zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>moretext</zz:MatchSet>
  </zz:Key>
</zz:KeyDump>"""

EXPECTED_6_2 = """\
<?xml version="1.0" encoding="us-ascii"?>
<zz:KeyDump xmlns:zz="http://xmlns.4suite.org/reserved">
  <zz:Key name="bar">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>
    </zz:MatchSet>
  </zz:Key>
  <zz:Key name="foo">
    <zz:MatchSet value="sometextmoretext">
      <z:foo xmlns:z="planetz" a="b">sometext<bar>moretext</bar>
      </z:foo>
    </zz:MatchSet>
    <zz:MatchSet value="b">
      <!--Attribute: a=b-->
    </zz:MatchSet>
    <zz:MatchSet value="sometext">sometext</zz:MatchSet>
    <zz:MatchSet value="moretext">
      <bar xmlns:z="planetz">moretext</bar>moretext</zz:MatchSet>
  </zz:Key>
</zz:KeyDump>"""


def Test(tester):
    source = test_harness.FileInfo(string=SRC_1)
    sheet = test_harness.FileInfo(string=SHEET_1)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_1_1,
                          title='xsl:key with match="node()", src has no attrs')

    source = test_harness.FileInfo(string=SRC_2)
    sheet = test_harness.FileInfo(string=SHEET_1)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_1_2,
                          title='xsl:key with match="node()"')

    source = test_harness.FileInfo(string=SRC_2)
    sheet = test_harness.FileInfo(string=SHEET_2)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_2_2,
                          title='xsl:key with match="*"')

    source = test_harness.FileInfo(string=SRC_2)
    sheet = test_harness.FileInfo(string=SHEET_3)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_3_2,
                          title='xsl:key with match="@*|*"')

    source = test_harness.FileInfo(string=SRC_2)
    sheet = test_harness.FileInfo(string=SHEET_4)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_4_2,
                          title='xsl:keys with match="node()" and match="*"')

    source = test_harness.FileInfo(string=SRC_2)
    sheet = test_harness.FileInfo(string=SHEET_5)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_5_2,
                          title='xsl:keys with match="node()" and match="z:*"')

    source = test_harness.FileInfo(string=SRC_2)
    sheet = test_harness.FileInfo(string=SHEET_6)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_6_2,
                          title='xsl:keys with match="node()|@*" and match="*"')
    return

