########################################################################
# test/xslt/fn_20000913.py
# Francis Norton's <francis@redrice.com> saxon vs msxml bug query

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_saxon_vs_msxml_fn_20000913(xslt_test):
    source = stringsource("""<xw:wrapper
xmlns:xw='http://www.workspot.net/~roundand/xml/xwrapper.xsd'>
  <itemStatus>
    <status>REFER</status>
    <applicationId>CCUK000000000604</applicationId>
  </itemStatus>
</xw:wrapper>""")
    transform = stringsource("""<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output method="xml" indent="yes"/>

  <!-- take a wrapper with a header and an appStatus -->
  <xsl:template match="/">
    <header>
      <status><xsl:value-of select="//status"/></status>
      <!-- now the rest of the simple itemStatus elements -->
      <xsl:apply-templates select="*"/>
    </header>
  </xsl:template>

  <!-- kill the itemStatus/status since we've already output it -->
  <xsl:template match="status" />
  <xsl:template match="itemStatus/status" priority="1.0"/>

  <!-- and generate "attribute" elements with the rest... -->
  <xsl:template match="itemStatus/*">
    <attribute name="{name(.)}"><xsl:value-of
select="text()"/></attribute>
  </xsl:template>

</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<header>
  <status>REFER</status>
  
    
    <attribute name='applicationId'>CCUK000000000604</attribute>
  
</header>"""

if __name__ == '__main__':
    test_main()
