########################################################################
# test/xslt/em_20010101.py
# edmund mitchell <edmund_mitchell@hotmail.com> having trouble with 
# call-template

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_call_template_em_20010101(xslt_test):
    source = stringsource("""<?xml version="1.0"?>
<outer>
        <inner>
                <deep att='value' att2='val2'>
                my goodness
                </deep>
        </inner>
</outer>""")
    transform = stringsource("""<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
version='1.0'>

<xsl:template name="pad">
    <xsl:param name="String"/>
    <xsl:param name="length"/>
    <xsl:variable name="spaces"
                  select="'                                      '"/>
    <xsl:value-of select="substring(concat($String,$spaces),1,$length)"/>
</xsl:template>

<xsl:variable name="stuff">
  <xsl:call-template name="pad">
    <xsl:with-param name="String" select="/outer/inner/deep/@att2"/>
    <xsl:with-param name="length" select="15"/>
  </xsl:call-template>
</xsl:variable>

<xsl:template match='/'>
        <xsl:value-of select="$stuff"/>
</xsl:template>

</xsl:stylesheet>
""")
    parameters = {}
    expected = """<?xml version="1.0" encoding="UTF-8"?>\012val2           """

if __name__ == '__main__':
    test_main()


    
