# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import activities_pb2 as activities__pb2


class ActivitiesStub(object):
    """An Activity is a record of an action taken against a strongDM deployment, e.g.
    a user creation, resource deletion, sso configuration change, etc. The Activities
    service is read-only.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Get = channel.unary_unary(
                '/v1.Activities/Get',
                request_serializer=activities__pb2.ActivityGetRequest.SerializeToString,
                response_deserializer=activities__pb2.ActivityGetResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.Activities/List',
                request_serializer=activities__pb2.ActivityListRequest.SerializeToString,
                response_deserializer=activities__pb2.ActivityListResponse.FromString,
                )


class ActivitiesServicer(object):
    """An Activity is a record of an action taken against a strongDM deployment, e.g.
    a user creation, resource deletion, sso configuration change, etc. The Activities
    service is read-only.
    """

    def Get(self, request, context):
        """Get reads one Activity by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of Activities matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ActivitiesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=activities__pb2.ActivityGetRequest.FromString,
                    response_serializer=activities__pb2.ActivityGetResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=activities__pb2.ActivityListRequest.FromString,
                    response_serializer=activities__pb2.ActivityListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.Activities', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Activities(object):
    """An Activity is a record of an action taken against a strongDM deployment, e.g.
    a user creation, resource deletion, sso configuration change, etc. The Activities
    service is read-only.
    """

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Activities/Get',
            activities__pb2.ActivityGetRequest.SerializeToString,
            activities__pb2.ActivityGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Activities/List',
            activities__pb2.ActivityListRequest.SerializeToString,
            activities__pb2.ActivityListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
