# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2018, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

TABLES = {
    'HL70001': ('Administrative Sex',
                ('A',
                 'F',
                 'M',
                 'N',
                 'O',
                 'U')),
    'HL70002': ('Marital Status',
                ('A',
                 'B',
                 'C',
                 'D',
                 'E',
                 'G',
                 'I',
                 'M',
                 'N',
                 'O',
                 'P',
                 'R',
                 'S',
                 'T',
                 'U',
                 'W')),
    'HL70003': ('Event Type',
                ('A01',
                 'A02',
                 'A03',
                 'A04',
                 'A05',
                 'A06',
                 'A07',
                 'A08',
                 'A09',
                 'A10',
                 'A11',
                 'A12',
                 'A13',
                 'A14',
                 'A15',
                 'A16',
                 'A17',
                 'A18',
                 'A19',
                 'A20',
                 'A21',
                 'A22',
                 'A23',
                 'A24',
                 'A25',
                 'A26',
                 'A27',
                 'A28',
                 'A29',
                 'A30',
                 'A31',
                 'A32',
                 'A33',
                 'A34',
                 'A35',
                 'A36',
                 'A37',
                 'A38',
                 'A39',
                 'A40',
                 'A41',
                 'A42',
                 'A43',
                 'A44',
                 'A45',
                 'A46',
                 'A47',
                 'A48',
                 'A49',
                 'A50',
                 'A51',
                 'A52',
                 'A53',
                 'A54',
                 'A55',
                 'A60',
                 'A61',
                 'A62',
                 'B01',
                 'B02',
                 'B03',
                 'B04',
                 'B05',
                 'B06',
                 'B07',
                 'B08',
                 'C01',
                 'C02',
                 'C03',
                 'C04',
                 'C05',
                 'C06',
                 'C07',
                 'C08',
                 'C09',
                 'C10',
                 'C11',
                 'C12',
                 'E01',
                 'E02',
                 'E03',
                 'E04',
                 'E10',
                 'E12',
                 'E13',
                 'E15',
                 'E20',
                 'E21',
                 'E22',
                 'E24',
                 'E30',
                 'E31',
                 'I01',
                 'I02',
                 'I03',
                 'I04',
                 'I05',
                 'I06',
                 'I07',
                 'I08',
                 'I09',
                 'I10',
                 'I11',
                 'I12',
                 'I13',
                 'I14',
                 'I15',
                 'I16',
                 'I17',
                 'I18',
                 'I19',
                 'I20',
                 'I21',
                 'I22',
                 'J01',
                 'J02',
                 'K11',
                 'K13',
                 'K15',
                 'K21',
                 'K22',
                 'K23',
                 'K24',
                 'K25',
                 'K31',
                 'K32',
                 'K33',
                 'K34',
                 'M01',
                 'M02',
                 'M03',
                 'M04',
                 'M05',
                 'M06',
                 'M07',
                 'M08',
                 'M09',
                 'M10',
                 'M11',
                 'M12',
                 'M13',
                 'M14',
                 'M15',
                 'M16',
                 'M17',
                 'M18',
                 'N01',
                 'N02',
                 'O01',
                 'O02',
                 'O03',
                 'O04',
                 'O05',
                 'O06',
                 'O07',
                 'O08',
                 'O09',
                 'O10',
                 'O11',
                 'O12',
                 'O13',
                 'O14',
                 'O15',
                 'O16',
                 'O17',
                 'O18',
                 'O19',
                 'O20',
                 'O21',
                 'O22',
                 'O23',
                 'O24',
                 'O25',
                 'O26',
                 'O27',
                 'O28',
                 'O29',
                 'O30',
                 'O31',
                 'O32',
                 'O33',
                 'O34',
                 'O35',
                 'O36',
                 'O37',
                 'O38',
                 'O39',
                 'O40',
                 'O41',
                 'O42',
                 'O43',
                 'O44',
                 'O45',
                 'O46',
                 'O47',
                 'O48',
                 'P01',
                 'P02',
                 'P03',
                 'P04',
                 'P05',
                 'P06',
                 'P07',
                 'P08',
                 'P09',
                 'P10',
                 'P11',
                 'P12',
                 'PC1',
                 'PC2',
                 'PC3',
                 'PC4',
                 'PC5',
                 'PC6',
                 'PC7',
                 'PC8',
                 'PC9',
                 'PCA',
                 'PCB',
                 'PCC',
                 'PCD',
                 'PCE',
                 'PCF',
                 'PCG',
                 'PCH',
                 'PCJ',
                 'PCK',
                 'PCL',
                 'Q01',
                 'Q02',
                 'Q03',
                 'Q05',
                 'Q06',
                 'Q11',
                 'Q13',
                 'Q15',
                 'Q16',
                 'Q17',
                 'Q21',
                 'Q22',
                 'Q23',
                 'Q24',
                 'Q25',
                 'Q26',
                 'Q27',
                 'Q28',
                 'Q29',
                 'Q30',
                 'Q31',
                 'Q32',
                 'Q33',
                 'Q34',
                 'R01',
                 'R02',
                 'R04',
                 'R21',
                 'R22',
                 'R23',
                 'R24',
                 'R25',
                 'R26',
                 'R30',
                 'R31',
                 'R32',
                 'R33',
                 'R40',
                 'R41',
                 'ROR',
                 'S01',
                 'S02',
                 'S03',
                 'S04',
                 'S05',
                 'S06',
                 'S07',
                 'S08',
                 'S09',
                 'S10',
                 'S11',
                 'S12',
                 'S13',
                 'S14',
                 'S15',
                 'S16',
                 'S17',
                 'S18',
                 'S19',
                 'S20',
                 'S21',
                 'S22',
                 'S23',
                 'S24',
                 'S25',
                 'S26',
                 'S27',
                 'S28',
                 'S29',
                 'S30',
                 'S31',
                 'S32',
                 'S33',
                 'S34',
                 'S35',
                 'S36',
                 'S37',
                 'T01',
                 'T02',
                 'T03',
                 'T04',
                 'T05',
                 'T06',
                 'T07',
                 'T08',
                 'T09',
                 'T10',
                 'T11',
                 'T12',
                 'U01',
                 'U02',
                 'U03',
                 'U04',
                 'U05',
                 'U06',
                 'U07',
                 'U08',
                 'U09',
                 'U10',
                 'U11',
                 'U12',
                 'U13',
                 'V01',
                 'V02',
                 'V03',
                 'V04',
                 'Varies',
                 'W01',
                 'W02')),
    'HL70004': ('Patient Class',
                ('B',
                 'C',
                 'E',
                 'I',
                 'N',
                 'O',
                 'P',
                 'R',
                 'U')),
    'HL70005': ('Race',
                ('1002-5',
                 '2028-9',
                 '2054-5',
                 '2076-8',
                 '2106-3',
                 '2131-1')),
    'HL70006': ('Religion',
                ('ABC',
                 'AGN',
                 'AME',
                 'AMT',
                 'ANG',
                 'AOG',
                 'ATH',
                 'BAH',
                 'BAP',
                 'BMA',
                 'BOT',
                 'BRE',
                 'BTA',
                 'BTH',
                 'BUD',
                 'CAT',
                 'CFR',
                 'CHR',
                 'CHS',
                 'CMA',
                 'CNF',
                 'COC',
                 'COG',
                 'COI',
                 'COL',
                 'COM',
                 'COP',
                 'COT',
                 'CRR',
                 'DOC',
                 'EOT',
                 'EPI',
                 'ERL',
                 'EVC',
                 'FRQ',
                 'FUL',
                 'FWB',
                 'GRE',
                 'HIN',
                 'HOT',
                 'HSH',
                 'HVA',
                 'JAI',
                 'JCO',
                 'JEW',
                 'JOR',
                 'JOT',
                 'JRC',
                 'JRF',
                 'JRN',
                 'JWN',
                 'LMS',
                 'LUT',
                 'MEN',
                 'MET',
                 'MOM',
                 'MOS',
                 'MOT',
                 'MSH',
                 'MSU',
                 'NAM',
                 'NAZ',
                 'NOE',
                 'NRL',
                 'ORT',
                 'OTH',
                 'PEN',
                 'PRC',
                 'PRE',
                 'PRO',
                 'REC',
                 'REO',
                 'SAA',
                 'SEV',
                 'SHN',
                 'SIK',
                 'SOU',
                 'SPI',
                 'UCC',
                 'UMD',
                 'UNI',
                 'UNU',
                 'VAR',
                 'WES',
                 'WMC')),
    'HL70007': ('Admission Type',
                ('A',
                 'C',
                 'E',
                 'L',
                 'N',
                 'R',
                 'U')),
    'HL70008': ('Acknowledgment Code',
                ('AA',
                 'AE',
                 'AR',
                 'CA',
                 'CE',
                 'CR')),
    'HL70009': ('Ambulatory Status',
                ('A0',
                 'A1',
                 'A2',
                 'A3',
                 'A4',
                 'A5',
                 'A6',
                 'A7',
                 'A8',
                 'A9',
                 'B1',
                 'B2',
                 'B3',
                 'B4',
                 'B5',
                 'B6')),
    'HL70010': ('Physician ID',
                ()),
    'HL70017': ('Transaction Type',
                ('AJ',
                 'CD',
                 'CG',
                 'CO',
                 'PY')),
    'HL70018': ('Patient Type',
                ()),
    'HL70019': ('Anesthesia Code',
                ()),
    'HL70021': ('Bad Debt Agency Code',
                ()),
    'HL70022': ('Billing Status',
                ()),
    'HL70023': ('Admit Source',
                ()),
    'HL70024': ('Fee Schedule',
                ()),
    'HL70027': ('Priority',
                ('A',
                 'P',
                 'R',
                 'S',
                 'T')),
    'HL70032': ('Charge/Price Indicator',
                ()),
    'HL70038': ('Order status',
                ('A',
                 'CA',
                 'CM',
                 'DC',
                 'ER',
                 'HD',
                 'IP',
                 'RP',
                 'SC')),
    'HL70042': ('Company Plan Code',
                ()),
    'HL70043': ('Condition Code',
                ()),
    'HL70044': ('Contract Code',
                ()),
    'HL70045': ('Courtesy Code',
                ()),
    'HL70046': ('Credit Rating',
                ()),
    'HL70049': ('Department Code',
                ()),
    'HL70050': ('Accident Code',
                ()),
    'HL70051': ('Diagnosis Code',
                ()),
    'HL70052': ('Diagnosis Type',
                ('A',
                 'F',
                 'W')),
    'HL70055': ('Diagnosis Related Group',
                ()),
    'HL70056': ('DRG Grouper Review Code',
                ()),
    'HL70059': ('Consent Code',
                ()),
    'HL70061': ('Check Digit Scheme',
                ('BCV',
                 'ISO',
                 'M10',
                 'M11',
                 'NPI')),
    'HL70062': ('Event Reason',
                ('1',
                 '2',
                 '3',
                 'O',
                 'U')),
    'HL70063': ('Relationship',
                ('ASC',
                 'BRO',
                 'CGV',
                 'CHD',
                 'DEP',
                 'DOM',
                 'EMC',
                 'EME',
                 'EMR',
                 'EXF',
                 'FCH',
                 'FND',
                 'FTH',
                 'GCH',
                 'GRD',
                 'GRP',
                 'MGR',
                 'MTH',
                 'NCH',
                 'NON',
                 'OAD',
                 'OTH',
                 'OWN',
                 'PAR',
                 'SCH',
                 'SEL',
                 'SIB',
                 'SIS',
                 'SPO',
                 'TRA',
                 'UNK',
                 'WRD')),
    'HL70064': ('Financial Class',
                ()),
    'HL70065': ('Specimen Action Code',
                ('A',
                 'G',
                 'L',
                 'O',
                 'P',
                 'R',
                 'S')),
    'HL70066': ('Employment Status',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '9',
                 'C',
                 'L',
                 'O',
                 'T')),
    'HL70068': ('Guarantor Type',
                ()),
    'HL70069': ('Hospital Service',
                ('CAR',
                 'MED',
                 'PUL',
                 'SUR',
                 'URO')),
    'HL70072': ('Insurance Plan ID',
                ()),
    'HL70073': ('Interest Rate Code',
                ()),
    'HL70074': ('Diagnostic Service Section ID',
                ('AU',
                 'BG',
                 'BLB',
                 'CG',
                 'CH',
                 'CP',
                 'CT',
                 'CTH',
                 'CUS',
                 'EC',
                 'EN',
                 'GE',
                 'HM',
                 'ICU',
                 'IMM',
                 'LAB',
                 'MB',
                 'MCB',
                 'MYC',
                 'NMR',
                 'NMS',
                 'NRS',
                 'OSL',
                 'OT',
                 'OTH',
                 'OUS',
                 'PF',
                 'PHR',
                 'PHY',
                 'PT',
                 'RAD',
                 'RC',
                 'RT',
                 'RUS',
                 'RX',
                 'SP',
                 'SR',
                 'TX',
                 'VR',
                 'VUS',
                 'XRC')),
    'HL70076': ('Message Type',
                ('ACK',
                 'ADR',
                 'ADT',
                 'BAR',
                 'BPS',
                 'BRP',
                 'BRT',
                 'BTS',
                 'CCF',
                 'CCI',
                 'CCM',
                 'CCQ',
                 'CCU',
                 'CQU',
                 'CRM',
                 'CSU',
                 'DBC',
                 'DBU',
                 'DEL',
                 'DEO',
                 'DER',
                 'DFT',
                 'DOC',
                 'DPR',
                 'DRC',
                 'DSR',
                 'EAC',
                 'EAN',
                 'EAR',
                 'EHC',
                 'ESR',
                 'ESU',
                 'INR',
                 'INU',
                 'LSR',
                 'LSU',
                 'MDM',
                 'MFD',
                 'MFK',
                 'MFN',
                 'MFQ',
                 'MFR',
                 'NMD',
                 'NMQ',
                 'NMR',
                 'OMB',
                 'OMD',
                 'OMG',
                 'OMI',
                 'OML',
                 'OMN',
                 'OMP',
                 'OMQ',
                 'OMS',
                 'OPL',
                 'OPR',
                 'OPU',
                 'ORA',
                 'ORB',
                 'ORD',
                 'ORF',
                 'ORG',
                 'ORI',
                 'ORL',
                 'ORM',
                 'ORN',
                 'ORP',
                 'ORR',
                 'ORS',
                 'ORU',
                 'ORX',
                 'OSM',
                 'OSQ',
                 'OSR',
                 'OSU',
                 'OUL',
                 'PEX',
                 'PGL',
                 'PIN',
                 'PMU',
                 'PPG',
                 'PPP',
                 'PPR',
                 'PPT',
                 'PPV',
                 'PRR',
                 'PTR',
                 'QBP',
                 'QCK',
                 'QCN',
                 'QRY',
                 'QSB',
                 'QSX',
                 'QVR',
                 'RAR',
                 'RAS',
                 'RCI',
                 'RCL',
                 'RDE',
                 'RDR',
                 'RDS',
                 'RDY',
                 'REF',
                 'RER',
                 'RGR',
                 'RGV',
                 'ROR',
                 'RPA',
                 'RPI',
                 'RPL',
                 'RPR',
                 'RQA',
                 'RQC',
                 'RQI',
                 'RQP',
                 'RRA',
                 'RRD',
                 'RRE',
                 'RRG',
                 'RRI',
                 'RSP',
                 'RTB',
                 'SCN',
                 'SDN',
                 'SDR',
                 'SIU',
                 'SLN',
                 'SLR',
                 'SMD',
                 'SQM',
                 'SQR',
                 'SRM',
                 'SRR',
                 'SSR',
                 'SSU',
                 'STC',
                 'STI',
                 'SUR',
                 'TBR',
                 'TCR',
                 'TCU',
                 'UDM',
                 'VXQ',
                 'VXR',
                 'VXU',
                 'VXX')),
    'HL70078': ('Interpretation Codes',
                ('<',
                 '>',
                 'A',
                 'AA',
                 'AC',
                 'B',
                 'D',
                 'DET',
                 'H',
                 'HH',
                 'HM',
                 'HU',
                 'I',
                 'IE',
                 'IND',
                 'L',
                 'LL',
                 'LU',
                 'MS',
                 'N',
                 'ND',
                 'NEG',
                 'NR',
                 'NS',
                 'null',
                 'OBX',
                 'POS',
                 'QCF',
                 'R',
                 'RR',
                 'S',
                 'SDD',
                 'SYN-R',
                 'SYN-S',
                 'TOX',
                 'U',
                 'VS',
                 'W',
                 'WR')),
    'HL70080': ('Nature of Abnormal Testing',
                ('A',
                 'B',
                 'N',
                 'R',
                 'S',
                 'SP',
                 'ST')),
    'HL70083': ('Outlier Type',
                ('C',
                 'D')),
    'HL70084': ('Performed by',
                ()),
    'HL70085': ('Observation Result Status Codes Interpretation',
                ('A',
                 'B',
                 'C',
                 'D',
                 'F',
                 'I',
                 'N',
                 'O',
                 'P',
                 'R',
                 'S',
                 'U',
                 'V',
                 'W',
                 'X')),
    'HL70086': ('Plan ID',
                ()),
    'HL70087': ('Pre-Admit Test Indicator',
                ()),
    'HL70088': ('Procedure Code',
                ()),
    'HL70091': ('Query Priority',
                ('D',
                 'I')),
    'HL70092': ('Re-Admission Indicator',
                ('R',)),
    'HL70093': ('Release Information',
                ('...',
                 'N',
                 'Y')),
    'HL70098': ('Type of Agreement',
                ('M',
                 'S',
                 'U')),
    'HL70099': ('VIP Indicator',
                ()),
    'HL70100': ('Invocation event',
                ('D',
                 'O',
                 'R',
                 'S',
                 'T')),
    'HL70103': ('Processing ID',
                ('D',
                 'P',
                 'T')),
    'HL70104': ('Version ID',
                ('2',
                 '2.0D',
                 '2.1',
                 '2.2',
                 '2.3',
                 '2.3.1',
                 '2.4',
                 '2.5',
                 '2.5.1',
                 '2.6',
                 '2.7',
                 '2.7.1',
                 '2.8',
                 '2.8.1')),
    'HL70105': ('Source of Comment',
                ('L',
                 'O',
                 'P')),
    'HL70110': ('Transfer to Bad Debt Code',
                ()),
    'HL70111': ('Delete Account Code',
                ()),
    'HL70112': ('Discharge Disposition',
                ()),
    'HL70113': ('Discharged to Location',
                ()),
    'HL70114': ('Diet Type',
                ()),
    'HL70115': ('Servicing Facilities',
                ()),
    'HL70116': ('Bed Status',
                ('C',
                 'H',
                 'I',
                 'K',
                 'O',
                 'U')),
    'HL70117': ('Account Status',
                ()),
    'HL70118': ('Major Diagnostic Category',
                ()),
    'HL70119': ('Order Control Codes',
                ('AF',
                 'CA',
                 'CH',
                 'CN',
                 'CP',
                 'CR',
                 'DC',
                 'DE',
                 'DF',
                 'DR',
                 'FU',
                 'HD',
                 'HR',
                 'LI',
                 'MC',
                 'NA',
                 'NW',
                 'OC',
                 'OD',
                 'OE',
                 'OF',
                 'OH',
                 'OK',
                 'OP',
                 'OR',
                 'PA',
                 'PR',
                 'PY',
                 'RE',
                 'RF',
                 'RL',
                 'RO',
                 'RP',
                 'RQ',
                 'RR',
                 'RU',
                 'SC',
                 'SN',
                 'SR',
                 'SS',
                 'UA',
                 'UC',
                 'UD',
                 'UF',
                 'UH',
                 'UM',
                 'UN',
                 'UR',
                 'UX',
                 'XO',
                 'XR',
                 'XX')),
    'HL70121': ('Response Flag',
                ('D',
                 'E',
                 'F',
                 'N',
                 'R')),
    'HL70122': ('Charge Type',
                ('CH',
                 'CO',
                 'CR',
                 'DP',
                 'GR',
                 'NC',
                 'PC',
                 'RS')),
    'HL70123': ('Result Status',
                ('A',
                 'C',
                 'F',
                 'I',
                 'O',
                 'P',
                 'R',
                 'S',
                 'X',
                 'Y',
                 'Z')),
    'HL70124': ('Transportation Mode',
                ('CART',
                 'PORT',
                 'WALK',
                 'WHLC')),
    'HL70125': ('Value Type',
                ('...',
                 'AUI',
                 'CCD',
                 'CCP',
                 'CD',
                 'CF',
                 'CNE',
                 'CNN',
                 'CP',
                 'CSU',
                 'CWE',
                 'CX',
                 'DDI',
                 'DIN',
                 'DLD',
                 'DLN',
                 'DLT',
                 'DR',
                 'DT',
                 'DTM',
                 'DTN',
                 'ED',
                 'EI',
                 'EIP',
                 'ERL',
                 'FC',
                 'FT',
                 'GTS',
                 'HD',
                 'ICD',
                 'IS',
                 'JCC',
                 'LA1',
                 'LA2',
                 'MA',
                 'MO',
                 'MOC',
                 'MOP',
                 'MSG',
                 'NA',
                 'NDL',
                 'NM',
                 'NR',
                 'OCD',
                 'OSP',
                 'PIP',
                 'PL',
                 'PLN',
                 'PPN',
                 'PRL',
                 'PT',
                 'PTA',
                 'QIP',
                 'QSC',
                 'RCD',
                 'RFR',
                 'RI',
                 'RMC',
                 'RP',
                 'RPT',
                 'SCV',
                 'SN',
                 'SNM',
                 'SPD',
                 'SRT',
                 'ST',
                 'TM',
                 'TX',
                 'UVC',
                 'VH',
                 'VID',
                 'VR',
                 'WVI',
                 'WVS',
                 'XAD',
                 'XCN',
                 'XON',
                 'XPN',
                 'XTN')),
    'HL70126': ('Quantity Limited Request',
                ('CH',
                 'LI',
                 'PG',
                 'RD',
                 'ZO')),
    'HL70127': ('Allergen Type',
                ('AA',
                 'DA',
                 'EA',
                 'FA',
                 'LA',
                 'MA',
                 'MC',
                 'PA')),
    'HL70128': ('Allergy Severity',
                ('MI',
                 'MO',
                 'SV',
                 'U')),
    'HL70129': ('Accommodation Code',
                ()),
    'HL70130': ('Visit User Code',
                ('HO',
                 'MO',
                 'PH',
                 'TE')),
    'HL70131': ('Contact Role',
                ('C',
                 'E',
                 'F',
                 'I',
                 'N',
                 'O',
                 'S',
                 'U')),
    'HL70132': ('Transaction Code',
                ()),
    'HL70135': ('Assignment of Benefits',
                ('M',
                 'N',
                 'Y')),
    'HL70136': ('Yes/no Indicator',
                ('N',
                 'Y')),
    'HL70137': ('Mail Claim Party',
                ('E',
                 'G',
                 'I',
                 'O',
                 'P')),
    'HL70139': ('Employer Information Data',
                ()),
    'HL70140': ('Military Service',
                ('AUSA',
                 'AUSAF',
                 'AUSN',
                 'NATO',
                 'NOAA',
                 'USA',
                 'USAF',
                 'USCG',
                 'USMC',
                 'USN',
                 'USPHS')),
    'HL70141': ('Military Rank/Grade',
                ('E1... E9',
                 'O1 ... O9',
                 'W1 ... W4')),
    'HL70142': ('Military Status',
                ('ACT',
                 'DEC',
                 'RET')),
    'HL70143': ('Non-covered Insurance Code',
                ()),
    'HL70144': ('Eligibility Source',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7')),
    'HL70145': ('Room Type',
                ('2ICU',
                 '2PRI',
                 '2SPR',
                 'ICU',
                 'PRI',
                 'SPR')),
    'HL70146': ('Amount Type',
                ('DF',
                 'LM',
                 'PC',
                 'RT',
                 'UL')),
    'HL70147': ('Policy Type',
                ('2ANC',
                 '2MMD',
                 '3MMD',
                 'ANC',
                 'MMD')),
    'HL70148': ('Money or Percentage Indicator',
                ('AT',
                 'PC')),
    'HL70149': ('Day Type',
                ('AP',
                 'DE',
                 'PE')),
    'HL70150': ('Certification Patient Type',
                ('ER',
                 'IPE',
                 'OPE',
                 'UR')),
    'HL70151': ('Second Opinion Status',
                ()),
    'HL70152': ('Second Opinion Documentation Received',
                ()),
    'HL70153': ('Value Code',
                ()),
    'HL70155': ('Accept/Application Acknowledgment Conditions',
                ('AL',
                 'ER',
                 'NE',
                 'SU')),
    'HL70159': ('Diet Code Specification Type',
                ('D',
                 'P',
                 'S')),
    'HL70160': ('Tray Type',
                ('EARLY',
                 'GUEST',
                 'LATE',
                 'MSG',
                 'NO')),
    'HL70161': ('Allow Substitution',
                ('G',
                 'N',
                 'T')),
    'HL70162': ('Route of Administration',
                ('AP',
                 'B',
                 'DT',
                 'EP',
                 'ET',
                 'GTT',
                 'GU',
                 'IA',
                 'IB',
                 'IC',
                 'ICV',
                 'ID',
                 'IH',
                 'IHA',
                 'IM',
                 'IMR',
                 'IN',
                 'IO',
                 'IP',
                 'IS',
                 'IT',
                 'IU',
                 'IV',
                 'MM',
                 'MTH',
                 'NG',
                 'NP',
                 'NS',
                 'NT',
                 'OP',
                 'OT',
                 'OTH',
                 'PF',
                 'PO',
                 'PR',
                 'RM',
                 'SC',
                 'SD',
                 'SL',
                 'TD',
                 'TL',
                 'TP',
                 'TRA',
                 'UR',
                 'VG',
                 'VM',
                 'WND')),
    'HL70163': ('Body Site',
                ('BE',
                 'BN',
                 'BU',
                 'CT',
                 'LA',
                 'LAC',
                 'LACF',
                 'LD',
                 'LE',
                 'LEJ',
                 'LF',
                 'LG',
                 'LH',
                 'LIJ',
                 'LLAQ',
                 'LLFA',
                 'LMFA',
                 'LN',
                 'LPC',
                 'LSC',
                 'LT',
                 'LUA',
                 'LUAQ',
                 'LUFA',
                 'LVG',
                 'LVL',
                 'NB',
                 'OD',
                 'OS',
                 'OU',
                 'PA',
                 'PERIN',
                 'RA',
                 'RAC',
                 'RACF',
                 'RD',
                 'RE',
                 'REJ',
                 'RF',
                 'RG',
                 'RH',
                 'RIJ',
                 'RLAQ',
                 'RLFA',
                 'RMFA',
                 'RN',
                 'RPC',
                 'RSC',
                 'RT',
                 'RUA',
                 'RUAQ',
                 'RUFA',
                 'RVG',
                 'RVL')),
    'HL70164': ('Administration Device',
                ('AP',
                 'BT',
                 'HL',
                 'IPPB',
                 'IVP',
                 'IVS',
                 'MI',
                 'NEB',
                 'PCA')),
    'HL70165': ('Administration Method',
                ('CH',
                 'DI',
                 'DU',
                 'IF',
                 'IR',
                 'IS',
                 'IVP',
                 'IVPB',
                 'NB',
                 'PF',
                 'PT',
                 'SH',
                 'SO',
                 'WA',
                 'WI')),
    'HL70166': ('RX Component Type',
                ('A',
                 'B')),
    'HL70167': ('Substitution Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '7',
                 '8',
                 'G',
                 'N',
                 'T')),
    'HL70168': ('Processing Priority',
                ('A',
                 'B',
                 'C',
                 'P',
                 'R',
                 'S',
                 'T')),
    'HL70169': ('Reporting Priority',
                ('C',
                 'R')),
    'HL70170': ('Derived Specimen',
                ('C',
                 'N',
                 'P')),
    'HL70171': ('Citizenship',
                ()),
    'HL70172': ('Veterans Military Status',
                ()),
    'HL70173': ('Coordination of Benefits',
                ('CO',
                 'IN')),
    'HL70174': ('Nature of Service/Test/Observation',
                ('A',
                 'C',
                 'F',
                 'P',
                 'S')),
    'HL70175': ('Master File Identifier Code',
                ('CDM',
                 'CLN',
                 'CMA',
                 'CMB',
                 'INV',
                 'LOC',
                 'MACP',
                 'MLCP',
                 'OMA',
                 'OMB',
                 'OMC',
                 'OMD',
                 'OME',
                 'OMM',
                 'PRA',
                 'STF')),
    'HL70177': ('Confidentiality Code',
                ('AID',
                 'EMP',
                 'ETH',
                 'HIV',
                 'PSY',
                 'R',
                 'U',
                 'UWM',
                 'V',
                 'VIP')),
    'HL70178': ('File Level Event Code',
                ('REP',
                 'UPD')),
    'HL70179': ('Response Level',
                ('AL',
                 'ER',
                 'NE',
                 'SU')),
    'HL70180': ('Record-level Event Code',
                ('MAC',
                 'MAD',
                 'MDC',
                 'MDL',
                 'MUP')),
    'HL70181': ('MFN Record-level Error Return',
                ('S',
                 'U')),
    'HL70182': ('Staff type',
                ()),
    'HL70183': ('Active/Inactive',
                ('A',
                 'I')),
    'HL70184': ('Department',
                ()),
    'HL70185': ('Preferred Method of Contact',
                ('B',
                 'C',
                 'E',
                 'F',
                 'H',
                 'O')),
    'HL70186': ('Practitioner Category',
                ()),
    'HL70187': ('Provider Billing',
                ('I',
                 'P')),
    'HL70188': ('Operator ID',
                ()),
    'HL70189': ('Ethnic Group',
                ('H',
                 'N',
                 'U')),
    'HL70190': ('Address Type',
                ('B',
                 'BA',
                 'BDL',
                 'BI',
                 'BR',
                 'C',
                 'F',
                 'H',
                 'L',
                 'M',
                 'N',
                 'O',
                 'P',
                 'RH',
                 'S',
                 'SH',
                 'TM',
                 'V')),
    'HL70191': ('Type of Referenced Data',
                ('AP',
                 'AU',
                 'FT',
                 'IM',
                 'multipart',
                 'NS',
                 'SD',
                 'SI',
                 'TEXT',
                 'TX')),
    'HL70193': ('Amount Class',
                ('AT',
                 'LM',
                 'PC',
                 'UL')),
    'HL70200': ('Name Type',
                ('...',
                 'A',
                 'B',
                 'BAD',
                 'C',
                 'D',
                 'F',
                 'I',
                 'K',
                 'L',
                 'M',
                 'MSK',
                 'N',
                 'NAV',
                 'NB',
                 'NOUSE',
                 'P',
                 'R',
                 'REL',
                 'S',
                 'T',
                 'TEMP',
                 'U')),
    'HL70201': ('Telecommunication Use Code',
                ('ASN',
                 'BPN',
                 'EMR',
                 'NET',
                 'ORN',
                 'PRN',
                 'PRS',
                 'VHN',
                 'WPN')),
    'HL70202': ('Telecommunication Equipment Type',
                ('BP',
                 'CP',
                 'FX',
                 'Internet',
                 'MD',
                 'PH',
                 'SAT',
                 'TDD',
                 'TTY',
                 'X.400')),
    'HL70203': ('Identifier Type',
                ('ACSN',
                 'AM',
                 'AMA',
                 'AN',
                 'An Identifier for a provider a',
                 'An identifier for a provider r',
                 'ANC',
                 'AND',
                 'ANON',
                 'ANT',
                 'APRN',
                 'ASID',
                 'BA',
                 'BC',
                 'BCT',
                 'BR',
                 'BRN',
                 'BSNR',
                 'CC',
                 'CONM',
                 'CY',
                 'CZ',
                 'DDS',
                 'DEA',
                 'DFN',
                 'DI',
                 'DL',
                 'DN',
                 'DO',
                 'DP',
                 'DPM',
                 'DR',
                 'DS',
                 'EI',
                 'EN',
                 'ESN',
                 'FI',
                 'GI',
                 'GL',
                 'GN',
                 'HC',
                 'IND',
                 'JHN',
                 'LACSN',
                 'LANR',
                 'LI',
                 'LN',
                 'LR',
                 'MA',
                 'MB',
                 'MC',
                 'MCD',
                 'MCN',
                 'MCR',
                 'MCT',
                 'MD',
                 'MI',
                 'MR',
                 'MRT',
                 'MS',
                 'NBSNR',
                 'NCT',
                 'NE',
                 'NH',
                 'NI',
                 'NII',
                 'NIIP',
                 'NNxxx',
                 'NP',
                 'NPI',
                 'OD',
                 'PA',
                 'PC',
                 'PCN',
                 'PE',
                 'PEN',
                 'PI',
                 'PN',
                 'PNT',
                 'PPIN',
                 'PPN',
                 'PRC',
                 'PRN',
                 'PT',
                 'QA',
                 'RI',
                 'RN',
                 'RPH',
                 'RR',
                 'RRI',
                 'RRP',
                 'SID',
                 'SL',
                 'SN',
                 'SP',
                 'SR',
                 'SS',
                 'TAX',
                 'TN',
                 'TPR',
                 'U',
                 'UPIN',
                 'USID',
                 'VN',
                 'VP',
                 'VS',
                 'WC',
                 'WCN',
                 'WP',
                 'XX')),
    'HL70204': ('Organizational Name Type',
                ('A',
                 'D',
                 'L',
                 'SL')),
    'HL70205': ('Price Type',
                ('AP',
                 'DC',
                 'IC',
                 'PF',
                 'TF',
                 'TP',
                 'UP')),
    'HL70206': ('Segment Action Code',
                ('A',
                 'D',
                 'U',
                 'X')),
    'HL70207': ('Processing Mode',
                ('A',
                 'I',
                 'Not present',
                 'R',
                 'T')),
    'HL70208': ('Query Response Status',
                ('AE',
                 'AR',
                 'NF',
                 'OK')),
    'HL70209': ('Relational Operator',
                ('CT',
                 'EQ',
                 'GE',
                 'GN',
                 'GT',
                 'LE',
                 'LT',
                 'NE')),
    'HL70210': ('Relational Conjunction',
                ('AND',
                 'OR')),
    'HL70211': ('Alternate Character Sets',
                ('8859/1',
                 '8859/15',
                 '8859/2',
                 '8859/3',
                 '8859/4',
                 '8859/5',
                 '8859/6',
                 '8859/7',
                 '8859/8',
                 '8859/9',
                 'ASCII',
                 'BIG-5',
                 'CNS 11643-1992',
                 'GB 18030-2000',
                 'ISO IR14',
                 'ISO IR159',
                 'ISO IR6',
                 'ISO IR87',
                 'KS X 1001',
                 'UNICODE',
                 'UNICODE UTF-8')),
    'HL70212': ('Nationality',
                ()),
    'HL70213': ('Purge Status Code',
                ('D',
                 'I',
                 'P')),
    'HL70214': ('Special Program Code',
                ('CH',
                 'ES',
                 'FP',
                 'O',
                 'U')),
    'HL70215': ('Publicity Code',
                ('F',
                 'N',
                 'O',
                 'U')),
    'HL70216': ('Patient Status Code',
                ('AI',
                 'DI')),
    'HL70217': ('Visit Priority Code',
                ('1',
                 '2',
                 '3')),
    'HL70218': ('Patient Charge Adjustment',
                ()),
    'HL70219': ('Recurring Service Code',
                ()),
    'HL70220': ('Living Arrangement',
                ('A',
                 'F',
                 'I',
                 'R',
                 'S',
                 'U')),
    'HL70222': ('Contact Reason',
                ()),
    'HL70223': ('Living Dependency',
                ('C',
                 'M',
                 'O',
                 'S',
                 'U')),
    'HL70224': ('Transport Arranged',
                ('A',
                 'N',
                 'U')),
    'HL70225': ('Escort Required',
                ('N',
                 'R',
                 'U')),
    'HL70227': ('Manufacturers of Vaccines (code=MVX)',
                ('AB',
                 'AD',
                 'ALP',
                 'AR',
                 'AVB',
                 'AVI',
                 'BA',
                 'BAH',
                 'BAY',
                 'BP',
                 'BPC',
                 'CEN',
                 'CHI',
                 'CMP',
                 'CNJ',
                 'CON',
                 'DVC',
                 'EVN',
                 'GEO',
                 'GRE',
                 'IAG',
                 'IM',
                 'IUS',
                 'JPN',
                 'KGC',
                 'LED',
                 'MA',
                 'MBL',
                 'MED',
                 'MIL',
                 'MIP',
                 'MSD',
                 'NAB',
                 'NAV',
                 'NOV',
                 'NVX',
                 'NYB',
                 'ORT',
                 'OTC',
                 'OTH',
                 'PD',
                 'PMC',
                 'PRX',
                 'PWJ',
                 'SCL',
                 'SI',
                 'SKB',
                 'SOL',
                 'TAL',
                 'UNK',
                 'USA',
                 'VXG',
                 'WA',
                 'WAL',
                 'ZLB')),
    'HL70228': ('Diagnosis Classification',
                ('C',
                 'D',
                 'I',
                 'M',
                 'O',
                 'R',
                 'S',
                 'T')),
    'HL70229': ('DRG Payor',
                ()),
    'HL70230': ('Procedure Functional Type',
                ('A',
                 'D',
                 'I',
                 'P')),
    'HL70231': ('Student Status',
                ('F',
                 'N',
                 'P')),
    'HL70232': ('- Insurance Company Contact Reason',
                ('1',
                 '2',
                 '3')),
    'HL70233': ('Non-Concur Code/Description',
                ()),
    'HL70234': ('Report Timing',
                ('10D',
                 '15D',
                 '30D',
                 '3D',
                 '7D',
                 'AD',
                 'CO',
                 'DE',
                 'PD',
                 'RQ')),
    'HL70235': ('Report Source',
                ('C',
                 'D',
                 'E',
                 'H',
                 'L',
                 'M',
                 'N',
                 'O',
                 'P',
                 'R')),
    'HL70236': ('Event Reported To',
                ('D',
                 'L',
                 'M',
                 'R')),
    'HL70237': ('Event Qualification',
                ('A',
                 'B',
                 'D',
                 'I',
                 'L',
                 'M',
                 'O',
                 'W')),
    'HL70238': ('Event Seriousness',
                ('N',
                 'S',
                 'Y')),
    'HL70239': ('Event Expected',
                ('N',
                 'U',
                 'Y')),
    'HL70240': ('Event Consequence',
                ('C',
                 'D',
                 'H',
                 'I',
                 'J',
                 'L',
                 'O',
                 'P',
                 'R')),
    'HL70241': ('Patient Outcome',
                ('D',
                 'F',
                 'N',
                 'R',
                 'S',
                 'U',
                 'W')),
    'HL70242': ('Primary Observer\'s Qualification',
                ('C',
                 'H',
                 'L',
                 'M',
                 'O',
                 'P',
                 'R')),
    'HL70243': ('Identity May Be Divulged',
                ('N',
                 'NA',
                 'Y')),
    'HL70244': ('Single Use Device',
                ()),
    'HL70245': ('Product Problem',
                ()),
    'HL70246': ('Product Available for Inspection',
                ()),
    'HL70247': ('Status of Evaluation',
                ('A',
                 'C',
                 'D',
                 'I',
                 'K',
                 'O',
                 'P',
                 'Q',
                 'R',
                 'U',
                 'X',
                 'Y')),
    'HL70248': ('Product Source',
                ('A',
                 'L',
                 'N',
                 'R')),
    'HL70249': ('Generic Product',
                ()),
    'HL70250': ('Relatedness Assessment',
                ('H',
                 'I',
                 'M',
                 'N',
                 'S')),
    'HL70251': ('Action Taken in Response to the Event',
                ('DI',
                 'DR',
                 'N',
                 'OT',
                 'WP',
                 'WT')),
    'HL70252': ('Causality Observations',
                ('AW',
                 'BE',
                 'DR',
                 'EX',
                 'IN',
                 'LI',
                 'OE',
                 'OT',
                 'PL',
                 'SE',
                 'TC')),
    'HL70253': ('Indirect Exposure Mechanism',
                ('B',
                 'F',
                 'O',
                 'P',
                 'X')),
    'HL70254': ('Kind of Quantity',
                ('ABS',
                 'ACNC',
                 'ACT',
                 'APER',
                 'ARB',
                 'AREA',
                 'ASPECT',
                 'CACT',
                 'CCNT',
                 'CCRTO',
                 'CFR',
                 'CLAS',
                 'CNC',
                 'CNST',
                 'COEF',
                 'COLOR',
                 'CONS',
                 'CRAT',
                 'CRTO',
                 'DEN',
                 'DEV',
                 'DIFF',
                 'ELAS',
                 'ELPOT',
                 'ELRAT',
                 'ELRES',
                 'ENGR',
                 'ENT',
                 'ENTCAT',
                 'ENTNUM',
                 'ENTSUB',
                 'ENTVOL',
                 'EQL',
                 'FORCE',
                 'FREQ',
                 'IMP',
                 'KINV',
                 'LEN',
                 'LINC',
                 'LIQ',
                 'MASS',
                 'MCNC',
                 'MCNT',
                 'MCRTO',
                 'MFR',
                 'MGFLUX',
                 'MINC',
                 'MORPH',
                 'MOTIL',
                 'MRAT',
                 'MRTO',
                 'NCNC',
                 'NCNT',
                 'NFR',
                 'NRTO',
                 'NUM',
                 'OD',
                 'OSMOL',
                 'PRES',
                 'PRID',
                 'PWR',
                 'RANGE',
                 'RATIO',
                 'RCRLTM',
                 'RDEN',
                 'REL',
                 'RLMCNC',
                 'RLSCNC',
                 'RLTM',
                 'SATFR',
                 'SCNC',
                 'SCNCIN',
                 'SCNT',
                 'SCNTR',
                 'SCRTO',
                 'SFR',
                 'SHAPE',
                 'SMELL',
                 'SRAT',
                 'SRTO',
                 'SUB',
                 'SUSC',
                 'TASTE',
                 'TEMP',
                 'TEMPDF',
                 'TEMPIN',
                 'THRMCNC',
                 'THRSCNC',
                 'TIME',
                 'TITR',
                 'TMDF',
                 'TMSTP',
                 'TRTO',
                 'TYPE',
                 'VCNT',
                 'VEL',
                 'VELRT',
                 'VFR',
                 'VISC',
                 'VOL',
                 'VRAT',
                 'VRTO')),
    'HL70255': ('Duration Categories',
                ('*',
                 '12H',
                 '1H',
                 '1L',
                 '1W',
                 '2.5H',
                 '24H',
                 '2D',
                 '2H',
                 '2L',
                 '2W',
                 '30M',
                 '3D',
                 '3H',
                 '3L',
                 '3W',
                 '4D',
                 '4H',
                 '4W',
                 '5D',
                 '5H',
                 '6D',
                 '6H',
                 '7H',
                 '8H',
                 'PT')),
    'HL70256': ('Time Delay Post Challenge',
                ('10D',
                 '10M',
                 '12H',
                 '15M',
                 '1H',
                 '1L',
                 '1M',
                 '1W',
                 '2.5H',
                 '20M',
                 '24H',
                 '25M',
                 '2D',
                 '2H',
                 '2L',
                 '2M',
                 '2W',
                 '30M',
                 '3D',
                 '3H',
                 '3L',
                 '3M',
                 '3W',
                 '4D',
                 '4H',
                 '4M',
                 '4W',
                 '5D',
                 '5H',
                 '5M',
                 '6D',
                 '6H',
                 '6M',
                 '7D',
                 '7H',
                 '7M',
                 '8H',
                 '8H SHIFT',
                 '8M',
                 '9M',
                 'BS',
                 'PEAK',
                 'RANDOM',
                 'TROUGH')),
    'HL70257': ('Nature of Challenge',
                ('CFST',
                 'EXCZ',
                 'FFST')),
    'HL70258': ('Relationship Modifier',
                ('BPU',
                 'CONTROL',
                 'DONOR',
                 'PATIENT')),
    'HL70259': ('Modality',
                ('AS',
                 'BS',
                 'CD',
                 'CP',
                 'CR',
                 'CS',
                 'CT',
                 'DD',
                 'DG',
                 'DM',
                 'EC',
                 'ES',
                 'FA',
                 'FS',
                 'LP',
                 'LS',
                 'MA',
                 'MS',
                 'NM',
                 'OT',
                 'PT',
                 'RF',
                 'ST',
                 'TG',
                 'US',
                 'XA')),
    'HL70260': ('Patient Location Type',
                ('B',
                 'C',
                 'D',
                 'E',
                 'L',
                 'N',
                 'O',
                 'R')),
    'HL70261': ('Location Equipment',
                ('EEG',
                 'EKG',
                 'INF',
                 'IVP',
                 'OXY',
                 'SUC',
                 'VEN',
                 'VIT')),
    'HL70262': ('Privacy Level',
                ('F',
                 'J',
                 'P',
                 'Q',
                 'S',
                 'W')),
    'HL70263': ('Level of Care',
                ('A',
                 'C',
                 'E',
                 'F',
                 'N',
                 'R',
                 'S')),
    'HL70264': ('Location Department',
                ()),
    'HL70265': ('Specialty Type',
                ('ALC',
                 'AMB',
                 'CAN',
                 'CAR',
                 'CCR',
                 'CHI',
                 'EDI',
                 'EMR',
                 'FPC',
                 'INT',
                 'ISO',
                 'NAT',
                 'NBI',
                 'OBG',
                 'OBS',
                 'OTH',
                 'PED',
                 'PHY',
                 'PIN',
                 'PPS',
                 'PRE',
                 'PSI',
                 'PSY',
                 'REH',
                 'SUR',
                 'WIC')),
    'HL70267': ('Days of the Week',
                ('FRI',
                 'MON',
                 'SAT',
                 'SUN',
                 'THU',
                 'TUE',
                 'WED')),
    'HL70268': ('Override',
                ('A',
                 'R',
                 'X')),
    'HL70269': ('Charge On Indicator',
                ('O',
                 'R')),
    'HL70270': ('Document Type',
                ('AR',
                 'CD',
                 'CN',
                 'DI',
                 'DS',
                 'ED',
                 'HP',
                 'OP',
                 'PC',
                 'PH',
                 'PN',
                 'PR',
                 'SP',
                 'TS')),
    'HL70271': ('Document Completion Status',
                ('AU',
                 'DI',
                 'DO',
                 'IN',
                 'IP',
                 'LA',
                 'PA')),
    'HL70272': ('Document Confidentiality Status',
                ('R',
                 'U',
                 'V')),
    'HL70273': ('Document Availability Status',
                ('AV',
                 'CA',
                 'OB',
                 'UN')),
    'HL70275': ('Document Storage Status',
                ('AA',
                 'AC',
                 'AR',
                 'PU')),
    'HL70276': ('Appointment reason codes', ()),
    'HL70277': ('Appointment Type Codes', ()),
    'HL70278': ('Filler status codes', ()),
    'HL70279': ('Allow Substitution Codes', ()),
    'HL70280': ('Referral Priority',
                ('A',
                 'R',
                 'S')),
    'HL70281': ('Referral Type',
                ('Hom',
                 'Lab',
                 'Med',
                 'Psy',
                 'Rad',
                 'Skn')),
    'HL70282': ('Referral Disposition',
                ('AM',
                 'RP',
                 'SO',
                 'WR')),
    'HL70283': ('Referral Status',
                ('A',
                 'E',
                 'P',
                 'R')),
    'HL70284': ('Referral Category',
                ('A',
                 'E',
                 'I',
                 'O')),
    'HL70285': ('Insurance Company ID Codes',
                ()),
    'HL70286': ('Provider Role',
                ('CP',
                 'PP',
                 'RP',
                 'RT')),
    'HL70287': ('Problem/Goal Action Code',
                ('AD',
                 'CO',
                 'DE',
                 'LI',
                 'UC',
                 'UN',
                 'UP')),
    'HL70288': ('Census Tract',
                ()),
    'HL70289': ('County/Parish',
                ()),
    'HL70291': ('Subtype of Referenced Data',
                ('...',
                 'x-hl7-cda-level-one')),
    'HL70292': ('Vaccines Administered (code = CVX) (parenteral, unless oral is noted)',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '10',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '105',
                 '106',
                 '107',
                 '108',
                 '109',
                 '11',
                 '110',
                 '111',
                 '112',
                 '113',
                 '114',
                 '115',
                 '116',
                 '117',
                 '118',
                 '119',
                 '12',
                 '120',
                 '121',
                 '122',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35',
                 '36',
                 '37',
                 '38',
                 '39',
                 '40',
                 '41',
                 '42',
                 '43',
                 '44',
                 '45',
                 '46',
                 '47',
                 '48',
                 '49',
                 '50',
                 '51',
                 '52',
                 '53',
                 '54',
                 '55',
                 '56',
                 '57',
                 '58',
                 '59',
                 '60',
                 '61',
                 '62',
                 '63',
                 '64',
                 '65',
                 '66',
                 '67',
                 '68',
                 '69',
                 '70',
                 '71',
                 '72',
                 '73',
                 '74',
                 '75',
                 '76',
                 '77',
                 '78',
                 '79',
                 '80',
                 '81',
                 '82',
                 '83',
                 '84',
                 '85',
                 '86',
                 '87',
                 '88',
                 '89',
                 '90',
                 '91',
                 '92',
                 '93',
                 '94',
                 '95',
                 '96',
                 '97',
                 '98',
                 '99',
                 '998',
                 '999')),
    'HL70293': ('Billing Category',
                ()),
    'HL70294': ('Time Selection Criteria Parameter Class Codes',
                ('Fri',
                 'Mon',
                 'Prefend',
                 'Prefstart',
                 'Sat',
                 'Sun',
                 'Thu',
                 'Tue',
                 'Wed')),
    'HL70295': ('Handicap',
                ()),
    'HL70296': ('Primary Language',
                ()),
    'HL70297': ('CN ID Source',
                ()),
    'HL70298': ('CP Range Type',
                ('F',
                 'P')),
    'HL70299': ('Encoding',
                ('A',
                 'Base64',
                 'Hex')),
    'HL70300': ('Namespace ID',
                ()),
    'HL70301': ('Universal ID Type',
                ('CLIA',
                 'CLIP',
                 'DNS',
                 'EUI64',
                 'GUID',
                 'HCD',
                 'HL7',
                 'ISO',
                 'L,M,N',
                 'Random',
                 'URI',
                 'UUID',
                 'x400',
                 'x500')),
    'HL70302': ('Point of Care',
                ()),
    'HL70303': ('Room',
                ()),
    'HL70304': ('Bed',
                ()),
    'HL70305': ('Person Location Type',
                ('C',
                 'D',
                 'H',
                 'N',
                 'O',
                 'P',
                 'S')),
    'HL70306': ('Location Status',
                ()),
    'HL70307': ('Building',
                ()),
    'HL70308': ('Floor',
                ()),
    'HL70309': ('Coverage Type',
                ('B',
                 'H',
                 'P',
                 'RX')),
    'HL70311': ('Job Status',
                ('O',
                 'P',
                 'T',
                 'U')),
    'HL70312': ('Policy Scope',
                ()),
    'HL70313': ('- Policy Source',
                ()),
    'HL70315': ('Living Will Code',
                ('F',
                 'I',
                 'N',
                 'U',
                 'Y')),
    'HL70316': ('Organ Donor Code',
                ('F',
                 'I',
                 'N',
                 'P',
                 'R',
                 'U',
                 'Y')),
    'HL70317': ('Annotations',
                ('9900',
                 '9901',
                 '9902',
                 '9903',
                 '9904')),
    'HL70319': ('Department Cost Center',
                ()),
    'HL70320': ('Item Natural Account Code',
                ()),
    'HL70321': ('Dispense Method',
                ('AD',
                 'F',
                 'TR',
                 'UD')),
    'HL70322': ('Completion Status',
                ('CP',
                 'NA',
                 'PA',
                 'RE')),
    'HL70324': ('Location Characteristic ID',
                ('GEN',
                 'IMP',
                 'INF',
                 'LCR',
                 'LIC',
                 'OVR',
                 'PRL',
                 'SET',
                 'SHA',
                 'SMK',
                 'STF',
                 'TEA')),
    'HL70325': ('Location Relationship ID',
                ('ALI',
                 'DTY',
                 'LAB',
                 'LB2',
                 'PAR',
                 'RX',
                 'RX2')),
    'HL70326': ('Visit Indicator',
                ('A',
                 'V')),
    'HL70327': ('Job Code',
                ()),
    'HL70328': ('Employee Classification',
                ()),
    'HL70329': ('Quantity Method',
                ('A',
                 'E')),
    'HL70330': ('Marketing Basis',
                ('510E',
                 '510K',
                 '522S',
                 'PMA',
                 'PRE',
                 'TXN')),
    'HL70331': ('Facility Type',
                ('A',
                 'D',
                 'M',
                 'U')),
    'HL70332': ('Source Type',
                ('A',
                 'I')),
    'HL70333': ('Driver\'s License Issuing Authority',
                ()),
    'HL70334': ('Disabled Person Code',
                ('AP',
                 'GT',
                 'IN',
                 'PT')),
    'HL70335': ('Repeat Pattern',
                ('A',
                 'BID',
                 'C',
                 'D',
                 'I',
                 'M',
                 'Meal Related Timings',
                 'Once',
                 'P',
                 'PRN',
                 'PRNxxx',
                 'Q<integer>D',
                 'Q<integer>H',
                 'Q<integer>J<day#>',
                 'Q<integer>L',
                 'Q<integer>M',
                 'Q<integer>S',
                 'Q<integer>W',
                 'QAM',
                 'QHS',
                 'QID',
                 'QOD',
                 'QPM',
                 'QSHIFT',
                 'TID',
                 'U <spec>',
                 'V',
                 'xID')),
    'HL70336': ('Referral Reason',
                ('O',
                 'P',
                 'S',
                 'W')),
    'HL70337': ('Certification Status',
                ('C',
                 'E')),
    'HL70338': ('Practitioner ID Number Type',
                ('CY',
                 'DEA',
                 'GL',
                 'L&I',
                 'LI',
                 'MCD',
                 'MCR',
                 'QA',
                 'SL',
                 'TAX',
                 'TRL',
                 'UPIN')),
    'HL70339': ('Advanced Beneficiary Notice Code',
                ('1',
                 '2',
                 '3',
                 '4')),
    'HL70340': ('Procedure Code Modifier', ()),
    'HL70341': ('Guarantor Credit Rating Code', ()),
    'HL70342': ('Military Recipient', ()),
    'HL70343': ('Military Handicapped Program Code', ()),
    'HL70344': ('Patient\'s Relationship to Insured',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19')),
    'HL70345': ('Appeal Reason',
                ()),
    'HL70346': ('Certification Agency',
                ()),
    'HL70347': ('State/Province',
                ('AB',
                 'MI')),
    'HL70350': ('Occurrence Code',
                ()),
    'HL70351': ('Occurrence Span',
                ()),
    'HL70353': ('CWE statuses',
                ('NA',
                 'NASK',
                 'NAV',
                 'U',
                 'UASK')),
    'HL70354': ('Message Structure',
                ('ACK',
                 'ADR_A19',
                 'ADT_A01',
                 'ADT_A02',
                 'ADT_A03',
                 'ADT_A05',
                 'ADT_A06',
                 'ADT_A09',
                 'ADT_A12',
                 'ADT_A15',
                 'ADT_A16',
                 'ADT_A17',
                 'ADT_A18',
                 'ADT_A20',
                 'ADT_A21',
                 'ADT_A24',
                 'ADT_A30',
                 'ADT_A37',
                 'ADT_A38',
                 'ADT_A39',
                 'ADT_A43',
                 'ADT_A44',
                 'ADT_A45',
                 'ADT_A50',
                 'ADT_A52',
                 'ADT_A54',
                 'ADT_A60',
                 'ADT_A61',
                 'BAR_P01',
                 'BAR_P02',
                 'BAR_P05',
                 'BAR_P06',
                 'BAR_P10',
                 'BAR_P12',
                 'BPS_O29',
                 'BRP_O30',
                 'BRT_O32',
                 'BTS_O31',
                 'CCF_I22',
                 'CCI_I22',
                 'CCM_I21',
                 'CCQ_I19',
                 'CCR_I16',
                 'CCU_I20',
                 'CQU_I19',
                 'CRM_C01',
                 'CSU_C09',
                 'DBC_O41',
                 'DBC_O42',
                 'DEL_O46',
                 'DEO_O45',
                 'DER_O44',
                 'DFT_P03',
                 'DFT_P11',
                 'DOC_T12',
                 'DPR_O48',
                 'DRC_O47',
                 'DRG_O43',
                 'EAC_U07',
                 'EAN_U09',
                 'EAR_U08',
                 'EHC_E01',
                 'EHC_E02',
                 'EHC_E04',
                 'EHC_E10',
                 'EHC_E12',
                 'EHC_E13',
                 'EHC_E15',
                 'EHC_E20',
                 'EHC_E21',
                 'EHC_E24',
                 'ESR_U02',
                 'ESU_U01',
                 'INR_U06',
                 'INU_U05',
                 'LSU_U12',
                 'MDM_T01',
                 'MDM_T02',
                 'MFK_M01',
                 'MFN_M01',
                 'MFN_M02',
                 'MFN_M03',
                 'MFN_M04',
                 'MFN_M05',
                 'MFN_M06',
                 'MFN_M07',
                 'MFN_M08',
                 'MFN_M09',
                 'MFN_M10',
                 'MFN_M11',
                 'MFN_M12',
                 'MFN_M13',
                 'MFN_M15',
                 'MFN_M16',
                 'MFN_M17',
                 'MFN_M18',
                 'MFQ_M01',
                 'MFR_M01',
                 'MFR_M04',
                 'MFR_M05',
                 'MFR_M06',
                 'MFR_M07',
                 'NMD_N02',
                 'NMQ_N01',
                 'NMR_N01',
                 'OMB_O27',
                 'OMD_O03',
                 'OMG_O19',
                 'OMI_O23',
                 'OML_O21',
                 'OML_O33',
                 'OML_O35',
                 'OML_O39',
                 'OMN_O07',
                 'OMP_O09',
                 'OMQ_O42',
                 'OMS_O05',
                 'OPL_O37',
                 'OPR_O38',
                 'OPU_R25',
                 'ORA_R33',
                 'ORA_R41',
                 'ORB_O28',
                 'ORD_O04',
                 'ORF_R04',
                 'ORG_O20',
                 'ORI_O24',
                 'ORL_O22',
                 'ORL_O34',
                 'ORL_O36',
                 'ORL_O40',
                 'ORL_O41',
                 'ORL_O42',
                 'ORL_O43',
                 'ORL_O44',
                 'ORM_O01',
                 'ORN_O08',
                 'ORP_O10',
                 'ORR_O02',
                 'ORS_O06',
                 'ORU_R01',
                 'ORU_R30',
                 'ORU_W01',
                 'ORX_O43',
                 'OSM_R26',
                 'OSQ_Q06',
                 'OSR_Q06',
                 'OSU_O41',
                 'OUL_R21',
                 'OUL_R22',
                 'OUL_R23',
                 'OUL_R24',
                 'PEX_P07',
                 'PGL_PC6',
                 'PMU_B01',
                 'PMU_B03',
                 'PMU_B04',
                 'PMU_B07',
                 'PMU_B08',
                 'PPG_PCG',
                 'PPP_PCB',
                 'PPR_PC1',
                 'PPT_PCL',
                 'PPV_PCA',
                 'PRR_PC5',
                 'PTR_PCF',
                 'QBP_E03',
                 'QBP_E22',
                 'QBP_O33',
                 'QBP_O34',
                 'QBP_Q11',
                 'QBP_Q13',
                 'QBP_Q15',
                 'QBP_Q21',
                 'QCK_Q02',
                 'QCN_J01',
                 'QRF_W02',
                 'QRY_A19',
                 'QRY_PC4',
                 'QRY_Q01',
                 'QRY_Q02',
                 'QRY_R02',
                 'QRY_T12',
                 'QSB_Q16',
                 'QVR_Q17',
                 'RAR_RAR',
                 'RAS_O17',
                 'RCI_I05',
                 'RCL_I06',
                 'RDE_O11',
                 'RDR_RDR',
                 'RDS_O13',
                 'RDY_K15',
                 'REF_I12',
                 'RER_RER',
                 'RGR_RGR',
                 'RGV_O15',
                 'ROR_ROR',
                 'RPA_I08',
                 'RPI_I01',
                 'RPI_I04',
                 'RPL_I02',
                 'RPR_I03',
                 'RQA_I08',
                 'RQC_I05',
                 'RQI_I01',
                 'RQP_I04',
                 'RRA_O18',
                 'RRD_O14',
                 'RRE_O12',
                 'RRG_O16',
                 'RRI_I12',
                 'RSP_E03',
                 'RSP_E22',
                 'RSP_K11',
                 'RSP_K21',
                 'RSP_K22',
                 'RSP_K23',
                 'RSP_K25',
                 'RSP_K31',
                 'RSP_K32',
                 'RSP_O33',
                 'RSP_O34',
                 'RSP_Q11',
                 'RTB_K13',
                 'SDR_S31',
                 'SDR_S32',
                 'SIU_S12',
                 'SLR_S28',
                 'SQM_S25',
                 'SQR_S25',
                 'SRM_S01',
                 'SRR_S01',
                 'SSR_U04',
                 'SSU_U03',
                 'STC_S33',
                 'SUR_P09',
                 'TCU_U10',
                 'UDM_Q05',
                 'VXQ_V01',
                 'VXR_V03',
                 'VXU_V04',
                 'VXX_V02')),
    'HL70355': ('Primary Key Value Type',
                ('CE',
                 'CWE',
                 'PL')),
    'HL70356': ('Alternate Character Set Handling Scheme',
                ('<null>',
                 '2.3',
                 'ISO 2022-1994')),
    'HL70357': ('Message Error Condition Codes',
                ('0',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '200',
                 '201',
                 '202',
                 '203',
                 '204',
                 '205',
                 '206',
                 '207')),
    'HL70358': ('Practitioner Group',
                ()),
    'HL70359': ('Diagnosis Priority',
                ('...',
                 '0',
                 '1',
                 '2')),
    'HL70360': ('Degree/License/Certificate',
                ('AA',
                 'AAS',
                 'ABA',
                 'AE',
                 'AS',
                 'BA',
                 'BBA',
                 'BE',
                 'BFA',
                 'BN',
                 'BS',
                 'BSL',
                 'BSN',
                 'BT',
                 'CANP',
                 'CER',
                 'CMA',
                 'CNM',
                 'CNP',
                 'CNS',
                 'CPNP',
                 'CRN',
                 'CTR',
                 'DBA',
                 'DED',
                 'DIP',
                 'DO',
                 'EMT',
                 'EMTP',
                 'FPNP',
                 'HS',
                 'JD',
                 'MA',
                 'MBA',
                 'MCE',
                 'MD',
                 'MDA',
                 'MDI',
                 'ME',
                 'MED',
                 'MEE',
                 'MFA',
                 'MME',
                 'MS',
                 'MSL',
                 'MSN',
                 'MT',
                 'MTH',
                 'NG',
                 'NP',
                 'PA',
                 'PharmD',
                 'PHD',
                 'PHE',
                 'PHS',
                 'PN',
                 'RMA',
                 'RN',
                 'RPH',
                 'SEC',
                 'TS')),
    'HL70361': ('Application',
                ()),
    'HL70362': ('Facility',
                ()),
    'HL70363': ('Assigning Authority',
                ()),
    'HL70364': ('Comment Type',
                ('1R',
                 '2R',
                 'AI',
                 'DR',
                 'GI',
                 'GR',
                 'PI',
                 'RE')),
    'HL70365': ('Equipment State',
                ('...',
                 'CL',
                 'CO',
                 'DI',
                 'ES',
                 'ID',
                 'IN',
                 'MA',
                 'OP',
                 'PA',
                 'PD',
                 'PU',
                 'SD',
                 'SS',
                 'TS')),
    'HL70366': ('Local/Remote Control State',
                ('...',
                 'L',
                 'R')),
    'HL70367': ('Alert Level',
                ('...',
                 'C',
                 'N',
                 'S',
                 'W')),
    'HL70368': ('Remote Control Command',
                ('AB',
                 'AF',
                 'AT',
                 'CL',
                 'CN',
                 'DI',
                 'EN',
                 'ES',
                 'EX',
                 'IN',
                 'LC',
                 'LK',
                 'LO',
                 'PA',
                 'RC',
                 'RE',
                 'SA',
                 'SU',
                 'TT',
                 'UC',
                 'UN')),
    'HL70369': ('Specimen Role',
                ('B',
                 'C',
                 'E',
                 'F',
                 'G',
                 'L',
                 'O',
                 'P',
                 'Q',
                 'R',
                 'V')),
    'HL70370': ('Container Status',
                ('I',
                 'L',
                 'M',
                 'O',
                 'P',
                 'R',
                 'U',
                 'X')),
    'HL70371': ('Additive/Preservative',
                ('ACDA',
                 'ACDB',
                 'ACET',
                 'AMIES',
                 'BACTM',
                 'BF10',
                 'BOR',
                 'BOUIN',
                 'BSKM',
                 'C32',
                 'C38',
                 'CARS',
                 'CARY',
                 'CHLTM',
                 'CTAD',
                 'EDTK',
                 'EDTK15',
                 'EDTK75',
                 'EDTN',
                 'ENT',
                 'ENT+',
                 'F10',
                 'FDP',
                 'FL10',
                 'FL100',
                 'HCL6',
                 'HEPA',
                 'HEPL',
                 'HEPN',
                 'HNO3',
                 'JKM',
                 'KARN',
                 'KOX',
                 'LIA',
                 'M4',
                 'M4RT',
                 'M5',
                 'MICHTM',
                 'MMDTM',
                 'NAF',
                 'NAPS',
                 'NONE',
                 'PAGE',
                 'PHENOL',
                 'PVA',
                 'RLM',
                 'SILICA',
                 'SPS',
                 'SST',
                 'STUTM',
                 'THROM',
                 'THYMOL',
                 'THYO',
                 'TOLU',
                 'URETM',
                 'VIRTM',
                 'WEST')),
    'HL70372': ('Specimen Component',
                ('BLD',
                 'BSEP',
                 'PLAS',
                 'PPP',
                 'PRP',
                 'SED',
                 'SER',
                 'SUP')),
    'HL70373': ('Treatment',
                ('ACID',
                 'ALK',
                 'DEFB',
                 'FILT',
                 'LDLP',
                 'NEUT',
                 'RECA',
                 'UFIL')),
    'HL70374': ('System Induced Contaminants',
                ('CNTM',)),
    'HL70375': ('Artificial Blood',
                ('FLUR',
                 'SFHB')),
    'HL70376': ('Special Handling Code',
                ('AMB',
                 'C37',
                 'CAMB',
                 'CATM',
                 'CFRZ',
                 'CREF',
                 'DFRZ',
                 'DRY',
                 'FRZ',
                 'MTLF',
                 'NTR',
                 'PRTL',
                 'PSA',
                 'PSO',
                 'REF',
                 'UFRZ',
                 'UPR')),
    'HL70377': ('Other Environmental Factors',
                ('A60',
                 'ATM')),
    'HL70378': ('Carrier Type',
                ()),
    'HL70379': ('Tray Type',
                ()),
    'HL70380': ('Separator Type',
                ()),
    'HL70381': ('Cap Type',
                ()),
    'HL70382': ('Drug Interference',
                ()),
    'HL70383': ('Substance Status',
                ('CE',
                 'CW',
                 'EE',
                 'EW',
                 'NE',
                 'NW',
                 'OE',
                 'OK',
                 'OW',
                 'QE',
                 'QW')),
    'HL70384': ('Substance Type',
                ('CO',
                 'DI',
                 'LI',
                 'LW',
                 'MR',
                 'OT',
                 'PT',
                 'PW',
                 'RC',
                 'SC',
                 'SR',
                 'SW')),
    'HL70385': ('Manufacturer Identifier',
                ()),
    'HL70386': ('Supplier Identifier',
                ()),
    'HL70387': ('Command Response',
                ('ER',
                 'OK',
                 'ST',
                 'TI',
                 'UN')),
    'HL70388': ('Processing Type',
                ('E',
                 'P')),
    'HL70389': ('Analyte Repeat Status',
                ('D',
                 'F',
                 'O',
                 'R')),
    'HL70391': ('Segment Group',
                ('ADMINISTRATION',
                 'ALLERGY',
                 'APP_STATS',
                 'APP_STATUS',
                 'ASSOCIATED_PERSON',
                 'ASSOCIATED_RX_ADMIN',
                 'ASSOCIATED_RX_ORDER',
                 'AUTHORIZATION',
                 'AUTHORIZATION_CONTACT',
                 'CERTIFICATE',
                 'CLOCK',
                 'CLOCK_AND_STATISTICS',
                 'CLOCK_AND_STATS_WITH_NOTES',
                 'CLOCK_AND_STATS_WITH_NOTES_ALT',
                 'COMMAND',
                 'COMMAND_RESPONSE',
                 'COMMON_ORDER',
                 'COMPONENT',
                 'COMPONENTS',
                 'CONTAINER',
                 'DEFINITION',
                 'DIET',
                 'DISPENSE',
                 'ENCODED_ORDER',
                 'ENCODING',
                 'EXPERIENCE',
                 'FINANCIAL',
                 'FINANCIAL_COMMON_ORDER',
                 'FINANCIAL_INSURANCE',
                 'FINANCIAL_OBSERVATION',
                 'FINANCIAL_ORDER',
                 'FINANCIAL_PROCEDURE',
                 'FINANCIAL_TIMING_QUANTITY',
                 'GENERAL_RESOURCE',
                 'GIVE',
                 'GOAL',
                 'GOAL_OBSERVATION',
                 'GOAL_PATHWAY',
                 'GOAL_ROLE',
                 'GUARANTOR_INSURANCE',
                 'INSURANCE',
                 'LOCATION_RESOURCE',
                 'MERGE_INFO',
                 'MF',
                 'MF_CDM',
                 'MF_CLIN_STUDY',
                 'MF_CLIN_STUDY_SCHED',
                 'MF_INV_ITEM',
                 'MF_LOC_DEPT',
                 'MF_LOCATION',
                 'MF_OBS_ATTRIBUTES',
                 'MF_PHASE_SCHED_DETAIL',
                 'MF_QUERY',
                 'MF_SITE_DEFINED',
                 'MF_STAFF',
                 'MF_TEST',
                 'MF_TEST_BATT_DETAIL',
                 'MF_TEST_BATTERIES',
                 'MF_TEST_CALC_DETAIL',
                 'MF_TEST_CALCULATED',
                 'MF_TEST_CAT_DETAIL',
                 'MF_TEST_CATEGORICAL',
                 'MF_TEST_NUMERIC',
                 'NK1_TIMING_QTY',
                 'NOTIFICATION',
                 'OBSERVATION',
                 'OBSERVATION_PRIOR',
                 'OBSERVATION_REQUEST',
                 'OMSERVATION',
                 'ORDER',
                 'ORDER_CHOICE',
                 'ORDER_DETAIL',
                 'ORDER_DETAIL_SUPPLEMENT',
                 'ORDER_DIET',
                 'ORDER_ENCODED',
                 'ORDER_OBSERVATION',
                 'ORDER_PRIOR',
                 'ORDER_TRAY',
                 'PATHWAY',
                 'PATHWAY_ROLE',
                 'PATIENT',
                 'PATIENT_PRIOR',
                 'PATIENT_RESULT',
                 'PATIENT_VISIT',
                 'PATIENT_VISIT_PRIOR',
                 'PERSONNEL_RESOURCE',
                 'PEX_CAUSE',
                 'PEX_OBSERVATION',
                 'PRIOR_RESULT',
                 'PROBLEM',
                 'PROBLEM_OBSERVATION',
                 'PROBLEM_PATHWAY',
                 'PROBLEM_ROLE',
                 'PROCEDURE',
                 'PRODUCT',
                 'PRODUCT_STATUS',
                 'PROVIDER',
                 'PROVIDER_CONTACT',
                 'QBP',
                 'QRY_WITH_DETAIL',
                 'QUERY_RESPONSE',
                 'QUERY_RESULT_CLUSTER',
                 'REQUEST',
                 'RESOURCE',
                 'RESOURCES',
                 'RESPONSE',
                 'RESULT',
                 'RESULTS',
                 'RESULTS_NOTES',
                 'ROW_DEFINITION',
                 'RX_ADMINISTRATION',
                 'RX_ORDER',
                 'SCHEDULE',
                 'SERVICE',
                 'SPECIMEN',
                 'SPECIMEN_CONTAINER',
                 'STAFF',
                 'STUDY',
                 'STUDY_OBSERVATION',
                 'STUDY_PHASE',
                 'STUDY_SCHEDULE',
                 'TEST_CONFIGURATION',
                 'TIMING',
                 'TIMING_DIET',
                 'TIMING_ENCODED',
                 'TIMING_GIVE',
                 'TIMING_PRIOR',
                 'TIMING_QTY',
                 'TIMING_QUANTITY',
                 'TIMING_TRAY',
                 'TREATMENT',
                 'VISIT')),
    'HL70392': ('Match Reason',
                ('DB',
                 'NA',
                 'NP',
                 'SS')),
    'HL70393': ('Match Algorithms',
                ('LINKSOFT_2.01',
                 'MATCHWARE_1.2')),
    'HL70394': ('Response Modality',
                ('B',
                 'R',
                 'T')),
    'HL70395': ('Modify Indicator',
                ('M',
                 'N')),
    'HL70396': ('Coding System',
                ('99zzz',
                 'ACR',
                 'ALPHAID2006',
                 'ALPHAID2007',
                 'ALPHAID2008',
                 'ALPHAID2009',
                 'ALPHAID2010',
                 'ALPHAID2011',
                 'ANS+',
                 'ART',
                 'AS4',
                 'AS4E',
                 'ATC',
                 'C4',
                 'CAPECC',
                 'CAS',
                 'CCC',
                 'CD2',
                 'CDCA',
                 'CDCEDACUITY',
                 'CDCM',
                 'CDCOBS',
                 'CDCPHINVS',
                 'CDCREC',
                 'CDS',
                 'CE (obsolete)',
                 'CLP',
                 'CPTM',
                 'CST',
                 'CVX',
                 'DCM',
                 'E',
                 'E5',
                 'E6',
                 'E7',
                 'ENZC',
                 'EPASRS',
                 'FDAUDI',
                 'FDAUNII',
                 'FDDC',
                 'FDDX',
                 'FDK',
                 'FIPS5_2',
                 'FIPS6_4',
                 'GDRG2004',
                 'GDRG2005',
                 'GDRG2006',
                 'GDRG2007',
                 'GDRG2008',
                 'GDRG2009',
                 'GMDC2004',
                 'GMDC2005',
                 'GMDC2006',
                 'GMDC2007',
                 'GMDC2008',
                 'GMDC2009',
                 'GS1UDI',
                 'HB',
                 'HCPCS',
                 'HCPT',
                 'HHC',
                 'HI',
                 'HIBUDI',
                 'HL7nnnn',
                 'HOT',
                 'HPC',
                 'I10',
                 'I10G2004',
                 'I10G2005',
                 'I10G2006',
                 'I10P',
                 'I9',
                 'I9C',
                 'I9CDX',
                 'I9CP',
                 'IBT',
                 'IBTnnnn',
                 'IC2',
                 'ICCUDI',
                 'ICD10AM',
                 'ICD10CA',
                 'ICD10GM2007',
                 'ICD10GM2008',
                 'ICD10GM2009',
                 'ICD10GM2010',
                 'ICD10GM2011',
                 'ICDO',
                 'ICDO2',
                 'ICDO3',
                 'ICS',
                 'ICSD',
                 'ISO',
                 'ISO3166_1',
                 'ISO3166_2',
                 'ISO4217',
                 'ISO639',
                 'ISOnnnn (deprecated)',
                 'ITIS',
                 'IUPC',
                 'IUPP',
                 'JC10',
                 'JC8',
                 'JJ1017',
                 'L',
                 'LB',
                 'LN',
                 'MCD',
                 'MCR',
                 'MDC',
                 'MDDX',
                 'MEDC',
                 'MEDR',
                 'MEDX',
                 'MGPI',
                 'MVX',
                 'NAICS',
                 'NCPDPnnnnsss',
                 'NDA',
                 'NDC',
                 'NDFRT',
                 'NIC',
                 'NIP001',
                 'NIP002',
                 'NIP004',
                 'NIP007',
                 'NIP008',
                 'NIP009',
                 'NIP010',
                 'NND',
                 'NPI',
                 'NUBC',
                 'NULLFL',
                 'O301',
                 'O3012004',
                 'O3012005',
                 'O3012006',
                 'OHA',
                 'OPS2007',
                 'OPS2008',
                 'OPS2009',
                 'OPS2010',
                 'OPS2011',
                 'PHINQUESTION',
                 'PLR',
                 'PLT',
                 'POS',
                 'RC',
                 'RXNORM',
                 'SCT',
                 'SCT2',
                 'SDM',
                 'SIC',
                 'SNM',
                 'SNM3',
                 'SNT',
                 'SOC',
                 'UB04FL14',
                 'UB04FL15',
                 'UB04FL17',
                 'UB04FL31',
                 'UB04FL35',
                 'UB04FL39',
                 'UC',
                 'UCUM',
                 'UMD',
                 'UML',
                 'UPC',
                 'UPIN',
                 'USPS',
                 'W1',
                 'W2',
                 'W4',
                 'WC',
                 'X12Dennnn')),
    'HL70397': ('Sequencing',
                ('A',
                 'AN',
                 'D',
                 'DN',
                 'N')),
    'HL70398': ('Continuation Style Code',
                ('F',
                 'I')),
    'HL70399': ('Country Code',
                ()),
    'HL70401': ('Government Reimbursement Program',
                ('C',
                 'MM')),
    'HL70402': ('School Type',
                ('D',
                 'G',
                 'M',
                 'U')),
    'HL70403': ('Language Ability',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70404': ('Language Proficiency',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6')),
    'HL70405': ('Organization Unit',
                ()),
    'HL70406': ('Organization Unit Type',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 'H',
                 'O')),
    'HL70409': ('Application Change Type',
                ('M',
                 'SD',
                 'SU')),
    'HL70411': ('Supplemental Service Information Values',
                ()),
    'HL70412': ('Category Identifier',
                ()),
    'HL70413': ('Consent Identifier',
                ()),
    'HL70414': ('Units of Time',
                ()),
    'HL70415': ('Transfer Type',
                ('E',
                 'N')),
    'HL70416': ('Procedure DRG Type',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70417': ('Tissue Type Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 'B',
                 'C',
                 'G')),
    'HL70418': ('Procedure Priority',
                ('...',
                 '0',
                 '1',
                 '2')),
    'HL70421': ('Severity of Illness Code',
                ('MI',
                 'MO',
                 'SE')),
    'HL70422': ('Triage Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '99')),
    'HL70423': ('Case Category Code',
                ('D',)),
    'HL70424': ('Gestation Category Code',
                ('1',
                 '2',
                 '3')),
    'HL70425': ('Newborn Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70426': ('Blood Product Code',
                ('CRYO',
                 'CRYOP',
                 'FFP',
                 'FFPTH',
                 'PC',
                 'PCA',
                 'PCNEO',
                 'PCW',
                 'PLT',
                 'PLTNEO',
                 'PLTP',
                 'PLTPH',
                 'PLTPHLR',
                 'RWB',
                 'WBA')),
    'HL70427': ('Risk Management Incident Code',
                ('B',
                 'C',
                 'D',
                 'E',
                 'F',
                 'H',
                 'I',
                 'J',
                 'K',
                 'O',
                 'P',
                 'R',
                 'S',
                 'T')),
    'HL70428': ('Incident Type Code',
                ('O',
                 'P',
                 'U')),
    'HL70429': ('Production Class Code',
                ('BR',
                 'DA',
                 'DR',
                 'DU',
                 'LY',
                 'MT',
                 'NA',
                 'OT',
                 'PL',
                 'RA',
                 'SH',
                 'U')),
    'HL70430': ('Mode of Arrival Code',
                ('A',
                 'C',
                 'F',
                 'H',
                 'O',
                 'P',
                 'U')),
    'HL70431': ('Recreational Drug Use Code',
                ('A',
                 'C',
                 'K',
                 'M',
                 'O',
                 'T',
                 'U')),
    'HL70432': ('Admission Level of Care Code',
                ('AC',
                 'CH',
                 'CO',
                 'CR',
                 'IM',
                 'MO')),
    'HL70433': ('Precaution Code',
                ('A',
                 'B',
                 'C',
                 'D',
                 'I',
                 'N',
                 'O',
                 'P',
                 'U')),
    'HL70434': ('Patient Condition Code',
                ('A',
                 'C',
                 'O',
                 'P',
                 'S',
                 'U')),
    'HL70435': ('Advance Directive Code',
                ('DNR',
                 'N')),
    'HL70436': ('Sensitivity to Causative Agent Code',
                ('AD',
                 'AL',
                 'CT',
                 'IN',
                 'SE')),
    'HL70437': ('Alert Device Code',
                ('B',
                 'N',
                 'W')),
    'HL70438': ('Allergy Clinical Status',
                ('C',
                 'D',
                 'E',
                 'I',
                 'P',
                 'S',
                 'U')),
    'HL70440': ('Data Types',
                ('AD',
                 'AUI',
                 'CCD',
                 'CCP',
                 'CD',
                 'CE',
                 'CF',
                 'CK',
                 'CM',
                 'CN',
                 'CNE',
                 'CNN',
                 'CP',
                 'CQ',
                 'CSU',
                 'CWE',
                 'CX',
                 'DDI',
                 'DIN',
                 'DLD',
                 'DLN',
                 'DLT',
                 'DR',
                 'DT',
                 'DTM',
                 'DTN',
                 'ED',
                 'EI',
                 'EIP',
                 'ELD',
                 'ERL',
                 'FC',
                 'FN',
                 'FT',
                 'GTS',
                 'HD',
                 'ICD',
                 'ID',
                 'IS',
                 'JCC',
                 'LA1',
                 'LA2',
                 'MA',
                 'MO',
                 'MOC',
                 'MOP',
                 'MSG',
                 'NA',
                 'NDL',
                 'NM',
                 'NR',
                 'OCD',
                 'OSD',
                 'OSP',
                 'PIP',
                 'PL',
                 'PLN',
                 'PN',
                 'PPN',
                 'PRL',
                 'PT',
                 'PTA',
                 'QIP',
                 'QSC',
                 'RCD',
                 'RFR',
                 'RI',
                 'RMC',
                 'RP',
                 'RPT',
                 'SAD',
                 'SCV',
                 'SI',
                 'SN',
                 'SNM',
                 'SPD',
                 'SPS',
                 'SRT',
                 'ST',
                 'TM',
                 'TN',
                 'TQ',
                 'TS',
                 'TX',
                 'UVC',
                 'VH',
                 'VID',
                 'VR',
                 'WVI',
                 'WVS',
                 'XAD',
                 'XCN',
                 'XON',
                 'XPN',
                 'XTN')),
    'HL70441': ('Immunization Registry Status',
                ('A',
                 'I',
                 'L',
                 'M',
                 'O',
                 'P',
                 'U')),
    'HL70442': ('Location Service Code',
                ('D',
                 'E',
                 'P',
                 'T')),
    'HL70443': ('Provider Role',
                ('AD',
                 'AI',
                 'AP',
                 'AT',
                 'CLP',
                 'CP',
                 'DP',
                 'EP',
                 'FHCP',
                 'IP',
                 'MDIR',
                 'OP',
                 'PH',
                 'PI',
                 'PP',
                 'RO',
                 'RP',
                 'RT',
                 'TN',
                 'TR',
                 'VP',
                 'VPS',
                 'VTS')),
    'HL70444': ('Name Assembly Order',
                ('F',
                 'G')),
    'HL70445': ('Identity Reliability Code',
                ('AL',
                 'UA',
                 'UD',
                 'US')),
    'HL70446': ('Species Code',
                ()),
    'HL70447': ('Breed Code',
                ()),
    'HL70448': ('Name Context',
                ()),
    'HL70450': ('Event Type',
                ('LOG',
                 'SER')),
    'HL70451': ('Substance Identifier',
                ()),
    'HL70452': ('Health Care Provider Type Code',
                ('SUGGESTION',)),
    'HL70453': ('Health Care Provider Classification',
                ('SUGGESTION',)),
    'HL70454': ('Health Care Provider Area of Specialization',
                ('SUGGESTION',)),
    'HL70455': ('Type of Bill Code',
                ()),
    'HL70456': ('Revenue code',
                ()),
    'HL70457': ('Overall Claim Disposition Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70458': ('OCE Edit Code',
                ('1',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '2',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '3',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35',
                 '36',
                 '37',
                 '38',
                 '39',
                 '4',
                 '40',
                 '41',
                 '42',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9')),
    'HL70459': ('Reimbursement Action Code',
                ('0',
                 '1',
                 '2',
                 '3')),
    'HL70460': ('Denial or Rejection Code',
                ('0',
                 '1',
                 '2')),
    'HL70461': ('License Number',
                ()),
    'HL70462': ('Location Cost Center',
                ()),
    'HL70463': ('Inventory Number',
                ()),
    'HL70464': ('Facility ID',
                ()),
    'HL70465': ('Name/Address Representation',
                ('A',
                 'I',
                 'P')),
    'HL70466': ('Ambulatory Payment Classification Code',
                ('...',
                 '31',
                 '163',
                 '181')),
    'HL70467': ('Modifier Edit Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 'U')),
    'HL70468': ('Payment Adjustment Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70469': ('Packaging Status Code',
                ('0',
                 '1',
                 '2')),
    'HL70470': ('- Reimbursement Type Code',
                ('Crnl',
                 'DME',
                 'EPO',
                 'Lab',
                 'Mamm',
                 'NoPay',
                 'OPPS',
                 'PartH',
                 'Pckg',
                 'Thrpy')),
    'HL70471': ('Query Name',
                ()),
    'HL70472': ('TQ Conjunction ID',
                ('A',
                 'C',
                 'S')),
    'HL70473': ('Formulary Status',
                ('G',
                 'N',
                 'R',
                 'Y')),
    'HL70474': ('Organization Unit Type',
                ('D',
                 'F',
                 'S',
                 'U',
                 'V')),
    'HL70475': ('Charge Type Reason',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70476': ('Medically Necessary Duplicate Procedure Reason',
                ()),
    'HL70477': ('Controlled Substance Schedule*',
                ('I',
                 'II',
                 'III',
                 'IV',
                 'V',
                 'VI')),
    'HL70478': ('Formulary Status',
                ('G',
                 'N',
                 'R',
                 'Y')),
    'HL70479': ('Pharmaceutical Substances',
                ()),
    'HL70480': ('Pharmacy Order Types',
                ('M',
                 'O',
                 'S')),
    'HL70482': ('Order Type',
                ('I',
                 'O')),
    'HL70483': ('Authorization Mode',
                ('EL',
                 'EM',
                 'FX',
                 'IP',
                 'MA',
                 'PA',
                 'PH',
                 'RE',
                 'VC',
                 'VO')),
    'HL70484': ('Dispense Type',
                ('B',
                 'C',
                 'N',
                 'P',
                 'Q',
                 'R',
                 'S',
                 'T',
                 'Z')),
    'HL70485': ('Extended Priority Codes',
                ('A',
                 'C',
                 'P',
                 'PRN',
                 'R',
                 'S',
                 'T',
                 'TD<integer>',
                 'TH<integer>',
                 'TL<integer>',
                 'TM<integer>',
                 'TS<integer>',
                 'TW<integer>')),
    'HL70487': ('Specimen Type',
                ('ABS',
                 'ACNE',
                 'ACNFLD',
                 'AIRS',
                 'ALL',
                 'AMN',
                 'AMP',
                 'ANGI',
                 'ARTC',
                 'ASERU',
                 'ASP',
                 'ATTE',
                 'AUTOA',
                 'AUTOC',
                 'AUTP',
                 'BBL',
                 'BCYST',
                 'BDY',
                 'BIFL',
                 'BITE',
                 'BLD',
                 'BLDA',
                 'BLDCO',
                 'BLDV',
                 'BLEB',
                 'BLIST',
                 'BOIL',
                 'BON',
                 'BOWL',
                 'BPH',
                 'BPU',
                 'BRN',
                 'BRSH',
                 'BRTH',
                 'BRUS',
                 'BUB',
                 'BULLA',
                 'BX',
                 'CALC',
                 'CARBU',
                 'CAT',
                 'CBITE',
                 'CDM',
                 'CLIPP',
                 'CNJT',
                 'CNL',
                 'COL',
                 'CONE',
                 'CSCR',
                 'CSERU',
                 'CSF',
                 'CSITE',
                 'CSMY',
                 'CST',
                 'CSVR',
                 'CTP',
                 'CUR',
                 'CVM',
                 'CVPS',
                 'CVPT',
                 'CYN',
                 'CYST',
                 'DBITE',
                 'DCS',
                 'DEC',
                 'DEION',
                 'DIA',
                 'DIAF',
                 'DISCHG',
                 'DIV',
                 'DRN',
                 'DRNG',
                 'DRNGP',
                 'DUFL',
                 'EARW',
                 'EBRUSH',
                 'EEYE',
                 'EFF',
                 'EFFUS',
                 'EFOD',
                 'EISO',
                 'ELT',
                 'ENVIR',
                 'EOS',
                 'EOTH',
                 'ESOI',
                 'ESOS',
                 'ETA',
                 'ETTP',
                 'ETTUB',
                 'EWHI',
                 'EXG',
                 'EXS',
                 'EXUDTE',
                 'FAW',
                 'FBLOOD',
                 'FGA',
                 'FIB',
                 'FIST',
                 'FLD',
                 'FLT',
                 'FLU',
                 'FLUID',
                 'FOLEY',
                 'FRS',
                 'FSCLP',
                 'FUR',
                 'GAS',
                 'GASA',
                 'GASAN',
                 'GASBR',
                 'GASD',
                 'GAST',
                 'GENL',
                 'GENV',
                 'GRAFT',
                 'GRAFTS',
                 'GRANU',
                 'GROSH',
                 'GSOL',
                 'GSPEC',
                 'GT',
                 'GTUBE',
                 'HAR',
                 'HBITE',
                 'HBLUD',
                 'HEMAQ',
                 'HEMO',
                 'HERNI',
                 'HEV',
                 'HIC',
                 'HYDC',
                 'IBITE',
                 'ICYST',
                 'IDC',
                 'IHG',
                 'ILEO',
                 'ILLEG',
                 'IMP',
                 'INCI',
                 'INFIL',
                 'INS',
                 'INTRD',
                 'ISLT',
                 'IT',
                 'IUD',
                 'IVCAT',
                 'IVFLD',
                 'IVTIP',
                 'JEJU',
                 'JNTFLD',
                 'JP',
                 'KELOI',
                 'KIDFLD',
                 'LAVG',
                 'LAVGG',
                 'LAVGP',
                 'LAVPG',
                 'LENS1',
                 'LENS2',
                 'LESN',
                 'LIQ',
                 'LIQO',
                 'LNA',
                 'LNV',
                 'LSAC',
                 'LYM',
                 'MAC',
                 'MAHUR',
                 'MAR',
                 'MASS',
                 'MBLD',
                 'MEC',
                 'MILK',
                 'MLK',
                 'MUCOS',
                 'MUCUS',
                 'NAIL',
                 'NASDR',
                 'NEDL',
                 'NEPH',
                 'NGASP',
                 'NGAST',
                 'NGS',
                 'NODUL',
                 'NSECR',
                 'ORH',
                 'ORL',
                 'OTH',
                 'PACEM',
                 'PAFL',
                 'PCFL',
                 'PDSIT',
                 'PDTS',
                 'PELVA',
                 'PENIL',
                 'PERIA',
                 'PILOC',
                 'PINS',
                 'PIS',
                 'PLAN',
                 'PLAS',
                 'PLB',
                 'PLC',
                 'PLEVS',
                 'PLR',
                 'PMN',
                 'PND',
                 'POL',
                 'POPGS',
                 'POPLG',
                 'POPLV',
                 'PORTA',
                 'PPP',
                 'PROST',
                 'PRP',
                 'PSC',
                 'PUNCT',
                 'PUS',
                 'PUSFR',
                 'PUST',
                 'QC3',
                 'RANDU',
                 'RBC',
                 'RBITE',
                 'RECT',
                 'RECTA',
                 'RENALC',
                 'RENC',
                 'RES',
                 'SAL',
                 'SCAR',
                 'SCLV',
                 'SCROA',
                 'SECRE',
                 'SER',
                 'SHU',
                 'SHUNF',
                 'SHUNT',
                 'SITE',
                 'SKBP',
                 'SKN',
                 'SMM',
                 'SMN',
                 'SNV',
                 'SPRM',
                 'SPRP',
                 'SPRPB',
                 'SPS',
                 'SPT',
                 'SPTC',
                 'SPTT',
                 'SPUT1',
                 'SPUTIN',
                 'SPUTSP',
                 'STER',
                 'STL',
                 'STONE',
                 'SUBMA',
                 'SUBMX',
                 'SUMP',
                 'SUP',
                 'SUTUR',
                 'SWGZ',
                 'SWT',
                 'TASP',
                 'TEAR',
                 'THRB',
                 'TISS',
                 'TISU',
                 'TLC',
                 'TRAC',
                 'TRANS',
                 'TSERU',
                 'TSTES',
                 'TTRA',
                 'TUBES',
                 'TUMOR',
                 'TZANC',
                 'UDENT',
                 'UMED',
                 'UR',
                 'URC',
                 'URINB',
                 'URINC',
                 'URINM',
                 'URINN',
                 'URINP',
                 'URNS',
                 'URT',
                 'USCOP',
                 'USPEC',
                 'USUB',
                 'VASTIP',
                 'VENT',
                 'VITF',
                 'VOM',
                 'WASH',
                 'WASI',
                 'WAT',
                 'WB',
                 'WBC',
                 'WEN',
                 'WICK',
                 'WND',
                 'WNDA',
                 'WNDD',
                 'WNDE',
                 'WORM',
                 'WRT',
                 'WWA',
                 'WWO',
                 'WWT')),
    'HL70488': ('Specimen Collection Method',
                ('ANP',
                 'BAP',
                 'BCAE',
                 'BCAN',
                 'BCPD',
                 'BIO',
                 'CAP',
                 'CATH',
                 'CVP',
                 'EPLA',
                 'ESWA',
                 'FNA',
                 'KOFFP',
                 'LNA',
                 'LNV',
                 'MARTL',
                 'ML11',
                 'MLP',
                 'NYP',
                 'PACE',
                 'PIN',
                 'PNA',
                 'PRIME',
                 'PUMP',
                 'QC5',
                 'SCLP',
                 'SCRAPS',
                 'SHA',
                 'SWA',
                 'SWD',
                 'TMAN',
                 'TMCH',
                 'TMM4',
                 'TMMY',
                 'TMOT',
                 'TMP',
                 'TMPV',
                 'TMSC',
                 'TMUP',
                 'TMVI',
                 'VENIP',
                 'WOOD')),
    'HL70489': ('Risk Codes',
                ('AGG',
                 'BHZ',
                 'BIO',
                 'COR',
                 'ESC',
                 'EXP',
                 'IFL',
                 'INF',
                 'INJ',
                 'POI',
                 'RAD')),
    'HL70490': ('Specimen Reject Reason',
                ('EX',
                 'QS',
                 'RA',
                 'RB',
                 'RC',
                 'RD',
                 'RE',
                 'RH',
                 'RI',
                 'RM',
                 'RN',
                 'RP',
                 'RR',
                 'RS')),
    'HL70491': ('Specimen Quality',
                ('E',
                 'F',
                 'G',
                 'P')),
    'HL70492': ('Specimen Appropriateness',
                ('A',
                 'I',
                 'P')),
    'HL70493': ('Specimen Condition',
                ('AUT',
                 'CFU',
                 'CLOT',
                 'CON',
                 'COOL',
                 'FROZ',
                 'HEM',
                 'LIVE',
                 'ROOM',
                 'SNR')),
    'HL70494': ('Specimen Child Role',
                ('A',
                 'C',
                 'M')),
    'HL70495': ('Body Site Modifier',
                ('ANT',
                 'BIL',
                 'DIS',
                 'EXT',
                 'L',
                 'LAT',
                 'LLQ',
                 'LOW',
                 'LUQ',
                 'MED',
                 'POS',
                 'PRO',
                 'R',
                 'RLQ',
                 'RUQ',
                 'UPP')),
    'HL70496': ('Consent Type',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35',
                 '36',
                 '37',
                 '38',
                 '39',
                 '40',
                 '41',
                 '42',
                 '43',
                 '44',
                 '45',
                 '46',
                 '47',
                 '48',
                 '49',
                 '50',
                 '51',
                 '52',
                 '53',
                 '54',
                 '55',
                 '56',
                 '57',
                 '58',
                 '59',
                 '60',
                 '61',
                 '62',
                 '63',
                 '64',
                 '65',
                 '66',
                 '67',
                 '68',
                 '69',
                 '70',
                 '71',
                 '72',
                 '73',
                 '74',
                 '75',
                 '76',
                 '77',
                 '78',
                 '79',
                 '80',
                 '81',
                 '82',
                 '83',
                 '84',
                 '85',
                 '86',
                 '87',
                 '88',
                 '89',
                 '90',
                 '91',
                 '92',
                 '93',
                 '94',
                 '95',
                 '96',
                 '97',
                 '98',
                 '99',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '105',
                 '106',
                 '107',
                 '108',
                 '109',
                 '110',
                 '111',
                 '112',
                 '113',
                 '1137',
                 '114',
                 '115',
                 '116',
                 '117',
                 '118',
                 '119',
                 '120',
                 '121',
                 '122',
                 '123',
                 '124',
                 '125',
                 '126',
                 '127',
                 '128',
                 '129',
                 '130',
                 '131',
                 '132',
                 '133',
                 '134',
                 '135',
                 '136')),
    'HL70497': ('Consent Mode',
                ('T',
                 'V',
                 'W')),
    'HL70498': ('Consent Status',
                ('A',
                 'B',
                 'L',
                 'P',
                 'R',
                 'X')),
    'HL70499': ('Consent Bypass Reason',
                ('E',
                 'PJ')),
    'HL70500': ('Consent Disclosure Level',
                ('F',
                 'N',
                 'P')),
    'HL70501': ('Consent Non-Disclosure Reason',
                ('E',
                 'PR',
                 'RX')),
    'HL70502': ('Non-Subject Consenter Reason',
                ('LM',
                 'MIN',
                 'NC')),
    'HL70503': ('Sequence/Results Flag',
                ('C',
                 'R',
                 'S')),
    'HL70504': ('Sequence Condition Code',
                ('EE',
                 'ES',
                 'SE',
                 'SS')),
    'HL70505': ('Cyclic Entry/Exit Indicator',
                ('#',
                 '*')),
    'HL70506': ('Service Request Relationship',
                ('C',
                 'E',
                 'N',
                 'S',
                 'T')),
    'HL70507': ('Observation Result Handling',
                ('A',
                 'F',
                 'N')),
    'HL70508': ('Blood Product Processing Requirements',
                ('AU',
                 'CM',
                 'CS',
                 'DI',
                 'FR',
                 'HB',
                 'HL',
                 'IG',
                 'IR',
                 'LR',
                 'WA')),
    'HL70509': ('Indication for Use',
                ()),
    'HL70510': ('Blood Product Dispense Status',
                ('CR',
                 'DS',
                 'PT',
                 'RA',
                 'RD',
                 'RE',
                 'RI',
                 'RL',
                 'RQ',
                 'RS',
                 'WA')),
    'HL70511': ('BP Observation Status Codes Interpretation',
                ('C',
                 'D',
                 'F',
                 'O',
                 'P',
                 'W')),
    'HL70512': ('Commercial Product',
                ()),
    'HL70513': ('Blood Product Transfusion/Disposition Status',
                ('RA',
                 'RL',
                 'TR',
                 'TX',
                 'WA')),
    'HL70514': ('Transfusion Adverse Reaction',
                ('ABOINC',
                 'ACUTHEHTR',
                 'ALLERGIC1',
                 'ALLERGIC2',
                 'ALLERGICR',
                 'ANAPHYLAC',
                 'BACTCONTAM',
                 'DELAYEDHTR',
                 'DELAYEDSTR',
                 'GVHD',
                 'HYPOTENS',
                 'NONHTR1',
                 'NONHTR2',
                 'NONHTRREC',
                 'NONIMMUNE',
                 'NONSPEC',
                 'NORXN',
                 'PTP',
                 'VOLOVER')),
    'HL70515': ('Transfusion Interrupted Reason',
                ()),
    'HL70516': ('Error Severity',
                ('E',
                 'F',
                 'I',
                 'W')),
    'HL70517': ('Inform Person Code',
                ('HD',
                 'NPAT',
                 'PAT',
                 'USR')),
    'HL70518': ('Override Type',
                ('EQV',
                 'EXTN',
                 'INLV')),
    'HL70519': ('Override Reason',
                ()),
    'HL70520': ('Message Waiting Priority',
                ('H',
                 'L',
                 'M')),
    'HL70521': ('Override Code',
                ()),
    'HL70523': ('Computation Type',
                ('%',
                 'a')),
    'HL70525': ('Privilege',
                ()),
    'HL70526': ('Privilege Class',
                ()),
    'HL70527': ('Calendar Alignment',
                ('DM',
                 'DW',
                 'DY',
                 'HD',
                 'MY',
                 'NH',
                 'SN',
                 'WY')),
    'HL70528': ('Event Related Period',
                ('AC',
                 'ACD',
                 'ACM',
                 'ACV',
                 'HS',
                 'IC',
                 'ICD',
                 'ICM',
                 'ICV',
                 'PC',
                 'PCD',
                 'PCM',
                 'PCV')),
    'HL70530': ('Organization, Agency, Department',
                ('AE',
                 'DEA',
                 'DOD',
                 'MC',
                 'VA',
                 'VI')),
    'HL70531': ('Institution',
                ()),
    'HL70532': ('Expanded Yes/no Indicator',
                ('ASKU',
                 'N',
                 'NA',
                 'NASK',
                 'NAV',
                 'NI',
                 'NP',
                 'UNK',
                 'Y')),
    'HL70533': ('Application Error Code',
                ()),
    'HL70534': ('Notify Clergy Code',
                ('L',
                 'N',
                 'O',
                 'U',
                 'Y')),
    'HL70535': ('Signature Code',
                ('C',
                 'M',
                 'P',
                 'S')),
    'HL70536': ('Certificate Status',
                ('E',
                 'I',
                 'P',
                 'R',
                 'V')),
    'HL70537': ('Institution',
                ()),
    'HL70538': ('Institution Relationship Type',
                ('CON',
                 'CST',
                 'EMP',
                 'VOL')),
    'HL70539': ('Cost Center Code',
                ()),
    'HL70540': ('Inactive Reason Code',
                ('L',
                 'R',
                 'T')),
    'HL70541': ('Specimen Type Modifier',
                ()),
    'HL70542': ('Specimen Source Type Modifier',
                ()),
    'HL70543': ('Specimen Collection Site',
                ()),
    'HL70544': ('Container Condition',
                ('CC',
                 'CL',
                 'CT',
                 'SB',
                 'XAMB',
                 'XC37',
                 'XCAMB',
                 'XCATM',
                 'XCFRZ',
                 'XCREF',
                 'XDFRZ',
                 'XDRY',
                 'XFRZ',
                 'XMTLF',
                 'XNTR',
                 'XPRTL',
                 'XPSA',
                 'XPSO',
                 'XREF',
                 'XUFRZ',
                 'XUPR')),
    'HL70547': ('Jurisdictional Breadth',
                ('C',
                 'N',
                 'S')),
    'HL70548': ('Signatory\'s Relationship to Subject',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7')),
    'HL70549': ('NDC Codes',
                ()),
    'HL70550': ('Body Parts',
                ('\u00c2\u00a0',
                 'ACET',
                 'ACHIL',
                 'ADB',
                 'ADE',
                 'ADR',
                 'AMN',
                 'AMS',
                 'ANAL',
                 'ANKL',
                 'ANTEC',
                 'ANTECF',
                 'ANTR',
                 'ANUS',
                 'AORTA',
                 'APDX',
                 'AR',
                 'AREO',
                 'ARM',
                 'ARTE',
                 'ASCIT',
                 'ASCT',
                 'ATR',
                 'AURI',
                 'AV',
                 'AXI',
                 'BACK',
                 'BARTD',
                 'BARTG',
                 'BCYS',
                 'BDY',
                 'BID',
                 'BIFL',
                 'BLAD',
                 'BLD',
                 'BLDA',
                 'BLDC',
                 'BLDV',
                 'BLOOD',
                 'BMAR',
                 'BON',
                 'BOWEL',
                 'BOWLA',
                 'BOWSM',
                 'BPH',
                 'BRA',
                 'BRAIN',
                 'BRO',
                 'BROCH',
                 'BRONC',
                 'BROW',
                 'BRST',
                 'BRSTFL',
                 'BRTGF',
                 'BRV',
                 'BUCCA',
                 'BURSA',
                 'BURSF',
                 'BUTT',
                 'CALF',
                 'CANAL',
                 'CANLI',
                 'CANTH',
                 'CARO',
                 'CARP',
                 'CAVIT',
                 'CBLD',
                 'CDM',
                 'CDUCT',
                 'CECUM',
                 'CERVUT',
                 'CHE',
                 'CHEEK',
                 'CHES',
                 'CHEST\u00c2\u00a0',
                 'CHIN',
                 'CIRCU',
                 'CLAVI',
                 'CLIT',
                 'CLITO',
                 'CNL',
                 'COCCG',
                 'COCCY',
                 'COLON',
                 'COLOS',
                 'CONJ',
                 'COR',
                 'CORAL',
                 'CORD',
                 'CORN',
                 'COS',
                 'CRANE',
                 'CRANF',
                 'CRANO',
                 'CRANP',
                 'CRANS',
                 'CRANT',
                 'CSF',
                 'CUBIT',
                 'CUFF',
                 'CULD',
                 'CULDO',
                 'CVX',
                 'DELT',
                 'DEN',
                 'DENTA',
                 'DIAF',
                 'DIGIT',
                 'DISC',
                 'DORS',
                 'DPH',
                 'DUFL',
                 'DUODE',
                 'DUR',
                 'EAR',
                 'EARBI',
                 'EARBM',
                 'EARBS',
                 'EARLO',
                 'EC',
                 'ELBOW',
                 'ELBOWJ',
                 'ENDC',
                 'ENDM',
                 'EOLPH',
                 'EOS',
                 'EPD',
                 'EPICA',
                 'EPICM',
                 'EPIDU',
                 'EPIGL',
                 'ESO',
                 'ESOPG',
                 'ET',
                 'ETHMO',
                 'EUR',
                 'EYE',
                 'EYELI',
                 'FACE',
                 'FALLT',
                 'FBINC',
                 'FBLAC',
                 'FBMAX',
                 'FBNAS',
                 'FBPAL',
                 'FBVOM',
                 'FBZYG',
                 'FEMOR',
                 'FEMUR',
                 'FET',
                 'FIBU',
                 'FING',
                 'FINGN',
                 'FMH',
                 'FOL',
                 'FOOT',
                 'FOREA',
                 'FOREH',
                 'FORES',
                 'FOURC',
                 'GB',
                 'GEN',
                 'GENC',
                 'GENL',
                 'GL',
                 'GLAND',
                 'GLANS',
                 'GLUT',
                 'GLUTE',
                 'GLUTM',
                 'GROIN',
                 'GUM',
                 'GVU',
                 'HAL',
                 'HAND',
                 'HAR',
                 'HART',
                 'HEAD',
                 'HEEL',
                 'HEM',
                 'HIP',
                 'HIPJ',
                 'HUMER',
                 'HV',
                 'HVB',
                 'HVT',
                 'HYMEN',
                 'ICX',
                 'ILC',
                 'ILCON',
                 'ILCR',
                 'ILE',
                 'ILEOS',
                 'ILEUM',
                 'ILIAC',
                 'INASA',
                 'INGUI',
                 'INSTL',
                 'INSTS',
                 'INT',
                 'INTRO',
                 'INTRU',
                 'ISCHI',
                 'ISH',
                 'JAW',
                 'JUGI',
                 'KIDN\u00c2\u00a0',
                 'KNEE',
                 'KNEEF',
                 'KNEEJ',
                 'LABIA',
                 'LABMA',
                 'LABMI',
                 'LACRI',
                 'LAM',
                 'LARYN',
                 'LEG',
                 'LENS',
                 'LING',
                 'LINGU',
                 'LIP',
                 'LIVER',
                 'LMN',
                 'LN',
                 'LNG',
                 'LOBE',
                 'LOCH',
                 'LUMBA',
                 'LUNG',
                 'LYM',
                 'MAC',
                 'MALLE',
                 'MANDI',
                 'MAR',
                 'MAST',
                 'MAXIL',
                 'MAXS',
                 'MEATU',
                 'MEC',
                 'MEDST',
                 'MEDU',
                 'METAC',
                 'METAT',
                 'MILK',
                 'MITRL',
                 'MOLAR',
                 'MONSU',
                 'MONSV',
                 'MOU',
                 'MOUTH',
                 'MP',
                 'MPB',
                 'MRSA2',
                 'MYO',
                 'NAIL',
                 'NAILB',
                 'NAILF',
                 'NAILT',
                 'NARES',
                 'NASL',
                 'NAVEL',
                 'NECK',
                 'NERVE',
                 'NIPPL',
                 'NLACR',
                 'NOS',
                 'NOSE',
                 'NOSTR',
                 'NP',
                 'NSS',
                 'NTRAC',
                 'OCCIP',
                 'OLECR',
                 'OMEN',
                 'ORBIT',
                 'ORO',
                 'OSCOX',
                 'OVARY',
                 'PAFL',
                 'PALAT',
                 'PALM',
                 'PANAL',
                 'PANCR',
                 'PARAT',
                 'PARIE',
                 'PARON',
                 'PAROT',
                 'PAS',
                 'PATEL',
                 'PCARD',
                 'PCLIT',
                 'PELV',
                 'PENIS',
                 'PENSH',
                 'PER',
                 'PERI',
                 'PERIH',
                 'PERIN',
                 'PERIS',
                 'PERIT',
                 'PERIU',
                 'PERIV',
                 'PERRA',
                 'PERT',
                 'PHALA',
                 'PILO',
                 'PINNA',
                 'PLACF',
                 'PLACM',
                 'PLANT',
                 'PLATH',
                 'PLATS',
                 'PLC',
                 'PLEU',
                 'PLEUR',
                 'PLR',
                 'PNEAL',
                 'PNEPH',
                 'PNM',
                 'POPLI',
                 'PORBI',
                 'PREAU',
                 'PRERE',
                 'PROS',
                 'PRST',
                 'PTONS',
                 'PUBIC',
                 'PUL',
                 'RADI',
                 'RADIUS',
                 'RBC',
                 'RECTL',
                 'RECTU',
                 'RENL',
                 'RIB',
                 'RNP',
                 'RPERI',
                 'SAC',
                 'SACIL',
                 'SACRA',
                 'SACRO',
                 'SACRU',
                 'SALGL',
                 'SCALP',
                 'SCAPU',
                 'SCLAV',
                 'SCLER',
                 'SCLV',
                 'SCROT',
                 'SDP',
                 'SEM',
                 'SEMN',
                 'SEPTU',
                 'SEROM',
                 'SGF',
                 'SHIN',
                 'SHOL',
                 'SHOLJ',
                 'SIGMO',
                 'SINUS',
                 'SKENE',
                 'SKM',
                 'SKULL',
                 'SOLE',
                 'SPCOR',
                 'SPHEN',
                 'SPLN',
                 'SPRM',
                 'SPX',
                 'STER',
                 'STOM',
                 'STOMA',
                 'STOOLL',
                 'STUMP',
                 'SUB',
                 'SUBD',
                 'SUBM',
                 'SUBME',
                 'SUBPH',
                 'SUBX',
                 'SUPB',
                 'SUPRA',
                 'SWT',
                 'SWTG',
                 'SYN',
                 'SYNOL',
                 'SYNOV',
                 'TARS',
                 'TBRON',
                 'TCN',
                 'TDUCT',
                 'TEAR',
                 'TEMPL',
                 'TEMPO',
                 'TESTI',
                 'THIGH',
                 'THM',
                 'THORA',
                 'THRB',
                 'THUMB',
                 'THYRD',
                 'TIBIA',
                 'TML',
                 'TNL',
                 'TOE',
                 'TOEN',
                 'TONG',
                 'TONS',
                 'TOOTH',
                 'TRCHE',
                 'TSK',
                 'ULNA',
                 'UMB',
                 'UMBL',
                 'URET',
                 'URTH',
                 'USTOM',
                 'UTER',
                 'UTERI',
                 'VAGIN',
                 'VAL',
                 'VAS',
                 'VASTL',
                 'VAULT',
                 'VCSF',
                 'VCUFF',
                 'VEIN',
                 'VENTG',
                 'VERMI',
                 'VERTC',
                 'VERTL',
                 'VERTT',
                 'VESCL',
                 'VESFLD',
                 'VESI',
                 'VESTI',
                 'VGV',
                 'VITR',
                 'VOC',
                 'VULVA',
                 'WBC',
                 'WRIST')),
    'HL70552': ('Advanced Beneficiary Notice Override Reason',
                ()),
    'HL70553': ('Invoice Control Code',
                ('AA',
                 'AI',
                 'CA',
                 'CG',
                 'CL',
                 'CN',
                 'CP',
                 'CQ',
                 'EA',
                 'OA',
                 'OR',
                 'PA',
                 'PD',
                 'RA',
                 'RC',
                 'RU',
                 'SA')),
    'HL70554': ('Invoice Reason Codes',
                ('LATE',
                 'NORM',
                 'SUB')),
    'HL70555': ('Invoice Type',
                ('BK',
                 'FN',
                 'FS',
                 'GP',
                 'IN',
                 'NP',
                 'PA',
                 'SL',
                 'SS',
                 'SU')),
    'HL70556': ('Benefit Group',
                ('AMB',
                 'DENT')),
    'HL70557': ('Payee Type',
                ('EMPL',
                 'ORG',
                 'PERS',
                 'PPER')),
    'HL70558': ('Payee Relationship to Invoice',
                ('FM',
                 'GT',
                 'PT',
                 'SB')),
    'HL70559': ('Product/Service Status',
                ('D',
                 'P',
                 'R')),
    'HL70560': ('Quantity Units',
                ('DY',
                 'FL',
                 'HS',
                 'MN',
                 'YY')),
    'HL70561': ('Product/Services Clarification Codes',
                ('CLCTR',
                 'DGAPP',
                 'DTCTR',
                 'ENC',
                 'GFTH',
                 'OOP',
                 'SEQ')),
    'HL70562': ('Processing Consideration Codes',
                ('DFADJ',
                 'EFORM',
                 'FAX',
                 'PAPER',
                 'PYRDELAY',
                 'RTADJ')),
    'HL70564': ('Adjustment Category Code',
                ('EA',
                 'IN',
                 'PA',
                 'PR')),
    'HL70565': ('Provider Adjustment Reason Code',
                ('DISP',
                 'GST',
                 'HST',
                 'MKUP',
                 'PST')),
    'HL70566': ('Blood Unit Type',
                ('GRN',
                 'LYM',
                 'PLS',
                 'PLT',
                 'PSC',
                 'RBC',
                 'WBL')),
    'HL70567': ('Weight Units',
                ('(lb_av)',
                 '(oz_av)',
                 'g',
                 'kg')),
    'HL70568': ('Volume Units',
                ('(pt_us)',
                 'l',
                 'ml')),
    'HL70569': ('Adjustment Action',
                ('EOB',
                 'PAT',
                 'PRO')),
    'HL70570': ('Payment Method Code',
                ('CASH',
                 'CCCA',
                 'CCHK',
                 'CDAC',
                 'CHCK',
                 'DDPO',
                 'DEBC',
                 'SWFT',
                 'TRAC',
                 'VISN')),
    'HL70571': ('Invoice Processing Results Status',
                ('ACK',
                 'ADJ',
                 'ADJSUB',
                 'ADJZER',
                 'PAID',
                 'PEND',
                 'PRED',
                 'REJECT')),
    'HL70572': ('Tax status',
                ('RVAT',
                 'UVAT')),
    'HL70615': ('User Authentication Credential Type Code',
                ('KERB',
                 'SAML')),
    'HL70616': ('Address Expiration Reason',
                ('C',
                 'E',
                 'M',
                 'R')),
    'HL70617': ('Address Usage',
                ('C',
                 'M',
                 'V')),
    'HL70618': ('Protection Code',
                ('LI',
                 'UL',
                 'UP')),
    'HL70625': ('Item Status Codes',
                ('1',
                 '2',
                 '3')),
    'HL70634': ('Item Importance Codes',
                ()),
    'HL70642': ('Reorder Theory Codes',
                ('D',
                 'M',
                 'O')),
    'HL70651': ('Labor Calculation Type',
                ('CST',
                 'TME')),
    'HL70653': ('Date Format',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6')),
    'HL70657': ('Device Type',
                ('1',
                 '2',
                 '3')),
    'HL70659': ('Lot Control',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70667': ('Device Data State',
                ('0',
                 '1')),
    'HL70669': ('Load Status',
                ('LCC',
                 'LCN',
                 'LCP',
                 'LLD')),
    'HL70682': ('Device Status',
                ('0',
                 '1')),
    'HL70702': ('Cycle Type',
                ('2RS',
                 'ANR',
                 'BDP',
                 'BWD',
                 'CMW',
                 'COD',
                 'CRT',
                 'DEC',
                 'DRT',
                 'DRW',
                 'EOH',
                 'EOL',
                 'EXP',
                 'FLS',
                 'GLS',
                 'GNP',
                 'GRV',
                 'GTL',
                 'ISO',
                 'IST',
                 'LKT',
                 'LQD',
                 'OPW',
                 'PEA',
                 'PLA',
                 'PRV',
                 'RNS',
                 'SFP',
                 'THR',
                 'TRB',
                 'UTL',
                 'WFP')),
    'HL70717': ('Access Restriction Value',
                ('ALL',
                 'DEM',
                 'DRG',
                 'HIV',
                 'LOC',
                 'NO',
                 'OI',
                 'OO',
                 'PID-17',
                 'PID-7',
                 'PSY',
                 'SMD',
                 'STD')),
    'HL70719': ('Access Restriction Reason Code',
                ('DIA',
                 'EMP',
                 'ORG',
                 'PAT',
                 'PHY',
                 'REG',
                 'VIP')),
    'HL70725': ('Mood Codes',
                ('APT',
                 'ARQ',
                 'E.g. Use in Care Plans,',
                 'EVN',
                 'EVN.CRT',
                 'EXP',
                 'INT',
                 'PRMS',
                 'PRP',
                 'RQO',
                 'Similar uses of above moods ma')),
    'HL70728': ('CCL Value',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70731': ('DRG Diagnosis Determination Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70734': ('Grouper Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9')),
    'HL70739': ('DRG Status Patient',
                ('1',
                 '2',
                 '3')),
    'HL70742': ('DRG Status Financial Calculation',
                ('0',
                 '1',
                 '3',
                 '4',
                 '5',
                 '10',
                 '11')),
    'HL70749': ('DRG Grouping Status',
                ('0',
                 '1',
                 '2',
                 '3')),
    'HL70755': ('Status Weight At Birth',
                ('0',
                 '1',
                 '2')),
    'HL70757': ('DRG Status Respiration Minutes',
                ('0',
                 '1',
                 '2')),
    'HL70759': ('Status Admission',
                ('0',
                 '1',
                 '2',
                 '3')),
    'HL70761': ('DRG Procedure Determination Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70763': ('DRG Procedure Relevance',
                ('0',
                 '1',
                 '2')),
    'HL70771': ('Resource Type or Category',
                ()),
    'HL70776': ('Item Status',
                ('A',
                 'I',
                 'P')),
    'HL70778': ('Item Type',
                ('EQP',
                 'IMP',
                 'MED',
                 'SUP',
                 'TDC')),
    'HL70790': ('Approving Regulatory Agency',
                ('AMA',
                 'FDA')),
    'HL70793': ('Ruling Act',
                ('SMDA',)),
    'HL70806': ('Sterilization Type',
                ('EOG',
                 'PCA',
                 'STM')),
    'HL70809': ('Maintenance Cycle',
                ()),
    'HL70811': ('Maintenance Type',
                ()),
    'HL70818': ('Package',
                ('BX',
                 'CS',
                 'EA',
                 'SET')),
    'HL70834': ('MIME Types',
                ('application',
                 'audio',
                 'image',
                 'model',
                 'multipart',
                 'text',
                 'video')),
    'HL70836': ('Problem Severity',
                ()),
    'HL70838': ('Problem Perspective',
                ()),
    'HL70865': ('Referral Documentation Completion Status',
                ()),
    'HL70868': ('Telecommunication Expiration Reason',
                ('C',
                 'E',
                 'M',
                 'N',
                 'R')),
    'HL70871': ('Supply Risk Codes',
                ('COR',
                 'EXP',
                 'FLA',
                 'INJ',
                 'RAD',
                 'TOX',
                 'UNK')),
    'HL70879': ('Product/Service Code',
                ()),
    'HL70880': ('Product/Service Code Modifier',
                ()),
    'HL70881': ('Role Executing Physician',
                ('B',
                 'P',
                 'T')),
    'HL70882': ('Medical Role Executing Physician',
                ('E',
                 'SE')),
    'HL70894': ('Side of body',
                ('L',
                 'R')),
    'HL70895': ('Present On Admission (POA) Indicator',
                ('E',
                 'N',
                 'U',
                 'W',
                 'Y')),
    'HL70904': ('Security Check Scheme',
                ('BCV',
                 'CCS',
                 'VID')),
    'HL70905': ('Shipment Status',
                ('INV',
                 'ONH',
                 'PRC',
                 'REJ',
                 'TRN',
                 'TTL')),
    'HL70906': ('ActPriority',
                ('A',
                 'CR',
                 'CS',
                 'CSP',
                 'CSR',
                 'EL',
                 'EM',
                 'P',
                 'PRN',
                 'R',
                 'RR',
                 'S',
                 'T',
                 'UD',
                 'UR')),
    'HL70907': ('Confidentiality',
                ('B',
                 'C',
                 'D',
                 'ETH',
                 'HIV',
                 'I',
                 'L',
                 'N',
                 'PSY',
                 'R',
                 'S',
                 'SDV',
                 'T',
                 'V')),
    'HL70908': ('Package Type',
                ()),
    'HL70909': ('Patient Results Release Categorization Scheme',
                ('SID',
                 'SIDC',
                 'SIMM',
                 'STBD',
                 'SWNL',
                 'SWTH')),
    'HL70910': ('Acquisition Modality',
                ()),
    'HL70912': ('Participation',
                ('AD',
                 'AI',
                 'AP',
                 'ARI',
                 'AT',
                 'AUT',
                 'CP',
                 'DP',
                 'EP',
                 'EQUIP',
                 'FHCP',
                 'MDIR',
                 'OP',
                 'OS',
                 'PB',
                 'PH',
                 'PI',
                 'PO',
                 'POMD',
                 'PP',
                 'PRI',
                 'RCT',
                 'RO',
                 'RP',
                 'RT',
                 'SB',
                 'SC',
                 'TN',
                 'TR',
                 'VP',
                 'VPS',
                 'VTS',
                 'WAY',
                 'WAYR')),
    'HL70913': ('Monetary Denomination Code',
                ()),
    'HL70914': ('Root Cause',
                ('AP',
                 'IM',
                 'L',
                 'NA',
                 'PD')),
    'HL70915': ('Process Control Code',
                ()),
    'HL70916': ('Relevant Clincial Information',
                ('F',
                 'NF',
                 'NG')),
    'HL70917': ('Bolus Type',
                ('C',
                 'L')),
    'HL70918': ('PCA Type', ()),
    'HL70919': ('Exclusive Test',
                ('D',
                 'N',
                 'Y')),
    'HL70920': ('Preferred Specimen/Attribute Status',
                ('A',
                 'P')),
    'HL70921': ('Certification Type Code',
                ('ADM',
                 'PROC',
                 'SERV')),
    'HL70922': ('Certification Category Code',
                ('IR',
                 'RA',
                 'RE')),
    'HL70923': ('Process Interruption',
                ('ABR',
                 'NIN',
                 'WOT')),
    'HL70924': ('Cumulative Dosage Limit UoM',
                ('A',
                 'D',
                 'M',
                 'O',
                 'PL',
                 'WK')),
    'HL70925': ('Phlebotomy Issue',
                ('ACN',
                 'CLT',
                 'COL',
                 'DAK',
                 'DBG',
                 'DMT',
                 'DND',
                 'INF',
                 'IPF',
                 'MIS',
                 'NAD',
                 'PFL',
                 'VSM')),
    'HL70926': ('Phlebotomy Status',
                ('NDR',
                 'SUC',
                 'UL5')),
    'HL70927': ('Arm Stick',
                ('B',
                 'L',
                 'R')),
    'HL70929': ('Weight Units',
                ('(lb_av)',
                 '(oz_av)',
                 'g',
                 'kg')),
    'HL70930': ('Volume Units',
                ('(pt_us)',
                 'l',
                 'ml')),
    'HL70931': ('Temperature Units',
                ('Cel',
                 'degF')),
    'HL70932': ('Donation Duration Units',
                ('min',
                 's')),
    'HL70933': ('Intended Procedure Type',
                ('2RC',
                 'GRN',
                 'HEM',
                 'HPC',
                 'LYM',
                 'PLS',
                 'PLT',
                 'PNP',
                 'PNR',
                 'PPR',
                 'THA',
                 'THW',
                 'WBL')),
    'HL70934': ('Order Workflow Profile',
                ()),
    'HL70935': ('Process Interruption Reason',
                ('ASC',
                 'BSC',
                 'CFT',
                 'DBB',
                 'DCW',
                 'DNI',
                 'GFE',
                 'NRG',
                 'PCD')),
    'HL70936': ('Observation Type',
                ('QST',
                 'RSLT',
                 'SCI')),
    'HL70937': ('Observation Sub-Type',
                ('AOE',
                 'ASC',
                 'MIR',
                 'MIRM',
                 'MNIR',
                 'SUP',
                 'SUR',
                 'UNSP')),
    'HL70938': ('Collection Event/Process Step Limit',
                ('DRW',
                 'ORD')),
    'HL70939': ('Communication Location',
                ('DG1-3',
                 'NK1-11',
                 'NK1-13',
                 'NK1-28',
                 'NK1-35',
                 'OBR-13',
                 'OBR-16',
                 'OBR-49',
                 'OBR-OBX',
                 'PID-11',
                 'PID-13',
                 'PID-14',
                 'PID-3',
                 'PID-40',
                 'PID-5',
                 'PID-6',
                 'PID-7',
                 'PRT-5',
                 'SPM-4',
                 'SPM-8',
                 'SPM-OBX')),
    'HL70940': ('Limitation Type Codes',
                ('FLDP',
                 'LCP',
                 'NFDA',
                 'NT')),
    'HL70941': ('Procedure Code',
                ())}
