# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2018, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

TABLES = {
    'HL70001': ('Administrative Sex',
                ('A',
                 'F',
                 'M',
                 'N',
                 'O',
                 'U')),
    'HL70002': ('Marital Status',
                ('A',
                 'B',
                 'C',
                 'D',
                 'E',
                 'G',
                 'I',
                 'M',
                 'N',
                 'O',
                 'P',
                 'R',
                 'S',
                 'T',
                 'U',
                 'W')),
    'HL70003': ('Event type',
                ('A01',
                 'A02',
                 'A03',
                 'A04',
                 'A05',
                 'A06',
                 'A07',
                 'A08',
                 'A09',
                 'A10',
                 'A11',
                 'A12',
                 'A13',
                 'A14',
                 'A15',
                 'A16',
                 'A17',
                 'A18',
                 'A19',
                 'A20',
                 'A21',
                 'A22',
                 'A23',
                 'A24',
                 'A25',
                 'A26',
                 'A27',
                 'A28',
                 'A29',
                 'A30',
                 'A31',
                 'A32',
                 'A33',
                 'A34',
                 'A35',
                 'A36',
                 'A37',
                 'A38',
                 'A39',
                 'A40',
                 'A41',
                 'A42',
                 'A43',
                 'A44',
                 'A45',
                 'A46',
                 'A47',
                 'A48',
                 'A49',
                 'A50',
                 'A51',
                 'A52',
                 'A53',
                 'A54',
                 'A55',
                 'A60',
                 'A61',
                 'A62',
                 'B01',
                 'B02',
                 'B03',
                 'B04',
                 'B05',
                 'B06',
                 'B07',
                 'B08',
                 'C01',
                 'C02',
                 'C03',
                 'C04',
                 'C05',
                 'C06',
                 'C07',
                 'C08',
                 'C09',
                 'C10',
                 'C11',
                 'C12',
                 'CNQ',
                 'I01',
                 'I02',
                 'I03',
                 'I04',
                 'I05',
                 'I06',
                 'I07',
                 'I08',
                 'I09',
                 'I10',
                 'I11',
                 'I12',
                 'I13',
                 'I14',
                 'I15',
                 'J01',
                 'J02',
                 'K11',
                 'K13',
                 'K15',
                 'K21',
                 'K22',
                 'K23',
                 'K24',
                 'K25',
                 'M01',
                 'M02',
                 'M03',
                 'M04',
                 'M05',
                 'M06',
                 'M07',
                 'M08',
                 'M09',
                 'M10',
                 'M11',
                 'M12',
                 'M13',
                 'M14',
                 'M15',
                 'N01',
                 'N02',
                 'O01',
                 'O02',
                 'O03',
                 'O04',
                 'O05',
                 'O06',
                 'O07',
                 'O08',
                 'O09',
                 'O10',
                 'O11',
                 'O12',
                 'O13',
                 'O14',
                 'O15',
                 'O16',
                 'O17',
                 'O18',
                 'O19',
                 'O20',
                 'O21',
                 'O22',
                 'O23',
                 'O24',
                 'O25',
                 'O26',
                 'O27',
                 'O28',
                 'O29',
                 'O30',
                 'O31',
                 'O32',
                 'O33',
                 'O34',
                 'O35',
                 'O36',
                 'P01',
                 'P02',
                 'P03',
                 'P04',
                 'P05',
                 'P06',
                 'P07',
                 'P08',
                 'P09',
                 'P10',
                 'P11',
                 'P12',
                 'PC1',
                 'PC2',
                 'PC3',
                 'PC4',
                 'PC5',
                 'PC6',
                 'PC7',
                 'PC8',
                 'PC9',
                 'PCA',
                 'PCB',
                 'PCC',
                 'PCD',
                 'PCE',
                 'PCF',
                 'PCG',
                 'PCH',
                 'PCJ',
                 'PCK',
                 'PCL',
                 'Q01',
                 'Q02',
                 'Q03',
                 'Q04',
                 'Q05',
                 'Q06',
                 'Q07',
                 'Q08',
                 'Q09',
                 'Q11',
                 'Q13',
                 'Q15',
                 'Q16',
                 'Q17',
                 'Q21',
                 'Q22',
                 'Q23',
                 'Q24',
                 'Q25',
                 'Q26',
                 'Q27',
                 'Q28',
                 'Q29',
                 'Q30',
                 'R01',
                 'R02',
                 'R03',
                 'R04',
                 'R07',
                 'R08',
                 'R09',
                 'R21',
                 'R22',
                 'R23',
                 'R24',
                 'R30',
                 'R31',
                 'R32',
                 'ROR',
                 'S01',
                 'S02',
                 'S03',
                 'S04',
                 'S05',
                 'S06',
                 'S07',
                 'S08',
                 'S09',
                 'S10',
                 'S11',
                 'S12',
                 'S13',
                 'S14',
                 'S15',
                 'S16',
                 'S17',
                 'S18',
                 'S19',
                 'S20',
                 'S21',
                 'S22',
                 'S23',
                 'S24',
                 'S25',
                 'S26',
                 'T01',
                 'T02',
                 'T03',
                 'T04',
                 'T05',
                 'T06',
                 'T07',
                 'T08',
                 'T09',
                 'T10',
                 'T11',
                 'T12',
                 'U01',
                 'U02',
                 'U03',
                 'U04',
                 'U05',
                 'U06',
                 'U07',
                 'U08',
                 'U09',
                 'U10',
                 'U11',
                 'U12',
                 'U13',
                 'V01',
                 'V02',
                 'V03',
                 'V04',
                 'Varies',
                 'W01',
                 'W02')),
    'HL70004': ('Patient Class',
                ('B',
                 'C',
                 'E',
                 'I',
                 'N',
                 'O',
                 'P',
                 'R',
                 'U')),
    'HL70005': ('Race',
                ('...',
                 '1002-5',
                 '2028-9',
                 '2054-5',
                 '2076-8',
                 '2106-3',
                 '2131-1')),
    'HL70006': ('Religion',
                ('ABC',
                 'AGN',
                 'AME',
                 'AMT',
                 'ANG',
                 'AOG',
                 'ATH',
                 'BAH',
                 'BAP',
                 'BMA',
                 'BOT',
                 'BTA',
                 'BTH',
                 'BUD',
                 'CAT',
                 'CFR',
                 'CHR',
                 'CHS',
                 'CMA',
                 'CNF',
                 'COC',
                 'COG',
                 'COI',
                 'COL',
                 'COM',
                 'COP',
                 'COT',
                 'CRR',
                 'EOT',
                 'EPI',
                 'ERL',
                 'EVC',
                 'FRQ',
                 'FWB',
                 'GRE',
                 'HIN',
                 'HOT',
                 'HSH',
                 'HVA',
                 'JAI',
                 'JCO',
                 'JEW',
                 'JOR',
                 'JOT',
                 'JRC',
                 'JRF',
                 'JRN',
                 'JWN',
                 'LMS',
                 'LUT',
                 'MEN',
                 'MET',
                 'MOM',
                 'MOS',
                 'MOT',
                 'MSH',
                 'MSU',
                 'NAM',
                 'NAZ',
                 'NOE',
                 'NRL',
                 'ORT',
                 'OTH',
                 'PEN',
                 'PRC',
                 'PRE',
                 'PRO',
                 'QUA',
                 'REC',
                 'REO',
                 'SAA',
                 'SEV',
                 'SHN',
                 'SIK',
                 'SOU',
                 'SPI',
                 'UCC',
                 'UMD',
                 'UNI',
                 'UNU',
                 'VAR',
                 'WES',
                 'WMC')),
    'HL70007': ('Admission Type',
                ('A',
                 'C',
                 'E',
                 'L',
                 'N',
                 'R',
                 'U')),
    'HL70008': ('Acknowledgment code',
                ('AA',
                 'AE',
                 'AR',
                 'CA',
                 'CE',
                 'CR')),
    'HL70009': ('Ambulatory Status',
                ('A0',
                 'A1',
                 'A2',
                 'A3',
                 'A4',
                 'A5',
                 'A6',
                 'A7',
                 'A8',
                 'A9',
                 'B1',
                 'B2',
                 'B3',
                 'B4',
                 'B5',
                 'B6')),
    'HL70017': ('Transaction Type',
                ('AJ',
                 'CD',
                 'CG',
                 'CO',
                 'PY')),
    'HL70023': ('Admit Source',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9')),
    'HL70027': ('Priority',
                ('A',
                 'P',
                 'R',
                 'S',
                 'T')),
    'HL70038': ('Order status',
                ('A',
                 'CA',
                 'CM',
                 'DC',
                 'ER',
                 'HD',
                 'IP',
                 'RP',
                 'SC')),
    'HL70048': ('What subject filter',
                ('ADV',
                 'ANU',
                 'APA',
                 'APM',
                 'APN',
                 'APP',
                 'ARN',
                 'CAN',
                 'DEM',
                 'FIN',
                 'GID',
                 'GOL',
                 'MRI',
                 'MRO',
                 'NCK',
                 'NSC',
                 'NST',
                 'ORD',
                 'OTH',
                 'PRB',
                 'PRO',
                 'RAR',
                 'RDR',
                 'RER',
                 'RES',
                 'RGR',
                 'ROR',
                 'SAL',
                 'SBK',
                 'SBL',
                 'SOF',
                 'SOP',
                 'SSA',
                 'SSR',
                 'STA',
                 'VXI',
                 'XID')),
    'HL70052': ('Diagnosis Type',
                ('A',
                 'F',
                 'W')),
    'HL70061': ('Check digit scheme',
                ('ISO',
                 'M10',
                 'M11',
                 'NPI')),
    'HL70062': ('Event reason',
                ('01',
                 '02',
                 '03',
                 'O',
                 'U')),
    'HL70063': ('Relationship',
                ('ASC',
                 'BRO',
                 'CGV',
                 'CHD',
                 'DEP',
                 'DOM',
                 'EMC',
                 'EME',
                 'EMR',
                 'EXF',
                 'FCH',
                 'FND',
                 'FTH',
                 'GCH',
                 'GRD',
                 'GRP',
                 'MGR',
                 'MTH',
                 'NCH',
                 'NON',
                 'OAD',
                 'OTH',
                 'OWN',
                 'PAR',
                 'SCH',
                 'SEL',
                 'SIB',
                 'SIS',
                 'SPO',
                 'TRA',
                 'UNK',
                 'WRD')),
    'HL70065': ('Specimen Action Code',
                ('A',
                 'G',
                 'L',
                 'O',
                 'P',
                 'R',
                 'S')),
    'HL70066': ('Employment Status',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '9',
                 'C',
                 'L',
                 'O',
                 'T')),
    'HL70069': ('Hospital Service',
                ('CAR',
                 'MED',
                 'PUL',
                 'SUR',
                 'URO')),
    'HL70070': ('Specimen Source Codes',
                ('ABS',
                 'ACNE',
                 'ACNFLD',
                 'AIRS',
                 'ALL',
                 'AMN',
                 'AMP',
                 'ANGI',
                 'ARTC',
                 'ASERU',
                 'ASP',
                 'ATTE',
                 'AUTOC',
                 'AUTP',
                 'BBL',
                 'BCYST',
                 'BDY',
                 'BIFL',
                 'BITE',
                 'BLD',
                 'BLDA',
                 'BLDC',
                 'BLDCO',
                 'BLDV',
                 'BLEB',
                 'BLIST',
                 'BOIL',
                 'BON',
                 'BOWL',
                 'BPH',
                 'BPU',
                 'BRN',
                 'BRO',
                 'BRSH',
                 'BRTH',
                 'BRUS',
                 'BUB',
                 'BULLA',
                 'BX',
                 'CALC',
                 'CARBU',
                 'CAT',
                 'CBITE',
                 'CDM',
                 'CLIPP',
                 'CNJT',
                 'CNL',
                 'COL',
                 'CONE',
                 'CSCR',
                 'CSERU',
                 'CSF',
                 'CSITE',
                 'CSMY',
                 'CST',
                 'CSVR',
                 'CTP',
                 'CUR',
                 'CVM',
                 'CVPS',
                 'CVPT',
                 'CVX',
                 'CYN',
                 'CYST',
                 'DBITE',
                 'DCS',
                 'DEC',
                 'DEION',
                 'DIA',
                 'DIAF',
                 'DISCHG',
                 'DIV',
                 'DOSE',
                 'DRN',
                 'DRNG',
                 'DRNGP',
                 'DUFL',
                 'EAR',
                 'EARW',
                 'EBRUSH',
                 'EEYE',
                 'EFF',
                 'EFFUS',
                 'EFOD',
                 'EISO',
                 'ELT',
                 'ENDC',
                 'ENDM',
                 'ENVIR',
                 'EOS',
                 'EOTH',
                 'ESOI',
                 'ESOS',
                 'ETA',
                 'ETTP',
                 'ETTUB',
                 'EWHI',
                 'EXG',
                 'EXS',
                 'EXUDTE',
                 'EYE',
                 'FAW',
                 'FBLOOD',
                 'FGA',
                 'FIB',
                 'FIST',
                 'FLD',
                 'FLT',
                 'FLU',
                 'FLUID',
                 'FOLEY',
                 'FRS',
                 'FSCLP',
                 'FUR',
                 'GAS',
                 'GASA',
                 'GASAN',
                 'GASBR',
                 'GASD',
                 'GAST',
                 'GEN',
                 'GENC',
                 'GENL',
                 'GENV',
                 'GRAFT',
                 'GRANU',
                 'GROSH',
                 'GSOL',
                 'GSPEC',
                 'GT',
                 'GTUBE',
                 'HAR',
                 'HBITE',
                 'HBLUD',
                 'HEMAQ',
                 'HEMO',
                 'HERNI',
                 'HEV',
                 'HIC',
                 'HYDC',
                 'IBITE',
                 'ICYST',
                 'IDC',
                 'IHG',
                 'ILEO',
                 'ILLEG',
                 'IMP',
                 'INCI',
                 'INFIL',
                 'INS',
                 'INTRD',
                 'ISLT',
                 'IT',
                 'IUD',
                 'IVCAT',
                 'IVFLD',
                 'IVTIP',
                 'JEJU',
                 'JNTFLD',
                 'JP',
                 'KELOI',
                 'KIDFLD',
                 'LAM',
                 'LAVG',
                 'LAVGG',
                 'LAVGP',
                 'LAVPG',
                 'LENS1',
                 'LENS2',
                 'LESN',
                 'LIQ',
                 'LIQO',
                 'LN',
                 'LNA',
                 'LNV',
                 'LSAC',
                 'LYM',
                 'MAC',
                 'MAHUR',
                 'MAR',
                 'MASS',
                 'MBLD',
                 'MEC',
                 'MILK',
                 'MLK',
                 'MUCOS',
                 'MUCUS',
                 'NAIL',
                 'NASDR',
                 'NEDL',
                 'NEPH',
                 'NGASP',
                 'NGAST',
                 'NGS',
                 'NODUL',
                 'NOS',
                 'NSECR',
                 'ORH',
                 'ORL',
                 'OTH',
                 'PACEM',
                 'PAFL',
                 'PAT',
                 'PCFL',
                 'PDSIT',
                 'PDTS',
                 'PELVA',
                 'PENIL',
                 'PERIA',
                 'PILOC',
                 'PINS',
                 'PIS',
                 'PLAN',
                 'PLAS',
                 'PLB',
                 'PLC',
                 'PLEVS',
                 'PLR',
                 'PMN',
                 'PND',
                 'POL',
                 'POPGS',
                 'POPLG',
                 'POPLV',
                 'PORTA',
                 'PPP',
                 'PROST',
                 'PRP',
                 'PRT',
                 'PSC',
                 'PUNCT',
                 'PUS',
                 'PUSFR',
                 'PUST',
                 'QC3',
                 'RANDU',
                 'RBC',
                 'RBITE',
                 'RECT',
                 'RECTA',
                 'RENALC',
                 'RENC',
                 'RES',
                 'RT',
                 'SAL',
                 'SCAR',
                 'SCLV',
                 'SCROA',
                 'SECRE',
                 'SER',
                 'SHU',
                 'SHUNF',
                 'SHUNT',
                 'SITE',
                 'SKBP',
                 'SKM',
                 'SKN',
                 'SMM',
                 'SMN',
                 'SNV',
                 'SPRM',
                 'SPRP',
                 'SPRPB',
                 'SPS',
                 'SPT',
                 'SPTC',
                 'SPTT',
                 'SPUT1',
                 'SPUTIN',
                 'SPUTSP',
                 'STER',
                 'STL',
                 'STON',
                 'STONE',
                 'SUBMA',
                 'SUBMX',
                 'SUMP',
                 'SUP',
                 'SUTUR',
                 'SWGZ',
                 'SWT',
                 'TASP',
                 'TEAR',
                 'THRB',
                 'THRT',
                 'TISG',
                 'TISPL',
                 'TISS',
                 'TISU',
                 'TLC',
                 'TLGI',
                 'TLNG',
                 'TRAC',
                 'TRANS',
                 'TSERU',
                 'TSMI',
                 'TSTES',
                 'TTRA',
                 'TUB',
                 'TUBES',
                 'TUMOR',
                 'TZANC',
                 'UDENT',
                 'ULC',
                 'UMB',
                 'UMED',
                 'UR',
                 'URC',
                 'URINB',
                 'URINC',
                 'URINM',
                 'URINN',
                 'URINP',
                 'URNS',
                 'URT',
                 'URTH',
                 'USCOP',
                 'USPEC',
                 'USUB',
                 'VASTIP',
                 'VENT',
                 'VITF',
                 'VOM',
                 'WASH',
                 'WASI',
                 'WAT',
                 'WB',
                 'WBC',
                 'WEN',
                 'WICK',
                 'WND',
                 'WNDA',
                 'WNDD',
                 'WNDE',
                 'WORM',
                 'WRT',
                 'WWA',
                 'WWO',
                 'WWT',
                 'XXX')),
    'HL70074': ('Diagnostic Service Section ID',
                ('AU',
                 'BG',
                 'BLB',
                 'CH',
                 'CP',
                 'CT',
                 'CTH',
                 'CUS',
                 'EC',
                 'EN',
                 'HM',
                 'ICU',
                 'IMM',
                 'LAB',
                 'MB',
                 'MCB',
                 'MYC',
                 'NMR',
                 'NMS',
                 'NRS',
                 'OSL',
                 'OT',
                 'OTH',
                 'OUS',
                 'PF',
                 'PHR',
                 'PHY',
                 'PT',
                 'RAD',
                 'RC',
                 'RT',
                 'RUS',
                 'RX',
                 'SP',
                 'SR',
                 'TX',
                 'VR',
                 'VUS',
                 'XRC')),
    'HL70076': ('Message type',
                ('ACK',
                 'ADR',
                 'ADT',
                 'BAR',
                 'BPS',
                 'BRP',
                 'BRT',
                 'BTS',
                 'CRM',
                 'CSU',
                 'DFT',
                 'DOC',
                 'DSR',
                 'EAC',
                 'EAN',
                 'EAR',
                 'EDR',
                 'EQQ',
                 'ERP',
                 'ESR',
                 'ESU',
                 'INR',
                 'INU',
                 'LSR',
                 'LSU',
                 'MCF',
                 'MDM',
                 'MFD',
                 'MFK',
                 'MFN',
                 'MFQ',
                 'MFR',
                 'NMD',
                 'NMQ',
                 'NMR',
                 'OMB',
                 'OMD',
                 'OMG',
                 'OMI',
                 'OML',
                 'OMN',
                 'OMP',
                 'OMS',
                 'ORB',
                 'ORD',
                 'ORF',
                 'ORG',
                 'ORI',
                 'ORL',
                 'ORM',
                 'ORN',
                 'ORP',
                 'ORR',
                 'ORS',
                 'ORU',
                 'OSQ',
                 'OSR',
                 'OUL',
                 'PEX',
                 'PGL',
                 'PIN',
                 'PMU',
                 'PPG',
                 'PPP',
                 'PPR',
                 'PPT',
                 'PPV',
                 'PRR',
                 'PTR',
                 'QBP',
                 'QCK',
                 'QCN',
                 'QRY',
                 'QSB',
                 'QSX',
                 'QVR',
                 'RAR',
                 'RAS',
                 'RCI',
                 'RCL',
                 'RDE',
                 'RDR',
                 'RDS',
                 'RDY',
                 'REF',
                 'RER',
                 'RGR',
                 'RGV',
                 'ROR',
                 'RPA',
                 'RPI',
                 'RPL',
                 'RPR',
                 'RQA',
                 'RQC',
                 'RQI',
                 'RQP',
                 'RQQ',
                 'RRA',
                 'RRD',
                 'RRE',
                 'RRG',
                 'RRI',
                 'RSP',
                 'RTB',
                 'SIU',
                 'SPQ',
                 'SQM',
                 'SQR',
                 'SRM',
                 'SRR',
                 'SSR',
                 'SSU',
                 'SUR',
                 'TBR',
                 'TCR',
                 'TCU',
                 'UDM',
                 'VQQ',
                 'VXQ',
                 'VXR',
                 'VXU',
                 'VXX')),
    'HL70078': ('Abnormal flags',
                ('<',
                 '>',
                 'A',
                 'AA',
                 'B',
                 'D',
                 'H',
                 'HH',
                 'I',
                 'L',
                 'LL',
                 'MS',
                 'N',
                 'null',
                 'R',
                 'S',
                 'U',
                 'VS',
                 'W')),
    'HL70080': ('Nature of Abnormal Testing',
                ('A',
                 'B',
                 'N',
                 'R',
                 'S',
                 'SP',
                 'ST')),
    'HL70083': ('Outlier Type',
                ('C',
                 'D')),
    'HL70085': ('Observation result status codes interpretation',
                ('C',
                 'D',
                 'F',
                 'I',
                 'N',
                 'O',
                 'P',
                 'R',
                 'S',
                 'U',
                 'W',
                 'X')),
    'HL70091': ('Query priority',
                ('D',
                 'I')),
    'HL70092': ('Re-Admission Indicator',
                ('R',)),
    'HL70093': ('Release Information',
                ('_',
                 'N',
                 'Y')),
    'HL70098': ('Type of Agreement',
                ('M',
                 'S',
                 'U')),
    'HL70100': ('Invocation event',
                ('D',
                 'O',
                 'R',
                 'S',
                 'T')),
    'HL70103': ('Processing ID',
                ('D',
                 'P',
                 'T')),
    'HL70104': ('Version ID',
                ('2.0',
                 '2.0D',
                 '2.1',
                 '2.2',
                 '2.3',
                 '2.3.1',
                 '2.4',
                 '2.5')),
    'HL70105': ('Source of comment',
                ('L',
                 'O',
                 'P')),
    'HL70106': ('Query/response format code',
                ('D',
                 'R',
                 'T')),
    'HL70107': ('Deferred response type',
                ('B',
                 'L')),
    'HL70108': ('Query results level',
                ('O',
                 'R',
                 'S',
                 'T')),
    'HL70109': ('Report priority',
                ('R',
                 'S')),
    'HL70112': ('Discharge Disposition',
                ('01',
                 '02',
                 '03',
                 '04',
                 '05',
                 '06',
                 '07',
                 '08',
                 '09',
                 '10 _19',
                 '20',
                 '21 ... 29',
                 '30',
                 '31 _ 39',
                 '40',
                 '41',
                 '42')),
    'HL70116': ('Bed Status',
                ('C',
                 'H',
                 'I',
                 'K',
                 'O',
                 'U')),
    'HL70119': ('Order control codes',
                ('AF',
                 'CA',
                 'CH',
                 'CN',
                 'CR',
                 'DC',
                 'DE',
                 'DF',
                 'DR',
                 'FU',
                 'HD',
                 'HR',
                 'LI',
                 'NA',
                 'NW',
                 'OC',
                 'OD',
                 'OE',
                 'OF',
                 'OH',
                 'OK',
                 'OP',
                 'OR',
                 'PA',
                 'PR',
                 'PY',
                 'RE',
                 'RF',
                 'RL',
                 'RO',
                 'RP',
                 'RQ',
                 'RR',
                 'RU',
                 'SC',
                 'SN',
                 'SR',
                 'SS',
                 'UA',
                 'UC',
                 'UD',
                 'UF',
                 'UH',
                 'UM',
                 'UN',
                 'UR',
                 'UX',
                 'XO',
                 'XR',
                 'XX')),
    'HL70121': ('Response flag',
                ('D',
                 'E',
                 'F',
                 'N',
                 'R')),
    'HL70122': ('Charge type',
                ('CH',
                 'CO',
                 'CR',
                 'DP',
                 'GR',
                 'NC',
                 'PC',
                 'RS')),
    'HL70123': ('Result Status',
                ('A',
                 'C',
                 'F',
                 'I',
                 'O',
                 'P',
                 'R',
                 'S',
                 'X',
                 'Y',
                 'Z')),
    'HL70124': ('Transportation Mode',
                ('CART',
                 'PORT',
                 'WALK',
                 'WHLC')),
    'HL70125': ('Value type',
                ('AD',
                 'CE',
                 'CF',
                 'CK',
                 'CN',
                 'CP',
                 'CX',
                 'DT',
                 'ED',
                 'FT',
                 'MO',
                 'NM',
                 'PN',
                 'RP',
                 'SN',
                 'ST',
                 'TM',
                 'TN',
                 'TS',
                 'TX',
                 'XAD',
                 'XCN',
                 'XON',
                 'XPN',
                 'XTN')),
    'HL70126': ('Quantity limited request',
                ('CH',
                 'LI',
                 'PG',
                 'RD',
                 'ZO')),
    'HL70127': ('Allergen Type',
                ('AA',
                 'DA',
                 'EA',
                 'FA',
                 'LA',
                 'MA',
                 'MC',
                 'PA')),
    'HL70128': ('Allergy Severity',
                ('MI',
                 'MO',
                 'SV',
                 'U')),
    'HL70130': ('Visit User Code',
                ('HO',
                 'MO',
                 'PH',
                 'TE')),
    'HL70131': ('Contact Role',
                ('C',
                 'E',
                 'F',
                 'I',
                 'N',
                 'O',
                 'S',
                 'U')),
    'HL70133': ('Procedure Practitioner Identifier Code Type',
                ('AN',
                 'AS',
                 'CM',
                 'NP',
                 'PR',
                 'PS',
                 'RD',
                 'RS',
                 'SN')),
    'HL70135': ('Assignment of Benefits',
                ('M',
                 'N',
                 'Y')),
    'HL70136': ('Yes/no indicator',
                ('N',
                 'Y')),
    'HL70137': ('Mail Claim Party',
                ('E',
                 'G',
                 'I',
                 'O',
                 'P')),
    'HL70140': ('Military Service',
                ('AUSA',
                 'AUSAF',
                 'AUSN',
                 'NATO',
                 'NOAA',
                 'USA',
                 'USAF',
                 'USCG',
                 'USMC',
                 'USN',
                 'USPHS')),
    'HL70141': ('Military Rank/Grade',
                ('E1... E9',
                 'O1 ... O9',
                 'W1 ... W4')),
    'HL70142': ('Military Status',
                ('ACT',
                 'DEC',
                 'RET')),
    'HL70144': ('Eligibility Source',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7')),
    'HL70145': ('Room type',
                ('2ICU',
                 '2PRI',
                 '2SPR',
                 'ICU',
                 'PRI',
                 'SPR')),
    'HL70146': ('Amount type',
                ('DF',
                 'LM',
                 'PC',
                 'RT',
                 'UL')),
    'HL70147': ('Policy type',
                ('2ANC',
                 '2MMD',
                 '3MMD',
                 'ANC',
                 'MMD')),
    'HL70148': ('Money or percentage indicator',
                ('AT',
                 'PC')),
    'HL70149': ('Day type',
                ('AP',
                 'DE',
                 'PE')),
    'HL70150': ('Certification patient type',
                ('ER',
                 'IPE',
                 'OPE',
                 'UR')),
    'HL70155': ('Accept/application acknowledgment conditions',
                ('AL',
                 'ER',
                 'NE',
                 'SU')),
    'HL70156': ('Which date/time qualifier',
                ('ANY',
                 'COL',
                 'ORD',
                 'RCT',
                 'REP',
                 'SCHED')),
    'HL70157': ('Which date/time status qualifier',
                ('ANY',
                 'CFN',
                 'COR',
                 'FIN',
                 'PRE',
                 'REP')),
    'HL70158': ('Date/time selection qualifier',
                ('1ST',
                 'ALL',
                 'LST',
                 'REV')),
    'HL70159': ('Diet Code Specification Type',
                ('D',
                 'P',
                 'S')),
    'HL70160': ('Tray Type',
                ('EARLY',
                 'GUEST',
                 'LATE',
                 'MSG',
                 'NO')),
    'HL70161': ('Allow Substitution',
                ('G',
                 'N',
                 'T')),
    'HL70162': ('Route of Administration',
                ('AP',
                 'B',
                 'DT',
                 'EP',
                 'ET',
                 'GTT',
                 'GU',
                 'IA',
                 'IB',
                 'IC',
                 'ICV',
                 'ID',
                 'IH',
                 'IHA',
                 'IM',
                 'IMR',
                 'IN',
                 'IO',
                 'IP',
                 'IS',
                 'IT',
                 'IU',
                 'IV',
                 'MM',
                 'MTH',
                 'NG',
                 'NP',
                 'NS',
                 'NT',
                 'OP',
                 'OT',
                 'OTH',
                 'PF',
                 'PO',
                 'PR',
                 'RM',
                 'SC',
                 'SD',
                 'SL',
                 'TD',
                 'TL',
                 'TP',
                 'TRA',
                 'UR',
                 'VG',
                 'VM',
                 'WND')),
    'HL70163': ('Body site',
                ('BE',
                 'BN',
                 'BU',
                 'CT',
                 'LA',
                 'LAC',
                 'LACF',
                 'LD',
                 'LE',
                 'LEJ',
                 'LF',
                 'LG',
                 'LH',
                 'LIJ',
                 'LLAQ',
                 'LLFA',
                 'LMFA',
                 'LN',
                 'LPC',
                 'LSC',
                 'LT',
                 'LUA',
                 'LUAQ',
                 'LUFA',
                 'LVG',
                 'LVL',
                 'NB',
                 'OD',
                 'OS',
                 'OU',
                 'PA',
                 'PERIN',
                 'RA',
                 'RAC',
                 'RACF',
                 'RD',
                 'RE',
                 'REJ',
                 'RF',
                 'RG',
                 'RH',
                 'RIJ',
                 'RLAQ',
                 'RLFA',
                 'RMFA',
                 'RN',
                 'RPC',
                 'RSC',
                 'RT',
                 'RUA',
                 'RUAQ',
                 'RUFA',
                 'RVG',
                 'RVL')),
    'HL70164': ('Administration Device',
                ('AP',
                 'BT',
                 'HL',
                 'IPPB',
                 'IVP',
                 'IVS',
                 'MI',
                 'NEB',
                 'PCA')),
    'HL70165': ('Administration Method',
                ('CH',
                 'DI',
                 'DU',
                 'IF',
                 'IR',
                 'IS',
                 'IVP',
                 'IVPB',
                 'NB',
                 'PF',
                 'PT',
                 'SH',
                 'SO',
                 'WA',
                 'WI')),
    'HL70166': ('RX Component Type',
                ('A',
                 'B')),
    'HL70167': ('Substitution Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '7',
                 '8',
                 'G',
                 'N',
                 'T')),
    'HL70168': ('Processing priority',
                ('A',
                 'B',
                 'C',
                 'P',
                 'R',
                 'S',
                 'T')),
    'HL70169': ('Reporting priority',
                ('C',
                 'R')),
    'HL70170': ('Derived specimen',
                ('C',
                 'N',
                 'P')),
    'HL70173': ('Coordination of Benefits',
                ('CO',
                 'IN')),
    'HL70174': ('Nature of Service/Test/Observation',
                ('A',
                 'C',
                 'F',
                 'P',
                 'S')),
    'HL70175': ('Master file identifier code',
                ('CDM',
                 'CLN',
                 'CMA',
                 'CMB',
                 'INV',
                 'LOC',
                 'OMA',
                 'OMB',
                 'OMC',
                 'OMD',
                 'OME',
                 'PRA',
                 'STF')),
    'HL70177': ('Confidentiality code',
                ('AID',
                 'EMP',
                 'ETH',
                 'HIV',
                 'PSY',
                 'R',
                 'U',
                 'UWM',
                 'V',
                 'VIP')),
    'HL70178': ('File level event code',
                ('REP',
                 'UPD')),
    'HL70179': ('Response level',
                ('AL',
                 'ER',
                 'NE',
                 'SU')),
    'HL70180': ('Record-level event code',
                ('MAC',
                 'MAD',
                 'MDC',
                 'MDL',
                 'MUP')),
    'HL70181': ('MFN record-level error return',
                ('S',
                 'U')),
    'HL70182': ('Staff type',
                ()),
    'HL70183': ('Active/Inactive',
                ('A',
                 'I')),
    'HL70184': ('Department',
                ()),
    'HL70185': ('Preferred method of contact',
                ('B',
                 'C',
                 'E',
                 'F',
                 'H',
                 'O')),
    'HL70187': ('Provider billing',
                ('I',
                 'P')),
    'HL70189': ('Ethnic Group',
                ('...',
                 'H',
                 'N',
                 'U')),
    'HL70190': ('Address type',
                ('B',
                 'BA',
                 'BDL',
                 'BR',
                 'C',
                 'F',
                 'H',
                 'L',
                 'M',
                 'N',
                 'O',
                 'P',
                 'RH')),
    'HL70191': ('Type of referenced data',
                ('AP',
                 'AU',
                 'FT',
                 'IM',
                 'multipart',
                 'NS',
                 'SD',
                 'SI',
                 'TEXT',
                 'TX')),
    'HL70193': ('Amount class',
                ('AT',
                 'LM',
                 'PC',
                 'UL')),
    'HL70200': ('Name type',
                ('A',
                 'B',
                 'C',
                 'D',
                 'I',
                 'L',
                 'M',
                 'N',
                 'P',
                 'R',
                 'S',
                 'T',
                 'U')),
    'HL70201': ('Telecommunication use code',
                ('ASN',
                 'BPN',
                 'EMR',
                 'NET',
                 'ORN',
                 'PRN',
                 'VHN',
                 'WPN')),
    'HL70202': ('Telecommunication equipment type',
                ('BP',
                 'CP',
                 'FX',
                 'Internet',
                 'MD',
                 'PH',
                 'TDD',
                 'TTY',
                 'X.400')),
    'HL70203': ('Identifier type',
                ('AM',
                 'AN',
                 'ANC',
                 'AND',
                 'ANON',
                 'ANT',
                 'APRN',
                 'BA',
                 'BC',
                 'BR',
                 'BRN',
                 'CC',
                 'CY',
                 'DDS',
                 'DEA',
                 'DFN',
                 'DI',
                 'DL',
                 'DN',
                 'DO',
                 'DPM',
                 'DR',
                 'DS',
                 'EI',
                 'EN',
                 'FI',
                 'GI',
                 'GL',
                 'GN',
                 'HC',
                 'IND',
                 'JHN',
                 'LI',
                 'LN',
                 'LR',
                 'MA',
                 'MB',
                 'MC',
                 'MCD',
                 'MCN',
                 'MCR',
                 'MD',
                 'MI',
                 'MR',
                 'MRT',
                 'MS',
                 'NE',
                 'NH',
                 'NI',
                 'NII',
                 'NIIP',
                 'NNxxx',
                 'NP',
                 'NPI',
                 'OD',
                 'PA',
                 'PCN',
                 'PE',
                 'PEN',
                 'PI',
                 'PN',
                 'PNT',
                 'PPN',
                 'PRC',
                 'PRN',
                 'PT',
                 'QA',
                 'RI',
                 'RN',
                 'RPH',
                 'RR',
                 'RRI',
                 'SL',
                 'SN',
                 'SR',
                 'SS',
                 'TAX',
                 'TN',
                 'U',
                 'UPIN',
                 'VN',
                 'VS',
                 'WC',
                 'WCN',
                 'XX')),
    'HL70204': ('Organizational name type',
                ('A',
                 'D',
                 'L',
                 'SL')),
    'HL70205': ('Price type',
                ('AP',
                 'DC',
                 'IC',
                 'PF',
                 'TF',
                 'TP',
                 'UP')),
    'HL70206': ('Segment action code',
                ('A',
                 'D',
                 'U')),
    'HL70207': ('Processing mode',
                ('A',
                 'I',
                 'Not present',
                 'R',
                 'T')),
    'HL70208': ('Query Response Status',
                ('AE',
                 'AR',
                 'NF',
                 'OK')),
    'HL70209': ('Relational operator',
                ('CT',
                 'EQ',
                 'GE',
                 'GN',
                 'GT',
                 'LE',
                 'LT',
                 'NE')),
    'HL70210': ('Relational conjunction',
                ('AND',
                 'OR')),
    'HL70211': ('Alternate character sets',
                ('8859/1',
                 '8859/2',
                 '8859/3',
                 '8859/4',
                 '8859/5',
                 '8859/6',
                 '8859/7',
                 '8859/8',
                 '8859/9',
                 'ASCII',
                 'BIG-5',
                 'CNS 11643-1992',
                 'GB 18030-2000',
                 'ISO IR14',
                 'ISO IR159',
                 'ISO IR87',
                 'KS X 1001',
                 'UNICODE',
                 'UNICODE UTF-16',
                 'UNICODE UTF-32',
                 'UNICODE UTF-8',
                 '8859/15')),
    'HL70213': ('Purge Status Code',
                ('D',
                 'I',
                 'P')),
    'HL70214': ('Special Program Code',
                ('CH',
                 'ES',
                 'FP',
                 'O',
                 'U')),
    'HL70215': ('Publicity Code',
                ('F',
                 'N',
                 'O',
                 'U')),
    'HL70216': ('Patient Status Code',
                ('AI',
                 'DI')),
    'HL70217': ('Visit Priority Code',
                ('1',
                 '2',
                 '3')),
    'HL70220': ('Living Arrangement',
                ('A',
                 'F',
                 'I',
                 'R',
                 'S',
                 'U')),
    'HL70223': ('Living Dependency',
                ('C',
                 'M',
                 'O',
                 'S',
                 'U')),
    'HL70224': ('Transport Arranged',
                ('A',
                 'N',
                 'U')),
    'HL70225': ('Escort Required',
                ('N',
                 'R',
                 'U')),
    'HL70227': ('Manufacturers of Vaccines (code=MVX)',
                ('AB',
                 'AD',
                 'ALP',
                 'AR',
                 'AVB',
                 'AVI',
                 'BA',
                 'BAH',
                 'BAY',
                 'BP',
                 'BPC',
                 'CEN',
                 'CHI',
                 'CMP',
                 'CON',
                 'EVN',
                 'GRE',
                 'IAG',
                 'IM',
                 'IUS',
                 'JPN',
                 'KGC',
                 'LED',
                 'MA',
                 'MBL',
                 'MED',
                 'MIL',
                 'MIP',
                 'MSD',
                 'NAB',
                 'NAV',
                 'NOV',
                 'NYB',
                 'ORT',
                 'OTC',
                 'OTH',
                 'PD',
                 'PMC',
                 'PRX',
                 'PWJ',
                 'SCL',
                 'SI',
                 'SKB',
                 'UNK',
                 'USA',
                 'WA',
                 'WAL')),
    'HL70228': ('Diagnosis Classification',
                ('C',
                 'D',
                 'I',
                 'M',
                 'O',
                 'R',
                 'S',
                 'T')),
    'HL70229': ('DRG Payor',
                ('C',
                 'G',
                 'M')),
    'HL70230': ('Procedure Functional Type',
                ('A',
                 'D',
                 'I',
                 'P')),
    'HL70231': ('Student Status',
                ('F',
                 'N',
                 'P')),
    'HL70232': ('Insurance Company Contact Reason',
                ('01',
                 '02',
                 '03')),
    'HL70234': ('Report timing',
                ('10D',
                 '15D',
                 '30D',
                 '3D',
                 '7D',
                 'AD',
                 'CO',
                 'DE',
                 'PD',
                 'RQ')),
    'HL70235': ('Report source',
                ('C',
                 'D',
                 'E',
                 'H',
                 'L',
                 'M',
                 'N',
                 'O',
                 'P',
                 'R')),
    'HL70236': ('Event Reported To',
                ('D',
                 'L',
                 'M',
                 'R')),
    'HL70237': ('Event Qualification',
                ('A',
                 'B',
                 'D',
                 'I',
                 'L',
                 'M',
                 'O',
                 'W')),
    'HL70238': ('Event Seriousness',
                ('N',
                 'S',
                 'Y')),
    'HL70239': ('Event Expected',
                ('N',
                 'U',
                 'Y')),
    'HL70240': ('Event Consequence',
                ('C',
                 'D',
                 'H',
                 'I',
                 'J',
                 'L',
                 'O',
                 'P',
                 'R')),
    'HL70241': ('Patient Outcome',
                ('D',
                 'F',
                 'N',
                 'R',
                 'S',
                 'U',
                 'W')),
    'HL70242': ('Primary Observer\'s Qualification',
                ('C',
                 'H',
                 'L',
                 'M',
                 'O',
                 'P',
                 'R')),
    'HL70243': ('Identity May Be Divulged',
                ('N',
                 'NA',
                 'Y')),
    'HL70247': ('Status of Evaluation',
                ('A',
                 'C',
                 'D',
                 'I',
                 'K',
                 'O',
                 'P',
                 'Q',
                 'R',
                 'U',
                 'X',
                 'Y')),
    'HL70248': ('Product source',
                ('A',
                 'L',
                 'N',
                 'R')),
    'HL70250': ('Relatedness Assessment',
                ('H',
                 'I',
                 'M',
                 'N',
                 'S')),
    'HL70251': ('Action Taken in Response to the Event',
                ('DI',
                 'DR',
                 'N',
                 'OT',
                 'WP',
                 'WT')),
    'HL70252': ('Causality Observations',
                ('AW',
                 'BE',
                 'DR',
                 'EX',
                 'IN',
                 'LI',
                 'OE',
                 'OT',
                 'PL',
                 'SE',
                 'TC')),
    'HL70253': ('Indirect exposure mechanism',
                ('B',
                 'F',
                 'O',
                 'P',
                 'X')),
    'HL70254': ('Kind of quantity',
                ('ABS',
                 'ACNC',
                 'ACT',
                 'APER',
                 'ARB',
                 'AREA',
                 'ASPECT',
                 'CACT',
                 'CCNT',
                 'CCRTO',
                 'CFR',
                 'CLAS',
                 'CNC',
                 'CNST',
                 'COEF',
                 'COLOR',
                 'CONS',
                 'CRAT',
                 'CRTO',
                 'DEN',
                 'DEV',
                 'DIFF',
                 'ELAS',
                 'ELPOT',
                 'ELRAT',
                 'ELRES',
                 'ENGR',
                 'ENT',
                 'ENTCAT',
                 'ENTNUM',
                 'ENTSUB',
                 'ENTVOL',
                 'EQL',
                 'FORCE',
                 'FREQ',
                 'IMP',
                 'KINV',
                 'LEN',
                 'LINC',
                 'LIQ',
                 'MASS',
                 'MCNC',
                 'MCNT',
                 'MCRTO',
                 'MFR',
                 'MGFLUX',
                 'MINC',
                 'MORPH',
                 'MOTIL',
                 'MRAT',
                 'MRTO',
                 'NCNC',
                 'NCNT',
                 'NFR',
                 'NRTO',
                 'NUM',
                 'OD',
                 'OSMOL',
                 'PRES',
                 'PRID',
                 'PWR',
                 'RANGE',
                 'RATIO',
                 'RCRLTM',
                 'RDEN',
                 'REL',
                 'RLMCNC',
                 'RLSCNC',
                 'RLTM',
                 'SATFR',
                 'SCNC',
                 'SCNCIN',
                 'SCNT',
                 'SCNTR',
                 'SCRTO',
                 'SFR',
                 'SHAPE',
                 'SMELL',
                 'SRAT',
                 'SRTO',
                 'SUB',
                 'SUSC',
                 'TASTE',
                 'TEMP',
                 'TEMPDF',
                 'TEMPIN',
                 'THRMCNC',
                 'THRSCNC',
                 'TIME',
                 'TITR',
                 'TMDF',
                 'TMSTP',
                 'TRTO',
                 'TYPE',
                 'VCNT',
                 'VEL',
                 'VELRT',
                 'VFR',
                 'VISC',
                 'VOL',
                 'VRAT',
                 'VRTO')),
    'HL70255': ('Duration categories',
                ('*',
                 '12H',
                 '1H',
                 '1L',
                 '1W',
                 '24H',
                 '2.5H',
                 '2D',
                 '2H',
                 '2L',
                 '2W',
                 '30M',
                 '3D',
                 '3H',
                 '3L',
                 '3W',
                 '4D',
                 '4H',
                 '4W',
                 '5D',
                 '5H',
                 '6D',
                 '6H',
                 '7H',
                 '8H',
                 'PT')),
    'HL70256': ('Time delay post challenge',
                ('10D',
                 '10M',
                 '12H',
                 '15M',
                 '1H',
                 '1L',
                 '1M',
                 '1W',
                 '20M',
                 '24H',
                 '2.5H',
                 '25M',
                 '2D',
                 '2H',
                 '2L',
                 '2M',
                 '2W',
                 '30M',
                 '3D',
                 '3H',
                 '3L',
                 '3M',
                 '3W',
                 '4D',
                 '4H',
                 '4M',
                 '4W',
                 '5D',
                 '5H',
                 '5M',
                 '6D',
                 '6H',
                 '6M',
                 '7D',
                 '7H',
                 '7M',
                 '8H',
                 '8H SHIFT',
                 '8M',
                 '9M',
                 'BS',
                 'PEAK',
                 'RANDOM',
                 'TROUGH')),
    'HL70257': ('Nature of challenge',
                ('CFST',
                 'EXCZ',
                 'FFST')),
    'HL70258': ('Relationship modifier',
                ('BPU',
                 'CONTROL',
                 'DONOR',
                 'PATIENT')),
    'HL70259': ('Modality',
                ('AS',
                 'BS',
                 'CD',
                 'CP',
                 'CR',
                 'CS',
                 'CT',
                 'DD',
                 'DG',
                 'DM',
                 'EC',
                 'ES',
                 'FA',
                 'FS',
                 'LP',
                 'LS',
                 'MA',
                 'MS',
                 'NM',
                 'OT',
                 'PT',
                 'RF',
                 'ST',
                 'TG',
                 'US',
                 'XA')),
    'HL70260': ('Patient location type',
                ('B',
                 'C',
                 'D',
                 'E',
                 'L',
                 'N',
                 'O',
                 'R')),
    'HL70261': ('Location Equipment',
                ('EEG',
                 'EKG',
                 'INF',
                 'IVP',
                 'OXY',
                 'SUC',
                 'VEN',
                 'VIT')),
    'HL70262': ('Privacy Level',
                ('F',
                 'J',
                 'P',
                 'Q',
                 'S',
                 'W')),
    'HL70263': ('Level of Care',
                ('A',
                 'C',
                 'E',
                 'F',
                 'N',
                 'R',
                 'S')),
    'HL70265': ('Specialty Type',
                ('ALC',
                 'AMB',
                 'CAN',
                 'CAR',
                 'CCR',
                 'CHI',
                 'EDI',
                 'EMR',
                 'FPC',
                 'INT',
                 'ISO',
                 'NAT',
                 'NBI',
                 'OBG',
                 'OBS',
                 'OTH',
                 'PED',
                 'PHY',
                 'PIN',
                 'PPS',
                 'PRE',
                 'PSI',
                 'PSY',
                 'REH',
                 'SUR',
                 'WIC')),
    'HL70267': ('Days of the week',
                ('FRI',
                 'MON',
                 'SAT',
                 'SUN',
                 'THU',
                 'TUE',
                 'WED')),
    'HL70268': ('Override',
                ('A',
                 'R',
                 'X')),
    'HL70269': ('Charge On Indicator',
                ('O',
                 'R')),
    'HL70270': ('Document Type',
                ('AR',
                 'CD',
                 'CN',
                 'DI',
                 'DS',
                 'ED',
                 'HP',
                 'OP',
                 'PC',
                 'PH',
                 'PN',
                 'PR',
                 'SP',
                 'TS')),
    'HL70271': ('Document completion status',
                ('AU',
                 'DI',
                 'DO',
                 'IN',
                 'IP',
                 'LA',
                 'PA')),
    'HL70272': ('Document Confidentiality Status',
                ('R',
                 'U',
                 'V')),
    'HL70273': ('Document Availability Status',
                ('AV',
                 'CA',
                 'OB',
                 'UN')),
    'HL70275': ('Document Storage Status',
                ('AA',
                 'AC',
                 'AR',
                 'PU')),
    'HL70276': ('Appointment reason codes',
                ('CHECKUP',
                 'EMERGENCY',
                 'FOLLOWUP',
                 'ROUTINE',
                 'WALKIN')),
    'HL70277': ('Appointment Type Codes',
                ('Complete',
                 'Normal',
                 'Tentative')),
    'HL70278': ('Filler status codes',
                ('Blocked',
                 'Booked',
                 'Cancelled',
                 'Complete',
                 'Dc',
                 'Deleted',
                 'Noshow',
                 'Overbook',
                 'Pending',
                 'Started',
                 'Waitlist')),
    'HL70279': ('Allow Substitution Codes',
                ('Confirm',
                 'No',
                 'Notify',
                 'Yes')),
    'HL70280': ('Referral priority',
                ('A',
                 'R',
                 'S')),
    'HL70281': ('Referral type',
                ('Hom',
                 'Lab',
                 'Med',
                 'Psy',
                 'Rad',
                 'Skn')),
    'HL70282': ('Referral disposition',
                ('AM',
                 'RP',
                 'SO',
                 'WR')),
    'HL70283': ('Referral status',
                ('A',
                 'E',
                 'P',
                 'R')),
    'HL70284': ('Referral category',
                ('A',
                 'E',
                 'I',
                 'O')),
    'HL70286': ('Provider role',
                ('CP',
                 'PP',
                 'RP',
                 'RT')),
    'HL70287': ('Problem/goal action code',
                ('AD',
                 'CO',
                 'DE',
                 'LI',
                 'UC',
                 'UN',
                 'UP')),
    'HL70291': ('Subtype of referenced data',
                ('BASIC',
                 'DICOM',
                 'FAX',
                 'GIF',
                 'HTML',
                 'JOT',
                 'JPEG',
                 'Octet-stream',
                 'PICT',
                 'PostScript',
                 'RTF',
                 'SGML',
                 'TIFF',
                 'x-hl7-cda-level-one',
                 'XML')),
    'HL70292': ('Vaccines administered (code = CVX)(parenteral, unless oral is noted)',
                ('01',
                 '02',
                 '03',
                 '04',
                 '05',
                 '06',
                 '07',
                 '08',
                 '09',
                 '10',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '105',
                 '106',
                 '107',
                 '108',
                 '109',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35',
                 '36',
                 '37',
                 '38',
                 '39',
                 '40',
                 '41',
                 '42',
                 '43',
                 '44',
                 '45',
                 '46',
                 '47',
                 '48',
                 '49',
                 '50',
                 '51',
                 '52',
                 '53',
                 '54',
                 '55',
                 '56',
                 '57',
                 '58',
                 '59',
                 '60',
                 '61',
                 '62',
                 '63',
                 '64',
                 '65',
                 '66',
                 '67',
                 '68',
                 '69',
                 '70',
                 '71',
                 '72',
                 '73',
                 '74',
                 '75',
                 '76',
                 '77',
                 '78',
                 '79',
                 '80',
                 '81',
                 '82',
                 '83',
                 '84',
                 '85',
                 '86',
                 '87',
                 '88',
                 '89',
                 '90',
                 '91',
                 '92',
                 '93',
                 '94',
                 '95',
                 '96',
                 '97',
                 '98',
                 '99',
                 '998',
                 '999')),
    'HL70294': ('Time selection criteria parameter class codes',
                ('Fri',
                 'Mon',
                 'Prefend',
                 'Prefstart',
                 'Sat',
                 'Sun',
                 'Thu',
                 'Tue',
                 'Wed')),
    'HL70298': ('CP range type',
                ('F',
                 'P')),
    'HL70299': ('Encoding',
                ('A',
                 'Base64',
                 'Hex')),
    'HL70301': ('Universal ID type',
                ('DNS',
                 'GUID',
                 'HCD',
                 'HL7',
                 'ISO',
                 'L,M,N',
                 'Random',
                 'URI',
                 'UUID',
                 'x400',
                 'x500')),
    'HL70305': ('Person location type',
                ('C',
                 'D',
                 'H',
                 'N',
                 'O',
                 'P',
                 'S')),
    'HL70309': ('Coverage Type',
                ('B',
                 'H',
                 'P')),
    'HL70311': ('Job Status',
                ('O',
                 'P',
                 'T',
                 'U')),
    'HL70315': ('Living Will Code',
                ('F',
                 'I',
                 'N',
                 'U',
                 'Y')),
    'HL70316': ('Organ Donor Code',
                ('F',
                 'I',
                 'N',
                 'P',
                 'R',
                 'U',
                 'Y')),
    'HL70317': ('Annotations',
                ('9900',
                 '9901',
                 '9902',
                 '9903',
                 '9904')),
    'HL70321': ('Dispense Method',
                ('AD',
                 'F',
                 'TR',
                 'UD')),
    'HL70322': ('Completion Status for valid values.',
                ('CP',
                 'NA',
                 'PA',
                 'RE')),
    'HL70323': ('Action Code',
                ('A',
                 'D',
                 'U',
                 'X')),
    'HL70324': ('Location characteristic ID',
                ('GEN',
                 'IMP',
                 'INF',
                 'LCR',
                 'LIC',
                 'OVR',
                 'PRL',
                 'SET',
                 'SHA',
                 'SMK',
                 'STF',
                 'TEA')),
    'HL70325': ('Location Relationship ID',
                ('ALI',
                 'DTY',
                 'LAB',
                 'LB2',
                 'PAR',
                 'RX',
                 'RX2')),
    'HL70326': ('Visit Indicator',
                ('A',
                 'V')),
    'HL70329': ('Quantity method',
                ('A',
                 'E')),
    'HL70330': ('Marketing basis',
                ('510E',
                 '510K',
                 '522S',
                 'PMA',
                 'PRE',
                 'TXN')),
    'HL70331': ('Facility type',
                ('A',
                 'D',
                 'M',
                 'U')),
    'HL70332': ('Source type',
                ('A',
                 'I')),
    'HL70334': ('Disabled Person Code',
                ('AP',
                 'GT',
                 'IN',
                 'PT')),
    'HL70335': ('Repeat pattern',
                ('A',
                 'BID',
                 'C',
                 'D',
                 'I',
                 'M',
                 'Meal Related Timings',
                 'Once',
                 'P',
                 'PRN',
                 'PRNxxx',
                 'QAM',
                 'QHS',
                 'QID',
                 'Q<integer>D',
                 'Q<integer>H',
                 'Q<integer>J<day#>',
                 'Q<integer>L',
                 'Q<integer>M',
                 'Q<integer>S',
                 'Q<integer>W',
                 'QOD',
                 'QPM',
                 'QSHIFT',
                 'TID',
                 'U <spec>',
                 'V',
                 'xID')),
    'HL70336': ('Referral reason',
                ('O',
                 'P',
                 'S',
                 'W')),
    'HL70337': ('Certification status',
                ('C',
                 'E')),
    'HL70338': ('Practitioner ID number type',
                ('CY',
                 'DEA',
                 'GL',
                 'LI',
                 'L&I',
                 'MCD',
                 'MCR',
                 'QA',
                 'SL',
                 'TAX',
                 'TRL',
                 'UPIN')),
    'HL70339': ('Advanced Beneficiary Notice Code',
                ('1',
                 '2',
                 '3',
                 '4')),
    'HL70344': ('Patient_s Relationship to Insured',
                ('01',
                 '02',
                 '03',
                 '04',
                 '05',
                 '06',
                 '07',
                 '08',
                 '09',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19')),
    'HL70347': ('State/province',
                ('AB',
                 'MI')),
    'HL70353': ('CWE statuses',
                ('NA',
                 'NASK',
                 'NAV',
                 'U',
                 'UASK')),
    'HL70354': ('Message structure',
                ('ACK',
                 'ADR_A19',
                 'ADT_A01',
                 'ADT_A02',
                 'ADT_A03',
                 'ADT_A05',
                 'ADT_A06',
                 'ADT_A09',
                 'ADT_A15',
                 'ADT_A16',
                 'ADT_A17',
                 'ADT_A18',
                 'ADT_A20',
                 'ADT_A21',
                 'ADT_A24',
                 'ADT_A30',
                 'ADT_A37',
                 'ADT_A38',
                 'ADT_A39',
                 'ADT_A43',
                 'ADT_A45',
                 'ADT_A50',
                 'ADT_A52',
                 'ADT_A54',
                 'ADT_A60',
                 'ADT_A61',
                 'BAR_P01',
                 'BAR_P02',
                 'BAR_P05',
                 'BAR_P06',
                 'BAR_P10',
                 'BAR_P12',
                 'BPS_O29',
                 'BRP_030',
                 'BRT_O32',
                 'BTS_O31',
                 'CRM_C01',
                 'CSU_C09',
                 'DFT_P03',
                 'DFT_P11',
                 'DOC_T12',
                 'DSR_P04',
                 'DSR_Q01',
                 'DSR_Q03',
                 'EAC_U07',
                 'EAN_U09',
                 'EAR_U08',
                 'EDR_R07',
                 'EQQ_Q04',
                 'ERP_R09',
                 'ESR_U02',
                 'ESU_U01',
                 'INR_U06',
                 'INU_U05',
                 'LSU_U12',
                 'MDM_T01',
                 'MDM_T02',
                 'MFD_MFA',
                 'MFK_M01',
                 'MFN_M01',
                 'MFN_M02',
                 'MFN_M03',
                 'MFN_M04',
                 'MFN_M05',
                 'MFN_M06',
                 'MFN_M07',
                 'MFN_M08',
                 'MFN_M09',
                 'MFN_M10',
                 'MFN_M11',
                 'MFN_M12',
                 'MFN_M13',
                 'MFN_M15',
                 'MFQ_M01',
                 'MFR_M01',
                 'NMD_N02',
                 'NMQ_N01',
                 'NMR_N01',
                 'OMB_O27',
                 'OMD_O03',
                 'OMG_O19',
                 'OMI_O23',
                 'OML_O21',
                 'OML_O33',
                 'OML_O35',
                 'OMN_O07',
                 'OMP_O09',
                 'OMS_O05',
                 'ORB_O28',
                 'ORD_O04',
                 'ORF_R04',
                 'ORG_O20',
                 'ORI_O24',
                 'ORL_O22',
                 'ORL_O34',
                 'ORL_O36',
                 'ORM_O01',
                 'ORN_O08',
                 'ORP_O10',
                 'ORR_O02',
                 'ORS_O06',
                 'ORU_R01',
                 'ORU_R30',
                 'ORU_R31',
                 'ORU_R32',
                 'ORU_W01',
                 'OSQ_Q06',
                 'OSR_Q06',
                 'OUL_R21',
                 'OUL_R22',
                 'OUL_R23',
                 'OUL_R24',
                 'PEX_P07',
                 'PGL_PC6',
                 'PMU_B01',
                 'PMU_B03',
                 'PMU_B04',
                 'PMU_B07',
                 'PMU_B08',
                 'PPG_PCG',
                 'PPP_PCB',
                 'PPR_PC1',
                 'PPT_PCL',
                 'PPV_PCA',
                 'PRR_PC5',
                 'PTR_PCF',
                 'QBP_Q11',
                 'QBP_Q13',
                 'QBP_Q15',
                 'QBP_Q21',
                 'QCK_Q02',
                 'QCN_J01',
                 'QRF_W02',
                 'QRY_A19',
                 'QRY_P04',
                 'QRY_PC4',
                 'QRY_Q01',
                 'QRY_Q02',
                 'QRY_R02',
                 'QRY_T12',
                 'QSB_Q16',
                 'QVR_Q17',
                 'RAR_RAR',
                 'RAS_O17',
                 'RCI_I05',
                 'RCL_I06',
                 'RDE_O01',
                 'RDE_O11',
                 'RDR_RDR',
                 'RDS_O13',
                 'RDY_K15',
                 'REF_I12',
                 'RER_RER',
                 'RGR_RGR',
                 'RGV_O15',
                 'ROR_ROR',
                 'RPA_I08',
                 'RPI_I01',
                 'RPL_I02',
                 'RPR_I03',
                 'RQA_I08',
                 'RQC_I05',
                 'RQI_I01',
                 'RQP_I04',
                 'RQQ_Q09',
                 'RRA_O02',
                 'RRA_O18',
                 'RRD_O14',
                 'RRE_O12',
                 'RRG_O16',
                 'RRI_I12',
                 'RSP_K11',
                 'RSP_K21',
                 'RSP_K22',
                 'RSP_K23',
                 'RTB_K13',
                 'SIU_S12',
                 'SPQ_Q08',
                 'SQM_S25',
                 'SQR_S25',
                 'SRM_S01',
                 'SRR_S01',
                 'SSR_U04',
                 'SSU_U03',
                 'SUR_P09',
                 'TBR_R08',
                 'TBR_R09',
                 'TCU_U10',
                 'UDM_Q05',
                 'VQQ_Q07',
                 'VXQ_V01',
                 'VXR_V03',
                 'VXU_V04',
                 'VXX_V02')),
    'HL70355': ('Primary key value type',
                ('CE',
                 'PL')),
    'HL70356': ('Alternate character set handling scheme',
                ('2.3',
                 'ISO 2022-1994',
                 '<null>')),
    'HL70357': ('Message error condition codes',
                ('0',
                 '100',
                 '101',
                 '102',
                 '103',
                 '200',
                 '201',
                 '202',
                 '203',
                 '204',
                 '205',
                 '206',
                 '207')),
    'HL70359': ('Diagnosis Priority',
                ('0',
                 '1',
                 '2 _')),
    'HL70360': ('Degree/license/certificate',
                ('AA',
                 'AAS',
                 'ABA',
                 'AE',
                 'AS',
                 'BA',
                 'BBA',
                 'BE',
                 'BFA',
                 'BN',
                 'BS',
                 'BSL',
                 'BSN',
                 'BT',
                 'CANP',
                 'CER',
                 'CMA',
                 'CNM',
                 'CNP',
                 'CNS',
                 'CPNP',
                 'CRN',
                 'DBA',
                 'DED',
                 'DIP',
                 'DO',
                 'EMT',
                 'EMTP',
                 'FPNP',
                 'HS',
                 'JD',
                 'MA',
                 'MBA',
                 'MCE',
                 'MD',
                 'MDA',
                 'MDI',
                 'ME',
                 'MED',
                 'MEE',
                 'MFA',
                 'MME',
                 'MS',
                 'MSL',
                 'MSN',
                 'MT',
                 'NG',
                 'NP',
                 'PA',
                 'PharmD',
                 'PHD',
                 'PHE',
                 'PHS',
                 'PN',
                 'RMA',
                 'RPH',
                 'SEC',
                 'TS')),
    'HL70364': ('Comment type',
                ('1R',
                 '2R',
                 'AI',
                 'DR',
                 'GI',
                 'GR',
                 'PI',
                 'RE')),
    'HL70365': ('Equipment state',
                ('CL',
                 'CO',
                 'ES',
                 'ID',
                 'IN',
                 'OP',
                 'PA',
                 'PD',
                 'PU')),
    'HL70366': ('Local/remote control state',
                ('L',
                 'R')),
    'HL70367': ('Alert level',
                ('C',
                 'N',
                 'S',
                 'W')),
    'HL70368': ('Remote control command',
                ('AB',
                 'CL',
                 'CN',
                 'DI',
                 'EN',
                 'ES',
                 'EX',
                 'IN',
                 'LC',
                 'LK',
                 'LO',
                 'PA',
                 'RC',
                 'RE',
                 'SA',
                 'SU',
                 'TT',
                 'UC',
                 'UN')),
    'HL70369': ('Specimen Role',
                ('B',
                 'C',
                 'E',
                 'F',
                 'G',
                 'L',
                 'O',
                 'P',
                 'Q',
                 'R',
                 'V')),
    'HL70370': ('Container status',
                ('I',
                 'L',
                 'M',
                 'O',
                 'P',
                 'R',
                 'U',
                 'X')),
    'HL70371': ('Additive/Preservative',
                ('ACDA',
                 'ACDB',
                 'ACET',
                 'AMIES',
                 'BACTM',
                 'BF10',
                 'BOR',
                 'BOUIN',
                 'BSKM',
                 'C32',
                 'C38',
                 'CARS',
                 'CARY',
                 'CHLTM',
                 'CTAD',
                 'EDTK',
                 'EDTK15',
                 'EDTK75',
                 'EDTN',
                 'ENT',
                 'ENT+',
                 'F10',
                 'FDP',
                 'FL10',
                 'FL100',
                 'HCL6',
                 'HEPA',
                 'HEPL',
                 'HEPN',
                 'HNO3',
                 'JKM',
                 'KARN',
                 'KOX',
                 'LIA',
                 'M4',
                 'M4RT',
                 'M5',
                 'MICHTM',
                 'MMDTM',
                 'NAF',
                 'NAPS',
                 'NONE',
                 'PAGE',
                 'PHENOL',
                 'PVA',
                 'RLM',
                 'SILICA',
                 'SPS',
                 'SST',
                 'STUTM',
                 'THROM',
                 'THYMOL',
                 'THYO',
                 'TOLU',
                 'URETM',
                 'VIRTM',
                 'WEST')),
    'HL70372': ('Specimen component',
                ('BLD',
                 'BSEP',
                 'PLAS',
                 'PPP',
                 'PRP',
                 'SED',
                 'SER',
                 'SUP')),
    'HL70373': ('Treatment',
                ('ACID',
                 'ALK',
                 'DEFB',
                 'FILT',
                 'LDLP',
                 'NEUT',
                 'RECA',
                 'UFIL')),
    'HL70374': ('System induced contaminants',
                ('CNTM',)),
    'HL70375': ('Artificial blood',
                ('FLUR',
                 'SFHB')),
    'HL70376': ('Special Handling Code',
                ('AMB',
                 'C37',
                 'CAMB',
                 'CATM',
                 'CFRZ',
                 'CREF',
                 'DFRZ',
                 'DRY',
                 'FRZ',
                 'MTLF',
                 'NTR',
                 'PRTL',
                 'PSA',
                 'PSO',
                 'REF',
                 'UFRZ',
                 'UPR')),
    'HL70377': ('Other environmental factors',
                ('A60',
                 'ATM')),
    'HL70383': ('Substance status',
                ('CE',
                 'CW',
                 'EE',
                 'EW',
                 'NE',
                 'NW',
                 'OE',
                 'OK',
                 'OW',
                 'QE',
                 'QW')),
    'HL70384': ('Substance type',
                ('CO',
                 'DI',
                 'LI',
                 'LW',
                 'MR',
                 'OT',
                 'PT',
                 'PW',
                 'RC',
                 'SC',
                 'SR',
                 'SW')),
    'HL70387': ('Command response',
                ('ER',
                 'OK',
                 'ST',
                 'TI',
                 'UN')),
    'HL70388': ('Processing type',
                ('E',
                 'P')),
    'HL70389': ('Analyte repeat status',
                ('D',
                 'F',
                 'O',
                 'R')),
    'HL70391': ('Segment group',
                ('OBRG',
                 'ORCG',
                 'PIDG',
                 'RXAG',
                 'RXDG',
                 'RXEG',
                 'RXOG')),
    'HL70392': ('Match reason',
                ('DB',
                 'NA',
                 'NP',
                 'SS')),
    'HL70393': ('Match algorithms',
                ('LINKSOFT_2.01',
                 'MATCHWARE_1.2')),
    'HL70394': ('Response modality',
                ('B',
                 'R',
                 'T')),
    'HL70395': ('Modify indicator',
                ('M',
                 'N')),
    'HL70396': ('Coding system',
                ('L',
                 'L',
                 'ACR',
                 'ANS+',
                 'ART',
                 'AS4',
                 'AS4E',
                 'ATC',
                 'C4',
                 'C5',
                 'CAS',
                 'CD2',
                 'CDCA',
                 'CDCM',
                 'CDS',
                 'CE',
                 'CLP',
                 'CPTM',
                 'CST',
                 'CVX',
                 'DCM',
                 'E',
                 'E5',
                 'E6',
                 'E7',
                 'ENZC',
                 'FDDC',
                 'FDDX',
                 'FDK',
                 'HB',
                 'HCPCS',
                 'HCPT',
                 'HHC',
                 'HI',
                 'HL7nnnn',
                 'HOT',
                 'HPC',
                 'I10',
                 'I10P',
                 'I9',
                 'I9C',
                 'IBT',
                 'IBTnnnn',
                 'IC2',
                 'ICD10AM',
                 'ICD10CA',
                 'ICDO',
                 'ICS',
                 'ICSD',
                 'ISO+',
                 'ISOnnnn',
                 'IUPC',
                 'IUPP',
                 'JC10',
                 'JC8',
                 'JJ1017',
                 'LB',
                 'LN',
                 'MCD',
                 'MCR',
                 'MDDX',
                 'MEDC',
                 'MEDR',
                 'MEDX',
                 'MGPI',
                 'MVX',
                 'NDA',
                 'NDC',
                 'NIC',
                 'NPI',
                 'NUBC',
                 'OHA',
                 'POS',
                 'RC',
                 'SDM',
                 'SNM',
                 'SNM3',
                 'SNT',
                 'UC',
                 'UMD',
                 'UML',
                 'UPC',
                 'UPIN',
                 'USPS',
                 'W1',
                 'W2',
                 'W4',
                 'WC',
                 'NABM',
                 '99IHE')),
    'HL70397': ('Sequencing',
                ('A',
                 'AN',
                 'D',
                 'DN',
                 'N')),
    'HL70398': ('Continuation style code',
                ('F',
                 'I')),
    'HL70399': ('Country code',
                ('AFG',
                 'ALB',
                 'DZA',
                 'ASM',
                 'AND',
                 'AGO',
                 'AIA',
                 'ATG',
                 'ARG',
                 'ARM',
                 'ABW',
                 'AUS',
                 'AZE',
                 'BHS',
                 'BHR',
                 'BGD',
                 'BRB',
                 'BLR',
                 'BLZ',
                 'BEN',
                 'BMU',
                 'BTN',
                 'BOL',
                 'BIH',
                 'BWA',
                 'BRA',
                 'BRN',
                 'BFA',
                 'BDI',
                 'KHM',
                 'CMR',
                 'CAN',
                 'CPV',
                 'CYM',
                 'CAF',
                 'TCD',
                 'CHL',
                 'CHN',
                 'COL',
                 'COM',
                 'COG',
                 'COD',
                 'COK',
                 'CRI',
                 'CIV',
                 'HRV',
                 'CUB',
                 'DJI',
                 'DMA',
                 'DOM',
                 'ECU',
                 'EGY',
                 'SLV',
                 'GNQ',
                 'ERI',
                 'ETH',
                 'FLK',
                 'FRO',
                 'FJI',
                 'GUF',
                 'PYF',
                 'GAB',
                 'GMB',
                 'GEO',
                 'GHA',
                 'GIB',
                 'GRC',
                 'GRL',
                 'GRD',
                 'GLP',
                 'GUM',
                 'GTM',
                 'GIN',
                 'GNB',
                 'GUY',
                 'HTI',
                 'VAT',
                 'HND',
                 'HKG',
                 'ISL',
                 'IND',
                 'IDN',
                 'IRN',
                 'IRQ',
                 'ISR',
                 'JAM',
                 'JPN',
                 'JOR',
                 'KAZ',
                 'KEN',
                 'KIR',
                 'PRK',
                 'KOR',
                 'KWT',
                 'KGZ',
                 'LAO',
                 'LBN',
                 'LSO',
                 'LBR',
                 'LBY',
                 'LIE',
                 'MAC',
                 'MKD',
                 'MDG',
                 'MWI',
                 'MYS',
                 'MDV',
                 'MLI',
                 'MHL',
                 'MTQ',
                 'MRT',
                 'MUS',
                 'MEX',
                 'FSM',
                 'MDA',
                 'MCO',
                 'MNG',
                 'MSR',
                 'MAR',
                 'MOZ',
                 'MMR',
                 'NAM',
                 'NRU',
                 'NPL',
                 'ANT',
                 'NCL',
                 'NZL',
                 'NIC',
                 'NER',
                 'NGA',
                 'NIU',
                 'NFK',
                 'MNP',
                 'NOR',
                 'OMN',
                 'PAK',
                 'PLW',
                 'PAN',
                 'PNG',
                 'PRY',
                 'PER',
                 'PHL',
                 'PCN',
                 'PRI',
                 'QAT',
                 'REU',
                 'RUS',
                 'RWA',
                 'SHN',
                 'KNA',
                 'LCA',
                 'SPM',
                 'VCT',
                 'WSM',
                 'SMR',
                 'STP',
                 'SAU',
                 'SEN',
                 'SYC',
                 'SLE',
                 'SGP',
                 'SLB',
                 'SOM',
                 'ZAF',
                 'LKA',
                 'SDN',
                 'SUR',
                 'SJM',
                 'SWZ',
                 'CHE',
                 'SYR',
                 'TWN',
                 'TJK',
                 'TZA',
                 'THA',
                 'TGO',
                 'TKL',
                 'TON',
                 'TTO',
                 'TUN',
                 'TUR',
                 'TKM',
                 'TCA',
                 'TUV',
                 'UGA',
                 'UKR',
                 'ARE',
                 'USA',
                 'URY',
                 'UZB',
                 'VUT',
                 'VEN',
                 'VNM',
                 'VGB',
                 'VIR',
                 'WLF',
                 'ESH',
                 'YEM',
                 'ZMB',
                 'ZWE',
                 'AUT',
                 'BEL',
                 'CYP',
                 'CZE',
                 'DNK',
                 'EST',
                 'FIN',
                 'FRA',
                 'DEU',
                 'HUN',
                 'IRL',
                 'ITA',
                 'LVA',
                 'LTU',
                 'LUX',
                 'MLT',
                 'NLD',
                 'POL',
                 'PRT',
                 'SVK',
                 'SVN',
                 'ESP',
                 'SWE',
                 'GBR',
                 'ROM',
                 'BGR')),
    'HL70401': ('Government reimbursement program',
                ('C',
                 'MM')),
    'HL70402': ('School type',
                ('D',
                 'G',
                 'M',
                 'U')),
    'HL70403': ('Language Ability',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70404': ('Language Proficiency',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6')),
    'HL70406': ('Organization unit type',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 'H',
                 'O')),
    'HL70409': ('Application change type',
                ('M',
                 'SD',
                 'SU')),
    'HL70415': ('DRG Transfer Type',
                ('E',
                 'N')),
    'HL70416': ('Procedure DRG Type',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70417': ('Tissue Type Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 'B',
                 'C',
                 'G')),
    'HL70418': ('Procedure Priority',
                ('0',
                 '1',
                 '2 _')),
    'HL70421': ('Severity of Illness Code',
                ('MI',
                 'MO',
                 'SE')),
    'HL70422': ('Triage Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '99')),
    'HL70423': ('Case Category Code',
                ('D',)),
    'HL70424': ('Gestation Category Code',
                ('1',
                 '2',
                 '3')),
    'HL70425': ('Newborn Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70426': ('Blood Product Code',
                ('CRYO',
                 'CRYOP',
                 'FFP',
                 'FFPTH',
                 'PC',
                 'PCA',
                 'PCNEO',
                 'PCW',
                 'PLT',
                 'PLTNEO',
                 'PLTP',
                 'PLTPH',
                 'PLTPHLR',
                 'RWB',
                 'WBA')),
    'HL70427': ('Risk Management Incident Code',
                ('B',
                 'C',
                 'D',
                 'E',
                 'F',
                 'H',
                 'I',
                 'J',
                 'K',
                 'O',
                 'P',
                 'R',
                 'S',
                 'T')),
    'HL70428': ('Incident Type Code',
                ('O',
                 'P',
                 'U')),
    'HL70429': ('Production Class Code',
                ('BR',
                 'DA',
                 'DR',
                 'DU',
                 'LY',
                 'MT',
                 'NA',
                 'OT',
                 'PL',
                 'RA',
                 'SH',
                 'U')),
    'HL70430': ('Mode of Arrival Code',
                ('A',
                 'C',
                 'F',
                 'H',
                 'O',
                 'P',
                 'U')),
    'HL70431': ('Recreational Drug Use Code',
                ('A',
                 'C',
                 'K',
                 'M',
                 'O',
                 'T',
                 'U')),
    'HL70432': ('Admission Level of Care Code',
                ('AC',
                 'CH',
                 'CO',
                 'CR',
                 'IM',
                 'MO')),
    'HL70433': ('Precaution Code',
                ('A',
                 'B',
                 'C',
                 'D',
                 'I',
                 'N',
                 'O',
                 'P',
                 'U')),
    'HL70434': ('Patient Condition Code',
                ('A',
                 'C',
                 'O',
                 'P',
                 'S',
                 'U')),
    'HL70435': ('Advance Directive Code',
                ('DNR',)),
    'HL70436': ('Sensitivity to Causative Agent Code',
                ('AD',
                 'AL',
                 'CT',
                 'IN')),
    'HL70437': ('Alert Device Code',
                ('B',
                 'N',
                 'W')),
    'HL70438': ('Allergy Clinical Status',
                ('C',
                 'D',
                 'E',
                 'I',
                 'P',
                 'S',
                 'U')),
    'HL70440': ('Data types',
                ('AD',
                 'AUI',
                 'CCD',
                 'CCP',
                 'CD',
                 'CE',
                 'CF',
                 'CK',
                 'CM',
                 'CN',
                 'CNE',
                 'CNS',
                 'CP',
                 'CQ',
                 'CSU',
                 'CWE',
                 'CX',
                 'DDI',
                 'DIN',
                 'DLD',
                 'DLN',
                 'DLT',
                 'DR',
                 'DT',
                 'DTM',
                 'DTN',
                 'ED',
                 'EI',
                 'EIP',
                 'ELD',
                 'ERL',
                 'FC',
                 'FN',
                 'FT',
                 'GTS',
                 'HD',
                 'ICD',
                 'ID',
                 'IS',
                 'JCC',
                 'LA1',
                 'LA2',
                 'MA',
                 'MO',
                 'MOC',
                 'MOP',
                 'MSG',
                 'NA',
                 'NDL',
                 'NM',
                 'NR',
                 'OCD',
                 'OSD',
                 'OSP',
                 'PIP',
                 'PL',
                 'PLN',
                 'PN',
                 'PPN',
                 'PRL',
                 'PT',
                 'PTA',
                 'QIP',
                 'QSC',
                 'RCD',
                 'RFR',
                 'RI',
                 'RMC',
                 'RP',
                 'RPT',
                 'SAD',
                 'SCV',
                 'SI',
                 'SN',
                 'SPD',
                 'SPS',
                 'SRT',
                 'ST',
                 'TM',
                 'TN',
                 'TQ',
                 'TS',
                 'TX',
                 'UVC',
                 'VH',
                 'VID',
                 'VR',
                 'WVI',
                 'WVS',
                 'XAD',
                 'XCN',
                 'XON',
                 'XPN',
                 'XTN')),
    'HL70441': ('Immunization Registry Status',
                ('A',
                 'I',
                 'L',
                 'M',
                 'O',
                 'P',
                 'U')),
    'HL70442': ('Location Service Code',
                ('D',
                 'E',
                 'P',
                 'T')),
    'HL70443': ('Provider role',
                ('AD',
                 'AT',
                 'CP',
                 'FHCP',
                 'PP',
                 'RP',
                 'RT')),
    'HL70444': ('Name assembly order',
                ('F',
                 'G')),
    'HL70445': ('Identity Reliability Code',
                ('AL',
                 'UA',
                 'UD',
                 'US')),
    'HL70450': ('Event type',
                ('LOG',
                 'SER')),
    'HL70451': ('Substance identifier',
                ('ALL',)),
    'HL70452': ('Health care provider type code',
                ('SUGGESTION',)),
    'HL70453': ('Health care provider classification',
                ('SUGGESTION',)),
    'HL70454': ('Health care provider area of specialization',
                ('SUGGESTION',)),
    'HL70455': ('Type of Bill Code',
                ()),
    'HL70456': ('Revenue code',
                ()),
    'HL70457': ('Overall Claim Disposition Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70458': ('OCE Edit Code',
                ('1',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '2',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '3',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35.',
                 '36.',
                 '37',
                 '38.',
                 '39.',
                 '4',
                 '40.',
                 '41.',
                 '42.',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9')),
    'HL70459': ('Reimbursement Action Code',
                ('0',
                 '1',
                 '2',
                 '3')),
    'HL70460': ('Denial or Rejection Code',
                ('0',
                 '1',
                 '2')),
    'HL70465': ('Name/address representation',
                ('A',
                 'I',
                 'P')),
    'HL70466': ('Ambulatory Payment Classification Code',
                ('031',
                 '163',
                 '181')),
    'HL70467': ('Modifier Edit Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 'U')),
    'HL70468': ('Payment Adjustment Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70469': ('Packaging Status Code',
                ('0',
                 '1',
                 '2')),
    'HL70470': ('Reimbursement Type Code',
                ('Crnl',
                 'DME',
                 'EPO',
                 'Lab',
                 'Mamm',
                 'NoPay',
                 'OPPS',
                 'PartH',
                 'Pckg',
                 'Thrpy')),
    'HL70472': ('TQ conjunction ID',
                ('A',
                 'C',
                 'S')),
    'HL70473': ('Formulary Status',
                ('G',
                 'N',
                 'R',
                 'Y')),
    'HL70474': ('Organization Unit Type',
                ('D',
                 'F',
                 'S',
                 'U',
                 'V')),
    'HL70475': ('Charge Type Reason',
                ('01',
                 '02',
                 '03',
                 '04',
                 '05')),
    'HL70477': ('Controlled Substance Schedule*',
                ('I',
                 'II',
                 'III',
                 'IV',
                 'V',
                 'VI')),
    'HL70478': ('Formulary Status',
                ('G',
                 'N',
                 'R',
                 'Y')),
    'HL70480': ('Pharmacy Order Types',
                ('M',
                 'O',
                 'S')),
    'HL70482': ('Order Type',
                ('I',
                 'O')),
    'HL70483': ('Authorization Mode',
                ('EL',
                 'EM',
                 'FX',
                 'IP',
                 'MA',
                 'PA',
                 'PH',
                 'RE',
                 'VC',
                 'VO')),
    'HL70484': ('Dispense Type',
                ('B',
                 'C',
                 'N',
                 'P',
                 'Q',
                 'R',
                 'S',
                 'T',
                 'Z')),
    'HL70485': ('Extended Priority Codes',
                ('A',
                 'C',
                 'P',
                 'PRN',
                 'R',
                 'S',
                 'T',
                 'TD<integer>',
                 'TH<integer>',
                 'TL<integer>',
                 'TM<integer>',
                 'TS<integer>',
                 'TW<integer>')),
    'HL70487': ('Specimen Type',
                ('ABS',
                 'AMN',
                 'ASP',
                 'BIFL',
                 'BLDA',
                 'BBL',
                 'BLDC',
                 'BPU',
                 'BLDV',
                 'BON',
                 'BRO',
                 'BRN',
                 'CALC',
                 'CDM',
                 'CNL',
                 'CTP',
                 'CSF',
                 'CVM',
                 'CVX',
                 'COL',
                 'BLDCO',
                 'CNJT',
                 'CUR',
                 'CYST',
                 'DIAF',
                 'DOSE',
                 'DRN',
                 'DUFL',
                 'EAR',
                 'EARW',
                 'ELT',
                 'ENDC',
                 'ENDM',
                 'EYE',
                 'EXG',
                 'FLT',
                 'FIST',
                 'FLU',
                 'GAS',
                 'GAST',
                 'GEN',
                 'GENC',
                 'GENL',
                 'GENV',
                 'HAR',
                 'IHG',
                 'IT',
                 'ISLT',
                 'LAM',
                 'LN',
                 'LNA',
                 'LNV',
                 'LIQ',
                 'MAR',
                 'MEC',
                 'MBLD',
                 'MLK',
                 'MILK',
                 'NAIL',
                 'NOS',
                 'ORH',
                 'PAFL',
                 'PRT',
                 'PLC',
                 'PLAS',
                 'PLB',
                 'PLR',
                 'PPP',
                 'PRP',
                 'PUS',
                 'RT',
                 'SAL',
                 'SMN',
                 'SER',
                 'SKN',
                 'SKM',
                 'SPRM',
                 'SPT',
                 'SPTC',
                 'SPTT',
                 'STL',
                 'SWT',
                 'SNV',
                 'TEAR',
                 'THRT',
                 'TISS',
                 'TISG',
                 'TLGI',
                 'TLNG',
                 'TISPL',
                 'TSMI',
                 'TISU',
                 'TUB',
                 'ULC',
                 'UMB',
                 'UMED',
                 'URTH',
                 'UR',
                 'URC',
                 'URT',
                 'URNS',
                 'USUB',
                 'VITF',
                 'VOM',
                 'BLD',
                 'BDY',
                 'WAT',
                 'WICK',
                 'WND',
                 'WNDA',
                 'WNDE',
                 'WNDD')),
    'HL70488': ('Specimen Collection Method',
                ('ANP',
                 'BAP',
                 'BCAE',
                 'BCAN',
                 'BCPD',
                 'BIO',
                 'CAP',
                 'CATH',
                 'CVP',
                 'EPLA',
                 'ESWA',
                 'FNA',
                 'KOFFP',
                 'LNA',
                 'LNV',
                 'MARTL',
                 'ML11',
                 'MLP',
                 'NYP',
                 'PACE',
                 'PIN',
                 'PNA',
                 'PRIME',
                 'PUMP',
                 'QC5',
                 'SCLP',
                 'SCRAPS',
                 'SHA',
                 'SWA',
                 'SWD',
                 'TMAN',
                 'TMCH',
                 'TMM4',
                 'TMMY',
                 'TMOT',
                 'TMP',
                 'TMPV',
                 'TMSC',
                 'TMUP',
                 'TMVI',
                 'VENIP',
                 'WOOD')),
    'HL70489': ('Risk Codes',
                ('AGG',
                 'BHZ',
                 'BIO',
                 'COR',
                 'ESC',
                 'EXP',
                 'IFL',
                 'INF',
                 'INJ',
                 'POI',
                 'RAD')),
    'HL70490': ('Specimen Reject Reason',
                ('EX',
                 'QS',
                 'RA',
                 'RB',
                 'RC',
                 'RD',
                 'RE',
                 'RH',
                 'RI',
                 'RM',
                 'RN',
                 'RP',
                 'RR',
                 'RS')),
    'HL70491': ('Specimen Quality',
                ('E',
                 'F',
                 'G',
                 'P')),
    'HL70492': ('Specimen Appropriateness',
                ('??',
                 'A',
                 'I',
                 'P')),
    'HL70493': ('Specimen Condition',
                ('AUT',
                 'CLOT',
                 'CON',
                 'COOL',
                 'FROZ',
                 'HEM',
                 'LIVE',
                 'ROOM',
                 'SNR')),
    'HL70494': ('Specimen Child Role',
                ('A',
                 'C',
                 'M')),
    'HL70495': ('Body Site Modifier',
                ('ANT',
                 'BIL',
                 'DIS',
                 'EXT',
                 'L',
                 'LAT',
                 'LLQ',
                 'LOW',
                 'LUQ',
                 'MED',
                 'POS',
                 'PRO',
                 'R',
                 'RLQ',
                 'RUQ',
                 '\u00a0UPP')),
    'HL70496': ('Consent Type',
                ('001',
                 '002',
                 '003',
                 '004',
                 '005',
                 '006',
                 '007',
                 '008',
                 '009',
                 '010',
                 '011',
                 '012',
                 '013',
                 '014',
                 '015',
                 '016',
                 '017',
                 '018',
                 '019',
                 '020',
                 '021',
                 '022',
                 '023',
                 '024',
                 '025',
                 '026',
                 '027',
                 '028',
                 '029',
                 '030',
                 '031',
                 '032',
                 '033',
                 '034',
                 '035',
                 '036',
                 '037',
                 '038',
                 '039',
                 '040',
                 '041',
                 '042',
                 '043',
                 '044',
                 '045',
                 '046',
                 '047',
                 '048',
                 '049',
                 '050',
                 '051',
                 '052',
                 '053',
                 '054',
                 '055',
                 '056',
                 '057',
                 '058',
                 '059',
                 '060',
                 '061',
                 '062',
                 '063',
                 '064',
                 '065',
                 '066',
                 '067',
                 '068',
                 '069',
                 '070',
                 '071',
                 '072',
                 '073',
                 '074',
                 '075',
                 '076',
                 '077',
                 '078',
                 '079',
                 '080',
                 '081',
                 '082',
                 '083',
                 '084',
                 '085',
                 '086',
                 '087',
                 '088',
                 '089',
                 '090',
                 '091',
                 '092',
                 '093',
                 '094',
                 '095',
                 '096',
                 '097',
                 '098',
                 '099',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '105',
                 '106',
                 '107',
                 '108',
                 '109',
                 '110',
                 '111',
                 '112',
                 '113',
                 '1137',
                 '114',
                 '115',
                 '116',
                 '117',
                 '118',
                 '119',
                 '120',
                 '121',
                 '122',
                 '123',
                 '124',
                 '125',
                 '126',
                 '127',
                 '128',
                 '129',
                 '130',
                 '131',
                 '132',
                 '133',
                 '134',
                 '135',
                 '136')),
    'HL70497': ('Consent Mode',
                ('T',
                 'V',
                 'W')),
    'HL70498': ('Consent Status',
                ('A',
                 'B',
                 'L',
                 'P',
                 'R',
                 'X')),
    'HL70499': ('Consent Bypass Reason',
                ('E',
                 'PJ')),
    'HL70500': ('Consent Disclosure Level',
                ('F',
                 'N',
                 'P')),
    'HL70501': ('Consent Non-Disclosure Reason',
                ('E',
                 'PR',
                 'RX')),
    'HL70502': ('Non-Subject Consenter Reason',
                ('LM',
                 'MIN',
                 'NC')),
    'HL70503': ('Sequence/Results Flag',
                ('C',
                 'R',
                 'S')),
    'HL70504': ('Sequence Condition Code',
                ('EE',
                 'ES',
                 'SE',
                 'SS')),
    'HL70505': ('Cyclic Entry/Exit Indicator',
                ('*',
                 '#')),
    'HL70506': ('Service Request Relationship',
                ('C',
                 'E',
                 'N',
                 'S',
                 'T')),
    'HL70507': ('Observation Result Handling',
                ('F',
                 'N')),
    'HL70508': ('Blood Product Processing Requirements',
                ('AU',
                 'CM',
                 'CS',
                 'DI',
                 'FR',
                 'HB',
                 'HL',
                 'IG',
                 'IR',
                 'LR',
                 'WA')),
    'HL70510': ('Blood Product Dispense Status',
                ('CR',
                 'DS',
                 'PT',
                 'RA',
                 'RD',
                 'RE',
                 'RI',
                 'RL',
                 'RQ',
                 'RS',
                 'WA')),
    'HL70511': ('BP Observation Status Codes Interpretation',
                ('C',
                 'D',
                 'F',
                 'O',
                 'P',
                 'W')),
    'HL70513': ('Blood Product Transfusion/Disposition Status',
                ('RA',
                 'RL',
                 'TR',
                 'TX',
                 'WA')),
    'HL70514': ('Transfusion Adverse Reaction',
                ('ABOINC',
                 'ACUTHEHTR',
                 'ALLERGIC1',
                 'ALLERGIC2',
                 'ALLERGICR',
                 'ANAPHYLAC',
                 'BACTCONTAM',
                 'DELAYEDHTR',
                 'DELAYEDSTR',
                 'GVHD',
                 'HYPOTENS',
                 'NONHTR1',
                 'NONHTR2',
                 'NONHTRREC',
                 'NONIMMUNE',
                 'NONSPEC',
                 'NORXN',
                 'PTP',
                 'VOLOVER')),
    'HL70516': ('Error severity',
                ('E',
                 'I',
                 'W')),
    'HL70517': ('Inform person code',
                ('HD',
                 'NPAT',
                 'PAT',
                 'USR')),
    'HL70518': ('Override type',
                ('EQV',
                 'EXTN',
                 'INLV')),
    'HL70519': ('Override reason',
                ()),
    'HL70523': ('Computation type',
                ('%',
                 'a')),
    'HL70524': ('Sequence condition',
                ('C',
                 'R',
                 'S')),
    'HL70527': ('Calendar alignment',
                ('DM',
                 'DW',
                 'DY',
                 'HD',
                 'MY',
                 'NH',
                 'SN',
                 'WY')),
    'HL70528': ('Event related period',
                ('AC',
                 'ACD',
                 'ACM',
                 'ACV',
                 'HS',
                 'IC',
                 'ICD',
                 'ICM',
                 'ICV',
                 'PC',
                 'PCD',
                 'PCM',
                 'PCV')),
    'HL70529': ('Precision',
                ('D',
                 'H',
                 'L',
                 'M',
                 'S',
                 'Y')),
    'HL70530': ('Organization, agency, department ',
                ('AE',
                 'DEA',
                 'DOD',
                 'MC',
                 'VA',
                 'VI')),
    'HL70532': ('Expanded yes/no indicator',
                ('ASKU',
                 'N',
                 'NA',
                 'NASK',
                 'NAV',
                 'NI',
                 'NP',
                 'UNK',
                 'Y')),
    'HL70534': ('Notify Clergy Code',
                ('L',
                 'N',
                 'O',
                 'U',
                 'Y')),
    'HL70535': ('Signature Code',
                ('C',
                 'M',
                 'P',
                 'S')),
    'HL70536': ('Certificate Status',
                ('E',
                 'I',
                 'P',
                 'R',
                 'V')),
    'HL70537': ('Institution',
                ()),
    'HL70538': ('Institution Relationship Type',
                ('CON',
                 'CST',
                 'EMP',
                 'VOL')),
    'HL70540': ('Inactive Reason Code',
                ('L',
                 'R',
                 'T')),
    'HL70547': ('Jurisdictional Breadth',
                ('C',
                 'N',
                 'S')),
    'HL70548': ('Signatory_s Relationship to Subject',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7')),
    'HL70550': ('Body Parts',
                ('\u00a0',
                 'ACET',
                 'ACHIL',
                 'ADB',
                 'ADE',
                 'ADR',
                 'AMN',
                 'AMS',
                 'ANAL',
                 'ANKL',
                 'ANTEC',
                 'ANTECF',
                 'ANTR',
                 'ANUS',
                 'AORTA',
                 'APDX',
                 'AR',
                 'AREO',
                 'ARM',
                 'ARTE',
                 'ASCIT',
                 'ASCT',
                 'ATR',
                 'AURI',
                 'AV',
                 'AXI',
                 'BACK',
                 'BARTD',
                 'BARTG',
                 'BCYS',
                 'BDY',
                 'BID',
                 'BIFL',
                 'BLAD',
                 'BLD',
                 'BLDA',
                 'BLDC',
                 'BLDV',
                 'BLOOD',
                 'BMAR',
                 'BON',
                 'BOWEL',
                 'BOWLA',
                 'BOWSM',
                 'BPH',
                 'BRA',
                 'BRAIN',
                 'BRO',
                 'BROCH',
                 'BRONC',
                 'BROW',
                 'BRST',
                 'BRSTFL',
                 'BRTGF',
                 'BRV',
                 'BUCCA',
                 'BURSA',
                 'BURSF',
                 'BUTT',
                 'CALF',
                 'CANAL',
                 'CANLI',
                 'CANTH',
                 'CARO',
                 'CARP',
                 'CAVIT',
                 'CBLD',
                 'CDM',
                 'CDUCT',
                 'CECUM',
                 'CERVUT',
                 'CHE',
                 'CHEEK',
                 'CHES',
                 'CHEST\u00a0',
                 'CHIN',
                 'CIRCU',
                 'CLAVI',
                 'CLIT',
                 'CLITO',
                 'CNL',
                 'COCCG',
                 'COCCY',
                 'COLON',
                 'COLOS',
                 'CONJ',
                 'COR',
                 'CORAL',
                 'CORD',
                 'CORN',
                 'COS',
                 'CRANE',
                 'CRANF',
                 'CRANO',
                 'CRANP',
                 'CRANS',
                 'CRANT',
                 'CSF',
                 'CUBIT',
                 'CUFF',
                 'CULD',
                 'CULDO',
                 'CVX',
                 'DELT',
                 'DEN',
                 'DENTA',
                 'DIAF',
                 'DIGIT',
                 'DISC',
                 'DORS',
                 'DPH',
                 'DUFL',
                 'DUODE',
                 'DUR',
                 'EAR',
                 'EARBI',
                 'EARBM',
                 'EARBS',
                 'EARLO',
                 'EC',
                 'ELBOW',
                 'ELBOWJ',
                 'ENDC',
                 'ENDM',
                 'EOLPH',
                 'EOS',
                 'EPD',
                 'EPICA',
                 'EPICM',
                 'EPIDU',
                 'EPIGL',
                 'ESO',
                 'ESOPG',
                 'ET',
                 'ETHMO',
                 'EUR',
                 'EYE',
                 'EYELI',
                 'FACE',
                 'FALLT',
                 'FBINC',
                 'FBLAC',
                 'FBMAX',
                 'FBNAS',
                 'FBPAL',
                 'FBVOM',
                 'FBZYG',
                 'FEMOR',
                 'FEMUR',
                 'FET',
                 'FIBU',
                 'FING',
                 'FINGN',
                 'FMH',
                 'FOL',
                 'FOOT',
                 'FOREA',
                 'FOREH',
                 'FORES',
                 'FOURC',
                 'GB',
                 'GEN',
                 'GENC',
                 'GENL',
                 'GL',
                 'GLAND',
                 'GLANS',
                 'GLUT',
                 'GLUTE',
                 'GLUTM',
                 'GROIN',
                 'GUM',
                 'GVU',
                 'HAL',
                 'HAND',
                 'HAR',
                 'HART',
                 'HEAD',
                 'HEEL',
                 'HEM',
                 'HIP',
                 'HIPJ',
                 'HUMER',
                 'HV',
                 'HVB',
                 'HVT',
                 'HYMEN',
                 'ICX',
                 'ILC',
                 'ILCON',
                 'ILCR',
                 'ILE',
                 'ILEOS',
                 'ILEUM',
                 'ILIAC',
                 'INASA',
                 'INGUI',
                 'INSTL',
                 'INSTS',
                 'INT',
                 'INTRO',
                 'INTRU',
                 'ISCHI',
                 'ISH',
                 'JAW',
                 'JUGI',
                 'KIDN\u00a0',
                 'KNEE',
                 'KNEEF',
                 'KNEEJ',
                 'LABIA',
                 'LABMA',
                 'LABMI',
                 'LACRI',
                 'LAM',
                 'LARYN',
                 'LEG',
                 'LENS',
                 'LING',
                 'LINGU',
                 'LIP',
                 'LIVER',
                 'LMN',
                 'LN',
                 'LNG',
                 'LOBE',
                 'LOCH',
                 'LUMBA',
                 'LUNG',
                 'LYM',
                 'MAC',
                 'MALLE',
                 'MANDI',
                 'MAR',
                 'MAST',
                 'MAXIL',
                 'MAXS',
                 'MEATU',
                 'MEC',
                 'MEDST',
                 'MEDU',
                 'METAC',
                 'METAT',
                 'MILK',
                 'MITRL',
                 'MOLAR',
                 'MONSU',
                 'MONSV',
                 'MOU',
                 'MOUTH',
                 'MP',
                 'MPB',
                 'MRSA2',
                 'MYO',
                 'NAIL',
                 'NAILB',
                 'NAILF',
                 'NAILT',
                 'NARES',
                 'NASL',
                 'NAVEL',
                 'NECK',
                 'NERVE',
                 'NIPPL',
                 'NLACR',
                 'NOS',
                 'NOSE',
                 'NOSTR',
                 'NP',
                 'NSS',
                 'NTRAC',
                 'OCCIP',
                 'OLECR',
                 'OMEN',
                 'ORBIT',
                 'ORO',
                 'OSCOX',
                 'OVARY',
                 'PAFL',
                 'PALAT',
                 'PALM',
                 'PANAL',
                 'PANCR',
                 'PARAT',
                 'PARIE',
                 'PARON',
                 'PAROT',
                 'PAS',
                 'PATEL',
                 'PCARD',
                 'PCLIT',
                 'PELV',
                 'PENIS',
                 'PENSH',
                 'PER',
                 'PERI',
                 'PERIH',
                 'PERIN',
                 'PERIS',
                 'PERIT',
                 'PERIU',
                 'PERIV',
                 'PERRA',
                 'PERT',
                 'PHALA',
                 'PILO',
                 'PINNA',
                 'PLACF',
                 'PLACM',
                 'PLANT',
                 'PLATH',
                 'PLATS',
                 'PLC',
                 'PLEU',
                 'PLEUR',
                 'PLR',
                 'PNEAL',
                 'PNEPH',
                 'PNM',
                 'POPLI',
                 'PORBI',
                 'PREAU',
                 'PRERE',
                 'PROS',
                 'PRST',
                 'PTONS',
                 'PUBIC',
                 'PUL',
                 'RADI',
                 'RADIUS',
                 'RBC',
                 'RECTL',
                 'RECTU',
                 'RENL',
                 'RIB',
                 'RNP',
                 'RPERI',
                 'SAC',
                 'SACIL',
                 'SACRA',
                 'SACRO',
                 'SACRU',
                 'SALGL',
                 'SCALP',
                 'SCAPU',
                 'SCLAV',
                 'SCLER',
                 'SCLV',
                 'SCROT',
                 'SDP',
                 'SEM',
                 'SEMN',
                 'SEPTU',
                 'SEROM',
                 'SGF',
                 'SHIN',
                 'SHOL',
                 'SHOLJ',
                 'SIGMO',
                 'SINUS',
                 'SKENE',
                 'SKM',
                 'SKULL',
                 'SOLE',
                 'SPCOR',
                 'SPHEN',
                 'SPLN',
                 'SPRM',
                 'SPX',
                 'STER',
                 'STOM',
                 'STOMA',
                 'STOOLL',
                 'STUMP',
                 'SUB',
                 'SUBD',
                 'SUBM',
                 'SUBME',
                 'SUBPH',
                 'SUBX',
                 'SUPB',
                 'SUPRA',
                 'SWT',
                 'SWTG',
                 'SYN',
                 'SYNOL',
                 'SYNOV',
                 'TARS',
                 'TBRON',
                 'TCN',
                 'TDUCT',
                 'TEAR',
                 'TEMPL',
                 'TEMPO',
                 'TESTI',
                 'THIGH',
                 'THM',
                 'THORA',
                 'THRB',
                 'THUMB',
                 'THYRD',
                 'TIBIA',
                 'TML',
                 'TNL',
                 'TOE',
                 'TOEN',
                 'TONG',
                 'TONS',
                 'TOOTH',
                 'TRCHE',
                 'TSK',
                 'ULNA',
                 'UMB',
                 'UMBL',
                 'URET',
                 'URTH',
                 'USTOM',
                 'UTER',
                 'UTERI',
                 'VAGIN',
                 'VAL',
                 'VAS',
                 'VASTL',
                 'VAULT',
                 'VCSF',
                 'VCUFF',
                 'VEIN',
                 'VENTG',
                 'VERMI',
                 'VERTC',
                 'VERTL',
                 'VERTT',
                 'VESCL',
                 'VESFLD',
                 'VESI',
                 'VESTI',
                 'VGV',
                 'VITR',
                 'VOC',
                 'VULVA',
                 'WBC',
                 'WRIST'))
}
