from .groups import GROUPS
from .segments import SEGMENTS

MESSAGES = {
    'ACK': ('sequence',
            (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
             ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
             ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),)),
    'ADR_A19': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('ADR_A19_QUERY_RESPONSE', GROUPS['ADR_A19_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'ADT_A01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A01_PROCEDURE', GROUPS['ADT_A01_PROCEDURE'], (0, -1), 'GRP'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A01_INSURANCE', GROUPS['ADT_A01_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A03_PROCEDURE', GROUPS['ADT_A03_PROCEDURE'], (0, -1), 'GRP'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A06_PROCEDURE', GROUPS['ADT_A06_PROCEDURE'], (0, -1), 'GRP'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A06_INSURANCE', GROUPS['ADT_A06_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),)),
    'ADT_A12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, 1), 'SEG'),)),
    'ADT_A16': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),)),
    'ADT_A17': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A18': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),)),
    'ADT_A20': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('NPU', SEGMENTS['NPU'], (1, 1), 'SEG'),)),
    'ADT_A24': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),)),
    'ADT_A30': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (1, 1), 'SEG'),)),
    'ADT_A38': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (1, 1), 'SEG'),)),
    'ADT_A39': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('ADT_A39_PATIENT', GROUPS['ADT_A39_PATIENT'], (1, -1), 'GRP'),)),
    'ADT_A43': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('ADT_A43_PATIENT', GROUPS['ADT_A43_PATIENT'], (1, -1), 'GRP'),)),
    'ADT_A45': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ADT_A45_MERGE_INFO', GROUPS['ADT_A45_MERGE_INFO'], (1, -1), 'GRP'),)),
    'ADT_A50': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),)),
    'BAR_P01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('BAR_P01_VISIT', GROUPS['BAR_P01_VISIT'], (1, -1), 'GRP'),)),
    'BAR_P02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('BAR_P02_PATIENT', GROUPS['BAR_P02_PATIENT'], (1, -1), 'GRP'),)),
    'BAR_P06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('BAR_P06_PATIENT', GROUPS['BAR_P06_PATIENT'], (1, -1), 'GRP'),)),
    'CRM_C01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('CRM_C01_PATIENT', GROUPS['CRM_C01_PATIENT'], (1, -1), 'GRP'),)),
    'CSU_C09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('CSU_C09_PATIENT', GROUPS['CSU_C09_PATIENT'], (1, -1), 'GRP'),)),
    'DFT_P03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DFT_P03_FINANCIAL', GROUPS['DFT_P03_FINANCIAL'], (1, -1), 'GRP'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('DFT_P03_INSURANCE', GROUPS['DFT_P03_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),)),
    'DOC_T12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('DOC_T12_RESULT', GROUPS['DOC_T12_RESULT'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'DSR_Q01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'DSR_Q03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (0, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'EDR_R07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'EQQ_Q04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EQL', SEGMENTS['EQL'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'ERP_R09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('ERQ', SEGMENTS['ERQ'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MDM_T01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('TXA', SEGMENTS['TXA'], (1, 1), 'SEG'),)),
    'MDM_T02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('TXA', SEGMENTS['TXA'], (1, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (1, -1), 'SEG'),)),
    'MFK_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFN_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M01_MF', GROUPS['MFN_M01_MF'], (1, -1), 'GRP'),)),
    'MFN_M02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M02_MF_STAFF', GROUPS['MFN_M02_MF_STAFF'], (1, -1), 'GRP'),)),
    'MFN_M08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M08_MF_TEST_NUMERIC', GROUPS['MFN_M08_MF_TEST_NUMERIC'], (1, -1), 'GRP'),)),
    'MFN_M09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M09_MF_TEST_CATEGORICAL', GROUPS['MFN_M09_MF_TEST_CATEGORICAL'], (1, -1), 'GRP'),)),
    'MFN_M10': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M10_MF_TEST_BATTERIES', GROUPS['MFN_M10_MF_TEST_BATTERIES'], (1, -1), 'GRP'),)),
    'MFN_M11': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M11_MF_TEST_CALCULATED', GROUPS['MFN_M11_MF_TEST_CALCULATED'], (1, -1), 'GRP'),)),
    'MFQ_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MFR_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFR_M01_MF_QUERY', GROUPS['MFR_M01_MF_QUERY'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'NMD_N02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 (
                 'NMD_N02_CLOCK_AND_STATS_WITH_NOTES', GROUPS['NMD_N02_CLOCK_AND_STATS_WITH_NOTES'], (1, -1), 'GRP'),)),
    'NMQ_N01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NMQ_N01_QRY_WITH_DETAIL', GROUPS['NMQ_N01_QRY_WITH_DETAIL'], (0, 1), 'GRP'),
                 ('NMQ_N01_CLOCK_AND_STATISTICS', GROUPS['NMQ_N01_CLOCK_AND_STATISTICS'], (1, -1), 'GRP'),)),
    'NMR_N01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (0, 1), 'SEG'),
                 ('NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT', GROUPS['NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT'], (1, -1),
                  'GRP'),)),
    'OMD_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMD_O01_PATIENT', GROUPS['OMD_O01_PATIENT'], (0, 1), 'GRP'),
                 ('OMD_O01_ORDER_DIET', GROUPS['OMD_O01_ORDER_DIET'], (1, -1), 'GRP'),
                 ('OMD_O01_ORDER_TRAY', GROUPS['OMD_O01_ORDER_TRAY'], (0, -1), 'GRP'),)),
    'OMN_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMN_O01_PATIENT', GROUPS['OMN_O01_PATIENT'], (0, 1), 'GRP'),
                 ('OMN_O01_ORDER', GROUPS['OMN_O01_ORDER'], (1, -1), 'GRP'),)),
    'OMS_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMS_O01_PATIENT', GROUPS['OMS_O01_PATIENT'], (0, 1), 'GRP'),
                 ('OMS_O01_ORDER', GROUPS['OMS_O01_ORDER'], (1, -1), 'GRP'),)),
    'ORD_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORD_O02_RESPONSE', GROUPS['ORD_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'ORF_R04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('ORF_R04_QUERY_RESPONSE', GROUPS['ORF_R04_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'ORM_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORM_O01_PATIENT', GROUPS['ORM_O01_PATIENT'], (0, 1), 'GRP'),
                 ('ORM_O01_ORDER', GROUPS['ORM_O01_ORDER'], (1, -1), 'GRP'),)),
    'ORN_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORN_O02_RESPONSE', GROUPS['ORN_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'ORR_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORR_O02_RESPONSE', GROUPS['ORR_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'ORS_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORS_O02_RESPONSE', GROUPS['ORS_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'ORU_R01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('ORU_R01_PATIENT_RESULT', GROUPS['ORU_R01_PATIENT_RESULT'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'OSQ_Q06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'OSR_Q06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('OSR_Q06_RESPONSE', GROUPS['OSR_Q06_RESPONSE'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'PEX_P07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('PEX_P07_VISIT', GROUPS['PEX_P07_VISIT'], (0, 1), 'GRP'),
                 ('PEX_P07_EXPERIENCE', GROUPS['PEX_P07_EXPERIENCE'], (1, -1), 'GRP'),)),
    'PGL_PC6': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PGL_PC6_PATIENT_VISIT', GROUPS['PGL_PC6_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PGL_PC6_GOAL', GROUPS['PGL_PC6_GOAL'], (1, -1), 'GRP'),)),
    'PIN_I07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('PIN_I07_PROVIDER', GROUPS['PIN_I07_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PIN_I07_GUARANTOR_INSURANCE', GROUPS['PIN_I07_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'PPG_PCG': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PPG_PCG_PATIENT_VISIT', GROUPS['PPG_PCG_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PPG_PCG_PATHWAY', GROUPS['PPG_PCG_PATHWAY'], (1, -1), 'GRP'),)),
    'PPP_PCB': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PPP_PCB_PATIENT_VISIT', GROUPS['PPP_PCB_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PPP_PCB_PATHWAY', GROUPS['PPP_PCB_PATHWAY'], (1, -1), 'GRP'),)),
    'PPR_PC1': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PPR_PC1_PATIENT_VISIT', GROUPS['PPR_PC1_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PPR_PC1_PROBLEM', GROUPS['PPR_PC1_PROBLEM'], (1, -1), 'GRP'),)),
    'PPT_PCL': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('PPT_PCL_PATIENT', GROUPS['PPT_PCL_PATIENT'], (1, -1), 'GRP'),)),
    'PPV_PCA': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('PPV_PCA_PATIENT', GROUPS['PPV_PCA_PATIENT'], (1, -1), 'GRP'),)),
    'PRR_PC5': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('PRR_PC5_PATIENT', GROUPS['PRR_PC5_PATIENT'], (1, -1), 'GRP'),)),
    'PTR_PCF': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('PTR_PCF_PATIENT', GROUPS['PTR_PCF_PATIENT'], (1, -1), 'GRP'),)),
    'QCK_Q02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (0, 1), 'SEG'),)),
    'QRY_A19': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),)),
    'QRY_PC4': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),)),
    'QRY_Q01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QRY_Q02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QRY_R02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (1, 1), 'SEG'),)),
    'QRY_T12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),)),
    'RAR_RAR': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('RAR_RAR_DEFINITION', GROUPS['RAR_RAR_DEFINITION'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RAS_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RAS_O01_PATIENT', GROUPS['RAS_O01_PATIENT'], (0, 1), 'GRP'),
                 ('RAS_O01_ORDER', GROUPS['RAS_O01_ORDER'], (1, -1), 'GRP'),)),
    'RCI_I05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('RCI_I05_PROVIDER', GROUPS['RCI_I05_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('RCI_I05_OBSERVATION', GROUPS['RCI_I05_OBSERVATION'], (0, -1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RCL_I06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('RCL_I06_PROVIDER', GROUPS['RCL_I06_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (0, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RDE_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RDE_O01_PATIENT', GROUPS['RDE_O01_PATIENT'], (0, 1), 'GRP'),
                 ('RDE_O01_ORDER', GROUPS['RDE_O01_ORDER'], (1, -1), 'GRP'),)),
    'RDO_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RDO_O01_PATIENT', GROUPS['RDO_O01_PATIENT'], (0, 1), 'GRP'),
                 ('RDO_O01_ORDER', GROUPS['RDO_O01_ORDER'], (1, -1), 'GRP'),)),
    'RDR_RDR': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('RDR_RDR_DEFINITION', GROUPS['RDR_RDR_DEFINITION'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RDS_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RDS_O01_PATIENT', GROUPS['RDS_O01_PATIENT'], (0, 1), 'GRP'),
                 ('RDS_O01_ORDER', GROUPS['RDS_O01_ORDER'], (1, -1), 'GRP'),)),
    'REF_I12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('REF_I12_AUTHORIZATION_CONTACT', GROUPS['REF_I12_AUTHORIZATION_CONTACT'], (0, 1), 'GRP'),
                 ('REF_I12_PROVIDER', GROUPS['REF_I12_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('REF_I12_INSURANCE', GROUPS['REF_I12_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('REF_I12_PROCEDURE', GROUPS['REF_I12_PROCEDURE'], (0, -1), 'GRP'),
                 ('REF_I12_OBSERVATION', GROUPS['REF_I12_OBSERVATION'], (0, -1), 'GRP'),
                 ('REF_I12_PATIENT_VISIT', GROUPS['REF_I12_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RER_RER': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('RER_RER_DEFINITION', GROUPS['RER_RER_DEFINITION'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RGR_RGR': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('RGR_RGR_DEFINITION', GROUPS['RGR_RGR_DEFINITION'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RGV_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RGV_O01_PATIENT', GROUPS['RGV_O01_PATIENT'], (0, 1), 'GRP'),
                 ('RGV_O01_ORDER', GROUPS['RGV_O01_ORDER'], (1, -1), 'GRP'),)),
    'ROR_ROR': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('ROR_ROR_DEFINITION', GROUPS['ROR_ROR_DEFINITION'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RPA_I08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('RPA_I08_AUTHORIZATION', GROUPS['RPA_I08_AUTHORIZATION'], (0, 1), 'GRP'),
                 ('RPA_I08_PROVIDER', GROUPS['RPA_I08_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('RPA_I08_INSURANCE', GROUPS['RPA_I08_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('RPA_I08_PROCEDURE', GROUPS['RPA_I08_PROCEDURE'], (1, -1), 'GRP'),
                 ('RPA_I08_OBSERVATION', GROUPS['RPA_I08_OBSERVATION'], (0, -1), 'GRP'),
                 ('RPA_I08_VISIT', GROUPS['RPA_I08_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RPI_I01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RPI_I01_PROVIDER', GROUPS['RPI_I01_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('RPI_I01_GUARANTOR_INSURANCE', GROUPS['RPI_I01_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RPL_I02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RPL_I02_PROVIDER', GROUPS['RPL_I02_PROVIDER'], (1, -1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (0, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RQA_I08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('RQA_I08_AUTHORIZATION', GROUPS['RQA_I08_AUTHORIZATION'], (0, 1), 'GRP'),
                 ('RQA_I08_PROVIDER', GROUPS['RQA_I08_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('RQA_I08_GUARANTOR_INSURANCE', GROUPS['RQA_I08_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('RQA_I08_PROCEDURE', GROUPS['RQA_I08_PROCEDURE'], (0, -1), 'GRP'),
                 ('RQA_I08_OBSERVATION', GROUPS['RQA_I08_OBSERVATION'], (0, -1), 'GRP'),
                 ('RQA_I08_VISIT', GROUPS['RQA_I08_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQC_I05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('RQC_I05_PROVIDER', GROUPS['RQC_I05_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQC_I06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('RQC_I06_PROVIDER', GROUPS['RQC_I06_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQI_I01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('RQI_I01_PROVIDER', GROUPS['RQI_I01_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('RQI_I01_GUARANTOR_INSURANCE', GROUPS['RQI_I01_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQP_I04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('RQP_I04_PROVIDER', GROUPS['RQP_I04_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQQ_Q09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('ERQ', SEGMENTS['ERQ'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RRA_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRA_O02_RESPONSE', GROUPS['RRA_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'RRD_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRD_O02_RESPONSE', GROUPS['RRD_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'RRE_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRE_O02_RESPONSE', GROUPS['RRE_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'RRG_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRG_O02_RESPONSE', GROUPS['RRG_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'RRI_I12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (0, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('RRI_I12_AUTHORIZATION_CONTACT', GROUPS['RRI_I12_AUTHORIZATION_CONTACT'], (0, 1), 'GRP'),
                 ('RRI_I12_PROVIDER_CONTACT', GROUPS['RRI_I12_PROVIDER_CONTACT'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('RRI_I12_PROCEDURE', GROUPS['RRI_I12_PROCEDURE'], (0, -1), 'GRP'),
                 ('RRI_I12_OBSERVATION', GROUPS['RRI_I12_OBSERVATION'], (0, -1), 'GRP'),
                 ('RRI_I12_PATIENT_VISIT', GROUPS['RRI_I12_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RRO_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRO_O02_RESPONSE', GROUPS['RRO_O02_RESPONSE'], (0, 1), 'GRP'),)),
    'SIU_S12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SCH', SEGMENTS['SCH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('SIU_S12_PATIENT', GROUPS['SIU_S12_PATIENT'], (0, -1), 'GRP'),
                 ('SIU_S12_RESOURCES', GROUPS['SIU_S12_RESOURCES'], (1, -1), 'GRP'),)),
    'SPQ_Q08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SPR', SEGMENTS['SPR'], (1, 1), 'SEG'),
                 ('RDF', SEGMENTS['RDF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'SQM_S25': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('SQM_S25_REQUEST', GROUPS['SQM_S25_REQUEST'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'SQR_S25': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('SQR_S25_SCHEDULE', GROUPS['SQR_S25_SCHEDULE'], (0, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'SRM_S01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('ARQ', SEGMENTS['ARQ'], (1, 1), 'SEG'),
                 ('APR', SEGMENTS['APR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('SRM_S01_PATIENT', GROUPS['SRM_S01_PATIENT'], (0, -1), 'GRP'),
                 ('SRM_S01_RESOURCES', GROUPS['SRM_S01_RESOURCES'], (1, -1), 'GRP'),)),
    'SRR_S01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('SRR_S01_SCHEDULE', GROUPS['SRR_S01_SCHEDULE'], (0, 1), 'GRP'),)),
    'SUR_P09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SUR_P09_FACILITY', GROUPS['SUR_P09_FACILITY'], (1, -1), 'GRP'),)),
    'TBR_R08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('RDF', SEGMENTS['RDF'], (1, 1), 'SEG'),
                 ('RDT', SEGMENTS['RDT'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'UDM_Q05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('URD', SEGMENTS['URD'], (1, 1), 'SEG'),
                 ('URS', SEGMENTS['URS'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'VQQ_Q07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('VTQ', SEGMENTS['VTQ'], (1, 1), 'SEG'),
                 ('RDF', SEGMENTS['RDF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'VXQ_V01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),)),
    'VXR_V03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('VXR_V03_PATIENT_VISIT', GROUPS['VXR_V03_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('VXR_V03_INSURANCE', GROUPS['VXR_V03_INSURANCE'], (0, -1), 'GRP'),
                 ('VXR_V03_ORDER', GROUPS['VXR_V03_ORDER'], (0, -1), 'GRP'),)),
    'VXU_V04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('VXU_V04_PATIENT', GROUPS['VXU_V04_PATIENT'], (0, 1), 'GRP'),
                 ('VXU_V04_INSURANCE', GROUPS['VXU_V04_INSURANCE'], (0, -1), 'GRP'),
                 ('VXU_V04_ORDER', GROUPS['VXU_V04_ORDER'], (0, -1), 'GRP'),)),
    'VXX_V02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('VXX_V02_PATIENT', GROUPS['VXX_V02_PATIENT'], (1, -1), 'GRP'),)),
}
