from .datatypes import DATATYPES_STRUCTS

FIELDS = {
    'ACC_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ACCIDENT_DATE_TIME', None, -1),
    'ACC_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACCIDENT_CODE', 'HL70050', -1),
    'ACC_3': ('leaf', None, 'ST', 'ACCIDENT_LOCATION', None, -1),
    'ACC_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'AUTO_ACCIDENT_STATE', 'HL70347', -1),
    'ACC_5': ('leaf', None, 'ID', 'ACCIDENT_JOB_RELATED_INDICATOR', 'HL70136', -1),
    'ACC_6': ('leaf', None, 'ID', 'ACCIDENT_DEATH_INDICATOR', 'HL70136', -1),
    'ADD_1': ('leaf', None, 'ST', 'ADDENDUM_CONTINUATION_POINTER', None, -1),
    'AIG_1': ('leaf', None, 'SI', 'SET_ID_AIG', None, -1),
    'AIG_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIG_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RESOURCE_ID', None, -1),
    'AIG_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RESOURCE_TYPE', None, -1),
    'AIG_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RESOURCE_GROUP', None, -1),
    'AIG_6': ('leaf', None, 'NM', 'RESOURCE_QUANTITY', None, -1),
    'AIG_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RESOURCE_QUANTITY_UNITS', None, -1),
    'AIG_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'START_DATE_TIME', None, -1),
    'AIG_9': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIG_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIG_11': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIG_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DURATION_UNITS', None, -1),
    'AIG_13': ('leaf', None, 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIG_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AIL_1': ('leaf', None, 'SI', 'SET_ID_AIL', None, -1),
    'AIL_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIL_3': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'LOCATION_RESOURCE_ID', None, -1),
    'AIL_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'LOCATION_TYPE_AIL', None, -1),
    'AIL_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'LOCATION_GROUP', None, -1),
    'AIL_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'START_DATE_TIME', None, -1),
    'AIL_7': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIL_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIL_9': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIL_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DURATION_UNITS', None, -1),
    'AIL_11': ('leaf', None, 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIL_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AIP_1': ('leaf', None, 'SI', 'SET_ID_AIP', None, -1),
    'AIP_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIP_3': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PERSONNEL_RESOURCE_ID', None, -1),
    'AIP_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RESOURCE_ROLE', None, -1),
    'AIP_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RESOURCE_GROUP', None, -1),
    'AIP_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'START_DATE_TIME', None, -1),
    'AIP_7': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIP_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIP_9': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIP_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DURATION_UNITS', None, -1),
    'AIP_11': ('leaf', None, 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIP_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AIS_1': ('leaf', None, 'SI', 'SET_ID_AIS', None, -1),
    'AIS_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIS_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'UNIVERSAL_SERVICE_ID', None, -1),
    'AIS_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'START_DATE_TIME', None, -1),
    'AIS_5': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIS_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIS_7': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIS_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DURATION_UNITS', None, -1),
    'AIS_9': ('leaf', None, 'IS', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIS_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AL1_1': ('leaf', None, 'SI', 'SET_ID_AL1', None, -1),
    'AL1_2': ('leaf', None, 'IS', 'ALLERGY_TYPE', 'HL70127', -1),
    'AL1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ALLERGY_CODE_MNEMONIC_DESCRIPTION', None, -1),
    'AL1_4': ('leaf', None, 'IS', 'ALLERGY_SEVERITY', 'HL70128', -1),
    'AL1_5': ('leaf', None, 'ST', 'ALLERGY_REACTION', None, -1),
    'AL1_6': ('leaf', None, 'DT', 'IDENTIFICATION_DATE', None, -1),
    'APR_1': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'TIME_SELECTION_CRITERIA', 'HL70294', -1),
    'APR_2': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'RESOURCE_SELECTION_CRITERIA', 'HL70294', -1),
    'APR_3': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'LOCATION_SELECTION_CRITERIA', 'HL70294', -1),
    'APR_4': ('leaf', None, 'NM', 'SLOT_SPACING_CRITERIA', None, -1),
    'APR_5': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'FILLER_OVERRIDE_CRITERIA', None, -1),
    'ARQ_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_APPOINTMENT_ID', None, -1),
    'ARQ_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_APPOINTMENT_ID', None, -1),
    'ARQ_3': ('leaf', None, 'NM', 'OCCURRENCE_NUMBER', None, -1),
    'ARQ_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_GROUP_NUMBER', None, -1),
    'ARQ_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SCHEDULE_ID', None, -1),
    'ARQ_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUEST_EVENT_REASON', None, -1),
    'ARQ_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPOINTMENT_REASON', 'HL70276', -1),
    'ARQ_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPOINTMENT_TYPE', 'HL70277', -1),
    'ARQ_9': ('leaf', None, 'NM', 'APPOINTMENT_DURATION', None, -1),
    'ARQ_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPOINTMENT_DURATION_UNITS', None, -1),
    'ARQ_11': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'REQUESTED_START_DATE_TIME_RANGE', None, -1),
    'ARQ_12': ('leaf', None, 'ST', 'PRIORITY_ARQ', None, -1),
    'ARQ_13': ('sequence', DATATYPES_STRUCTS['RI'], 'RI', 'REPEATING_INTERVAL', None, -1),
    'ARQ_14': ('leaf', None, 'ST', 'REPEATING_INTERVAL_DURATION', None, -1),
    'ARQ_15': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PLACER_CONTACT_PERSON', None, -1),
    'ARQ_16': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PLACER_CONTACT_PHONE_NUMBER', None, -1),
    'ARQ_17': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PLACER_CONTACT_ADDRESS', None, -1),
    'ARQ_18': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PLACER_CONTACT_LOCATION', None, -1),
    'ARQ_19': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY_PERSON', None, -1),
    'ARQ_20': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ENTERED_BY_PHONE_NUMBER', None, -1),
    'ARQ_21': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ENTERED_BY_LOCATION', None, -1),
    'ARQ_22': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_PLACER_APPOINTMENT_ID', None, -1),
    'ARQ_23': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_FILLER_APPOINTMENT_ID', None, -1),
    'AUT_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'AUTHORIZING_PAYOR_PLAN_ID', 'HL70072', -1),
    'AUT_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'AUTHORIZING_PAYOR_COMPANY_ID', 'HL70285', -1),
    'AUT_3': ('leaf', None, 'ST', 'AUTHORIZING_PAYOR_COMPANY_NAME', None, -1),
    'AUT_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'AUTHORIZATION_EFFECTIVE_DATE', None, -1),
    'AUT_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'AUTHORIZATION_EXPIRATION_DATE', None, -1),
    'AUT_6': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'AUTHORIZATION_IDENTIFIER', None, -1),
    'AUT_7': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'REIMBURSEMENT_LIMIT', None, -1),
    'AUT_8': ('leaf', None, 'NM', 'REQUESTED_NUMBER_OF_TREATMENTS', None, -1),
    'AUT_9': ('leaf', None, 'NM', 'AUTHORIZED_NUMBER_OF_TREATMENTS', None, -1),
    'AUT_10': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PROCESS_DATE', None, -1),
    'BHS_1': ('leaf', None, 'ST', 'BATCH_FIELD_SEPARATOR', None, -1),
    'BHS_2': ('leaf', None, 'ST', 'BATCH_ENCODING_CHARACTERS', None, -1),
    'BHS_3': ('leaf', None, 'ST', 'BATCH_SENDING_APPLICATION', None, -1),
    'BHS_4': ('leaf', None, 'ST', 'BATCH_SENDING_FACILITY', None, -1),
    'BHS_5': ('leaf', None, 'ST', 'BATCH_RECEIVING_APPLICATION', None, -1),
    'BHS_6': ('leaf', None, 'ST', 'BATCH_RECEIVING_FACILITY', None, -1),
    'BHS_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'BATCH_CREATION_DATE_TIME', None, -1),
    'BHS_8': ('leaf', None, 'ST', 'BATCH_SECURITY', None, -1),
    'BHS_9': ('leaf', None, 'ST', 'BATCH_NAME_ID_TYPE', None, -1),
    'BHS_10': ('leaf', None, 'ST', 'BATCH_COMMENT', None, -1),
    'BHS_11': ('leaf', None, 'ST', 'BATCH_CONTROL_ID', None, -1),
    'BHS_12': ('leaf', None, 'ST', 'REFERENCE_BATCH_CONTROL_ID', None, -1),
    'BLG_1': ('sequence', DATATYPES_STRUCTS['CCD'], 'CCD', 'WHEN_TO_CHARGE', 'HL70100', -1),
    'BLG_2': ('leaf', None, 'ID', 'CHARGE_TYPE', 'HL70122', -1),
    'BLG_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ACCOUNT_ID', None, -1),
    'BTS_1': ('leaf', None, 'ST', 'BATCH_MESSAGE_COUNT', None, -1),
    'BTS_2': ('leaf', None, 'ST', 'BATCH_COMMENT', None, -1),
    'BTS_3': ('leaf', None, 'NM', 'BATCH_TOTALS', None, -1),
    'CDM_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_KEY_VALUE_CDM', 'HL70132', -1),
    'CDM_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CHARGE_CODE_ALIAS', None, -1),
    'CDM_3': ('leaf', None, 'ST', 'CHARGE_DESCRIPTION_SHORT', None, -1),
    'CDM_4': ('leaf', None, 'ST', 'CHARGE_DESCRIPTION_LONG', None, -1),
    'CDM_5': ('leaf', None, 'IS', 'DESCRIPTION_OVERRIDE_INDICATOR', 'HL70268', -1),
    'CDM_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'EXPLODING_CHARGES', None, -1),
    'CDM_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_CODE', 'HL70088', -1),
    'CDM_8': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'CDM_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INVENTORY_NUMBER', None, -1),
    'CDM_10': ('leaf', None, 'NM', 'RESOURCE_LOAD', None, -1),
    'CDM_11': ('sequence', DATATYPES_STRUCTS['CK'], 'CK', 'CONTRACT_NUMBER', None, -1),
    'CDM_12': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'CONTRACT_ORGANIZATION', None, -1),
    'CDM_13': ('leaf', None, 'ID', 'ROOM_FEE_INDICATOR', 'HL70136', -1),
    'CM0_1': ('leaf', None, 'SI', 'SET_ID_CM0', None, -1),
    'CM0_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SPONSOR_STUDY_ID', None, -1),
    'CM0_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ALTERNATE_STUDY_ID', None, -1),
    'CM0_4': ('leaf', None, 'ST', 'TITLE_OF_STUDY', None, -1),
    'CM0_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CHAIRMAN_OF_STUDY', None, -1),
    'CM0_6': ('leaf', None, 'DT', 'LAST_IRB_APPROVAL_DATE', None, -1),
    'CM0_7': ('leaf', None, 'NM', 'TOTAL_ACCRUAL_TO_DATE', None, -1),
    'CM0_8': ('leaf', None, 'DT', 'LAST_ACCRUAL_DATE', None, -1),
    'CM0_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CONTACT_FOR_STUDY', None, -1),
    'CM0_10': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_S_TEL_NUMBER', None, -1),
    'CM0_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_S_ADDRESS', None, -1),
    'CM1_1': ('leaf', None, 'SI', 'SET_ID_CM1', None, -1),
    'CM1_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STUDY_PHASE_IDENTIFIER', None, -1),
    'CM1_3': ('leaf', None, 'ST', 'DESCRIPTION_OF_STUDY_PHASE', None, -1),
    'CM2_1': ('leaf', None, 'SI', 'SET_ID_CM2', None, -1),
    'CM2_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SCHEDULED_TIME_POINT', None, -1),
    'CM2_3': ('leaf', None, 'ST', 'DESCRIPTION_OF_TIME_POINT', None, -1),
    'CM2_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'EVENTS_SCHEDULED_THIS_TIME_POINT', None, -1),
    'CSP_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STUDY_PHASE_IDENTIFIER', None, -1),
    'CSP_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_STUDY_PHASE_BEGAN', None, -1),
    'CSP_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_STUDY_PHASE_ENDED', None, -1),
    'CSP_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STUDY_PHASE_EVALUABILITY', None, -1),
    'CSR_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SPONSOR_STUDY_ID', None, -1),
    'CSR_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ALTERNATE_STUDY_ID', None, -1),
    'CSR_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INSTITUTION_REGISTERING_THE_PATIENT', None, -1),
    'CSR_4': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'SPONSOR_PATIENT_ID', None, -1),
    'CSR_5': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ALTERNATE_PATIENT_ID_CSR', None, -1),
    'CSR_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_PATIENT_STUDY_REGISTRATION', None, -1),
    'CSR_7': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PERSON_PERFORMING_STUDY_REGISTRATION', None, -1),
    'CSR_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'STUDY_AUTHORIZING_PROVIDER', None, -1),
    'CSR_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_PATIENT_STUDY_CONSENT_SIGNED', None, -1),
    'CSR_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PATIENT_STUDY_ELIGIBILITY_STATUS', None, -1),
    'CSR_11': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'STUDY_RANDOMIZATION_DATE_TIME', None, -1),
    'CSR_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RANDOMIZED_STUDY_ARM', None, -1),
    'CSR_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STRATUM_FOR_STUDY_RANDOMIZATION', None, -1),
    'CSR_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PATIENT_EVALUABILITY_STATUS', None, -1),
    'CSR_15': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_ENDED_STUDY', None, -1),
    'CSR_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REASON_ENDED_STUDY', None, -1),
    'CSS_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STUDY_SCHEDULED_TIME_POINT', None, -1),
    'CSS_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'STUDY_SCHEDULED_PATIENT_TIME_POINT', None, -1),
    'CSS_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STUDY_QUALITY_CONTROL_CODES', None, -1),
    'CTD_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTACT_ROLE', 'HL70131', -1),
    'CTD_2': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'CONTACT_NAME', None, -1),
    'CTD_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_ADDRESS', None, -1),
    'CTD_4': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'CONTACT_LOCATION', None, -1),
    'CTD_5': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_COMMUNICATION_INFORMATION', None, -1),
    'CTD_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185', -1),
    'CTD_7': ('sequence', DATATYPES_STRUCTS['PI'], 'PI', 'CONTACT_IDENTIFIERS', None, -1),
    'CTI_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SPONSOR_STUDY_ID', None, -1),
    'CTI_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STUDY_PHASE_IDENTIFIER', None, -1),
    'CTI_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STUDY_SCHEDULED_TIME_POINT', None, -1),
    'DB1_1': ('leaf', None, 'SI', 'SET_ID_DB1', None, -1),
    'DB1_2': ('leaf', None, 'IS', 'DISABLED_PERSON_CODE', 'HL70334', -1),
    'DB1_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'DISABLED_PERSON_IDENTIFIER', None, -1),
    'DB1_4': ('leaf', None, 'ID', 'DISABLED_INDICATOR', 'HL70136', -1),
    'DB1_5': ('leaf', None, 'DT', 'DISABILITY_START_DATE', None, -1),
    'DB1_6': ('leaf', None, 'DT', 'DISABILITY_END_DATE', None, -1),
    'DB1_7': ('leaf', None, 'DT', 'DISABILITY_RETURN_TO_WORK_DATE', None, -1),
    'DB1_8': ('leaf', None, 'DT', 'DISABILITY_UNABLE_TO_WORK_DATE', None, -1),
    'DG1_1': ('leaf', None, 'SI', 'SET_ID_DG1', None, -1),
    'DG1_2': ('leaf', None, 'ID', 'DIAGNOSIS_CODING_METHOD', 'HL70053', -1),
    'DG1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIAGNOSIS_CODE_DG1', 'HL70051', -1),
    'DG1_4': ('leaf', None, 'ST', 'DIAGNOSIS_DESCRIPTION', None, -1),
    'DG1_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DIAGNOSIS_DATE_TIME', None, -1),
    'DG1_6': ('leaf', None, 'IS', 'DIAGNOSIS_TYPE', 'HL70052', -1),
    'DG1_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MAJOR_DIAGNOSTIC_CATEGORY', 'HL70118', -1),
    'DG1_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIAGNOSTIC_RELATED_GROUP', 'HL70055', -1),
    'DG1_9': ('leaf', None, 'ID', 'DRG_APPROVAL_INDICATOR', 'HL70136', -1),
    'DG1_10': ('leaf', None, 'IS', 'DRG_GROUPER_REVIEW_CODE', 'HL70056', -1),
    'DG1_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OUTLIER_TYPE', 'HL70083', -1),
    'DG1_12': ('leaf', None, 'NM', 'OUTLIER_DAYS', None, -1),
    'DG1_13': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'OUTLIER_COST', None, -1),
    'DG1_14': ('leaf', None, 'ST', 'GROUPER_VERSION_AND_TYPE', None, -1),
    'DG1_15': ('leaf', None, 'ID', 'DIAGNOSIS_PRIORITY', 'HL70359', -1),
    'DG1_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DIAGNOSING_CLINICIAN', None, -1),
    'DG1_17': ('leaf', None, 'IS', 'DIAGNOSIS_CLASSIFICATION', 'HL70228', -1),
    'DG1_18': ('leaf', None, 'ID', 'CONFIDENTIAL_INDICATOR', 'HL70136', -1),
    'DG1_19': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ATTESTATION_DATE_TIME', None, -1),
    'DRG_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIAGNOSTIC_RELATED_GROUP', 'HL70055', -1),
    'DRG_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DRG_ASSIGNED_DATE_TIME', None, -1),
    'DRG_3': ('leaf', None, 'ID', 'DRG_APPROVAL_INDICATOR', 'HL70136', -1),
    'DRG_4': ('leaf', None, 'IS', 'DRG_GROUPER_REVIEW_CODE', 'HL70056', -1),
    'DRG_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OUTLIER_TYPE', 'HL70083', -1),
    'DRG_6': ('leaf', None, 'NM', 'OUTLIER_DAYS', None, -1),
    'DRG_7': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'OUTLIER_COST', None, -1),
    'DRG_8': ('leaf', None, 'IS', 'DRG_PAYOR', 'HL70229', -1),
    'DRG_9': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'OUTLIER_REIMBURSEMENT', None, -1),
    'DRG_10': ('leaf', None, 'ID', 'CONFIDENTIAL_INDICATOR', 'HL70136', -1),
    'DSC_1': ('leaf', None, 'ST', 'CONTINUATION_POINTER', None, -1),
    'DSP_1': ('leaf', None, 'SI', 'SET_ID_DSP', None, -1),
    'DSP_2': ('leaf', None, 'SI', 'DISPLAY_LEVEL', None, -1),
    'DSP_3': ('leaf', None, 'TX', 'DATA_LINE', None, -1),
    'DSP_4': ('leaf', None, 'ST', 'LOGICAL_BREAK_POINT', None, -1),
    'DSP_5': ('leaf', None, 'TX', 'RESULT_ID', None, -1),
    'EQL_1': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'EQL_2': ('leaf', None, 'ID', 'QUERY_RESPONSE_FORMAT_CODE', 'HL70106', -1),
    'EQL_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'EQL_QUERY_NAME', None, -1),
    'EQL_4': ('leaf', None, 'ST', 'EQL_QUERY_STATEMENT', None, -1),
    'ERQ_1': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'ERQ_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'EVENT_IDENTIFIER', None, -1),
    'ERQ_3': ('sequence', DATATYPES_STRUCTS['QIP'], 'QIP', 'INPUT_PARAMETER_LIST', None, -1),
    'ERR_1': ('sequence', DATATYPES_STRUCTS['ELD'], 'ELD', 'ERROR_CODE_AND_LOCATION', None, -1),
    'EVN_1': ('leaf', None, 'ID', 'EVENT_TYPE_CODE', 'HL70003', -1),
    'EVN_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'RECORDED_DATE_TIME', None, -1),
    'EVN_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_PLANNED_EVENT', None, -1),
    'EVN_4': ('leaf', None, 'IS', 'EVENT_REASON_CODE', 'HL70062', -1),
    'EVN_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OPERATOR_ID', 'HL70188', -1),
    'EVN_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_OCCURRED', None, -1),
    'FAC_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FACILITY_ID_FAC', None, -1),
    'FAC_2': ('leaf', None, 'ID', 'FACILITY_TYPE', 'HL70331', -1),
    'FAC_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'FACILITY_ADDRESS', None, -1),
    'FAC_4': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'FACILITY_TELECOMMUNICATION', None, -1),
    'FAC_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CONTACT_PERSON', None, -1),
    'FAC_6': ('leaf', None, 'ST', 'CONTACT_TITLE', None, -1),
    'FAC_7': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_ADDRESS', None, -1),
    'FAC_8': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_TELECOMMUNICATION', None, -1),
    'FAC_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'SIGNATURE_AUTHORITY', None, -1),
    'FAC_10': ('leaf', None, 'ST', 'SIGNATURE_AUTHORITY_TITLE', None, -1),
    'FAC_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'SIGNATURE_AUTHORITY_ADDRESS', None, -1),
    'FAC_12': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'SIGNATURE_AUTHORITY_TELECOMMUNICATION', None, -1),
    'FHS_1': ('leaf', None, 'ST', 'FILE_FIELD_SEPARATOR', None, -1),
    'FHS_2': ('leaf', None, 'ST', 'FILE_ENCODING_CHARACTERS', None, -1),
    'FHS_3': ('leaf', None, 'ST', 'FILE_SENDING_APPLICATION', None, -1),
    'FHS_4': ('leaf', None, 'ST', 'FILE_SENDING_FACILITY', None, -1),
    'FHS_5': ('leaf', None, 'ST', 'FILE_RECEIVING_APPLICATION', None, -1),
    'FHS_6': ('leaf', None, 'ST', 'FILE_RECEIVING_FACILITY', None, -1),
    'FHS_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'FILE_CREATION_DATE_TIME', None, -1),
    'FHS_8': ('leaf', None, 'ST', 'FILE_SECURITY', None, -1),
    'FHS_9': ('leaf', None, 'ST', 'FILE_NAME_ID', None, -1),
    'FHS_10': ('leaf', None, 'ST', 'FILE_HEADER_COMMENT', None, -1),
    'FHS_11': ('leaf', None, 'ST', 'FILE_CONTROL_ID', None, -1),
    'FHS_12': ('leaf', None, 'ST', 'REFERENCE_FILE_CONTROL_ID', None, -1),
    'FT1_1': ('leaf', None, 'SI', 'SET_ID_FT1', None, -1),
    'FT1_2': ('leaf', None, 'ST', 'TRANSACTION_ID', None, -1),
    'FT1_3': ('leaf', None, 'ST', 'TRANSACTION_BATCH_ID', None, -1),
    'FT1_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'TRANSACTION_DATE', None, -1),
    'FT1_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'TRANSACTION_POSTING_DATE', None, -1),
    'FT1_6': ('leaf', None, 'IS', 'TRANSACTION_TYPE', 'HL70017', -1),
    'FT1_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRANSACTION_CODE', 'HL70132', -1),
    'FT1_8': ('leaf', None, 'ST', 'TRANSACTION_DESCRIPTION', None, -1),
    'FT1_9': ('leaf', None, 'ST', 'TRANSACTION_DESCRIPTION_ALT', None, -1),
    'FT1_10': ('leaf', None, 'NM', 'TRANSACTION_QUANTITY', None, -1),
    'FT1_11': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TRANSACTION_AMOUNT_EXTENDED', None, -1),
    'FT1_12': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TRANSACTION_AMOUNT_UNIT', None, -1),
    'FT1_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DEPARTMENT_CODE', 'HL70049', -1),
    'FT1_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INSURANCE_PLAN_ID', 'HL70072', -1),
    'FT1_15': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'INSURANCE_AMOUNT', None, -1),
    'FT1_16': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ASSIGNED_PATIENT_LOCATION', None, -1),
    'FT1_17': ('leaf', None, 'IS', 'FEE_SCHEDULE', 'HL70024', -1),
    'FT1_18': ('leaf', None, 'IS', 'PATIENT_TYPE', 'HL70018', -1),
    'FT1_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIAGNOSIS_CODE_FT1', 'HL70051', -1),
    'FT1_20': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PERFORMED_BY_CODE', 'HL70084', -1),
    'FT1_21': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERED_BY_CODE', None, -1),
    'FT1_22': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'UNIT_COST', None, -1),
    'FT1_23': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'FT1_24': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY_CODE', None, -1),
    'FT1_25': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_CODE', 'HL70088', -1),
    'FT1_26': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'FTS_1': ('leaf', None, 'NM', 'FILE_BATCH_COUNT', None, -1),
    'FTS_2': ('leaf', None, 'ST', 'FILE_TRAILER_COMMENT', None, -1),
    'GOL_1': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70287', -1),
    'GOL_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ACTION_DATE_TIME', None, -1),
    'GOL_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GOAL_ID', None, -1),
    'GOL_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'GOAL_INSTANCE_ID', None, -1),
    'GOL_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EPISODE_OF_CARE_ID', None, -1),
    'GOL_6': ('leaf', None, 'NM', 'GOAL_LIST_PRIORITY', None, -1),
    'GOL_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'GOAL_ESTABLISHED_DATE_TIME', None, -1),
    'GOL_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EXPECTED_GOAL_ACHIEVE_DATE_TIME', None, -1),
    'GOL_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GOAL_CLASSIFICATION', None, -1),
    'GOL_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GOAL_MANAGEMENT_DISCIPLINE', None, -1),
    'GOL_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CURRENT_GOAL_REVIEW_STATUS', None, -1),
    'GOL_12': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'CURRENT_GOAL_REVIEW_DATE_TIME', None, -1),
    'GOL_13': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'NEXT_GOAL_REVIEW_DATE_TIME', None, -1),
    'GOL_14': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PREVIOUS_GOAL_REVIEW_DATE_TIME', None, -1),
    'GOL_15': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'GOAL_REVIEW_INTERVAL', None, -1),
    'GOL_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GOAL_EVALUATION', None, -1),
    'GOL_17': ('leaf', None, 'ST', 'GOAL_EVALUATION_COMMENT', None, -1),
    'GOL_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GOAL_LIFE_CYCLE_STATUS', None, -1),
    'GOL_19': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'GOAL_LIFE_CYCLE_STATUS_DATE_TIME', None, -1),
    'GOL_20': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GOAL_TARGET_TYPE', None, -1),
    'GOL_21': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GOAL_TARGET_NAME', None, -1),
    'GT1_1': ('leaf', None, 'SI', 'SET_ID_GT1', None, -1),
    'GT1_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'GUARANTOR_NUMBER', None, -1),
    'GT1_3': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GUARANTOR_NAME', None, -1),
    'GT1_4': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GUARANTOR_SPOUSE_NAME', None, -1),
    'GT1_5': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'GUARANTOR_ADDRESS', None, -1),
    'GT1_6': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'GUARANTOR_PH_NUM_HOME', None, -1),
    'GT1_7': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'GUARANTOR_PH_NUM_BUSINESS', None, -1),
    'GT1_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'GUARANTOR_DATE_TIME_OF_BIRTH', None, -1),
    'GT1_9': ('leaf', None, 'IS', 'GUARANTOR_SEX', 'HL70001', -1),
    'GT1_10': ('leaf', None, 'IS', 'GUARANTOR_TYPE', 'HL70068', -1),
    'GT1_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GUARANTOR_RELATIONSHIP', 'HL70063', -1),
    'GT1_12': ('leaf', None, 'ST', 'GUARANTOR_SSN', None, -1),
    'GT1_13': ('leaf', None, 'DT', 'GUARANTOR_DATE_BEGIN', None, -1),
    'GT1_14': ('leaf', None, 'DT', 'GUARANTOR_DATE_END', None, -1),
    'GT1_15': ('leaf', None, 'NM', 'GUARANTOR_PRIORITY', None, -1),
    'GT1_16': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GUARANTOR_EMPLOYER_NAME', None, -1),
    'GT1_17': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'GUARANTOR_EMPLOYER_ADDRESS', None, -1),
    'GT1_18': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'GUARANTOR_EMPLOYER_PHONE_NUMBER', None, -1),
    'GT1_19': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'GUARANTOR_EMPLOYEE_ID_NUMBER', None, -1),
    'GT1_20': ('leaf', None, 'IS', 'GUARANTOR_EMPLOYMENT_STATUS', 'HL70066', -1),
    'GT1_21': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'GUARANTOR_ORGANIZATION_NAME', None, -1),
    'GT1_22': ('leaf', None, 'ID', 'GUARANTOR_BILLING_HOLD_FLAG', 'HL70136', -1),
    'GT1_23': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GUARANTOR_CREDIT_RATING_CODE', 'HL70341', -1),
    'GT1_24': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'GUARANTOR_DEATH_DATE_AND_TIME', None, -1),
    'GT1_25': ('leaf', None, 'ID', 'GUARANTOR_DEATH_FLAG', 'HL70136', -1),
    'GT1_26': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GUARANTOR_CHARGE_ADJUSTMENT_CODE', 'HL70218', -1),
    'GT1_27': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'GUARANTOR_HOUSEHOLD_ANNUAL_INCOME', None, -1),
    'GT1_28': ('leaf', None, 'NM', 'GUARANTOR_HOUSEHOLD_SIZE', None, -1),
    'GT1_29': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'GUARANTOR_EMPLOYER_ID_NUMBER', None, -1),
    'GT1_30': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GUARANTOR_MARITAL_STATUS_CODE', 'HL70002', -1),
    'GT1_31': ('leaf', None, 'DT', 'GUARANTOR_HIRE_EFFECTIVE_DATE', None, -1),
    'GT1_32': ('leaf', None, 'DT', 'EMPLOYMENT_STOP_DATE', None, -1),
    'GT1_33': ('leaf', None, 'IS', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'GT1_34': ('leaf', None, 'IS', 'AMBULATORY_STATUS', 'HL70009', -1),
    'GT1_35': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CITIZENSHIP', 'HL70171', -1),
    'GT1_36': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'GT1_37': ('leaf', None, 'IS', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'GT1_38': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PUBLICITY_CODE', 'HL70215', -1),
    'GT1_39': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'GT1_40': ('leaf', None, 'IS', 'STUDENT_INDICATOR', 'HL70231', -1),
    'GT1_41': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RELIGION', 'HL70006', -1),
    'GT1_42': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'GT1_43': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NATIONALITY', 'HL70212', -1),
    'GT1_44': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ETHNIC_GROUP', 'HL70189', -1),
    'GT1_45': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'CONTACT_PERSON_S_NAME', None, -1),
    'GT1_46': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_PERSON_S_TELEPHONE_NUMBER', None, -1),
    'GT1_47': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTACT_REASON', 'HL70222', -1),
    'GT1_48': ('leaf', None, 'IS', 'CONTACT_RELATIONSHIP', 'HL70063', -1),
    'GT1_49': ('leaf', None, 'ST', 'JOB_TITLE', None, -1),
    'GT1_50': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'JOB_CODE_CLASS', 'HL70327', -1),
    'GT1_51': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'GUARANTOR_EMPLOYER_S_ORGANIZATION_NAME', None, -1),
    'GT1_52': ('leaf', None, 'IS', 'HANDICAP', 'HL70295', -1),
    'GT1_53': ('leaf', None, 'IS', 'JOB_STATUS', 'HL70311', -1),
    'GT1_54': ('sequence', DATATYPES_STRUCTS['FC'], 'FC', 'GUARANTOR_FINANCIAL_CLASS', 'HL70064', -1),
    'GT1_55': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GUARANTOR_RACE', 'HL70005', -1),
    'IN1_1': ('leaf', None, 'SI', 'SET_ID_IN1', None, -1),
    'IN1_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INSURANCE_PLAN_ID', 'HL70072', -1),
    'IN1_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURANCE_COMPANY_ID', None, -1),
    'IN1_4': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURANCE_COMPANY_NAME', None, -1),
    'IN1_5': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'INSURANCE_COMPANY_ADDRESS', None, -1),
    'IN1_6': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'INSURANCE_CO_CONTACT_PERSON', None, -1),
    'IN1_7': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURANCE_CO_PHONE_NUMBER', None, -1),
    'IN1_8': ('leaf', None, 'ST', 'GROUP_NUMBER', None, -1),
    'IN1_9': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'GROUP_NAME', None, -1),
    'IN1_10': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURED_S_GROUP_EMP_ID', None, -1),
    'IN1_11': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURED_S_GROUP_EMP_NAME', None, -1),
    'IN1_12': ('leaf', None, 'DT', 'PLAN_EFFECTIVE_DATE', None, -1),
    'IN1_13': ('leaf', None, 'DT', 'PLAN_EXPIRATION_DATE', None, -1),
    'IN1_14': ('sequence', DATATYPES_STRUCTS['AUI'], 'AUI', 'AUTHORIZATION_INFORMATION', None, -1),
    'IN1_15': ('leaf', None, 'IS', 'PLAN_TYPE', 'HL70086', -1),
    'IN1_16': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'NAME_OF_INSURED', None, -1),
    'IN1_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INSURED_S_RELATIONSHIP_TO_PATIENT', 'HL70063', -1),
    'IN1_18': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'INSURED_S_DATE_OF_BIRTH', None, -1),
    'IN1_19': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'INSURED_S_ADDRESS', None, -1),
    'IN1_20': ('leaf', None, 'IS', 'ASSIGNMENT_OF_BENEFITS', 'HL70135', -1),
    'IN1_21': ('leaf', None, 'IS', 'COORDINATION_OF_BENEFITS', 'HL70173', -1),
    'IN1_22': ('leaf', None, 'ST', 'COORD_OF_BEN_PRIORITY', None, -1),
    'IN1_23': ('leaf', None, 'ID', 'NOTICE_OF_ADMISSION_FLAG', 'HL70136', -1),
    'IN1_24': ('leaf', None, 'DT', 'NOTICE_OF_ADMISSION_DATE', None, -1),
    'IN1_25': ('leaf', None, 'ID', 'REPORT_OF_ELIGIBILITY_FLAG', 'HL70136', -1),
    'IN1_26': ('leaf', None, 'DT', 'REPORT_OF_ELIGIBILITY_DATE', None, -1),
    'IN1_27': ('leaf', None, 'IS', 'RELEASE_INFORMATION_CODE', 'HL70093', -1),
    'IN1_28': ('leaf', None, 'ST', 'PRE_ADMIT_CERT_PAC', None, -1),
    'IN1_29': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'VERIFICATION_DATE_TIME', None, -1),
    'IN1_30': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'VERIFICATION_BY', None, -1),
    'IN1_31': ('leaf', None, 'IS', 'TYPE_OF_AGREEMENT_CODE', 'HL70098', -1),
    'IN1_32': ('leaf', None, 'IS', 'BILLING_STATUS', 'HL70022', -1),
    'IN1_33': ('leaf', None, 'NM', 'LIFETIME_RESERVE_DAYS', None, -1),
    'IN1_34': ('leaf', None, 'NM', 'DELAY_BEFORE_L_R_DAY', None, -1),
    'IN1_35': ('leaf', None, 'IS', 'COMPANY_PLAN_CODE', 'HL70042', -1),
    'IN1_36': ('leaf', None, 'ST', 'POLICY_NUMBER', None, -1),
    'IN1_37': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'POLICY_DEDUCTIBLE', None, -1),
    'IN1_38': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'POLICY_LIMIT_AMOUNT', None, -1),
    'IN1_39': ('leaf', None, 'NM', 'POLICY_LIMIT_DAYS', None, -1),
    'IN1_40': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'ROOM_RATE_SEMI_PRIVATE', None, -1),
    'IN1_41': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'ROOM_RATE_PRIVATE', None, -1),
    'IN1_42': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INSURED_S_EMPLOYMENT_STATUS', 'HL70066', -1),
    'IN1_43': ('leaf', None, 'IS', 'INSURED_S_SEX', 'HL70001', -1),
    'IN1_44': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'INSURED_S_EMPLOYER_S_ADDRESS', None, -1),
    'IN1_45': ('leaf', None, 'ST', 'VERIFICATION_STATUS', None, -1),
    'IN1_46': ('leaf', None, 'IS', 'PRIOR_INSURANCE_PLAN_ID', 'HL70072', -1),
    'IN1_47': ('leaf', None, 'IS', 'COVERAGE_TYPE', 'HL70309', -1),
    'IN1_48': ('leaf', None, 'IS', 'HANDICAP', 'HL70295', -1),
    'IN1_49': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURED_S_ID_NUMBER', None, -1),
    'IN2_1': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURED_S_EMPLOYEE_ID', None, -1),
    'IN2_2': ('leaf', None, 'ST', 'INSURED_S_SOCIAL_SECURITY_NUMBER', None, -1),
    'IN2_3': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'INSURED_S_EMPLOYER_S_NAME_AND_ID', None, -1),
    'IN2_4': ('leaf', None, 'IS', 'EMPLOYER_INFORMATION_DATA', 'HL70139', -1),
    'IN2_5': ('leaf', None, 'IS', 'MAIL_CLAIM_PARTY', 'HL70137', -1),
    'IN2_6': ('leaf', None, 'ST', 'MEDICARE_HEALTH_INS_CARD_NUMBER', None, -1),
    'IN2_7': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MEDICAID_CASE_NAME', None, -1),
    'IN2_8': ('leaf', None, 'ST', 'MEDICAID_CASE_NUMBER', None, -1),
    'IN2_9': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MILITARY_SPONSOR_NAME', None, -1),
    'IN2_10': ('leaf', None, 'ST', 'MILITARY_ID_NUMBER', None, -1),
    'IN2_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DEPENDENT_OF_MILITARY_RECIPIENT', 'HL70342', -1),
    'IN2_12': ('leaf', None, 'ST', 'MILITARY_ORGANIZATION', None, -1),
    'IN2_13': ('leaf', None, 'ST', 'MILITARY_STATION', None, -1),
    'IN2_14': ('leaf', None, 'IS', 'MILITARY_SERVICE', 'HL70140', -1),
    'IN2_15': ('leaf', None, 'IS', 'MILITARY_RANK_GRADE', 'HL70141', -1),
    'IN2_16': ('leaf', None, 'IS', 'MILITARY_STATUS', 'HL70142', -1),
    'IN2_17': ('leaf', None, 'DT', 'MILITARY_RETIRE_DATE', None, -1),
    'IN2_18': ('leaf', None, 'ID', 'MILITARY_NON_AVAIL_CERT_ON_FILE', 'HL70136', -1),
    'IN2_19': ('leaf', None, 'ID', 'BABY_COVERAGE', 'HL70136', -1),
    'IN2_20': ('leaf', None, 'ID', 'COMBINE_BABY_BILL', 'HL70136', -1),
    'IN2_21': ('leaf', None, 'ST', 'BLOOD_DEDUCTIBLE', None, -1),
    'IN2_22': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'SPECIAL_COVERAGE_APPROVAL_NAME', None, -1),
    'IN2_23': ('leaf', None, 'ST', 'SPECIAL_COVERAGE_APPROVAL_TITLE', None, -1),
    'IN2_24': ('leaf', None, 'IS', 'NON_COVERED_INSURANCE_CODE', 'HL70143', -1),
    'IN2_25': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PAYOR_ID', None, -1),
    'IN2_26': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PAYOR_SUBSCRIBER_ID', None, -1),
    'IN2_27': ('leaf', None, 'IS', 'ELIGIBILITY_SOURCE', 'HL70144', -1),
    'IN2_28': ('sequence', DATATYPES_STRUCTS['RMC'], 'RMC', 'ROOM_COVERAGE_TYPE_AMOUNT', 'HL70145', -1),
    'IN2_29': ('sequence', DATATYPES_STRUCTS['PTA'], 'PTA', 'POLICY_TYPE_AMOUNT', 'HL70147', -1),
    'IN2_30': ('sequence', DATATYPES_STRUCTS['DDI'], 'DDI', 'DAILY_DEDUCTIBLE', None, -1),
    'IN2_31': ('leaf', None, 'IS', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'IN2_32': ('leaf', None, 'IS', 'AMBULATORY_STATUS', 'HL70009', -1),
    'IN2_33': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CITIZENSHIP', 'HL70171', -1),
    'IN2_34': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'IN2_35': ('leaf', None, 'IS', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'IN2_36': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PUBLICITY_CODE', 'HL70215', -1),
    'IN2_37': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'IN2_38': ('leaf', None, 'IS', 'STUDENT_INDICATOR', 'HL70231', -1),
    'IN2_39': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RELIGION', 'HL70006', -1),
    'IN2_40': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'IN2_41': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NATIONALITY', 'HL70212', -1),
    'IN2_42': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ETHNIC_GROUP', 'HL70189', -1),
    'IN2_43': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MARITAL_STATUS', 'HL70002', -1),
    'IN2_44': ('leaf', None, 'DT', 'INSURED_S_EMPLOYMENT_START_DATE', None, -1),
    'IN2_45': ('leaf', None, 'DT', 'EMPLOYMENT_STOP_DATE', None, -1),
    'IN2_46': ('leaf', None, 'ST', 'JOB_TITLE', None, -1),
    'IN2_47': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'JOB_CODE_CLASS', 'HL70327', -1),
    'IN2_48': ('leaf', None, 'IS', 'JOB_STATUS', 'HL70311', -1),
    'IN2_49': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'EMPLOYER_CONTACT_PERSON_NAME', None, -1),
    'IN2_50': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'EMPLOYER_CONTACT_PERSON_PHONE_NUMBER', None, -1),
    'IN2_51': ('leaf', None, 'IS', 'EMPLOYER_CONTACT_REASON', 'HL70222', -1),
    'IN2_52': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'INSURED_S_CONTACT_PERSON_S_NAME', None, -1),
    'IN2_53': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURED_S_CONTACT_PERSON_PHONE_NUMBER', None, -1),
    'IN2_54': ('leaf', None, 'IS', 'INSURED_S_CONTACT_PERSON_REASON', 'HL70222', -1),
    'IN2_55': ('leaf', None, 'DT', 'RELATIONSHIP_TO_THE_PATIENT_START_DATE', None, -1),
    'IN2_56': ('leaf', None, 'DT', 'RELATIONSHIP_TO_THE_PATIENT_STOP_DATE', None, -1),
    'IN2_57': ('leaf', None, 'IS', 'INSURANCE_CO_CONTACT_REASON', 'HL70232', -1),
    'IN2_58': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURANCE_CO_CONTACT_PHONE_NUMBER', None, -1),
    'IN2_59': ('leaf', None, 'IS', 'POLICY_SCOPE', 'HL70312', -1),
    'IN2_60': ('leaf', None, 'IS', 'POLICY_SOURCE', 'HL70313', -1),
    'IN2_61': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_MEMBER_NUMBER', None, -1),
    'IN2_62': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GUARANTOR_S_RELATIONSHIP_TO_INSURED', 'HL70063', -1),
    'IN2_63': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURED_S_PHONE_NUMBER_HOME', None, -1),
    'IN2_64': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURED_S_EMPLOYER_PHONE_NUMBER', None, -1),
    'IN2_65': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MILITARY_HANDICAPPED_PROGRAM', 'HL70343', -1),
    'IN2_66': ('leaf', None, 'ID', 'SUSPEND_FLAG', 'HL70136', -1),
    'IN2_67': ('leaf', None, 'ID', 'COPAY_LIMIT_FLAG', 'HL70136', -1),
    'IN2_68': ('leaf', None, 'ID', 'STOPLOSS_LIMIT_FLAG', 'HL70136', -1),
    'IN2_69': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURED_ORGANIZATION_NAME_AND_ID', None, -1),
    'IN2_70': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURED_EMPLOYER_ORGANIZATION_NAME_AND_ID', None, -1),
    'IN2_71': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RACE', 'HL70005', -1),
    'IN2_72': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'HCFA_PATIENT_S_RELATIONSHIP_TO_INSURED', 'HL70344', -1),
    'IN3_1': ('leaf', None, 'SI', 'SET_ID_IN3', None, -1),
    'IN3_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'CERTIFICATION_NUMBER', None, -1),
    'IN3_3': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CERTIFIED_BY', None, -1),
    'IN3_4': ('leaf', None, 'ID', 'CERTIFICATION_REQUIRED', 'HL70136', -1),
    'IN3_5': ('sequence', DATATYPES_STRUCTS['MOP'], 'MOP', 'PENALTY', 'HL70148', -1),
    'IN3_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'CERTIFICATION_DATE_TIME', None, -1),
    'IN3_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'CERTIFICATION_MODIFY_DATE_TIME', None, -1),
    'IN3_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OPERATOR', None, -1),
    'IN3_9': ('leaf', None, 'DT', 'CERTIFICATION_BEGIN_DATE', None, -1),
    'IN3_10': ('leaf', None, 'DT', 'CERTIFICATION_END_DATE', None, -1),
    'IN3_11': ('sequence', DATATYPES_STRUCTS['DTN'], 'DTN', 'DAYS', 'HL70149', -1),
    'IN3_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NON_CONCUR_CODE_DESCRIPTION', 'HL70233', -1),
    'IN3_13': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'NON_CONCUR_EFFECTIVE_DATE_TIME', None, -1),
    'IN3_14': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PHYSICIAN_REVIEWER', 'HL70010', -1),
    'IN3_15': ('leaf', None, 'ST', 'CERTIFICATION_CONTACT', None, -1),
    'IN3_16': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CERTIFICATION_CONTACT_PHONE_NUMBER', None, -1),
    'IN3_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPEAL_REASON', 'HL70345', -1),
    'IN3_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CERTIFICATION_AGENCY', 'HL70346', -1),
    'IN3_19': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CERTIFICATION_AGENCY_PHONE_NUMBER', None, -1),
    'IN3_20': ('sequence', DATATYPES_STRUCTS['PCF'], 'PCF', 'PRE_CERTIFICATION_REQ_WINDOW', 'HL70150', -1),
    'IN3_21': ('leaf', None, 'ST', 'CASE_MANAGER', None, -1),
    'IN3_22': ('leaf', None, 'DT', 'SECOND_OPINION_DATE', None, -1),
    'IN3_23': ('leaf', None, 'IS', 'SECOND_OPINION_STATUS', 'HL70151', -1),
    'IN3_24': ('leaf', None, 'IS', 'SECOND_OPINION_DOCUMENTATION_RECEIVED', 'HL70152', -1),
    'IN3_25': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'SECOND_OPINION_PHYSICIAN', 'HL70010', -1),
    'LCC_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LCC', None, -1),
    'LCC_2': ('leaf', None, 'IS', 'LOCATION_DEPARTMENT', 'HL70264', -1),
    'LCC_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACCOMMODATION_TYPE', 'HL70129', -1),
    'LCC_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CHARGE_CODE', 'HL70132', -1),
    'LCH_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LCH', None, -1),
    'LCH_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'LCH_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SEGMENT_UNIQUE_KEY', None, -1),
    'LCH_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'LOCATION_CHARACTERISTIC_ID', 'HL70324', -1),
    'LCH_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'LOCATION_CHARACTERISTIC_VALUE', None, -1),
    'LDP_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LDP', None, -1),
    'LDP_2': ('leaf', None, 'IS', 'LOCATION_DEPARTMENT', 'HL70264', -1),
    'LDP_3': ('leaf', None, 'IS', 'LOCATION_SERVICE', 'HL70069', -1),
    'LDP_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SPECIALTY_TYPE', 'HL70265', -1),
    'LDP_5': ('leaf', None, 'IS', 'VALID_PATIENT_CLASSES', 'HL70004', -1),
    'LDP_6': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'LDP_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ACTIVATION_DATE_LDP', None, -1),
    'LDP_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'INACTIVATION_DATE_LDP', None, -1),
    'LDP_9': ('leaf', None, 'ST', 'INACTIVATED_REASON', None, -1),
    'LDP_10': ('sequence', DATATYPES_STRUCTS['VH'], 'VH', 'VISITING_HOURS', 'HL70267', -1),
    'LDP_11': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_PHONE', None, -1),
    'LOC_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LOC', None, -1),
    'LOC_2': ('leaf', None, 'ST', 'LOCATION_DESCRIPTION', None, -1),
    'LOC_3': ('leaf', None, 'IS', 'LOCATION_TYPE_LOC', 'HL70260', -1),
    'LOC_4': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORGANIZATION_NAME_LOC', None, -1),
    'LOC_5': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'LOCATION_ADDRESS', None, -1),
    'LOC_6': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'LOCATION_PHONE', None, -1),
    'LOC_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'LICENSE_NUMBER', None, -1),
    'LOC_8': ('leaf', None, 'IS', 'LOCATION_EQUIPMENT', 'HL70261', -1),
    'LRL_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LRL', None, -1),
    'LRL_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'LRL_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SEGMENT_UNIQUE_KEY', None, -1),
    'LRL_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'LOCATION_RELATIONSHIP_ID', 'HL70325', -1),
    'LRL_5': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORGANIZATIONAL_LOCATION_RELATIONSHIP_VALUE', None, -1),
    'LRL_6': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PATIENT_LOCATION_RELATIONSHIP_VALUE', None, -1),
    'MFA_1': ('leaf', None, 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180', -1),
    'MFA_2': ('leaf', None, 'ST', 'MFN_CONTROL_ID', None, -1),
    'MFA_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_COMPLETION_DATE_TIME', None, -1),
    'MFA_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MFN_RECORD_LEVEL_ERROR_RETURN', 'HL70181', -1),
    'MFA_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_KEY_VALUE_MFA', None, -1),
    'MFA_6': ('leaf', None, 'ID', 'PRIMARY_KEY_VALUE_TYPE_MFA', 'HL70355', -1),
    'MFE_1': ('leaf', None, 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180', -1),
    'MFE_2': ('leaf', None, 'ST', 'MFN_CONTROL_ID', None, -1),
    'MFE_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE_TIME', None, -1),
    'MFE_4': ('sequence', None, 'varies', 'PRIMARY_KEY_VALUE_MFE', None, -1),
    'MFE_5': ('leaf', None, 'ID', 'PRIMARY_KEY_VALUE_TYPE', 'HL70355', -1),
    'MFI_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MASTER_FILE_IDENTIFIER', 'HL70175', -1),
    'MFI_2': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'MASTER_FILE_APPLICATION_IDENTIFIER', None, -1),
    'MFI_3': ('leaf', None, 'ID', 'FILE_LEVEL_EVENT_CODE', 'HL70178', -1),
    'MFI_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ENTERED_DATE_TIME', None, -1),
    'MFI_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE_TIME', None, -1),
    'MFI_6': ('leaf', None, 'ID', 'RESPONSE_LEVEL_CODE', 'HL70179', -1),
    'MRG_1': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_PATIENT_IDENTIFIER_LIST', None, -1),
    'MRG_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_ALTERNATE_PATIENT_ID', None, -1),
    'MRG_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_PATIENT_ACCOUNT_NUMBER', None, -1),
    'MRG_4': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_PATIENT_ID', None, -1),
    'MRG_5': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_VISIT_NUMBER', None, -1),
    'MRG_6': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_ALTERNATE_VISIT_ID', None, -1),
    'MRG_7': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PRIOR_PATIENT_NAME', None, -1),
    'MSA_1': ('leaf', None, 'ID', 'ACKNOWLEDGEMENT_CODE', 'HL70008', -1),
    'MSA_2': ('leaf', None, 'ST', 'MESSAGE_CONTROL_ID', None, -1),
    'MSA_3': ('leaf', None, 'ST', 'TEXT_MESSAGE', None, -1),
    'MSA_4': ('leaf', None, 'NM', 'EXPECTED_SEQUENCE_NUMBER', None, -1),
    'MSA_5': ('leaf', None, 'ID', 'DELAYED_ACKNOWLEDGMENT_TYPE', 'HL70102', -1),
    'MSA_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ERROR_CONDITION', None, -1),
    'MSH_1': ('leaf', None, 'ST', 'FIELD_SEPARATOR', None, -1),
    'MSH_2': ('leaf', None, 'ST', 'ENCODING_CHARACTERS', None, -1),
    'MSH_3': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'SENDING_APPLICATION', 'HL70361', -1),
    'MSH_4': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'SENDING_FACILITY', 'HL70362', -1),
    'MSH_5': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'RECEIVING_APPLICATION', 'HL70361', -1),
    'MSH_6': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'RECEIVING_FACILITY', 'HL70362', -1),
    'MSH_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_MESSAGE', None, -1),
    'MSH_8': ('leaf', None, 'ST', 'SECURITY', None, -1),
    'MSH_9': ('sequence', DATATYPES_STRUCTS['MSG'], 'MSG', 'MESSAGE_TYPE', 'HL70076', -1),
    'MSH_10': ('leaf', None, 'ST', 'MESSAGE_CONTROL_ID', None, -1),
    'MSH_11': ('sequence', DATATYPES_STRUCTS['PT'], 'PT', 'PROCESSING_ID', None, -1),
    'MSH_12': ('sequence', DATATYPES_STRUCTS['VID'], 'VID', 'VERSION_ID', 'HL70104', -1),
    'MSH_13': ('leaf', None, 'NM', 'SEQUENCE_NUMBER', None, -1),
    'MSH_14': ('leaf', None, 'ST', 'CONTINUATION_POINTER', None, -1),
    'MSH_15': ('leaf', None, 'ID', 'ACCEPT_ACKNOWLEDGMENT_TYPE', 'HL70155', -1),
    'MSH_16': ('leaf', None, 'ID', 'APPLICATION_ACKNOWLEDGMENT_TYPE', 'HL70155', -1),
    'MSH_17': ('leaf', None, 'ID', 'COUNTRY_CODE', None, -1),
    'MSH_18': ('leaf', None, 'ID', 'CHARACTER_SET', 'HL70211', -1),
    'MSH_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRINCIPAL_LANGUAGE_OF_MESSAGE', None, -1),
    'MSH_20': ('leaf', None, 'ID', 'ALTERNATE_CHARACTER_SET_HANDLING_SCHEME', 'HL70356', -1),
    'NCK_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SYSTEM_DATE_TIME', None, -1),
    'NK1_1': ('leaf', None, 'SI', 'SET_ID_NK1', None, -1),
    'NK1_2': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'NAME', None, -1),
    'NK1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RELATIONSHIP', 'HL70063', -1),
    'NK1_4': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ADDRESS', None, -1),
    'NK1_5': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER', None, -1),
    'NK1_6': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'BUSINESS_PHONE_NUMBER', None, -1),
    'NK1_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTACT_ROLE', 'HL70131', -1),
    'NK1_8': ('leaf', None, 'DT', 'START_DATE', None, -1),
    'NK1_9': ('leaf', None, 'DT', 'END_DATE', None, -1),
    'NK1_10': ('leaf', None, 'ST', 'NEXT_OF_KIN_ASSOCIATED_PARTIES_JOB_TITLE', None, -1),
    'NK1_11': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'NEXT_OF_KIN_ASSOCIATED_PARTIES_JOB_CODE_CLASS', 'HL70327', -1),
    'NK1_12': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'NEXT_OF_KIN_ASSOCIATED_PARTIES_EMPLOYEE_NUMBER', None, -1),
    'NK1_13': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORGANIZATION_NAME_NK1', None, -1),
    'NK1_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MARITAL_STATUS', 'HL70002', -1),
    'NK1_15': ('leaf', None, 'IS', 'SEX', 'HL70001', -1),
    'NK1_16': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_BIRTH', None, -1),
    'NK1_17': ('leaf', None, 'IS', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'NK1_18': ('leaf', None, 'IS', 'AMBULATORY_STATUS', 'HL70009', -1),
    'NK1_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CITIZENSHIP', 'HL70171', -1),
    'NK1_20': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'NK1_21': ('leaf', None, 'IS', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'NK1_22': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PUBLICITY_CODE', 'HL70215', -1),
    'NK1_23': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'NK1_24': ('leaf', None, 'IS', 'STUDENT_INDICATOR', 'HL70231', -1),
    'NK1_25': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RELIGION', 'HL70006', -1),
    'NK1_26': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'NK1_27': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NATIONALITY', 'HL70212', -1),
    'NK1_28': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ETHNIC_GROUP', 'HL70189', -1),
    'NK1_29': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTACT_REASON', 'HL70222', -1),
    'NK1_30': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'CONTACT_PERSON_S_NAME', None, -1),
    'NK1_31': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_PERSON_S_TELEPHONE_NUMBER', None, -1),
    'NK1_32': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_PERSON_S_ADDRESS', None, -1),
    'NK1_33': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'NEXT_OF_KIN_ASSOCIATED_PARTY_S_IDENTIFIERS', None, -1),
    'NK1_34': ('leaf', None, 'IS', 'JOB_STATUS', 'HL70311', -1),
    'NK1_35': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RACE', 'HL70005', -1),
    'NK1_36': ('leaf', None, 'IS', 'HANDICAP', 'HL70295', -1),
    'NK1_37': ('leaf', None, 'ST', 'CONTACT_PERSON_SOCIAL_SECURITY_NUMBER', None, -1),
    'NPU_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'BED_LOCATION', None, -1),
    'NPU_2': ('leaf', None, 'IS', 'BED_STATUS', 'HL70116', -1),
    'NSC_1': ('leaf', None, 'IS', 'NETWORK_CHANGE_TYPE', 'HL70333', -1),
    'NSC_2': ('leaf', None, 'ST', 'CURRENT_CPU', None, -1),
    'NSC_3': ('leaf', None, 'ST', 'CURRENT_FILESERVER', None, -1),
    'NSC_4': ('leaf', None, 'ST', 'CURRENT_APPLICATION', None, -1),
    'NSC_5': ('leaf', None, 'ST', 'CURRENT_FACILITY', None, -1),
    'NSC_6': ('leaf', None, 'ST', 'NEW_CPU', None, -1),
    'NSC_7': ('leaf', None, 'ST', 'NEW_FILESERVER', None, -1),
    'NSC_8': ('leaf', None, 'ST', 'NEW_APPLICATION', None, -1),
    'NSC_9': ('leaf', None, 'ST', 'NEW_FACILITY', None, -1),
    'NST_1': ('leaf', None, 'ID', 'STATISTICS_AVAILABLE', 'HL70136', -1),
    'NST_2': ('leaf', None, 'ST', 'SOURCE_IDENTIFIER', None, -1),
    'NST_3': ('leaf', None, 'ID', 'SOURCE_TYPE', None, -1),
    'NST_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'STATISTICS_START', None, -1),
    'NST_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'STATISTICS_END', None, -1),
    'NST_6': ('leaf', None, 'NM', 'RECEIVE_CHARACTER_COUNT', None, -1),
    'NST_7': ('leaf', None, 'NM', 'SEND_CHARACTER_COUNT', None, -1),
    'NST_8': ('leaf', None, 'NM', 'MESSAGES_RECEIVED', None, -1),
    'NST_9': ('leaf', None, 'NM', 'MESSAGES_SENT', None, -1),
    'NST_10': ('leaf', None, 'NM', 'CHECKSUM_ERRORS_RECEIVED', None, -1),
    'NST_11': ('leaf', None, 'NM', 'LENGTH_ERRORS_RECEIVED', None, -1),
    'NST_12': ('leaf', None, 'NM', 'OTHER_ERRORS_RECEIVED', None, -1),
    'NST_13': ('leaf', None, 'NM', 'CONNECT_TIMEOUTS', None, -1),
    'NST_14': ('leaf', None, 'NM', 'RECEIVE_TIMEOUTS', None, -1),
    'NST_15': ('leaf', None, 'NM', 'NETWORK_ERRORS', None, -1),
    'NTE_1': ('leaf', None, 'SI', 'SET_ID_NTE', None, -1),
    'NTE_2': ('leaf', None, 'ID', 'SOURCE_OF_COMMENT', 'HL70105', -1),
    'NTE_3': ('leaf', None, 'FT', 'COMMENT', None, -1),
    'NTE_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COMMENT_TYPE', 'HL70364', -1),
    'OBR_1': ('leaf', None, 'SI', 'SET_ID_OBR', None, -1),
    'OBR_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'OBR_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'OBR_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'UNIVERSAL_SERVICE_ID', None, -1),
    'OBR_5': ('leaf', None, 'ID', 'PRIORITY_OBR', None, -1),
    'OBR_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'REQUESTED_DATE_TIME', None, -1),
    'OBR_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'OBSERVATION_DATE_TIME', None, -1),
    'OBR_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'OBSERVATION_END_DATE_TIME', None, -1),
    'OBR_9': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'COLLECTION_VOLUME', None, -1),
    'OBR_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'COLLECTOR_IDENTIFIER', None, -1),
    'OBR_11': ('leaf', None, 'ID', 'SPECIMEN_ACTION_CODE', 'HL70065', -1),
    'OBR_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DANGER_CODE', None, -1),
    'OBR_13': ('leaf', None, 'ST', 'RELEVANT_CLINICAL_INFO', None, -1),
    'OBR_14': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SPECIMEN_RECEIVED_DATE_TIME', None, -1),
    'OBR_15': ('sequence', DATATYPES_STRUCTS['SPS'], 'SPS', 'SPECIMEN_SOURCE', 'HL70070', -1),
    'OBR_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER', None, -1),
    'OBR_17': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ORDER_CALLBACK_PHONE_NUMBER', None, -1),
    'OBR_18': ('leaf', None, 'ST', 'PLACER_FIELD_1', None, -1),
    'OBR_19': ('leaf', None, 'ST', 'PLACER_FIELD_2', None, -1),
    'OBR_20': ('leaf', None, 'ST', 'FILLER_FIELD_1', None, -1),
    'OBR_21': ('leaf', None, 'ST', 'FILLER_FIELD_2', None, -1),
    'OBR_22': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'RESULTS_RPT_STATUS_CHNG_DATE_TIME', None, -1),
    'OBR_23': ('sequence', DATATYPES_STRUCTS['MOC'], 'MOC', 'CHARGE_TO_PRACTICE', None, -1),
    'OBR_24': ('leaf', None, 'ID', 'DIAGNOSTIC_SERV_SECT_ID', 'HL70074', -1),
    'OBR_25': ('leaf', None, 'ID', 'RESULT_STATUS', 'HL70123', -1),
    'OBR_26': ('sequence', DATATYPES_STRUCTS['PRL'], 'PRL', 'PARENT_RESULT', None, -1),
    'OBR_27': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'OBR_28': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'RESULT_COPIES_TO', None, -1),
    'OBR_29': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PARENT', None, -1),
    'OBR_30': ('leaf', None, 'ID', 'TRANSPORTATION_MODE', 'HL70124', -1),
    'OBR_31': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REASON_FOR_STUDY', None, -1),
    'OBR_32': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'PRINCIPAL_RESULT_INTERPRETER', None, -1),
    'OBR_33': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'ASSISTANT_RESULT_INTERPRETER', None, -1),
    'OBR_34': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'TECHNICIAN', None, -1),
    'OBR_35': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'TRANSCRIPTIONIST', None, -1),
    'OBR_36': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SCHEDULED_DATE_TIME', None, -1),
    'OBR_37': ('leaf', None, 'NM', 'NUMBER_OF_SAMPLE_CONTAINERS', None, -1),
    'OBR_38': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRANSPORT_LOGISTICS_OF_COLLECTED_SAMPLE', None, -1),
    'OBR_39': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COLLECTOR_S_COMMENT', None, -1),
    'OBR_40': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRANSPORT_ARRANGEMENT_RESPONSIBILITY', None, -1),
    'OBR_41': ('leaf', None, 'ID', 'TRANSPORT_ARRANGED', 'HL70224', -1),
    'OBR_42': ('leaf', None, 'ID', 'ESCORT_REQUIRED', 'HL70225', -1),
    'OBR_43': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PLANNED_PATIENT_TRANSPORT_COMMENT', None, -1),
    'OBR_44': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_CODE', 'HL70088', -1),
    'OBR_45': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'OBX_1': ('leaf', None, 'SI', 'SET_ID_OBX', None, -1),
    'OBX_2': ('leaf', None, 'ID', 'VALUE_TYPE', 'HL70125', -1),
    'OBX_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OBSERVATION_IDENTIFIER', None, -1),
    'OBX_4': ('leaf', None, 'ST', 'OBSERVATION_SUB_ID', None, -1),
    'OBX_5': ('sequence', None, 'varies', 'OBSERVATION_VALUE', None, -1),
    'OBX_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'UNITS', None, -1),
    'OBX_7': ('leaf', None, 'ST', 'REFERENCES_RANGE', None, -1),
    'OBX_8': ('leaf', None, 'ID', 'ABNORMAL_FLAGS', 'HL70078', -1),
    'OBX_9': ('leaf', None, 'NM', 'PROBABILITY', None, -1),
    'OBX_10': ('leaf', None, 'ID', 'NATURE_OF_ABNORMAL_TEST', 'HL70080', -1),
    'OBX_11': ('leaf', None, 'ID', 'OBSERVATION_RESULT_STATUS', 'HL70085', -1),
    'OBX_12': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_LAST_OBS_NORMAL_VALUES', None, -1),
    'OBX_13': ('leaf', None, 'ST', 'USER_DEFINED_ACCESS_CHECKS', None, -1),
    'OBX_14': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_THE_OBSERVATION', None, -1),
    'OBX_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCER_S_ID', None, -1),
    'OBX_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'RESPONSIBLE_OBSERVER', None, -1),
    'OBX_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OBSERVATION_METHOD', None, -1),
    'ODS_1': ('leaf', None, 'ID', 'TYPE', 'HL70159', -1),
    'ODS_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SERVICE_PERIOD', None, -1),
    'ODS_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIET_SUPPLEMENT_OR_PREFERENCE_CODE', None, -1),
    'ODS_4': ('leaf', None, 'ST', 'TEXT_INSTRUCTION', None, -1),
    'ODT_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRAY_TYPE', 'HL70160', -1),
    'ODT_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SERVICE_PERIOD', None, -1),
    'ODT_3': ('leaf', None, 'ST', 'TEXT_INSTRUCTION', None, -1),
    'OM1_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM1_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCER_S_TEST_OBSERVATION_ID', None, -1),
    'OM1_3': ('leaf', None, 'ID', 'PERMITTED_DATA_TYPES', 'HL70125', -1),
    'OM1_4': ('leaf', None, 'ID', 'SPECIMEN_REQUIRED', 'HL70136', -1),
    'OM1_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCER_ID', None, -1),
    'OM1_6': ('leaf', None, 'TX', 'OBSERVATION_DESCRIPTION', None, -1),
    'OM1_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OTHER_TEST_OBSERVATION_IDS_FOR_THE_OBSERVATION', None, -1),
    'OM1_8': ('leaf', None, 'ST', 'OTHER_NAMES', None, -1),
    'OM1_9': ('leaf', None, 'ST', 'PREFERRED_REPORT_NAME_FOR_THE_OBSERVATION', None, -1),
    'OM1_10': ('leaf', None, 'ST', 'PREFERRED_SHORT_NAME_OR_MNEMONIC_FOR_OBSERVATION', None, -1),
    'OM1_11': ('leaf', None, 'ST', 'PREFERRED_LONG_NAME_FOR_THE_OBSERVATION', None, -1),
    'OM1_12': ('leaf', None, 'ID', 'ORDERABILITY', 'HL70136', -1),
    'OM1_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'IDENTITY_OF_INSTRUMENT_USED_TO_PERFORM_THIS_STUDY', None, -1),
    'OM1_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CODED_REPRESENTATION_OF_METHOD', None, -1),
    'OM1_15': ('leaf', None, 'ID', 'PORTABLE', 'HL70136', -1),
    'OM1_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OBSERVATION_PRODUCING_DEPARTMENT_SECTION', None, -1),
    'OM1_17': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'TELEPHONE_NUMBER_OF_SECTION', None, -1),
    'OM1_18': ('leaf', None, 'IS', 'NATURE_OF_TEST_OBSERVATION', 'HL70174', -1),
    'OM1_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REPORT_SUBHEADER', None, -1),
    'OM1_20': ('leaf', None, 'ST', 'REPORT_DISPLAY_ORDER', None, -1),
    'OM1_21': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_STAMP_FOR_ANY_CHANGE_IN_DEFINITION_FOR_THE_OBSERVATION', None, -1),
    'OM1_22': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE_TIME_OF_CHANGE', None, -1),
    'OM1_23': ('leaf', None, 'NM', 'TYPICAL_TURN_AROUND_TIME', None, -1),
    'OM1_24': ('leaf', None, 'NM', 'PROCESSING_TIME', None, -1),
    'OM1_25': ('leaf', None, 'ID', 'PROCESSING_PRIORITY', 'HL70168', -1),
    'OM1_26': ('leaf', None, 'ID', 'REPORTING_PRIORITY', 'HL70169', -1),
    'OM1_27': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OUTSIDE_SITE_S_WHERE_OBSERVATION_MAY_BE_PERFORMED', None, -1),
    'OM1_28': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ADDRESS_OF_OUTSIDE_SITE_S', None, -1),
    'OM1_29': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER_OF_OUTSIDE_SITE', None, -1),
    'OM1_30': ('leaf', None, 'IS', 'CONFIDENTIALITY_CODE', 'HL70177', -1),
    'OM1_31': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OBSERVATIONS_REQUIRED_TO_INTERPRET_THE_OBS', None, -1),
    'OM1_32': ('leaf', None, 'TX', 'INTERPRETATION_OF_OBSERVATIONS', None, -1),
    'OM1_33': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTRAINDICATIONS_TO_OBSERVATIONS', None, -1),
    'OM1_34': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFLEX_TESTS_OBSERVATIONS', None, -1),
    'OM1_35': ('leaf', None, 'TX', 'RULES_THAT_TRIGGER_REFLEX_TESTING', None, -1),
    'OM1_36': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FIXED_CANNED_MESSAGE', None, -1),
    'OM1_37': ('leaf', None, 'TX', 'PATIENT_PREPARATION', None, -1),
    'OM1_38': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_MEDICATION', None, -1),
    'OM1_39': ('leaf', None, 'TX', 'FACTORS_THAT_MAY_EFFECT_THE_OBSERVATION', None, -1),
    'OM1_40': ('leaf', None, 'ST', 'TEST_OBSERVATION_PERFORMANCE_SCHEDULE', None, -1),
    'OM1_41': ('leaf', None, 'TX', 'DESCRIPTION_OF_TEST_METHODS', None, -1),
    'OM1_42': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'KIND_OF_QUANTITY_OBSERVED', 'HL70254', -1),
    'OM1_43': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'POINT_VERSUS_INTERVAL', 'HL70255', -1),
    'OM1_44': ('leaf', None, 'TX', 'CHALLENGE_INFORMATION', 'HL70256', -1),
    'OM1_45': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RELATIONSHIP_MODIFIER', 'HL70258', -1),
    'OM1_46': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TARGET_ANATOMIC_SITE_OF_TEST', None, -1),
    'OM1_47': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MODALITY_OF_IMAGING_MEASUREMENT', 'HL70259', -1),
    'OM2_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM2_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'UNITS_OF_MEASURE', None, -1),
    'OM2_3': ('leaf', None, 'NM', 'RANGE_OF_DECIMAL_PRECISION', None, -1),
    'OM2_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CORRESPONDING_SI_UNITS_OF_MEASURE', None, -1),
    'OM2_5': ('leaf', None, 'TX', 'SI_CONVERSION_FACTOR', None, -1),
    'OM2_6': ('sequence', DATATYPES_STRUCTS['RFR'], 'RFR', 'REFERENCE_NORMAL_RANGE_ORDINAL_CONTINUOUS_OBS', None, -1),
    'OM2_7': ('sequence', DATATYPES_STRUCTS['NR'], 'NR', 'CRITICAL_RANGE_FOR_ORDINAL_CONTINUOUS_OBS', None, -1),
    'OM2_8': ('sequence', DATATYPES_STRUCTS['RFR'], 'RFR', 'ABSOLUTE_RANGE_FOR_ORDINAL_CONTINUOUS_OBS', None, -1),
    'OM2_9': ('sequence', DATATYPES_STRUCTS['DLT'], 'DLT', 'DELTA_CHECK_CRITERIA', None, -1),
    'OM2_10': ('leaf', None, 'NM', 'MINIMUM_MEANINGFUL_INCREMENTS', None, -1),
    'OM3_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM3_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PREFERRED_CODING_SYSTEM', None, -1),
    'OM3_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VALID_CODED_ANSWERS', None, -1),
    'OM3_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NORMAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS', None, -1),
    'OM3_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ABNORMAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS', None, -1),
    'OM3_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CRITICAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS', None, -1),
    'OM3_7': ('leaf', None, 'ID', 'VALUE_TYPE', 'HL70125', -1),
    'OM4_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM4_2': ('leaf', None, 'ID', 'DERIVED_SPECIMEN', 'HL70170', -1),
    'OM4_3': ('leaf', None, 'TX', 'CONTAINER_DESCRIPTION', None, -1),
    'OM4_4': ('leaf', None, 'NM', 'CONTAINER_VOLUME', None, -1),
    'OM4_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTAINER_UNITS', None, -1),
    'OM4_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SPECIMEN', None, -1),
    'OM4_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADDITIVE', None, -1),
    'OM4_8': ('leaf', None, 'TX', 'PREPARATION', None, -1),
    'OM4_9': ('leaf', None, 'TX', 'SPECIAL_HANDLING_REQUIREMENTS', None, -1),
    'OM4_10': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NORMAL_COLLECTION_VOLUME', None, -1),
    'OM4_11': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'MINIMUM_COLLECTION_VOLUME', None, -1),
    'OM4_12': ('leaf', None, 'TX', 'SPECIMEN_REQUIREMENTS', None, -1),
    'OM4_13': ('leaf', None, 'ID', 'SPECIMEN_PRIORITIES', 'HL70027', -1),
    'OM4_14': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'SPECIMEN_RETENTION_TIME', None, -1),
    'OM5_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM5_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TEST_OBSERVATIONS_INCLUDED_WITHIN_AN_ORDERED_TEST_BATTERY', None, -1),
    'OM5_3': ('leaf', None, 'ST', 'OBSERVATION_ID_SUFFIXES', None, -1),
    'OM6_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM6_2': ('leaf', None, 'TX', 'DERIVATION_RULE', None, -1),
    'ORC_1': ('leaf', None, 'ID', 'ORDER_CONTROL', 'HL70119', -1),
    'ORC_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'ORC_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'ORC_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_GROUP_NUMBER', None, -1),
    'ORC_5': ('leaf', None, 'ID', 'ORDER_STATUS', 'HL70038', -1),
    'ORC_6': ('leaf', None, 'ID', 'RESPONSE_FLAG', 'HL70121', -1),
    'ORC_7': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'ORC_8': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PARENT', None, -1),
    'ORC_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_TRANSACTION', None, -1),
    'ORC_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY', None, -1),
    'ORC_11': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'VERIFIED_BY', None, -1),
    'ORC_12': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER', None, -1),
    'ORC_13': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ENTERER_S_LOCATION', None, -1),
    'ORC_14': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CALL_BACK_PHONE_NUMBER', None, -1),
    'ORC_15': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ORDER_EFFECTIVE_DATE_TIME', None, -1),
    'ORC_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ORDER_CONTROL_CODE_REASON', None, -1),
    'ORC_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ENTERING_ORGANIZATION', None, -1),
    'ORC_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ENTERING_DEVICE', None, -1),
    'ORC_19': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ACTION_BY', None, -1),
    'ORC_20': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADVANCED_BENEFICIARY_NOTICE_CODE', 'HL70339', -1),
    'ORC_21': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORDERING_FACILITY_NAME', None, -1),
    'ORC_22': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ORDERING_FACILITY_ADDRESS', None, -1),
    'ORC_23': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ORDERING_FACILITY_PHONE_NUMBER', None, -1),
    'ORC_24': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ORDERING_PROVIDER_ADDRESS', None, -1),
    'PCR_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'IMPLICATED_PRODUCT', None, -1),
    'PCR_2': ('leaf', None, 'IS', 'GENERIC_PRODUCT', 'HL70249', -1),
    'PCR_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCT_CLASS', None, -1),
    'PCR_4': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DURATION_OF_THERAPY', None, -1),
    'PCR_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PRODUCT_MANUFACTURE_DATE', None, -1),
    'PCR_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PRODUCT_EXPIRATION_DATE', None, -1),
    'PCR_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PRODUCT_IMPLANTATION_DATE', None, -1),
    'PCR_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PRODUCT_EXPLANTATION_DATE', None, -1),
    'PCR_9': ('leaf', None, 'IS', 'SINGLE_USE_DEVICE', 'HL70244', -1),
    'PCR_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INDICATION_FOR_PRODUCT_USE', None, -1),
    'PCR_11': ('leaf', None, 'IS', 'PRODUCT_PROBLEM', 'HL70245', -1),
    'PCR_12': ('leaf', None, 'ST', 'PRODUCT_SERIAL_LOT_NUMBER', None, -1),
    'PCR_13': ('leaf', None, 'IS', 'PRODUCT_AVAILABLE_FOR_INSPECTION', 'HL70246', -1),
    'PCR_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCT_EVALUATION_PERFORMED', None, -1),
    'PCR_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCT_EVALUATION_STATUS', 'HL70247', -1),
    'PCR_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCT_EVALUATION_RESULTS', None, -1),
    'PCR_17': ('leaf', None, 'ID', 'EVALUATED_PRODUCT_SOURCE', 'HL70248', -1),
    'PCR_18': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_PRODUCT_RETURNED_TO_MANUFACTURER', None, -1),
    'PCR_19': ('leaf', None, 'ID', 'DEVICE_OPERATOR_QUALIFICATIONS', 'HL70242', -1),
    'PCR_20': ('leaf', None, 'ID', 'RELATEDNESS_ASSESSMENT', 'HL70250', -1),
    'PCR_21': ('leaf', None, 'ID', 'ACTION_TAKEN_IN_RESPONSE_TO_THE_EVENT', 'HL70251', -1),
    'PCR_22': ('leaf', None, 'ID', 'EVENT_CAUSALITY_OBSERVATIONS', 'HL70252', -1),
    'PCR_23': ('leaf', None, 'ID', 'INDIRECT_EXPOSURE_MECHANISM', 'HL70253', -1),
    'PD1_1': ('leaf', None, 'IS', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'PD1_2': ('leaf', None, 'IS', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'PD1_3': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PATIENT_PRIMARY_FACILITY', None, -1),
    'PD1_4': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PATIENT_PRIMARY_CARE_PROVIDER_NAME_ID_NO', None, -1),
    'PD1_5': ('leaf', None, 'IS', 'STUDENT_INDICATOR', 'HL70231', -1),
    'PD1_6': ('leaf', None, 'IS', 'HANDICAP', 'HL70295', -1),
    'PD1_7': ('leaf', None, 'IS', 'LIVING_WILL', 'HL70315', -1),
    'PD1_8': ('leaf', None, 'IS', 'ORGAN_DONOR', 'HL70316', -1),
    'PD1_9': ('leaf', None, 'ID', 'SEPARATE_BILL', 'HL70136', -1),
    'PD1_10': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'DUPLICATE_PATIENT', None, -1),
    'PD1_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PUBLICITY_CODE', 'HL70215', -1),
    'PD1_12': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'PDC_1': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'MANUFACTURER_DISTRIBUTOR', None, -1),
    'PDC_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COUNTRY', None, -1),
    'PDC_3': ('leaf', None, 'ST', 'BRAND_NAME', None, -1),
    'PDC_4': ('leaf', None, 'ST', 'DEVICE_FAMILY_NAME', None, -1),
    'PDC_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GENERIC_NAME', None, -1),
    'PDC_6': ('leaf', None, 'ST', 'MODEL_IDENTIFIER', None, -1),
    'PDC_7': ('leaf', None, 'ST', 'CATALOGUE_IDENTIFIER', None, -1),
    'PDC_8': ('leaf', None, 'ST', 'OTHER_IDENTIFIER', None, -1),
    'PDC_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCT_CODE', None, -1),
    'PDC_10': ('leaf', None, 'ID', 'MARKETING_BASIS', 'HL70330', -1),
    'PDC_11': ('leaf', None, 'ST', 'MARKETING_APPROVAL_ID', None, -1),
    'PDC_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'LABELED_SHELF_LIFE', None, -1),
    'PDC_13': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'EXPECTED_SHELF_LIFE', None, -1),
    'PDC_14': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_FIRST_MARKETED', None, -1),
    'PDC_15': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_LAST_MARKETED', None, -1),
    'PEO_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'EVENT_IDENTIFIERS_USED', None, -1),
    'PEO_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'EVENT_SYMPTOM_DIAGNOSIS_CODE', None, -1),
    'PEO_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_ONSET_DATE_TIME', None, -1),
    'PEO_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_EXACERBATION_DATE_TIME', None, -1),
    'PEO_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_IMPROVED_DATE_TIME', None, -1),
    'PEO_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_ENDED_DATA_TIME', None, -1),
    'PEO_7': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'EVENT_LOCATION_OCCURRED_ADDRESS', None, -1),
    'PEO_8': ('leaf', None, 'ID', 'EVENT_QUALIFICATION', 'HL70237', -1),
    'PEO_9': ('leaf', None, 'ID', 'EVENT_SERIOUS', 'HL70238', -1),
    'PEO_10': ('leaf', None, 'ID', 'EVENT_EXPECTED', 'HL70239', -1),
    'PEO_11': ('leaf', None, 'ID', 'EVENT_OUTCOME', 'HL70240', -1),
    'PEO_12': ('leaf', None, 'ID', 'PATIENT_OUTCOME', 'HL70241', -1),
    'PEO_13': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_OTHERS', None, -1),
    'PEO_14': ('leaf', None, 'FT', 'EVENT_FROM_ORIGINAL_REPORTER', None, -1),
    'PEO_15': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_PATIENT', None, -1),
    'PEO_16': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_PRACTITIONER', None, -1),
    'PEO_17': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_AUTOPSY', None, -1),
    'PEO_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CAUSE_OF_DEATH', None, -1),
    'PEO_19': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PRIMARY_OBSERVER_NAME', None, -1),
    'PEO_20': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PRIMARY_OBSERVER_ADDRESS', None, -1),
    'PEO_21': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PRIMARY_OBSERVER_TELEPHONE', None, -1),
    'PEO_22': ('leaf', None, 'ID', 'PRIMARY_OBSERVER_S_QUALIFICATION', 'HL70242', -1),
    'PEO_23': ('leaf', None, 'ID', 'CONFIRMATION_PROVIDED_BY', 'HL70242', -1),
    'PEO_24': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PRIMARY_OBSERVER_AWARE_DATE_TIME', None, -1),
    'PEO_25': ('leaf', None, 'ID', 'PRIMARY_OBSERVER_S_IDENTITY_MAY_BE_DIVULGED', 'HL70243', -1),
    'PES_1': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'SENDER_ORGANIZATION_NAME', None, -1),
    'PES_2': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'SENDER_INDIVIDUAL_NAME', None, -1),
    'PES_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'SENDER_ADDRESS', None, -1),
    'PES_4': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'SENDER_TELEPHONE', None, -1),
    'PES_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SENDER_EVENT_IDENTIFIER', None, -1),
    'PES_6': ('leaf', None, 'NM', 'SENDER_SEQUENCE_NUMBER', None, -1),
    'PES_7': ('leaf', None, 'FT', 'SENDER_EVENT_DESCRIPTION', None, -1),
    'PES_8': ('leaf', None, 'FT', 'SENDER_COMMENT', None, -1),
    'PES_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SENDER_AWARE_DATE_TIME', None, -1),
    'PES_10': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_REPORT_DATE', None, -1),
    'PES_11': ('leaf', None, 'ID', 'EVENT_REPORT_TIMING_TYPE', 'HL70234', -1),
    'PES_12': ('leaf', None, 'ID', 'EVENT_REPORT_SOURCE', 'HL70235', -1),
    'PES_13': ('leaf', None, 'ID', 'EVENT_REPORTED_TO', 'HL70236', -1),
    'PID_1': ('leaf', None, 'SI', 'SET_ID_PID', None, -1),
    'PID_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_ID', None, -1),
    'PID_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_IDENTIFIER_LIST', None, -1),
    'PID_4': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ALTERNATE_PATIENT_ID_PID', None, -1),
    'PID_5': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PATIENT_NAME', None, -1),
    'PID_6': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'PID_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_BIRTH', None, -1),
    'PID_8': ('leaf', None, 'IS', 'SEX', 'HL70001', -1),
    'PID_9': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PATIENT_ALIAS', None, -1),
    'PID_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RACE', 'HL70005', -1),
    'PID_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PATIENT_ADDRESS', None, -1),
    'PID_12': ('leaf', None, 'IS', 'COUNTY_CODE', 'HL70289', -1),
    'PID_13': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER_HOME', None, -1),
    'PID_14': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER_BUSINESS', None, -1),
    'PID_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'PID_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MARITAL_STATUS', 'HL70002', -1),
    'PID_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RELIGION', 'HL70006', -1),
    'PID_18': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_ACCOUNT_NUMBER', None, -1),
    'PID_19': ('leaf', None, 'ST', 'SSN_NUMBER_PATIENT', None, -1),
    'PID_20': ('sequence', DATATYPES_STRUCTS['DLN'], 'DLN', 'DRIVER_S_LICENSE_NUMBER_PATIENT', None, -1),
    'PID_21': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'MOTHER_S_IDENTIFIER', None, -1),
    'PID_22': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ETHNIC_GROUP', 'HL70189', -1),
    'PID_23': ('leaf', None, 'ST', 'BIRTH_PLACE', None, -1),
    'PID_24': ('leaf', None, 'ID', 'MULTIPLE_BIRTH_INDICATOR', 'HL70136', -1),
    'PID_25': ('leaf', None, 'NM', 'BIRTH_ORDER', None, -1),
    'PID_26': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CITIZENSHIP', 'HL70171', -1),
    'PID_27': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VETERANS_MILITARY_STATUS', 'HL70172', -1),
    'PID_28': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NATIONALITY', 'HL70212', -1),
    'PID_29': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PATIENT_DEATH_DATE_AND_TIME', None, -1),
    'PID_30': ('leaf', None, 'ID', 'PATIENT_DEATH_INDICATOR', 'HL70136', -1),
    'PR1_1': ('leaf', None, 'SI', 'SET_ID_PR1', None, -1),
    'PR1_2': ('leaf', None, 'IS', 'PROCEDURE_CODING_METHOD', 'HL70089', -1),
    'PR1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_CODE', 'HL70088', -1),
    'PR1_4': ('leaf', None, 'ST', 'PROCEDURE_DESCRIPTION', None, -1),
    'PR1_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PROCEDURE_DATE_TIME', None, -1),
    'PR1_6': ('leaf', None, 'IS', 'PROCEDURE_FUNCTIONAL_TYPE', 'HL70230', -1),
    'PR1_7': ('leaf', None, 'NM', 'PROCEDURE_MINUTES', None, -1),
    'PR1_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ANESTHESIOLOGIST', 'HL70010', -1),
    'PR1_9': ('leaf', None, 'IS', 'ANESTHESIA_CODE', 'HL70019', -1),
    'PR1_10': ('leaf', None, 'NM', 'ANESTHESIA_MINUTES', None, -1),
    'PR1_11': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'SURGEON', 'HL70010', -1),
    'PR1_12': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PROCEDURE_PRACTITIONER', 'HL70010', -1),
    'PR1_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONSENT_CODE', 'HL70059', -1),
    'PR1_14': ('leaf', None, 'NM', 'PROCEDURE_PRIORITY', None, -1),
    'PR1_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ASSOCIATED_DIAGNOSIS_CODE', 'HL70051', -1),
    'PR1_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'PRA_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_KEY_VALUE_PRA', None, -1),
    'PRA_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRACTITIONER_GROUP', 'HL70358', -1),
    'PRA_3': ('leaf', None, 'IS', 'PRACTITIONER_CATEGORY', 'HL70186', -1),
    'PRA_4': ('leaf', None, 'ID', 'PROVIDER_BILLING', 'HL70187', -1),
    'PRA_5': ('sequence', DATATYPES_STRUCTS['SPD'], 'SPD', 'SPECIALTY', 'HL70337', -1),
    'PRA_6': ('sequence', DATATYPES_STRUCTS['PLN'], 'PLN', 'PRACTITIONER_ID_NUMBERS', 'HL70338', -1),
    'PRA_7': ('sequence', DATATYPES_STRUCTS['PIP'], 'PIP', 'PRIVILEGES', None, -1),
    'PRA_8': ('leaf', None, 'DT', 'DATE_ENTERED_PRACTICE', None, -1),
    'PRB_1': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70287', -1),
    'PRB_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ACTION_DATE_TIME', None, -1),
    'PRB_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_ID', None, -1),
    'PRB_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROBLEM_INSTANCE_ID', None, -1),
    'PRB_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EPISODE_OF_CARE_ID', None, -1),
    'PRB_6': ('leaf', None, 'NM', 'PROBLEM_LIST_PRIORITY', None, -1),
    'PRB_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PROBLEM_ESTABLISHED_DATE_TIME', None, -1),
    'PRB_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ANTICIPATED_PROBLEM_RESOLUTION_DATE_TIME', None, -1),
    'PRB_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ACTUAL_PROBLEM_RESOLUTION_DATE_TIME', None, -1),
    'PRB_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_CLASSIFICATION', None, -1),
    'PRB_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_MANAGEMENT_DISCIPLINE', None, -1),
    'PRB_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_PERSISTENCE', None, -1),
    'PRB_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_CONFIRMATION_STATUS', None, -1),
    'PRB_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_LIFE_CYCLE_STATUS', None, -1),
    'PRB_15': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PROBLEM_LIFE_CYCLE_STATUS_DATE_TIME', None, -1),
    'PRB_16': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PROBLEM_DATE_OF_ONSET', None, -1),
    'PRB_17': ('leaf', None, 'ST', 'PROBLEM_ONSET_TEXT', None, -1),
    'PRB_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_RANKING', None, -1),
    'PRB_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CERTAINTY_OF_PROBLEM', None, -1),
    'PRB_20': ('leaf', None, 'NM', 'PROBABILITY_OF_PROBLEM_0_1', None, -1),
    'PRB_21': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INDIVIDUAL_AWARENESS_OF_PROBLEM', None, -1),
    'PRB_22': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROBLEM_PROGNOSIS', None, -1),
    'PRB_23': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INDIVIDUAL_AWARENESS_OF_PROGNOSIS', None, -1),
    'PRB_24': ('leaf', None, 'ST', 'FAMILY_SIGNIFICANT_OTHER_AWARENESS_OF_PROBLEM_PROGNOSIS', None, -1),
    'PRB_25': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SECURITY_SENSITIVITY', None, -1),
    'PRC_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_KEY_VALUE_PRC', 'HL70132', -1),
    'PRC_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FACILITY_ID_PRC', None, -1),
    'PRC_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DEPARTMENT', 'HL70184', -1),
    'PRC_4': ('leaf', None, 'IS', 'VALID_PATIENT_CLASSES', 'HL70004', -1),
    'PRC_5': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRICE', None, -1),
    'PRC_6': ('leaf', None, 'ST', 'FORMULA', None, -1),
    'PRC_7': ('leaf', None, 'NM', 'MINIMUM_QUANTITY', None, -1),
    'PRC_8': ('leaf', None, 'NM', 'MAXIMUM_QUANTITY', None, -1),
    'PRC_9': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'MINIMUM_PRICE', None, -1),
    'PRC_10': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'MAXIMUM_PRICE', None, -1),
    'PRC_11': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_START_DATE', None, -1),
    'PRC_12': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_END_DATE', None, -1),
    'PRC_13': ('leaf', None, 'IS', 'PRICE_OVERRIDE_FLAG', 'HL70268', -1),
    'PRC_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'BILLING_CATEGORY', 'HL70293', -1),
    'PRC_15': ('leaf', None, 'ID', 'CHARGEABLE_FLAG', 'HL70136', -1),
    'PRC_16': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'PRC_17': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'COST', None, -1),
    'PRC_18': ('leaf', None, 'IS', 'CHARGE_ON_INDICATOR', 'HL70269', -1),
    'PRD_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROVIDER_ROLE', 'HL70286', -1),
    'PRD_2': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PROVIDER_NAME', None, -1),
    'PRD_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PROVIDER_ADDRESS', None, -1),
    'PRD_4': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PROVIDER_LOCATION', None, -1),
    'PRD_5': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PROVIDER_COMMUNICATION_INFORMATION', None, -1),
    'PRD_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185', -1),
    'PRD_7': ('sequence', DATATYPES_STRUCTS['PI'], 'PI', 'PROVIDER_IDENTIFIERS', None, -1),
    'PRD_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_START_DATE_OF_PROVIDER_ROLE', None, -1),
    'PRD_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_END_DATE_OF_PROVIDER_ROLE', None, -1),
    'PSH_1': ('leaf', None, 'ST', 'REPORT_TYPE', None, -1),
    'PSH_2': ('leaf', None, 'ST', 'REPORT_FORM_IDENTIFIER', None, -1),
    'PSH_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'REPORT_DATE', None, -1),
    'PSH_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'REPORT_INTERVAL_START_DATE', None, -1),
    'PSH_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'REPORT_INTERVAL_END_DATE', None, -1),
    'PSH_6': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_MANUFACTURED', None, -1),
    'PSH_7': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_DISTRIBUTED', None, -1),
    'PSH_8': ('leaf', None, 'ID', 'QUANTITY_DISTRIBUTED_METHOD', 'HL70329', -1),
    'PSH_9': ('leaf', None, 'FT', 'QUANTITY_DISTRIBUTED_COMMENT', None, -1),
    'PSH_10': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_IN_USE', None, -1),
    'PSH_11': ('leaf', None, 'ID', 'QUANTITY_IN_USE_METHOD', 'HL70329', -1),
    'PSH_12': ('leaf', None, 'FT', 'QUANTITY_IN_USE_COMMENT', None, -1),
    'PSH_13': ('leaf', None, 'NM', 'NUMBER_OF_PRODUCT_EXPERIENCE_REPORTS_FILED_BY_FACILITY', None, -1),
    'PSH_14': ('leaf', None, 'NM', 'NUMBER_OF_PRODUCT_EXPERIENCE_REPORTS_FILED_BY_DISTRIBUTOR', None, -1),
    'PTH_1': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70287', -1),
    'PTH_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PATHWAY_ID', None, -1),
    'PTH_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PATHWAY_INSTANCE_ID', None, -1),
    'PTH_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PATHWAY_ESTABLISHED_DATE_TIME', None, -1),
    'PTH_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PATHWAY_LIFE_CYCLE_STATUS', None, -1),
    'PTH_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'CHANGE_PATHWAY_LIFE_CYCLE_STATUS_DATE_TIME', None, -1),
    'PV1_1': ('leaf', None, 'SI', 'SET_ID_PV1', None, -1),
    'PV1_2': ('leaf', None, 'IS', 'PATIENT_CLASS', 'HL70004', -1),
    'PV1_3': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ASSIGNED_PATIENT_LOCATION', None, -1),
    'PV1_4': ('leaf', None, 'IS', 'ADMISSION_TYPE', 'HL70007', -1),
    'PV1_5': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PREADMIT_NUMBER', None, -1),
    'PV1_6': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIOR_PATIENT_LOCATION', None, -1),
    'PV1_7': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ATTENDING_DOCTOR', 'HL70010', -1),
    'PV1_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'REFERRING_DOCTOR', 'HL70010', -1),
    'PV1_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CONSULTING_DOCTOR', 'HL70010', -1),
    'PV1_10': ('leaf', None, 'IS', 'HOSPITAL_SERVICE', 'HL70069', -1),
    'PV1_11': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'TEMPORARY_LOCATION', None, -1),
    'PV1_12': ('leaf', None, 'IS', 'PREADMIT_TEST_INDICATOR', 'HL70087', -1),
    'PV1_13': ('leaf', None, 'IS', 'RE_ADMISSION_INDICATOR', 'HL70092', -1),
    'PV1_14': ('leaf', None, 'IS', 'ADMIT_SOURCE', 'HL70023', -1),
    'PV1_15': ('leaf', None, 'IS', 'AMBULATORY_STATUS', 'HL70009', -1),
    'PV1_16': ('leaf', None, 'IS', 'VIP_INDICATOR', 'HL70099', -1),
    'PV1_17': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ADMITTING_DOCTOR', 'HL70010', -1),
    'PV1_18': ('leaf', None, 'IS', 'PATIENT_TYPE', 'HL70018', -1),
    'PV1_19': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'VISIT_NUMBER', None, -1),
    'PV1_20': ('sequence', DATATYPES_STRUCTS['FC'], 'FC', 'FINANCIAL_CLASS', 'HL70064', -1),
    'PV1_21': ('leaf', None, 'IS', 'CHARGE_PRICE_INDICATOR', 'HL70032', -1),
    'PV1_22': ('leaf', None, 'IS', 'COURTESY_CODE', 'HL70045', -1),
    'PV1_23': ('leaf', None, 'IS', 'CREDIT_RATING', 'HL70046', -1),
    'PV1_24': ('leaf', None, 'IS', 'CONTRACT_CODE', 'HL70044', -1),
    'PV1_25': ('leaf', None, 'DT', 'CONTRACT_EFFECTIVE_DATE', None, -1),
    'PV1_26': ('leaf', None, 'NM', 'CONTRACT_AMOUNT', None, -1),
    'PV1_27': ('leaf', None, 'NM', 'CONTRACT_PERIOD', None, -1),
    'PV1_28': ('leaf', None, 'IS', 'INTEREST_CODE', 'HL70073', -1),
    'PV1_29': ('leaf', None, 'IS', 'TRANSFER_TO_BAD_DEBT_CODE', 'HL70110', -1),
    'PV1_30': ('leaf', None, 'DT', 'TRANSFER_TO_BAD_DEBT_DATE', None, -1),
    'PV1_31': ('leaf', None, 'IS', 'BAD_DEBT_AGENCY_CODE', 'HL70021', -1),
    'PV1_32': ('leaf', None, 'NM', 'BAD_DEBT_TRANSFER_AMOUNT', None, -1),
    'PV1_33': ('leaf', None, 'NM', 'BAD_DEBT_RECOVERY_AMOUNT', None, -1),
    'PV1_34': ('leaf', None, 'IS', 'DELETE_ACCOUNT_INDICATOR', 'HL70111', -1),
    'PV1_35': ('leaf', None, 'DT', 'DELETE_ACCOUNT_DATE', None, -1),
    'PV1_36': ('leaf', None, 'IS', 'DISCHARGE_DISPOSITION', 'HL70112', -1),
    'PV1_37': ('sequence', DATATYPES_STRUCTS['DLD'], 'DLD', 'DISCHARGED_TO_LOCATION', 'HL70113', -1),
    'PV1_38': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIET_TYPE', 'HL70114', -1),
    'PV1_39': ('leaf', None, 'IS', 'SERVICING_FACILITY', 'HL70115', -1),
    'PV1_40': ('leaf', None, 'IS', 'BED_STATUS', 'HL70116', -1),
    'PV1_41': ('leaf', None, 'IS', 'ACCOUNT_STATUS', 'HL70117', -1),
    'PV1_42': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PENDING_LOCATION', None, -1),
    'PV1_43': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIOR_TEMPORARY_LOCATION', None, -1),
    'PV1_44': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ADMIT_DATE_TIME', None, -1),
    'PV1_45': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DISCHARGE_DATE_TIME', None, -1),
    'PV1_46': ('leaf', None, 'NM', 'CURRENT_PATIENT_BALANCE', None, -1),
    'PV1_47': ('leaf', None, 'NM', 'TOTAL_CHARGES', None, -1),
    'PV1_48': ('leaf', None, 'NM', 'TOTAL_ADJUSTMENTS', None, -1),
    'PV1_49': ('leaf', None, 'NM', 'TOTAL_PAYMENTS', None, -1),
    'PV1_50': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ALTERNATE_VISIT_ID', 'HL70203', -1),
    'PV1_51': ('leaf', None, 'IS', 'VISIT_INDICATOR', 'HL70326', -1),
    'PV1_52': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OTHER_HEALTHCARE_PROVIDER', 'HL70010', -1),
    'PV2_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIOR_PENDING_LOCATION', None, -1),
    'PV2_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACCOMMODATION_CODE', 'HL70129', -1),
    'PV2_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMIT_REASON', None, -1),
    'PV2_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRANSFER_REASON', None, -1),
    'PV2_5': ('leaf', None, 'ST', 'PATIENT_VALUABLES', None, -1),
    'PV2_6': ('leaf', None, 'ST', 'PATIENT_VALUABLES_LOCATION', None, -1),
    'PV2_7': ('leaf', None, 'IS', 'VISIT_USER_CODE', 'HL70130', -1),
    'PV2_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EXPECTED_ADMIT_DATE_TIME', None, -1),
    'PV2_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EXPECTED_DISCHARGE_DATE_TIME', None, -1),
    'PV2_10': ('leaf', None, 'NM', 'ESTIMATED_LENGTH_OF_INPATIENT_STAY', None, -1),
    'PV2_11': ('leaf', None, 'NM', 'ACTUAL_LENGTH_OF_INPATIENT_STAY', None, -1),
    'PV2_12': ('leaf', None, 'ST', 'VISIT_DESCRIPTION', None, -1),
    'PV2_13': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'REFERRAL_SOURCE_CODE', None, -1),
    'PV2_14': ('leaf', None, 'DT', 'PREVIOUS_SERVICE_DATE', None, -1),
    'PV2_15': ('leaf', None, 'ID', 'EMPLOYMENT_ILLNESS_RELATED_INDICATOR', 'HL70136', -1),
    'PV2_16': ('leaf', None, 'IS', 'PURGE_STATUS_CODE', 'HL70213', -1),
    'PV2_17': ('leaf', None, 'DT', 'PURGE_STATUS_DATE', None, -1),
    'PV2_18': ('leaf', None, 'IS', 'SPECIAL_PROGRAM_CODE', 'HL70214', -1),
    'PV2_19': ('leaf', None, 'ID', 'RETENTION_INDICATOR', 'HL70136', -1),
    'PV2_20': ('leaf', None, 'NM', 'EXPECTED_NUMBER_OF_INSURANCE_PLANS', None, -1),
    'PV2_21': ('leaf', None, 'IS', 'VISIT_PUBLICITY_CODE', 'HL70215', -1),
    'PV2_22': ('leaf', None, 'ID', 'VISIT_PROTECTION_INDICATOR', 'HL70136', -1),
    'PV2_23': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'CLINIC_ORGANIZATION_NAME', None, -1),
    'PV2_24': ('leaf', None, 'IS', 'PATIENT_STATUS_CODE', 'HL70216', -1),
    'PV2_25': ('leaf', None, 'IS', 'VISIT_PRIORITY_CODE', 'HL70217', -1),
    'PV2_26': ('leaf', None, 'DT', 'PREVIOUS_TREATMENT_DATE', None, -1),
    'PV2_27': ('leaf', None, 'IS', 'EXPECTED_DISCHARGE_DISPOSITION', 'HL70112', -1),
    'PV2_28': ('leaf', None, 'DT', 'SIGNATURE_ON_FILE_DATE', None, -1),
    'PV2_29': ('leaf', None, 'DT', 'FIRST_SIMILAR_ILLNESS_DATE', None, -1),
    'PV2_30': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PATIENT_CHARGE_ADJUSTMENT_CODE', 'HL70218', -1),
    'PV2_31': ('leaf', None, 'IS', 'RECURRING_SERVICE_CODE', 'HL70219', -1),
    'PV2_32': ('leaf', None, 'ID', 'BILLING_MEDIA_CODE', 'HL70136', -1),
    'PV2_33': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EXPECTED_SURGERY_DATE_TIME', None, -1),
    'PV2_34': ('leaf', None, 'ID', 'MILITARY_PARTNERSHIP_CODE', 'HL70136', -1),
    'PV2_35': ('leaf', None, 'ID', 'MILITARY_NON_AVAILABILITY_CODE', 'HL70136', -1),
    'PV2_36': ('leaf', None, 'ID', 'NEWBORN_BABY_INDICATOR', 'HL70136', -1),
    'PV2_37': ('leaf', None, 'ID', 'BABY_DETAINED_INDICATOR', 'HL70136', -1),
    'QAK_1': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'QAK_2': ('leaf', None, 'ID', 'QUERY_RESPONSE_STATUS', 'HL70208', -1),
    'QRD_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'QUERY_DATE_TIME', None, -1),
    'QRD_2': ('leaf', None, 'ID', 'QUERY_FORMAT_CODE', 'HL70106', -1),
    'QRD_3': ('leaf', None, 'ID', 'QUERY_PRIORITY', 'HL70091', -1),
    'QRD_4': ('leaf', None, 'ST', 'QUERY_ID', None, -1),
    'QRD_5': ('leaf', None, 'ID', 'DEFERRED_RESPONSE_TYPE', 'HL70107', -1),
    'QRD_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DEFERRED_RESPONSE_DATE_TIME', None, -1),
    'QRD_7': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_LIMITED_REQUEST', 'HL70126', -1),
    'QRD_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'WHO_SUBJECT_FILTER', None, -1),
    'QRD_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'WHAT_SUBJECT_FILTER', 'HL70048', -1),
    'QRD_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'WHAT_DEPARTMENT_DATA_CODE', None, -1),
    'QRD_11': ('sequence', DATATYPES_STRUCTS['VR'], 'VR', 'WHAT_DATA_CODE_VALUE_QUAL', None, -1),
    'QRD_12': ('leaf', None, 'ID', 'QUERY_RESULTS_LEVEL', 'HL70108', -1),
    'QRF_1': ('leaf', None, 'ST', 'WHERE_SUBJECT_FILTER', None, -1),
    'QRF_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'WHEN_DATA_START_DATE_TIME', None, -1),
    'QRF_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'WHEN_DATA_END_DATE_TIME', None, -1),
    'QRF_4': ('leaf', None, 'ST', 'WHAT_USER_QUALIFIER', None, -1),
    'QRF_5': ('leaf', None, 'ST', 'OTHER_QRY_SUBJECT_FILTER', None, -1),
    'QRF_6': ('leaf', None, 'ID', 'WHICH_DATE_TIME_QUALIFIER', 'HL70156', -1),
    'QRF_7': ('leaf', None, 'ID', 'WHICH_DATE_TIME_STATUS_QUALIFIER', 'HL70157', -1),
    'QRF_8': ('leaf', None, 'ID', 'DATE_TIME_SELECTION_QUALIFIER', 'HL70158', -1),
    'QRF_9': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'WHEN_QUANTITY_TIMING_QUALIFIER', None, -1),
    'RDF_1': ('leaf', None, 'NM', 'NUMBER_OF_COLUMNS_PER_ROW', None, -1),
    'RDF_2': ('sequence', DATATYPES_STRUCTS['RCD'], 'RCD', 'COLUMN_DESCRIPTION', None, -1),
    'RDT_1': ('sequence', None, 'varies', 'COLUMN_VALUE', None, -1),
    'RF1_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFERRAL_STATUS', 'HL70283', -1),
    'RF1_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFERRAL_PRIORITY', 'HL70280', -1),
    'RF1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFERRAL_TYPE', 'HL70281', -1),
    'RF1_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFERRAL_DISPOSITION', 'HL70282', -1),
    'RF1_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFERRAL_CATEGORY', 'HL70284', -1),
    'RF1_6': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ORIGINATING_REFERRAL_IDENTIFIER', None, -1),
    'RF1_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE', None, -1),
    'RF1_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EXPIRATION_DATE', None, -1),
    'RF1_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PROCESS_DATE', None, -1),
    'RF1_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFERRAL_REASON', 'HL70336', -1),
    'RF1_11': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EXTERNAL_REFERRAL_IDENTIFIER', None, -1),
    'RGS_1': ('leaf', None, 'SI', 'SET_ID_RGS', None, -1),
    'RGS_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'RGS_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RESOURCE_GROUP_ID', None, -1),
    'ROL_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ROLE_INSTANCE_ID', None, -1),
    'ROL_2': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70287', -1),
    'ROL_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ROLE_ROL', None, -1),
    'ROL_4': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ROLE_PERSON', None, -1),
    'ROL_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ROLE_BEGIN_DATE_TIME', None, -1),
    'ROL_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ROLE_END_DATE_TIME', None, -1),
    'ROL_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ROLE_DURATION', None, -1),
    'ROL_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ROLE_ACTION_REASON', None, -1),
    'RQ1_1': ('leaf', None, 'ST', 'ANTICIPATED_PRICE', None, -1),
    'RQ1_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MANUFACTURER_ID', None, -1),
    'RQ1_3': ('leaf', None, 'ST', 'MANUFACTURER_S_CATALOG', None, -1),
    'RQ1_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VENDOR_ID', None, -1),
    'RQ1_5': ('leaf', None, 'ST', 'VENDOR_CATALOG', None, -1),
    'RQ1_6': ('leaf', None, 'ID', 'TAXABLE', 'HL70136', -1),
    'RQ1_7': ('leaf', None, 'ID', 'SUBSTITUTE_ALLOWED', 'HL70136', -1),
    'RQD_1': ('leaf', None, 'SI', 'REQUISITION_LINE_NUMBER', None, -1),
    'RQD_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ITEM_CODE_INTERNAL', None, -1),
    'RQD_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ITEM_CODE_EXTERNAL', None, -1),
    'RQD_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'HOSPITAL_ITEM_CODE', None, -1),
    'RQD_5': ('leaf', None, 'NM', 'REQUISITION_QUANTITY', None, -1),
    'RQD_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUISITION_UNIT_OF_MEASURE', None, -1),
    'RQD_7': ('leaf', None, 'IS', 'DEPT_COST_CENTER', 'HL70319', -1),
    'RQD_8': ('leaf', None, 'IS', 'ITEM_NATURAL_ACCOUNT_CODE', 'HL70320', -1),
    'RQD_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DELIVER_TO_ID', None, -1),
    'RQD_10': ('leaf', None, 'DT', 'DATE_NEEDED', None, -1),
    'RXA_1': ('leaf', None, 'NM', 'GIVE_SUB_ID_COUNTER', None, -1),
    'RXA_2': ('leaf', None, 'NM', 'ADMINISTRATION_SUB_ID_COUNTER', None, -1),
    'RXA_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_START_OF_ADMINISTRATION', None, -1),
    'RXA_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_END_OF_ADMINISTRATION', None, -1),
    'RXA_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTERED_CODE', 'HL70292', -1),
    'RXA_6': ('leaf', None, 'NM', 'ADMINISTERED_AMOUNT', None, -1),
    'RXA_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTERED_UNITS', None, -1),
    'RXA_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTERED_DOSAGE_FORM', None, -1),
    'RXA_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTRATION_NOTES', None, -1),
    'RXA_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ADMINISTERING_PROVIDER', None, -1),
    'RXA_11': ('sequence', DATATYPES_STRUCTS['LA2'], 'LA2', 'ADMINISTERED_AT_LOCATION', None, -1),
    'RXA_12': ('leaf', None, 'ST', 'ADMINISTERED_PER_TIME_UNIT', None, -1),
    'RXA_13': ('leaf', None, 'NM', 'ADMINISTERED_STRENGTH', None, -1),
    'RXA_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTERED_STRENGTH_UNITS', None, -1),
    'RXA_15': ('leaf', None, 'ST', 'SUBSTANCE_LOT_NUMBER', None, -1),
    'RXA_16': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SUBSTANCE_EXPIRATION_DATE', None, -1),
    'RXA_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SUBSTANCE_MANUFACTURER_NAME', 'HL70227', -1),
    'RXA_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SUBSTANCE_REFUSAL_REASON', None, -1),
    'RXA_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INDICATION', None, -1),
    'RXA_20': ('leaf', None, 'ID', 'COMPLETION_STATUS', 'HL70322', -1),
    'RXA_21': ('leaf', None, 'ID', 'ACTION_CODE_RXA', 'HL70323', -1),
    'RXA_22': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SYSTEM_ENTRY_DATE_TIME', None, -1),
    'RXC_1': ('leaf', None, 'ID', 'RX_COMPONENT_TYPE', 'HL70166', -1),
    'RXC_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COMPONENT_CODE', None, -1),
    'RXC_3': ('leaf', None, 'NM', 'COMPONENT_AMOUNT', None, -1),
    'RXC_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COMPONENT_UNITS', None, -1),
    'RXC_5': ('leaf', None, 'NM', 'COMPONENT_STRENGTH', None, -1),
    'RXC_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COMPONENT_STRENGTH_UNITS', None, -1),
    'RXD_1': ('leaf', None, 'NM', 'DISPENSE_SUB_ID_COUNTER', None, -1),
    'RXD_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DISPENSE_GIVE_CODE', 'HL70292', -1),
    'RXD_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_DISPENSED', None, -1),
    'RXD_4': ('leaf', None, 'NM', 'ACTUAL_DISPENSE_AMOUNT', None, -1),
    'RXD_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACTUAL_DISPENSE_UNITS', None, -1),
    'RXD_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACTUAL_DOSAGE_FORM', None, -1),
    'RXD_7': ('leaf', None, 'ST', 'PRESCRIPTION_NUMBER', None, -1),
    'RXD_8': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_REMAINING', None, -1),
    'RXD_9': ('leaf', None, 'ST', 'DISPENSE_NOTES', None, -1),
    'RXD_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DISPENSING_PROVIDER', None, -1),
    'RXD_11': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXD_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXD_13': ('sequence', DATATYPES_STRUCTS['LA2'], 'LA2', 'DISPENSE_TO_LOCATION', None, -1),
    'RXD_14': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXD_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PHARMACY_TREATMENT_SUPPLIER_S_SPECIAL_DISPENSING_INSTRUCTIONS', None, -1),
    'RXD_16': ('leaf', None, 'NM', 'ACTUAL_STRENGTH', None, -1),
    'RXD_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACTUAL_STRENGTH_UNIT', None, -1),
    'RXD_18': ('leaf', None, 'ST', 'SUBSTANCE_LOT_NUMBER', None, -1),
    'RXD_19': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SUBSTANCE_EXPIRATION_DATE', None, -1),
    'RXD_20': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SUBSTANCE_MANUFACTURER_NAME', 'HL70227', -1),
    'RXD_21': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INDICATION', None, -1),
    'RXD_22': ('leaf', None, 'NM', 'DISPENSE_PACKAGE_SIZE', None, -1),
    'RXD_23': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DISPENSE_PACKAGE_SIZE_UNIT', None, -1),
    'RXD_24': ('leaf', None, 'ID', 'DISPENSE_PACKAGE_METHOD', 'HL70321', -1),
    'RXE_1': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'RXE_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_CODE', 'HL70292', -1),
    'RXE_3': ('leaf', None, 'NM', 'GIVE_AMOUNT_MINIMUM', None, -1),
    'RXE_4': ('leaf', None, 'NM', 'GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXE_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_UNITS', None, -1),
    'RXE_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_DOSAGE_FORM', None, -1),
    'RXE_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', None, -1),
    'RXE_8': ('sequence', DATATYPES_STRUCTS['LA1'], 'LA1', 'DELIVER_TO_LOCATION', None, -1),
    'RXE_9': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXE_10': ('leaf', None, 'NM', 'DISPENSE_AMOUNT', None, -1),
    'RXE_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DISPENSE_UNITS', None, -1),
    'RXE_12': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS', None, -1),
    'RXE_13': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER_S_DEA_NUMBER', None, -1),
    'RXE_14': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PHARMACIST_TREATMENT_SUPPLIER_S_VERIFIER_ID', None, -1),
    'RXE_15': ('leaf', None, 'ST', 'PRESCRIPTION_NUMBER', None, -1),
    'RXE_16': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_REMAINING', None, -1),
    'RXE_17': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_DOSES_DISPENSED', None, -1),
    'RXE_18': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'D_T_OF_MOST_RECENT_REFILL_OR_DOSE_DISPENSED', None, -1),
    'RXE_19': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXE_20': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXE_21': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PHARMACY_TREATMENT_SUPPLIER_S_SPECIAL_DISPENSING_INSTRUCTIONS', None, -1),
    'RXE_22': ('leaf', None, 'ST', 'GIVE_PER_TIME_UNIT', None, -1),
    'RXE_23': ('leaf', None, 'ST', 'GIVE_RATE_AMOUNT', None, -1),
    'RXE_24': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_RATE_UNITS', None, -1),
    'RXE_25': ('leaf', None, 'NM', 'GIVE_STRENGTH', None, -1),
    'RXE_26': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_STRENGTH_UNITS', None, -1),
    'RXE_27': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_INDICATION', None, -1),
    'RXE_28': ('leaf', None, 'NM', 'DISPENSE_PACKAGE_SIZE', None, -1),
    'RXE_29': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DISPENSE_PACKAGE_SIZE_UNIT', None, -1),
    'RXE_30': ('leaf', None, 'ID', 'DISPENSE_PACKAGE_METHOD', 'HL70321', -1),
    'RXG_1': ('leaf', None, 'NM', 'GIVE_SUB_ID_COUNTER', None, -1),
    'RXG_2': ('leaf', None, 'NM', 'DISPENSE_SUB_ID_COUNTER', None, -1),
    'RXG_3': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'RXG_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_CODE', 'HL70292', -1),
    'RXG_5': ('leaf', None, 'NM', 'GIVE_AMOUNT_MINIMUM', None, -1),
    'RXG_6': ('leaf', None, 'NM', 'GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXG_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_UNITS', None, -1),
    'RXG_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_DOSAGE_FORM', None, -1),
    'RXG_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTRATION_NOTES', None, -1),
    'RXG_10': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXG_11': ('sequence', DATATYPES_STRUCTS['LA2'], 'LA2', 'DISPENSE_TO_LOCATION', None, -1),
    'RXG_12': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXG_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PHARMACY_TREATMENT_SUPPLIER_S_SPECIAL_ADMINISTRATION_INSTRUCTIONS', None, -1),
    'RXG_14': ('leaf', None, 'ST', 'GIVE_PER_TIME_UNIT', None, -1),
    'RXG_15': ('leaf', None, 'ST', 'GIVE_RATE_AMOUNT', None, -1),
    'RXG_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_RATE_UNITS', None, -1),
    'RXG_17': ('leaf', None, 'NM', 'GIVE_STRENGTH', None, -1),
    'RXG_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_STRENGTH_UNITS', None, -1),
    'RXG_19': ('leaf', None, 'ST', 'SUBSTANCE_LOT_NUMBER', None, -1),
    'RXG_20': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SUBSTANCE_EXPIRATION_DATE', None, -1),
    'RXG_21': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SUBSTANCE_MANUFACTURER_NAME', 'HL70227', -1),
    'RXG_22': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INDICATION', None, -1),
    'RXO_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_GIVE_CODE', None, -1),
    'RXO_2': ('leaf', None, 'NM', 'REQUESTED_GIVE_AMOUNT_MINIMUM', None, -1),
    'RXO_3': ('leaf', None, 'NM', 'REQUESTED_GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXO_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_GIVE_UNITS', None, -1),
    'RXO_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_DOSAGE_FORM', None, -1),
    'RXO_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROVIDER_S_PHARMACY_TREATMENT_INSTRUCTIONS', None, -1),
    'RXO_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', None, -1),
    'RXO_8': ('sequence', DATATYPES_STRUCTS['LA1'], 'LA1', 'DELIVER_TO_LOCATION', None, -1),
    'RXO_9': ('leaf', None, 'ID', 'ALLOW_SUBSTITUTIONS', 'HL70161', -1),
    'RXO_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_DISPENSE_CODE', None, -1),
    'RXO_11': ('leaf', None, 'NM', 'REQUESTED_DISPENSE_AMOUNT', None, -1),
    'RXO_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_DISPENSE_UNITS', None, -1),
    'RXO_13': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS', None, -1),
    'RXO_14': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER_S_DEA_NUMBER', None, -1),
    'RXO_15': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PHARMACIST_TREATMENT_SUPPLIER_S_VERIFIER_ID', None, -1),
    'RXO_16': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXO_17': ('leaf', None, 'ST', 'REQUESTED_GIVE_PER_TIME_UNIT', None, -1),
    'RXO_18': ('leaf', None, 'NM', 'REQUESTED_GIVE_STRENGTH', None, -1),
    'RXO_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_GIVE_STRENGTH_UNITS', None, -1),
    'RXO_20': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INDICATION', None, -1),
    'RXO_21': ('leaf', None, 'ST', 'REQUESTED_GIVE_RATE_AMOUNT', None, -1),
    'RXO_22': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_GIVE_RATE_UNITS', None, -1),
    'RXO_23': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXR_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ROUTE', 'HL70162', -1),
    'RXR_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SITE', 'HL70163', -1),
    'RXR_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTRATION_DEVICE', 'HL70164', -1),
    'RXR_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTRATION_METHOD', 'HL70165', -1),
    'RXR_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ROUTING_INSTRUCTION', None, -1),
    'SCH_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_APPOINTMENT_ID', None, -1),
    'SCH_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_APPOINTMENT_ID', None, -1),
    'SCH_3': ('leaf', None, 'NM', 'OCCURRENCE_NUMBER', None, -1),
    'SCH_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_GROUP_NUMBER', None, -1),
    'SCH_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SCHEDULE_ID', None, -1),
    'SCH_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'EVENT_REASON', None, -1),
    'SCH_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPOINTMENT_REASON', 'HL70276', -1),
    'SCH_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPOINTMENT_TYPE', 'HL70277', -1),
    'SCH_9': ('leaf', None, 'NM', 'APPOINTMENT_DURATION', None, -1),
    'SCH_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPOINTMENT_DURATION_UNITS', None, -1),
    'SCH_11': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'APPOINTMENT_TIMING_QUANTITY', None, -1),
    'SCH_12': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PLACER_CONTACT_PERSON', None, -1),
    'SCH_13': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PLACER_CONTACT_PHONE_NUMBER', None, -1),
    'SCH_14': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PLACER_CONTACT_ADDRESS', None, -1),
    'SCH_15': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PLACER_CONTACT_LOCATION', None, -1),
    'SCH_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'FILLER_CONTACT_PERSON', None, -1),
    'SCH_17': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'FILLER_CONTACT_PHONE_NUMBER', None, -1),
    'SCH_18': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'FILLER_CONTACT_ADDRESS', None, -1),
    'SCH_19': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'FILLER_CONTACT_LOCATION', None, -1),
    'SCH_20': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY_PERSON', None, -1),
    'SCH_21': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ENTERED_BY_PHONE_NUMBER', None, -1),
    'SCH_22': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ENTERED_BY_LOCATION', None, -1),
    'SCH_23': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_PLACER_APPOINTMENT_ID', None, -1),
    'SCH_24': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_FILLER_APPOINTMENT_ID', None, -1),
    'SCH_25': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'SPR_1': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'SPR_2': ('leaf', None, 'ID', 'QUERY_RESPONSE_FORMAT_CODE', 'HL70106', -1),
    'SPR_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STORED_PROCEDURE_NAME', None, -1),
    'SPR_4': ('sequence', DATATYPES_STRUCTS['QIP'], 'QIP', 'INPUT_PARAMETER_LIST', None, -1),
    'STF_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_KEY_VALUE_STF', None, -1),
    'STF_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'STAFF_ID_CODE', None, -1),
    'STF_3': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'STAFF_NAME', None, -1),
    'STF_4': ('leaf', None, 'IS', 'STAFF_TYPE', 'HL70182', -1),
    'STF_5': ('leaf', None, 'IS', 'SEX', 'HL70001', -1),
    'STF_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_BIRTH', None, -1),
    'STF_7': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'STF_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DEPARTMENT', 'HL70184', -1),
    'STF_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'HOSPITAL_SERVICE', 'HL70069', -1),
    'STF_10': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE', None, -1),
    'STF_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'OFFICE_HOME_ADDRESS', None, -1),
    'STF_12': ('sequence', DATATYPES_STRUCTS['DIN'], 'DIN', 'INSTITUTION_ACTIVATION_DATE', None, -1),
    'STF_13': ('sequence', DATATYPES_STRUCTS['DIN'], 'DIN', 'INSTITUTION_INACTIVATION_DATE', None, -1),
    'STF_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'BACKUP_PERSON_ID', None, -1),
    'STF_15': ('leaf', None, 'ST', 'E_MAIL_ADDRESS', None, -1),
    'STF_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185', -1),
    'STF_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MARITAL_STATUS', 'HL70002', -1),
    'STF_18': ('leaf', None, 'ST', 'JOB_TITLE', None, -1),
    'STF_19': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'JOB_CODE_CLASS', 'HL70327', -1),
    'STF_20': ('leaf', None, 'IS', 'EMPLOYMENT_STATUS', 'HL70066', -1),
    'STF_21': ('leaf', None, 'ID', 'ADDITIONAL_INSURED_ON_AUTO', 'HL70136', -1),
    'STF_22': ('sequence', DATATYPES_STRUCTS['DLN'], 'DLN', 'DRIVER_S_LICENSE_NUMBER_STAFF', None, -1),
    'STF_23': ('leaf', None, 'ID', 'COPY_AUTO_INS', 'HL70136', -1),
    'STF_24': ('leaf', None, 'DT', 'AUTO_INS_EXPIRES', None, -1),
    'STF_25': ('leaf', None, 'DT', 'DATE_LAST_DMV_REVIEW', None, -1),
    'STF_26': ('leaf', None, 'DT', 'DATE_NEXT_DMV_REVIEW', None, -1),
    'TXA_1': ('leaf', None, 'SI', 'SET_ID_TXA', None, -1),
    'TXA_2': ('leaf', None, 'IS', 'DOCUMENT_TYPE', 'HL70270', -1),
    'TXA_3': ('leaf', None, 'ID', 'DOCUMENT_CONTENT_PRESENTATION', 'HL70191', -1),
    'TXA_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ACTIVITY_DATE_TIME', None, -1),
    'TXA_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PRIMARY_ACTIVITY_PROVIDER_CODE_NAME', None, -1),
    'TXA_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ORIGINATION_DATE_TIME', None, -1),
    'TXA_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'TRANSCRIPTION_DATE_TIME', None, -1),
    'TXA_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EDIT_DATE_TIME', None, -1),
    'TXA_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORIGINATOR_CODE_NAME', None, -1),
    'TXA_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ASSIGNED_DOCUMENT_AUTHENTICATOR', None, -1),
    'TXA_11': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'TRANSCRIPTIONIST_CODE_NAME', None, -1),
    'TXA_12': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'UNIQUE_DOCUMENT_NUMBER', None, -1),
    'TXA_13': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_DOCUMENT_NUMBER', None, -1),
    'TXA_14': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'TXA_15': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'TXA_16': ('leaf', None, 'ST', 'UNIQUE_DOCUMENT_FILE_NAME', None, -1),
    'TXA_17': ('leaf', None, 'ID', 'DOCUMENT_COMPLETION_STATUS', 'HL70271', -1),
    'TXA_18': ('leaf', None, 'ID', 'DOCUMENT_CONFIDENTIALITY_STATUS', 'HL70272', -1),
    'TXA_19': ('leaf', None, 'ID', 'DOCUMENT_AVAILABILITY_STATUS', 'HL70273', -1),
    'TXA_20': ('leaf', None, 'ID', 'DOCUMENT_STORAGE_STATUS', 'HL70275', -1),
    'TXA_21': ('leaf', None, 'ST', 'DOCUMENT_CHANGE_REASON', None, -1),
    'TXA_22': ('sequence', DATATYPES_STRUCTS['PPN'], 'PPN', 'AUTHENTICATION_PERSON_TIME_STAMP', None, -1),
    'TXA_23': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DISTRIBUTED_COPIES_CODE_AND_NAME_OF_RECIPIENTS', None, -1),
    'UB1_1': ('leaf', None, 'SI', 'SET_ID_UB1', None, -1),
    'UB1_2': ('leaf', None, 'NM', 'BLOOD_DEDUCTIBLE_43', None, -1),
    'UB1_3': ('leaf', None, 'NM', 'BLOOD_FURNISHED_PINTS_OF_40', None, -1),
    'UB1_4': ('leaf', None, 'NM', 'BLOOD_REPLACED_PINTS_41', None, -1),
    'UB1_5': ('leaf', None, 'NM', 'BLOOD_NOT_REPLACED_PINTS_42', None, -1),
    'UB1_6': ('leaf', None, 'NM', 'CO_INSURANCE_DAYS_25', None, -1),
    'UB1_7': ('leaf', None, 'IS', 'CONDITION_CODE_35_39', 'HL70043', -1),
    'UB1_8': ('leaf', None, 'NM', 'COVERED_DAYS_23', None, -1),
    'UB1_9': ('leaf', None, 'NM', 'NON_COVERED_DAYS_24', None, -1),
    'UB1_10': ('sequence', DATATYPES_STRUCTS['UVC'], 'UVC', 'VALUE_AMOUNT_CODE_46_49', 'HL70153', -1),
    'UB1_11': ('leaf', None, 'NM', 'NUMBER_OF_GRACE_DAYS_90', None, -1),
    'UB1_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SPECIAL_PROGRAM_INDICATOR_44', 'HL70348', -1),
    'UB1_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PSRO_UR_APPROVAL_INDICATOR_87', 'HL70349', -1),
    'UB1_14': ('leaf', None, 'DT', 'PSRO_UR_APPROVED_STAY_FM_88', None, -1),
    'UB1_15': ('leaf', None, 'DT', 'PSRO_UR_APPROVED_STAY_TO_89', None, -1),
    'UB1_16': ('sequence', DATATYPES_STRUCTS['OCD'], 'OCD', 'OCCURRENCE_28_32', 'HL70350', -1),
    'UB1_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OCCURRENCE_SPAN_33', 'HL70351', -1),
    'UB1_18': ('leaf', None, 'DT', 'OCCUR_SPAN_START_DATE_33', None, -1),
    'UB1_19': ('leaf', None, 'DT', 'OCCUR_SPAN_END_DATE_33', None, -1),
    'UB1_20': ('leaf', None, 'ST', 'UB_82_LOCATOR_2', None, -1),
    'UB1_21': ('leaf', None, 'ST', 'UB_82_LOCATOR_9', None, -1),
    'UB1_22': ('leaf', None, 'ST', 'UB_82_LOCATOR_27', None, -1),
    'UB1_23': ('leaf', None, 'ST', 'UB_82_LOCATOR_45', None, -1),
    'UB2_1': ('leaf', None, 'SI', 'SET_ID_UB2', None, -1),
    'UB2_2': ('leaf', None, 'ST', 'CO_INSURANCE_DAYS_9', None, -1),
    'UB2_3': ('leaf', None, 'IS', 'CONDITION_CODE_24_30', 'HL70043', -1),
    'UB2_4': ('leaf', None, 'ST', 'COVERED_DAYS_7', None, -1),
    'UB2_5': ('leaf', None, 'ST', 'NON_COVERED_DAYS_8', None, -1),
    'UB2_6': ('sequence', DATATYPES_STRUCTS['UVC'], 'UVC', 'VALUE_AMOUNT_CODE', 'HL70153', -1),
    'UB2_7': ('sequence', DATATYPES_STRUCTS['OCD'], 'OCD', 'OCCURRENCE_CODE_DATE_32_35', 'HL70350', -1),
    'UB2_8': ('sequence', DATATYPES_STRUCTS['OSP'], 'OSP', 'OCCURRENCE_SPAN_CODE_DATES_36', 'HL70351', -1),
    'UB2_9': ('leaf', None, 'ST', 'UB92_LOCATOR_2_STATE', None, -1),
    'UB2_10': ('leaf', None, 'ST', 'UB92_LOCATOR_11_STATE', None, -1),
    'UB2_11': ('leaf', None, 'ST', 'UB92_LOCATOR_31_NATIONAL', None, -1),
    'UB2_12': ('leaf', None, 'ST', 'DOCUMENT_CONTROL_NUMBER', None, -1),
    'UB2_13': ('leaf', None, 'ST', 'UB92_LOCATOR_49_NATIONAL', None, -1),
    'UB2_14': ('leaf', None, 'ST', 'UB92_LOCATOR_56_STATE', None, -1),
    'UB2_15': ('leaf', None, 'ST', 'UB92_LOCATOR_57_NATIONAL', None, -1),
    'UB2_16': ('leaf', None, 'ST', 'UB92_LOCATOR_78_STATE', None, -1),
    'UB2_17': ('leaf', None, 'NM', 'SPECIAL_VISIT_COUNT', None, -1),
    'URD_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'R_U_DATE_TIME', None, -1),
    'URD_2': ('leaf', None, 'ID', 'REPORT_PRIORITY', 'HL70109', -1),
    'URD_3': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'R_U_WHO_SUBJECT_DEFINITION', None, -1),
    'URD_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'R_U_WHAT_SUBJECT_DEFINITION', 'HL70048', -1),
    'URD_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'R_U_WHAT_DEPARTMENT_CODE', None, -1),
    'URD_6': ('leaf', None, 'ST', 'R_U_DISPLAY_PRINT_LOCATIONS', None, -1),
    'URD_7': ('leaf', None, 'ID', 'R_U_RESULTS_LEVEL', 'HL70108', -1),
    'URS_1': ('leaf', None, 'ST', 'R_U_WHERE_SUBJECT_DEFINITION', None, -1),
    'URS_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'R_U_WHEN_DATA_START_DATE_TIME', None, -1),
    'URS_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'R_U_WHEN_DATA_END_DATE_TIME', None, -1),
    'URS_4': ('leaf', None, 'ST', 'R_U_WHAT_USER_QUALIFIER', None, -1),
    'URS_5': ('leaf', None, 'ST', 'R_U_OTHER_RESULTS_SUBJECT_DEFINITION', None, -1),
    'URS_6': ('leaf', None, 'ID', 'R_U_WHICH_DATE_TIME_QUALIFIER', 'HL70156', -1),
    'URS_7': ('leaf', None, 'ID', 'R_U_WHICH_DATE_TIME_STATUS_QUALIFIER', 'HL70157', -1),
    'URS_8': ('leaf', None, 'ID', 'R_U_DATE_TIME_SELECTION_QUALIFIER', 'HL70158', -1),
    'URS_9': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'R_U_QUANTITY_TIMING_QUALIFIER', None, -1),
    'VAR_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'VARIANCE_INSTANCE_ID', None, -1),
    'VAR_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DOCUMENTED_DATE_TIME', None, -1),
    'VAR_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'STATED_VARIANCE_DATE_TIME', None, -1),
    'VAR_4': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'VARIANCE_ORIGINATOR', None, -1),
    'VAR_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VARIANCE_CLASSIFICATION', None, -1),
    'VAR_6': ('leaf', None, 'ST', 'VARIANCE_DESCRIPTION', None, -1),
    'VTQ_1': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'VTQ_2': ('leaf', None, 'ID', 'QUERY_RESPONSE_FORMAT_CODE', 'HL70106', -1),
    'VTQ_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VT_QUERY_NAME', None, -1),
    'VTQ_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VIRTUAL_TABLE_NAME', None, -1),
    'VTQ_5': ('sequence', DATATYPES_STRUCTS['QSC'], 'QSC', 'SELECTION_CRITERIA', None, -1),
}