# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AaddsResourceDetails(msrest.serialization.Model):
    """The Azure active directory domain service resource details.

    :param domain_name: The Azure active directory domain service name.
    :type domain_name: str
    :param initial_sync_complete: This indicates whether initial sync complete or not.
    :type initial_sync_complete: bool
    :param ldaps_enabled: This indicates whether enable ldaps or not.
    :type ldaps_enabled: bool
    :param ldaps_public_certificate_in_base64: The base 64 format string of public ldap
     certificate.
    :type ldaps_public_certificate_in_base64: str
    :param resource_id: The resource id of azure active directory domain service.
    :type resource_id: str
    :param subnet_id: The subnet resource id.
    :type subnet_id: str
    :param tenant_id: The tenant id of azure active directory domain service .
    :type tenant_id: str
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'initial_sync_complete': {'key': 'initialSyncComplete', 'type': 'bool'},
        'ldaps_enabled': {'key': 'ldapsEnabled', 'type': 'bool'},
        'ldaps_public_certificate_in_base64': {'key': 'ldapsPublicCertificateInBase64', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AaddsResourceDetails, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.initial_sync_complete = kwargs.get('initial_sync_complete', None)
        self.ldaps_enabled = kwargs.get('ldaps_enabled', None)
        self.ldaps_public_certificate_in_base64 = kwargs.get('ldaps_public_certificate_in_base64', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Application(ProxyResource):
    """The HDInsight cluster application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param etag: The ETag for the application.
    :type etag: str
    :param tags: A set of tags. The tags for the application.
    :type tags: dict[str, str]
    :param properties: The properties of the application.
    :type properties: ~azure.mgmt.hdinsight.models.ApplicationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ApplicationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Application, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.tags = kwargs.get('tags', None)
        self.properties = kwargs.get('properties', None)


class ApplicationGetEndpoint(msrest.serialization.Model):
    """Gets the application SSH endpoint.

    :param location: The location of the endpoint.
    :type location: str
    :param destination_port: The destination port to connect to.
    :type destination_port: int
    :param public_port: The public port to connect to.
    :type public_port: int
    :param private_ip_address: The private ip address of the endpoint.
    :type private_ip_address: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'int'},
        'public_port': {'key': 'publicPort', 'type': 'int'},
        'private_ip_address': {'key': 'privateIPAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGetEndpoint, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.destination_port = kwargs.get('destination_port', None)
        self.public_port = kwargs.get('public_port', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)


class ApplicationGetHttpsEndpoint(msrest.serialization.Model):
    """Gets the application HTTP endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param access_modes: The list of access modes for the application.
    :type access_modes: list[str]
    :ivar location: The location of the endpoint.
    :vartype location: str
    :param destination_port: The destination port to connect to.
    :type destination_port: int
    :ivar public_port: The public port to connect to.
    :vartype public_port: int
    :param private_ip_address: The private ip address of the endpoint.
    :type private_ip_address: str
    :param sub_domain_suffix: The subdomain suffix of the application.
    :type sub_domain_suffix: str
    :param disable_gateway_auth: The value indicates whether to disable GatewayAuth.
    :type disable_gateway_auth: bool
    """

    _validation = {
        'location': {'readonly': True},
        'public_port': {'readonly': True},
    }

    _attribute_map = {
        'access_modes': {'key': 'accessModes', 'type': '[str]'},
        'location': {'key': 'location', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'int'},
        'public_port': {'key': 'publicPort', 'type': 'int'},
        'private_ip_address': {'key': 'privateIPAddress', 'type': 'str'},
        'sub_domain_suffix': {'key': 'subDomainSuffix', 'type': 'str'},
        'disable_gateway_auth': {'key': 'disableGatewayAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGetHttpsEndpoint, self).__init__(**kwargs)
        self.access_modes = kwargs.get('access_modes', None)
        self.location = None
        self.destination_port = kwargs.get('destination_port', None)
        self.public_port = None
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.sub_domain_suffix = kwargs.get('sub_domain_suffix', None)
        self.disable_gateway_auth = kwargs.get('disable_gateway_auth', None)


class ApplicationListResult(msrest.serialization.Model):
    """Result of the request to list cluster Applications. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of HDInsight applications installed on HDInsight cluster.
    :type value: list[~azure.mgmt.hdinsight.models.Application]
    :ivar next_link: The URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Application]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ApplicationProperties(msrest.serialization.Model):
    """The HDInsight cluster application GET response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param compute_profile: The list of roles in the cluster.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param install_script_actions: The list of install script actions.
    :type install_script_actions: list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :param uninstall_script_actions: The list of uninstall script actions.
    :type uninstall_script_actions: list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :param https_endpoints: The list of application HTTPS endpoints.
    :type https_endpoints: list[~azure.mgmt.hdinsight.models.ApplicationGetHttpsEndpoint]
    :param ssh_endpoints: The list of application SSH endpoints.
    :type ssh_endpoints: list[~azure.mgmt.hdinsight.models.ApplicationGetEndpoint]
    :ivar provisioning_state: The provisioning state of the application.
    :vartype provisioning_state: str
    :param application_type: The application type.
    :type application_type: str
    :ivar application_state: The application state.
    :vartype application_state: str
    :param errors: The list of errors.
    :type errors: list[~azure.mgmt.hdinsight.models.Errors]
    :ivar created_date: The application create date time.
    :vartype created_date: str
    :ivar marketplace_identifier: The marketplace identifier.
    :vartype marketplace_identifier: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'application_state': {'readonly': True},
        'created_date': {'readonly': True},
        'marketplace_identifier': {'readonly': True},
    }

    _attribute_map = {
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'install_script_actions': {'key': 'installScriptActions', 'type': '[RuntimeScriptAction]'},
        'uninstall_script_actions': {'key': 'uninstallScriptActions', 'type': '[RuntimeScriptAction]'},
        'https_endpoints': {'key': 'httpsEndpoints', 'type': '[ApplicationGetHttpsEndpoint]'},
        'ssh_endpoints': {'key': 'sshEndpoints', 'type': '[ApplicationGetEndpoint]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'application_type': {'key': 'applicationType', 'type': 'str'},
        'application_state': {'key': 'applicationState', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Errors]'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'marketplace_identifier': {'key': 'marketplaceIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationProperties, self).__init__(**kwargs)
        self.compute_profile = kwargs.get('compute_profile', None)
        self.install_script_actions = kwargs.get('install_script_actions', None)
        self.uninstall_script_actions = kwargs.get('uninstall_script_actions', None)
        self.https_endpoints = kwargs.get('https_endpoints', None)
        self.ssh_endpoints = kwargs.get('ssh_endpoints', None)
        self.provisioning_state = None
        self.application_type = kwargs.get('application_type', None)
        self.application_state = None
        self.errors = kwargs.get('errors', None)
        self.created_date = None
        self.marketplace_identifier = None


class AsyncOperationResult(msrest.serialization.Model):
    """The azure async operation response.

    :param status: The async operation state. Possible values include: "InProgress", "Succeeded",
     "Failed".
    :type status: str or ~azure.mgmt.hdinsight.models.AsyncOperationState
    :param error: The operation error information.
    :type error: ~azure.mgmt.hdinsight.models.Errors
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Errors'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AsyncOperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class Autoscale(msrest.serialization.Model):
    """The autoscale request parameters.

    :param capacity: Parameters for load-based autoscale.
    :type capacity: ~azure.mgmt.hdinsight.models.AutoscaleCapacity
    :param recurrence: Parameters for schedule-based autoscale.
    :type recurrence: ~azure.mgmt.hdinsight.models.AutoscaleRecurrence
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'AutoscaleCapacity'},
        'recurrence': {'key': 'recurrence', 'type': 'AutoscaleRecurrence'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Autoscale, self).__init__(**kwargs)
        self.capacity = kwargs.get('capacity', None)
        self.recurrence = kwargs.get('recurrence', None)


class AutoscaleCapacity(msrest.serialization.Model):
    """The load-based autoscale request parameters.

    :param min_instance_count: The minimum instance count of the cluster.
    :type min_instance_count: int
    :param max_instance_count: The maximum instance count of the cluster.
    :type max_instance_count: int
    """

    _attribute_map = {
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'max_instance_count': {'key': 'maxInstanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleCapacity, self).__init__(**kwargs)
        self.min_instance_count = kwargs.get('min_instance_count', None)
        self.max_instance_count = kwargs.get('max_instance_count', None)


class AutoscaleConfigurationUpdateParameter(msrest.serialization.Model):
    """The autoscale configuration update parameter.

    :param autoscale: The autoscale configuration.
    :type autoscale: ~azure.mgmt.hdinsight.models.Autoscale
    """

    _attribute_map = {
        'autoscale': {'key': 'autoscale', 'type': 'Autoscale'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleConfigurationUpdateParameter, self).__init__(**kwargs)
        self.autoscale = kwargs.get('autoscale', None)


class AutoscaleRecurrence(msrest.serialization.Model):
    """Schedule-based autoscale request parameters.

    :param time_zone: The time zone for the autoscale schedule times.
    :type time_zone: str
    :param schedule: Array of schedule-based autoscale rules.
    :type schedule: list[~azure.mgmt.hdinsight.models.AutoscaleSchedule]
    """

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': '[AutoscaleSchedule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleRecurrence, self).__init__(**kwargs)
        self.time_zone = kwargs.get('time_zone', None)
        self.schedule = kwargs.get('schedule', None)


class AutoscaleSchedule(msrest.serialization.Model):
    """Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity.

    :param days: Days of the week for a schedule-based autoscale rule.
    :type days: list[str or ~azure.mgmt.hdinsight.models.DaysOfWeek]
    :param time_and_capacity: Time and capacity for a schedule-based autoscale rule.
    :type time_and_capacity: ~azure.mgmt.hdinsight.models.AutoscaleTimeAndCapacity
    """

    _attribute_map = {
        'days': {'key': 'days', 'type': '[str]'},
        'time_and_capacity': {'key': 'timeAndCapacity', 'type': 'AutoscaleTimeAndCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleSchedule, self).__init__(**kwargs)
        self.days = kwargs.get('days', None)
        self.time_and_capacity = kwargs.get('time_and_capacity', None)


class AutoscaleTimeAndCapacity(msrest.serialization.Model):
    """Time and capacity request parameters.

    :param time: 24-hour time in the form xx:xx.
    :type time: str
    :param min_instance_count: The minimum instance count of the cluster.
    :type min_instance_count: int
    :param max_instance_count: The maximum instance count of the cluster.
    :type max_instance_count: int
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'str'},
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'max_instance_count': {'key': 'maxInstanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleTimeAndCapacity, self).__init__(**kwargs)
        self.time = kwargs.get('time', None)
        self.min_instance_count = kwargs.get('min_instance_count', None)
        self.max_instance_count = kwargs.get('max_instance_count', None)


class AzureMonitorRequest(msrest.serialization.Model):
    """The azure monitor parameters.

    :param workspace_id: The Log Analytics workspace ID.
    :type workspace_id: str
    :param primary_key: The Log Analytics workspace key.
    :type primary_key: str
    :param selected_configurations: The selected configurations.
    :type selected_configurations: ~azure.mgmt.hdinsight.models.AzureMonitorSelectedConfigurations
    """

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'selected_configurations': {'key': 'selectedConfigurations', 'type': 'AzureMonitorSelectedConfigurations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMonitorRequest, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.selected_configurations = kwargs.get('selected_configurations', None)


class AzureMonitorResponse(msrest.serialization.Model):
    """The azure monitor status response.

    :param cluster_monitoring_enabled: The status of the monitor on the HDInsight cluster.
    :type cluster_monitoring_enabled: bool
    :param workspace_id: The workspace ID of the monitor on the HDInsight cluster.
    :type workspace_id: str
    :param selected_configurations: The selected configurations.
    :type selected_configurations: ~azure.mgmt.hdinsight.models.AzureMonitorSelectedConfigurations
    """

    _attribute_map = {
        'cluster_monitoring_enabled': {'key': 'clusterMonitoringEnabled', 'type': 'bool'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'selected_configurations': {'key': 'selectedConfigurations', 'type': 'AzureMonitorSelectedConfigurations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMonitorResponse, self).__init__(**kwargs)
        self.cluster_monitoring_enabled = kwargs.get('cluster_monitoring_enabled', None)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.selected_configurations = kwargs.get('selected_configurations', None)


class AzureMonitorSelectedConfigurations(msrest.serialization.Model):
    """The selected configurations for azure monitor.

    :param configuration_version: The configuration version.
    :type configuration_version: str
    :param global_configurations: The global configurations of selected configurations.
    :type global_configurations: dict[str, str]
    :param table_list: The table list.
    :type table_list: list[~azure.mgmt.hdinsight.models.AzureMonitorTableConfiguration]
    """

    _attribute_map = {
        'configuration_version': {'key': 'configurationVersion', 'type': 'str'},
        'global_configurations': {'key': 'globalConfigurations', 'type': '{str}'},
        'table_list': {'key': 'tableList', 'type': '[AzureMonitorTableConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMonitorSelectedConfigurations, self).__init__(**kwargs)
        self.configuration_version = kwargs.get('configuration_version', None)
        self.global_configurations = kwargs.get('global_configurations', None)
        self.table_list = kwargs.get('table_list', None)


class AzureMonitorTableConfiguration(msrest.serialization.Model):
    """The table configuration for the Log Analytics integration.

    :param name: The name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMonitorTableConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class BillingMeters(msrest.serialization.Model):
    """The billing meters.

    :param meter_parameter: The virtual machine sizes.
    :type meter_parameter: str
    :param meter: The HDInsight meter guid.
    :type meter: str
    :param unit: The unit of meter, VMHours or CoreHours.
    :type unit: str
    """

    _attribute_map = {
        'meter_parameter': {'key': 'meterParameter', 'type': 'str'},
        'meter': {'key': 'meter', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingMeters, self).__init__(**kwargs)
        self.meter_parameter = kwargs.get('meter_parameter', None)
        self.meter = kwargs.get('meter', None)
        self.unit = kwargs.get('unit', None)


class BillingResources(msrest.serialization.Model):
    """The billing resources.

    :param region: The region or location.
    :type region: str
    :param billing_meters: The billing meter information.
    :type billing_meters: list[~azure.mgmt.hdinsight.models.BillingMeters]
    :param disk_billing_meters: The managed disk billing information.
    :type disk_billing_meters: list[~azure.mgmt.hdinsight.models.DiskBillingMeters]
    """

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
        'billing_meters': {'key': 'billingMeters', 'type': '[BillingMeters]'},
        'disk_billing_meters': {'key': 'diskBillingMeters', 'type': '[DiskBillingMeters]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingResources, self).__init__(**kwargs)
        self.region = kwargs.get('region', None)
        self.billing_meters = kwargs.get('billing_meters', None)
        self.disk_billing_meters = kwargs.get('disk_billing_meters', None)


class BillingResponseListResult(msrest.serialization.Model):
    """The response for the operation to get regional billingSpecs for a subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param vm_sizes: The virtual machine sizes to include or exclude.
    :type vm_sizes: list[str]
    :param vm_sizes_with_encryption_at_host: The vm sizes which enable encryption at host.
    :type vm_sizes_with_encryption_at_host: list[str]
    :param vm_size_filters: The virtual machine filtering mode. Effectively this can enabling or
     disabling the virtual machine sizes in a particular set.
    :type vm_size_filters: list[~azure.mgmt.hdinsight.models.VmSizeCompatibilityFilterV2]
    :ivar vm_size_properties: The vm size properties.
    :vartype vm_size_properties: list[~azure.mgmt.hdinsight.models.VmSizeProperty]
    :param billing_resources: The billing and managed disk billing resources for a region.
    :type billing_resources: list[~azure.mgmt.hdinsight.models.BillingResources]
    """

    _validation = {
        'vm_size_properties': {'readonly': True},
    }

    _attribute_map = {
        'vm_sizes': {'key': 'vmSizes', 'type': '[str]'},
        'vm_sizes_with_encryption_at_host': {'key': 'vmSizesWithEncryptionAtHost', 'type': '[str]'},
        'vm_size_filters': {'key': 'vmSizeFilters', 'type': '[VmSizeCompatibilityFilterV2]'},
        'vm_size_properties': {'key': 'vmSizeProperties', 'type': '[VmSizeProperty]'},
        'billing_resources': {'key': 'billingResources', 'type': '[BillingResources]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingResponseListResult, self).__init__(**kwargs)
        self.vm_sizes = kwargs.get('vm_sizes', None)
        self.vm_sizes_with_encryption_at_host = kwargs.get('vm_sizes_with_encryption_at_host', None)
        self.vm_size_filters = kwargs.get('vm_size_filters', None)
        self.vm_size_properties = None
        self.billing_resources = kwargs.get('billing_resources', None)


class CapabilitiesResult(msrest.serialization.Model):
    """The Get Capabilities operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param versions: The version capability.
    :type versions: dict[str, ~azure.mgmt.hdinsight.models.VersionsCapability]
    :param regions: The virtual machine size compatibility features.
    :type regions: dict[str, ~azure.mgmt.hdinsight.models.RegionsCapability]
    :param vmsizes: The virtual machine sizes.
    :type vmsizes: dict[str, ~azure.mgmt.hdinsight.models.VmSizesCapability]
    :param vmsize_filters: The virtual machine size compatibility filters.
    :type vmsize_filters: list[~azure.mgmt.hdinsight.models.VmSizeCompatibilityFilter]
    :param features: The capability features.
    :type features: list[str]
    :ivar quota: The quota capability.
    :vartype quota: ~azure.mgmt.hdinsight.models.QuotaCapability
    """

    _validation = {
        'quota': {'readonly': True},
    }

    _attribute_map = {
        'versions': {'key': 'versions', 'type': '{VersionsCapability}'},
        'regions': {'key': 'regions', 'type': '{RegionsCapability}'},
        'vmsizes': {'key': 'vmsizes', 'type': '{VmSizesCapability}'},
        'vmsize_filters': {'key': 'vmsize_filters', 'type': '[VmSizeCompatibilityFilter]'},
        'features': {'key': 'features', 'type': '[str]'},
        'quota': {'key': 'quota', 'type': 'QuotaCapability'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilitiesResult, self).__init__(**kwargs)
        self.versions = kwargs.get('versions', None)
        self.regions = kwargs.get('regions', None)
        self.vmsizes = kwargs.get('vmsizes', None)
        self.vmsize_filters = kwargs.get('vmsize_filters', None)
        self.features = kwargs.get('features', None)
        self.quota = None


class ClientGroupInfo(msrest.serialization.Model):
    """The information of AAD security group.

    :param group_name: The AAD security group name.
    :type group_name: str
    :param group_id: The AAD security group id.
    :type group_id: str
    """

    _attribute_map = {
        'group_name': {'key': 'groupName', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientGroupInfo, self).__init__(**kwargs)
        self.group_name = kwargs.get('group_name', None)
        self.group_id = kwargs.get('group_id', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The Azure Region where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Cluster(TrackedResource):
    """The HDInsight cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The Azure Region where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: The ETag for the resource.
    :type etag: str
    :param properties: The properties of the cluster.
    :type properties: ~azure.mgmt.hdinsight.models.ClusterGetProperties
    :param identity: The identity of the cluster, if configured.
    :type identity: ~azure.mgmt.hdinsight.models.ClusterIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClusterGetProperties'},
        'identity': {'key': 'identity', 'type': 'ClusterIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Cluster, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.properties = kwargs.get('properties', None)
        self.identity = kwargs.get('identity', None)


class ClusterConfigurations(msrest.serialization.Model):
    """The configuration object for the specified cluster.

    :param configurations: The configuration object for the specified configuration for the
     specified cluster.
    :type configurations: dict[str, dict[str, str]]
    """

    _attribute_map = {
        'configurations': {'key': 'configurations', 'type': '{{str}}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterConfigurations, self).__init__(**kwargs)
        self.configurations = kwargs.get('configurations', None)


class ClusterCreateParametersExtended(msrest.serialization.Model):
    """The CreateCluster request parameters.

    :param location: The location of the cluster.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: The cluster create parameters.
    :type properties: ~azure.mgmt.hdinsight.models.ClusterCreateProperties
    :param identity: The identity of the cluster, if configured.
    :type identity: ~azure.mgmt.hdinsight.models.ClusterIdentity
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ClusterCreateProperties'},
        'identity': {'key': 'identity', 'type': 'ClusterIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterCreateParametersExtended, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.properties = kwargs.get('properties', None)
        self.identity = kwargs.get('identity', None)


class ClusterCreateProperties(msrest.serialization.Model):
    """The cluster create parameters.

    :param cluster_version: The version of the cluster.
    :type cluster_version: str
    :param os_type: The type of operating system. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.hdinsight.models.OSType
    :param tier: The cluster tier. Possible values include: "Standard", "Premium".
    :type tier: str or ~azure.mgmt.hdinsight.models.Tier
    :param cluster_definition: The cluster definition.
    :type cluster_definition: ~azure.mgmt.hdinsight.models.ClusterDefinition
    :param kafka_rest_properties: The cluster kafka rest proxy configuration.
    :type kafka_rest_properties: ~azure.mgmt.hdinsight.models.KafkaRestProperties
    :param security_profile: The security profile.
    :type security_profile: ~azure.mgmt.hdinsight.models.SecurityProfile
    :param compute_profile: The compute profile.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param storage_profile: The storage profile.
    :type storage_profile: ~azure.mgmt.hdinsight.models.StorageProfile
    :param disk_encryption_properties: The disk encryption properties.
    :type disk_encryption_properties: ~azure.mgmt.hdinsight.models.DiskEncryptionProperties
    :param encryption_in_transit_properties: The encryption-in-transit properties.
    :type encryption_in_transit_properties:
     ~azure.mgmt.hdinsight.models.EncryptionInTransitProperties
    :param min_supported_tls_version: The minimal supported tls version.
    :type min_supported_tls_version: str
    :param network_properties: The network properties.
    :type network_properties: ~azure.mgmt.hdinsight.models.NetworkProperties
    :param compute_isolation_properties: The compute isolation properties.
    :type compute_isolation_properties: ~azure.mgmt.hdinsight.models.ComputeIsolationProperties
    """

    _attribute_map = {
        'cluster_version': {'key': 'clusterVersion', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'cluster_definition': {'key': 'clusterDefinition', 'type': 'ClusterDefinition'},
        'kafka_rest_properties': {'key': 'kafkaRestProperties', 'type': 'KafkaRestProperties'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'disk_encryption_properties': {'key': 'diskEncryptionProperties', 'type': 'DiskEncryptionProperties'},
        'encryption_in_transit_properties': {'key': 'encryptionInTransitProperties', 'type': 'EncryptionInTransitProperties'},
        'min_supported_tls_version': {'key': 'minSupportedTlsVersion', 'type': 'str'},
        'network_properties': {'key': 'networkProperties', 'type': 'NetworkProperties'},
        'compute_isolation_properties': {'key': 'computeIsolationProperties', 'type': 'ComputeIsolationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterCreateProperties, self).__init__(**kwargs)
        self.cluster_version = kwargs.get('cluster_version', None)
        self.os_type = kwargs.get('os_type', None)
        self.tier = kwargs.get('tier', None)
        self.cluster_definition = kwargs.get('cluster_definition', None)
        self.kafka_rest_properties = kwargs.get('kafka_rest_properties', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.compute_profile = kwargs.get('compute_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.disk_encryption_properties = kwargs.get('disk_encryption_properties', None)
        self.encryption_in_transit_properties = kwargs.get('encryption_in_transit_properties', None)
        self.min_supported_tls_version = kwargs.get('min_supported_tls_version', None)
        self.network_properties = kwargs.get('network_properties', None)
        self.compute_isolation_properties = kwargs.get('compute_isolation_properties', None)


class ClusterCreateRequestValidationParameters(ClusterCreateParametersExtended):
    """The cluster create request specification.

    :param location: The location of the cluster.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param properties: The cluster create parameters.
    :type properties: ~azure.mgmt.hdinsight.models.ClusterCreateProperties
    :param identity: The identity of the cluster, if configured.
    :type identity: ~azure.mgmt.hdinsight.models.ClusterIdentity
    :param name: The cluster name.
    :type name: str
    :param type: The resource type.
    :type type: str
    :param tenant_id: The tenant id.
    :type tenant_id: str
    :param fetch_aadds_resource: This indicates whether fetch Aadds resource or not.
    :type fetch_aadds_resource: bool
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ClusterCreateProperties'},
        'identity': {'key': 'identity', 'type': 'ClusterIdentity'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'fetch_aadds_resource': {'key': 'fetchAaddsResource', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterCreateRequestValidationParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.fetch_aadds_resource = kwargs.get('fetch_aadds_resource', None)


class ClusterCreateValidationResult(msrest.serialization.Model):
    """The response of cluster create request validation.

    :param validation_errors: The validation errors.
    :type validation_errors: list[~azure.mgmt.hdinsight.models.ValidationErrorInfo]
    :param validation_warnings: The validation warnings.
    :type validation_warnings: list[~azure.mgmt.hdinsight.models.ValidationErrorInfo]
    :param estimated_creation_duration: The estimated creation duration.
    :type estimated_creation_duration: ~datetime.timedelta
    :param aadds_resources_details: The Azure active directory domain service resource details.
    :type aadds_resources_details: list[~azure.mgmt.hdinsight.models.AaddsResourceDetails]
    """

    _attribute_map = {
        'validation_errors': {'key': 'validationErrors', 'type': '[ValidationErrorInfo]'},
        'validation_warnings': {'key': 'validationWarnings', 'type': '[ValidationErrorInfo]'},
        'estimated_creation_duration': {'key': 'estimatedCreationDuration', 'type': 'duration'},
        'aadds_resources_details': {'key': 'aaddsResourcesDetails', 'type': '[AaddsResourceDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterCreateValidationResult, self).__init__(**kwargs)
        self.validation_errors = kwargs.get('validation_errors', None)
        self.validation_warnings = kwargs.get('validation_warnings', None)
        self.estimated_creation_duration = kwargs.get('estimated_creation_duration', None)
        self.aadds_resources_details = kwargs.get('aadds_resources_details', None)


class ClusterDefinition(msrest.serialization.Model):
    """The cluster definition.

    :param blueprint: The link to the blueprint.
    :type blueprint: str
    :param kind: The type of cluster.
    :type kind: str
    :param component_version: The versions of different services in the cluster.
    :type component_version: dict[str, str]
    :param configurations: The cluster configurations.
    :type configurations: any
    """

    _attribute_map = {
        'blueprint': {'key': 'blueprint', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'component_version': {'key': 'componentVersion', 'type': '{str}'},
        'configurations': {'key': 'configurations', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterDefinition, self).__init__(**kwargs)
        self.blueprint = kwargs.get('blueprint', None)
        self.kind = kwargs.get('kind', None)
        self.component_version = kwargs.get('component_version', None)
        self.configurations = kwargs.get('configurations', None)


class ClusterDiskEncryptionParameters(msrest.serialization.Model):
    """The Disk Encryption Cluster request parameters.

    :param vault_uri: Base key vault URI where the customers key is located eg.
     https://myvault.vault.azure.net.
    :type vault_uri: str
    :param key_name: Key name that is used for enabling disk encryption.
    :type key_name: str
    :param key_version: Specific key version that is used for enabling disk encryption.
    :type key_version: str
    """

    _attribute_map = {
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterDiskEncryptionParameters, self).__init__(**kwargs)
        self.vault_uri = kwargs.get('vault_uri', None)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)


class ClusterGetProperties(msrest.serialization.Model):
    """The properties of cluster.

    All required parameters must be populated in order to send to Azure.

    :param cluster_version: The version of the cluster.
    :type cluster_version: str
    :param cluster_hdp_version: The hdp version of the cluster.
    :type cluster_hdp_version: str
    :param os_type: The type of operating system. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.hdinsight.models.OSType
    :param tier: The cluster tier. Possible values include: "Standard", "Premium".
    :type tier: str or ~azure.mgmt.hdinsight.models.Tier
    :param cluster_id: The cluster id.
    :type cluster_id: str
    :param cluster_definition: Required. The cluster definition.
    :type cluster_definition: ~azure.mgmt.hdinsight.models.ClusterDefinition
    :param kafka_rest_properties: The cluster kafka rest proxy configuration.
    :type kafka_rest_properties: ~azure.mgmt.hdinsight.models.KafkaRestProperties
    :param security_profile: The security profile.
    :type security_profile: ~azure.mgmt.hdinsight.models.SecurityProfile
    :param compute_profile: The compute profile.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "InProgress", "Failed", "Succeeded", "Canceled", "Deleting".
    :type provisioning_state: str or ~azure.mgmt.hdinsight.models.HDInsightClusterProvisioningState
    :param created_date: The date on which the cluster was created.
    :type created_date: str
    :param cluster_state: The state of the cluster.
    :type cluster_state: str
    :param quota_info: The quota information.
    :type quota_info: ~azure.mgmt.hdinsight.models.QuotaInfo
    :param errors: The list of errors.
    :type errors: list[~azure.mgmt.hdinsight.models.Errors]
    :param connectivity_endpoints: The list of connectivity endpoints.
    :type connectivity_endpoints: list[~azure.mgmt.hdinsight.models.ConnectivityEndpoint]
    :param disk_encryption_properties: The disk encryption properties.
    :type disk_encryption_properties: ~azure.mgmt.hdinsight.models.DiskEncryptionProperties
    :param encryption_in_transit_properties: The encryption-in-transit properties.
    :type encryption_in_transit_properties:
     ~azure.mgmt.hdinsight.models.EncryptionInTransitProperties
    :param storage_profile: The storage profile.
    :type storage_profile: ~azure.mgmt.hdinsight.models.StorageProfile
    :param min_supported_tls_version: The minimal supported tls version.
    :type min_supported_tls_version: str
    :param excluded_services_config: The excluded services config.
    :type excluded_services_config: ~azure.mgmt.hdinsight.models.ExcludedServicesConfig
    :param network_properties: The network properties.
    :type network_properties: ~azure.mgmt.hdinsight.models.NetworkProperties
    :param compute_isolation_properties: The compute isolation properties.
    :type compute_isolation_properties: ~azure.mgmt.hdinsight.models.ComputeIsolationProperties
    """

    _validation = {
        'cluster_definition': {'required': True},
    }

    _attribute_map = {
        'cluster_version': {'key': 'clusterVersion', 'type': 'str'},
        'cluster_hdp_version': {'key': 'clusterHdpVersion', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'str'},
        'cluster_definition': {'key': 'clusterDefinition', 'type': 'ClusterDefinition'},
        'kafka_rest_properties': {'key': 'kafkaRestProperties', 'type': 'KafkaRestProperties'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'cluster_state': {'key': 'clusterState', 'type': 'str'},
        'quota_info': {'key': 'quotaInfo', 'type': 'QuotaInfo'},
        'errors': {'key': 'errors', 'type': '[Errors]'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': '[ConnectivityEndpoint]'},
        'disk_encryption_properties': {'key': 'diskEncryptionProperties', 'type': 'DiskEncryptionProperties'},
        'encryption_in_transit_properties': {'key': 'encryptionInTransitProperties', 'type': 'EncryptionInTransitProperties'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'min_supported_tls_version': {'key': 'minSupportedTlsVersion', 'type': 'str'},
        'excluded_services_config': {'key': 'excludedServicesConfig', 'type': 'ExcludedServicesConfig'},
        'network_properties': {'key': 'networkProperties', 'type': 'NetworkProperties'},
        'compute_isolation_properties': {'key': 'computeIsolationProperties', 'type': 'ComputeIsolationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterGetProperties, self).__init__(**kwargs)
        self.cluster_version = kwargs.get('cluster_version', None)
        self.cluster_hdp_version = kwargs.get('cluster_hdp_version', None)
        self.os_type = kwargs.get('os_type', None)
        self.tier = kwargs.get('tier', None)
        self.cluster_id = kwargs.get('cluster_id', None)
        self.cluster_definition = kwargs['cluster_definition']
        self.kafka_rest_properties = kwargs.get('kafka_rest_properties', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.compute_profile = kwargs.get('compute_profile', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.created_date = kwargs.get('created_date', None)
        self.cluster_state = kwargs.get('cluster_state', None)
        self.quota_info = kwargs.get('quota_info', None)
        self.errors = kwargs.get('errors', None)
        self.connectivity_endpoints = kwargs.get('connectivity_endpoints', None)
        self.disk_encryption_properties = kwargs.get('disk_encryption_properties', None)
        self.encryption_in_transit_properties = kwargs.get('encryption_in_transit_properties', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.min_supported_tls_version = kwargs.get('min_supported_tls_version', None)
        self.excluded_services_config = kwargs.get('excluded_services_config', None)
        self.network_properties = kwargs.get('network_properties', None)
        self.compute_isolation_properties = kwargs.get('compute_isolation_properties', None)


class ClusterIdentity(msrest.serialization.Model):
    """Identity for the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of cluster identity. This property will only be provided
     for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the cluster. This property will only be provided
     for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned'
     includes both an implicitly created identity and a set of user assigned identities. Possible
     values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.hdinsight.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the cluster. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.hdinsight.models.ComponentsC51Ht8SchemasClusteridentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ComponentsC51Ht8SchemasClusteridentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ClusterListPersistedScriptActionsResult(msrest.serialization.Model):
    """The ListPersistedScriptActions operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Persisted Script Actions.
    :type value: list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuntimeScriptAction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListPersistedScriptActionsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ClusterListResult(msrest.serialization.Model):
    """The List Cluster operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Clusters.
    :type value: list[~azure.mgmt.hdinsight.models.Cluster]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ClusterListRuntimeScriptActionDetailResult(msrest.serialization.Model):
    """The list runtime script action detail response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.hdinsight.models.RuntimeScriptActionDetail]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuntimeScriptActionDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListRuntimeScriptActionDetailResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClusterListRuntimeScriptActionDetailResultAutoGenerated(msrest.serialization.Model):
    """The list runtime script action detail response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of persisted script action details for the cluster.
    :vartype value: list[~azure.mgmt.hdinsight.models.RuntimeScriptActionDetail]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuntimeScriptActionDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListRuntimeScriptActionDetailResultAutoGenerated, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClusterMonitoringRequest(msrest.serialization.Model):
    """The cluster monitor parameters.

    :param workspace_id: The cluster monitor workspace ID.
    :type workspace_id: str
    :param primary_key: The cluster monitor workspace key.
    :type primary_key: str
    """

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterMonitoringRequest, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.primary_key = kwargs.get('primary_key', None)


class ClusterMonitoringResponse(msrest.serialization.Model):
    """The cluster monitoring status response.

    :param cluster_monitoring_enabled: The status of the monitor on the HDInsight cluster.
    :type cluster_monitoring_enabled: bool
    :param workspace_id: The workspace ID of the monitor on the HDInsight cluster.
    :type workspace_id: str
    """

    _attribute_map = {
        'cluster_monitoring_enabled': {'key': 'clusterMonitoringEnabled', 'type': 'bool'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterMonitoringResponse, self).__init__(**kwargs)
        self.cluster_monitoring_enabled = kwargs.get('cluster_monitoring_enabled', None)
        self.workspace_id = kwargs.get('workspace_id', None)


class ClusterPatchParameters(msrest.serialization.Model):
    """The PatchCluster request parameters.

    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterPatchParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class ClusterResizeParameters(msrest.serialization.Model):
    """The Resize Cluster request parameters.

    :param target_instance_count: The target instance count for the operation.
    :type target_instance_count: int
    """

    _attribute_map = {
        'target_instance_count': {'key': 'targetInstanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterResizeParameters, self).__init__(**kwargs)
        self.target_instance_count = kwargs.get('target_instance_count', None)


class ComponentsC51Ht8SchemasClusteridentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """ComponentsC51Ht8SchemasClusteridentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    :param tenant_id: The tenant id of user assigned identity.
    :type tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentsC51Ht8SchemasClusteridentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
        self.tenant_id = kwargs.get('tenant_id', None)


class ComputeIsolationProperties(msrest.serialization.Model):
    """The compute isolation properties.

    :param enable_compute_isolation: The flag indicates whether enable compute isolation or not.
    :type enable_compute_isolation: bool
    :param host_sku: The host sku.
    :type host_sku: str
    """

    _attribute_map = {
        'enable_compute_isolation': {'key': 'enableComputeIsolation', 'type': 'bool'},
        'host_sku': {'key': 'hostSku', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeIsolationProperties, self).__init__(**kwargs)
        self.enable_compute_isolation = kwargs.get('enable_compute_isolation', False)
        self.host_sku = kwargs.get('host_sku', None)


class ComputeProfile(msrest.serialization.Model):
    """Describes the compute profile.

    :param roles: The list of roles in the cluster.
    :type roles: list[~azure.mgmt.hdinsight.models.Role]
    """

    _attribute_map = {
        'roles': {'key': 'roles', 'type': '[Role]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeProfile, self).__init__(**kwargs)
        self.roles = kwargs.get('roles', None)


class ConnectivityEndpoint(msrest.serialization.Model):
    """The connectivity properties.

    :param name: The name of the endpoint.
    :type name: str
    :param protocol: The protocol of the endpoint.
    :type protocol: str
    :param location: The location of the endpoint.
    :type location: str
    :param port: The port to connect to.
    :type port: int
    :param private_ip_address: The private ip address of the endpoint.
    :type private_ip_address: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'private_ip_address': {'key': 'privateIPAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityEndpoint, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol = kwargs.get('protocol', None)
        self.location = kwargs.get('location', None)
        self.port = kwargs.get('port', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)


class DataDisksGroups(msrest.serialization.Model):
    """The data disks groups for the role.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param disks_per_node: The number of disks per node.
    :type disks_per_node: int
    :ivar storage_account_type: ReadOnly. The storage account type. Do not set this value.
    :vartype storage_account_type: str
    :ivar disk_size_gb: ReadOnly. The DiskSize in GB. Do not set this value.
    :vartype disk_size_gb: int
    """

    _validation = {
        'storage_account_type': {'readonly': True},
        'disk_size_gb': {'readonly': True},
    }

    _attribute_map = {
        'disks_per_node': {'key': 'disksPerNode', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataDisksGroups, self).__init__(**kwargs)
        self.disks_per_node = kwargs.get('disks_per_node', None)
        self.storage_account_type = None
        self.disk_size_gb = None


class Dimension(msrest.serialization.Model):
    """The definition of Dimension.

    :param name: The name of the dimension.
    :type name: str
    :param display_name: The display name of the dimension.
    :type display_name: str
    :param internal_name: The display name of the dimension.
    :type internal_name: str
    :param to_be_exported_for_shoebox: The flag indicates whether the metric will be exported for
     shoebox or not.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.internal_name = kwargs.get('internal_name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class DiskBillingMeters(msrest.serialization.Model):
    """The disk billing meters.

    :param disk_rp_meter: The managed disk meter guid.
    :type disk_rp_meter: str
    :param sku: The managed disk billing sku, P30 or S30.
    :type sku: str
    :param tier: The managed disk billing tier, Standard or Premium. Possible values include:
     "Standard", "Premium".
    :type tier: str or ~azure.mgmt.hdinsight.models.Tier
    """

    _attribute_map = {
        'disk_rp_meter': {'key': 'diskRpMeter', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskBillingMeters, self).__init__(**kwargs)
        self.disk_rp_meter = kwargs.get('disk_rp_meter', None)
        self.sku = kwargs.get('sku', None)
        self.tier = kwargs.get('tier', None)


class DiskEncryptionProperties(msrest.serialization.Model):
    """The disk encryption properties.

    :param vault_uri: Base key vault URI where the customers key is located eg.
     https://myvault.vault.azure.net.
    :type vault_uri: str
    :param key_name: Key name that is used for enabling disk encryption.
    :type key_name: str
    :param key_version: Specific key version that is used for enabling disk encryption.
    :type key_version: str
    :param encryption_algorithm: Algorithm identifier for encryption, default RSA-OAEP. Possible
     values include: "RSA-OAEP", "RSA-OAEP-256", "RSA1_5".
    :type encryption_algorithm: str or ~azure.mgmt.hdinsight.models.JsonWebKeyEncryptionAlgorithm
    :param msi_resource_id: Resource ID of Managed Identity that is used to access the key vault.
    :type msi_resource_id: str
    :param encryption_at_host: Indicates whether or not resource disk encryption is enabled.
    :type encryption_at_host: bool
    """

    _attribute_map = {
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
        'msi_resource_id': {'key': 'msiResourceId', 'type': 'str'},
        'encryption_at_host': {'key': 'encryptionAtHost', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskEncryptionProperties, self).__init__(**kwargs)
        self.vault_uri = kwargs.get('vault_uri', None)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)
        self.encryption_algorithm = kwargs.get('encryption_algorithm', None)
        self.msi_resource_id = kwargs.get('msi_resource_id', None)
        self.encryption_at_host = kwargs.get('encryption_at_host', False)


class EncryptionInTransitProperties(msrest.serialization.Model):
    """The encryption-in-transit properties.

    :param is_encryption_in_transit_enabled: Indicates whether or not inter cluster node
     communication is encrypted in transit.
    :type is_encryption_in_transit_enabled: bool
    """

    _attribute_map = {
        'is_encryption_in_transit_enabled': {'key': 'isEncryptionInTransitEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionInTransitProperties, self).__init__(**kwargs)
        self.is_encryption_in_transit_enabled = kwargs.get('is_encryption_in_transit_enabled', False)


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Errors(msrest.serialization.Model):
    """The error message associated with the cluster creation.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Errors, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ExcludedServicesConfig(msrest.serialization.Model):
    """The configuration that services will be excluded when creating cluster.

    :param excluded_services_config_id: The config id of excluded services.
    :type excluded_services_config_id: str
    :param excluded_services_list: The list of excluded services.
    :type excluded_services_list: str
    """

    _attribute_map = {
        'excluded_services_config_id': {'key': 'excludedServicesConfigId', 'type': 'str'},
        'excluded_services_list': {'key': 'excludedServicesList', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExcludedServicesConfig, self).__init__(**kwargs)
        self.excluded_services_config_id = kwargs.get('excluded_services_config_id', None)
        self.excluded_services_list = kwargs.get('excluded_services_list', None)


class ExecuteScriptActionParameters(msrest.serialization.Model):
    """The parameters for the script actions to execute on a running cluster.

    All required parameters must be populated in order to send to Azure.

    :param script_actions: The list of run time script actions.
    :type script_actions: list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :param persist_on_success: Required. Gets or sets if the scripts needs to be persisted.
    :type persist_on_success: bool
    """

    _validation = {
        'persist_on_success': {'required': True},
    }

    _attribute_map = {
        'script_actions': {'key': 'scriptActions', 'type': '[RuntimeScriptAction]'},
        'persist_on_success': {'key': 'persistOnSuccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExecuteScriptActionParameters, self).__init__(**kwargs)
        self.script_actions = kwargs.get('script_actions', None)
        self.persist_on_success = kwargs['persist_on_success']


class Extension(msrest.serialization.Model):
    """Cluster monitoring extensions.

    :param workspace_id: The workspace ID for the cluster monitoring extension.
    :type workspace_id: str
    :param primary_key: The certificate for the cluster monitoring extensions.
    :type primary_key: str
    """

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Extension, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.primary_key = kwargs.get('primary_key', None)


class GatewaySettings(msrest.serialization.Model):
    """Gateway settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_credential_enabled: Indicates whether or not the gateway settings based authorization
     is enabled.
    :vartype is_credential_enabled: str
    :ivar user_name: The gateway settings user name.
    :vartype user_name: str
    :ivar password: The gateway settings user password.
    :vartype password: str
    """

    _validation = {
        'is_credential_enabled': {'readonly': True},
        'user_name': {'readonly': True},
        'password': {'readonly': True},
    }

    _attribute_map = {
        'is_credential_enabled': {'key': 'restAuthCredential\\.isEnabled', 'type': 'str'},
        'user_name': {'key': 'restAuthCredential\\.username', 'type': 'str'},
        'password': {'key': 'restAuthCredential\\.password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewaySettings, self).__init__(**kwargs)
        self.is_credential_enabled = None
        self.user_name = None
        self.password = None


class HardwareProfile(msrest.serialization.Model):
    """The hardware profile.

    :param vm_size: The size of the VM.
    :type vm_size: str
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareProfile, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)


class HostInfo(msrest.serialization.Model):
    """The cluster host information.

    :param name: The host name.
    :type name: str
    :param fqdn: The Fully Qualified Domain Name of host.
    :type fqdn: str
    :param effective_disk_encryption_key_url: The effective disk encryption key URL used by the
     host.
    :type effective_disk_encryption_key_url: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'effective_disk_encryption_key_url': {'key': 'effectiveDiskEncryptionKeyUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.effective_disk_encryption_key_url = kwargs.get('effective_disk_encryption_key_url', None)


class KafkaRestProperties(msrest.serialization.Model):
    """The kafka rest proxy configuration which contains AAD security group information.

    :param client_group_info: The information of AAD security group.
    :type client_group_info: ~azure.mgmt.hdinsight.models.ClientGroupInfo
    :param configuration_override: The configurations that need to be overriden.
    :type configuration_override: dict[str, str]
    """

    _attribute_map = {
        'client_group_info': {'key': 'clientGroupInfo', 'type': 'ClientGroupInfo'},
        'configuration_override': {'key': 'configurationOverride', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KafkaRestProperties, self).__init__(**kwargs)
        self.client_group_info = kwargs.get('client_group_info', None)
        self.configuration_override = kwargs.get('configuration_override', None)


class LinuxOperatingSystemProfile(msrest.serialization.Model):
    """The ssh username, password, and ssh public key.

    :param username: The username.
    :type username: str
    :param password: The password.
    :type password: str
    :param ssh_profile: The SSH profile.
    :type ssh_profile: ~azure.mgmt.hdinsight.models.SshProfile
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'ssh_profile': {'key': 'sshProfile', 'type': 'SshProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinuxOperatingSystemProfile, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.ssh_profile = kwargs.get('ssh_profile', None)


class LocalizedName(msrest.serialization.Model):
    """The details about the localizable name of a type of usage.

    :param value: The name of the used resource.
    :type value: str
    :param localized_value: The localized name of the used resource.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalizedName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class MetricSpecifications(msrest.serialization.Model):
    """The details of metric specifications.

    :param name: The name of the metric specification.
    :type name: str
    :param display_name: The display name of the metric specification.
    :type display_name: str
    :param display_description: The display description of the metric specification.
    :type display_description: str
    :param unit: The unit of the metric specification.
    :type unit: str
    :param aggregation_type: The aggregation type of the metric specification.
    :type aggregation_type: str
    :param supported_aggregation_types: The supported aggregation types of the metric
     specification.
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: The supported time grain types of the metric specification.
    :type supported_time_grain_types: list[str]
    :param enable_regional_mdm_account: The flag indicates whether enable regional mdm account or
     not.
    :type enable_regional_mdm_account: bool
    :param source_mdm_account: The source mdm account.
    :type source_mdm_account: str
    :param source_mdm_namespace: The source mdm namespace.
    :type source_mdm_namespace: str
    :param metric_filter_pattern: The metric filter pattern.
    :type metric_filter_pattern: str
    :param fill_gap_with_zero: The flag indicates whether filling gap with zero.
    :type fill_gap_with_zero: bool
    :param category: The category of the metric.
    :type category: str
    :param resource_id_dimension_name_override: The override name of resource id dimension name.
    :type resource_id_dimension_name_override: str
    :param is_internal: The flag indicates whether the metric is internal or not.
    :type is_internal: bool
    :param delegate_metric_name_override: The override name of delegate metric.
    :type delegate_metric_name_override: str
    :param dimensions: The dimensions of the metric specification.
    :type dimensions: list[~azure.mgmt.hdinsight.models.Dimension]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'delegate_metric_name_override': {'key': 'delegateMetricNameOverride', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecifications, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.enable_regional_mdm_account = kwargs.get('enable_regional_mdm_account', None)
        self.source_mdm_account = kwargs.get('source_mdm_account', None)
        self.source_mdm_namespace = kwargs.get('source_mdm_namespace', None)
        self.metric_filter_pattern = kwargs.get('metric_filter_pattern', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.category = kwargs.get('category', None)
        self.resource_id_dimension_name_override = kwargs.get('resource_id_dimension_name_override', None)
        self.is_internal = kwargs.get('is_internal', None)
        self.delegate_metric_name_override = kwargs.get('delegate_metric_name_override', None)
        self.dimensions = kwargs.get('dimensions', None)


class NameAvailabilityCheckRequestParameters(msrest.serialization.Model):
    """The request spec of checking name availability.

    :param name: The resource name.
    :type name: str
    :param type: The resource type.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityCheckRequestParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class NameAvailabilityCheckResult(msrest.serialization.Model):
    """The response spec of checking name availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name_available: This indicates whether the name is available.
    :type name_available: bool
    :ivar reason: The reason of the result.
    :vartype reason: str
    :ivar message: The related message.
    :vartype message: str
    """

    _validation = {
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityCheckResult, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = None
        self.message = None


class NetworkProperties(msrest.serialization.Model):
    """The network properties.

    :param resource_provider_connection: The direction for the resource provider connection.
     Possible values include: "Inbound", "Outbound".
    :type resource_provider_connection: str or
     ~azure.mgmt.hdinsight.models.ResourceProviderConnection
    :param private_link: Indicates whether or not private link is enabled. Possible values include:
     "Disabled", "Enabled".
    :type private_link: str or ~azure.mgmt.hdinsight.models.PrivateLink
    """

    _attribute_map = {
        'resource_provider_connection': {'key': 'resourceProviderConnection', 'type': 'str'},
        'private_link': {'key': 'privateLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProperties, self).__init__(**kwargs)
        self.resource_provider_connection = kwargs.get('resource_provider_connection', None)
        self.private_link = kwargs.get('private_link', None)


class Operation(msrest.serialization.Model):
    """The HDInsight REST API operation.

    :param name: The operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.hdinsight.models.OperationDisplay
    :param properties: The operation properties.
    :type properties: ~azure.mgmt.hdinsight.models.OperationProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.properties = kwargs.get('properties', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :param provider: The service provider: Microsoft.HDInsight.
    :type provider: str
    :param resource: The resource on which the operation is performed: Cluster, Applications, etc.
    :type resource: str
    :param operation: The operation type: read, write, delete, etc.
    :type operation: str
    :param description: Localized friendly description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list HDInsight operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: The list of HDInsight operations supported by the HDInsight resource provider.
    :type value: list[~azure.mgmt.hdinsight.models.Operation]
    :param next_link: The URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationProperties(msrest.serialization.Model):
    """The details of operation.

    :param service_specification: The specification of the service.
    :type service_specification: ~azure.mgmt.hdinsight.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class OsProfile(msrest.serialization.Model):
    """The Linux operation systems profile.

    :param linux_operating_system_profile: The Linux OS profile.
    :type linux_operating_system_profile: ~azure.mgmt.hdinsight.models.LinuxOperatingSystemProfile
    """

    _attribute_map = {
        'linux_operating_system_profile': {'key': 'linuxOperatingSystemProfile', 'type': 'LinuxOperatingSystemProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OsProfile, self).__init__(**kwargs)
        self.linux_operating_system_profile = kwargs.get('linux_operating_system_profile', None)


class QuotaCapability(msrest.serialization.Model):
    """The regional quota capability.

    :param cores_used: The number of cores used in the subscription.
    :type cores_used: long
    :param max_cores_allowed: The number of cores that the subscription allowed.
    :type max_cores_allowed: long
    :param regional_quotas: The list of region quota capabilities.
    :type regional_quotas: list[~azure.mgmt.hdinsight.models.RegionalQuotaCapability]
    """

    _attribute_map = {
        'cores_used': {'key': 'cores_used', 'type': 'long'},
        'max_cores_allowed': {'key': 'max_cores_allowed', 'type': 'long'},
        'regional_quotas': {'key': 'regionalQuotas', 'type': '[RegionalQuotaCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaCapability, self).__init__(**kwargs)
        self.cores_used = kwargs.get('cores_used', None)
        self.max_cores_allowed = kwargs.get('max_cores_allowed', None)
        self.regional_quotas = kwargs.get('regional_quotas', None)


class QuotaInfo(msrest.serialization.Model):
    """The quota properties for the cluster.

    :param cores_used: The cores used by the cluster.
    :type cores_used: int
    """

    _attribute_map = {
        'cores_used': {'key': 'coresUsed', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaInfo, self).__init__(**kwargs)
        self.cores_used = kwargs.get('cores_used', None)


class RegionalQuotaCapability(msrest.serialization.Model):
    """The regional quota capacity.

    :param region_name: The region name.
    :type region_name: str
    :param cores_used: The number of cores used in the region.
    :type cores_used: long
    :param cores_available: The number of cores available in the region.
    :type cores_available: long
    """

    _attribute_map = {
        'region_name': {'key': 'region_name', 'type': 'str'},
        'cores_used': {'key': 'cores_used', 'type': 'long'},
        'cores_available': {'key': 'cores_available', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionalQuotaCapability, self).__init__(**kwargs)
        self.region_name = kwargs.get('region_name', None)
        self.cores_used = kwargs.get('cores_used', None)
        self.cores_available = kwargs.get('cores_available', None)


class RegionsCapability(msrest.serialization.Model):
    """The regions capability.

    :param available: The list of region capabilities.
    :type available: list[str]
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionsCapability, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)


class Role(msrest.serialization.Model):
    """Describes a role on the cluster.

    :param name: The name of the role.
    :type name: str
    :param min_instance_count: The minimum instance count of the cluster.
    :type min_instance_count: int
    :param target_instance_count: The instance count of the cluster.
    :type target_instance_count: int
    :param vm_group_name: The name of the virtual machine group.
    :type vm_group_name: str
    :param autoscale_configuration: The autoscale configurations.
    :type autoscale_configuration: ~azure.mgmt.hdinsight.models.Autoscale
    :param hardware_profile: The hardware profile.
    :type hardware_profile: ~azure.mgmt.hdinsight.models.HardwareProfile
    :param os_profile: The operating system profile.
    :type os_profile: ~azure.mgmt.hdinsight.models.OsProfile
    :param virtual_network_profile: The virtual network profile.
    :type virtual_network_profile: ~azure.mgmt.hdinsight.models.VirtualNetworkProfile
    :param data_disks_groups: The data disks groups for the role.
    :type data_disks_groups: list[~azure.mgmt.hdinsight.models.DataDisksGroups]
    :param script_actions: The list of script actions on the role.
    :type script_actions: list[~azure.mgmt.hdinsight.models.ScriptAction]
    :param encrypt_data_disks: Indicates whether encrypt the data disks.
    :type encrypt_data_disks: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'target_instance_count': {'key': 'targetInstanceCount', 'type': 'int'},
        'vm_group_name': {'key': 'VMGroupName', 'type': 'str'},
        'autoscale_configuration': {'key': 'autoscale', 'type': 'Autoscale'},
        'hardware_profile': {'key': 'hardwareProfile', 'type': 'HardwareProfile'},
        'os_profile': {'key': 'osProfile', 'type': 'OsProfile'},
        'virtual_network_profile': {'key': 'virtualNetworkProfile', 'type': 'VirtualNetworkProfile'},
        'data_disks_groups': {'key': 'dataDisksGroups', 'type': '[DataDisksGroups]'},
        'script_actions': {'key': 'scriptActions', 'type': '[ScriptAction]'},
        'encrypt_data_disks': {'key': 'encryptDataDisks', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Role, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.min_instance_count = kwargs.get('min_instance_count', None)
        self.target_instance_count = kwargs.get('target_instance_count', None)
        self.vm_group_name = kwargs.get('vm_group_name', None)
        self.autoscale_configuration = kwargs.get('autoscale_configuration', None)
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.virtual_network_profile = kwargs.get('virtual_network_profile', None)
        self.data_disks_groups = kwargs.get('data_disks_groups', None)
        self.script_actions = kwargs.get('script_actions', None)
        self.encrypt_data_disks = kwargs.get('encrypt_data_disks', False)


class RuntimeScriptAction(msrest.serialization.Model):
    """Describes a script action on a running cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the script action.
    :type name: str
    :param uri: Required. The URI to the script.
    :type uri: str
    :param parameters: The parameters for the script.
    :type parameters: str
    :param roles: Required. The list of roles where script will be executed.
    :type roles: list[str]
    :ivar application_name: The application name of the script action, if any.
    :vartype application_name: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'roles': {'required': True},
        'application_name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
        'application_name': {'key': 'applicationName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuntimeScriptAction, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.uri = kwargs['uri']
        self.parameters = kwargs.get('parameters', None)
        self.roles = kwargs['roles']
        self.application_name = None


class RuntimeScriptActionDetail(RuntimeScriptAction):
    """The execution details of a script action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the script action.
    :type name: str
    :param uri: Required. The URI to the script.
    :type uri: str
    :param parameters: The parameters for the script.
    :type parameters: str
    :param roles: Required. The list of roles where script will be executed.
    :type roles: list[str]
    :ivar application_name: The application name of the script action, if any.
    :vartype application_name: str
    :ivar script_execution_id: The execution id of the script action.
    :vartype script_execution_id: long
    :ivar start_time: The start time of script action execution.
    :vartype start_time: str
    :ivar end_time: The end time of script action execution.
    :vartype end_time: str
    :ivar status: The current execution status of the script action.
    :vartype status: str
    :ivar operation: The reason why the script action was executed.
    :vartype operation: str
    :ivar execution_summary: The summary of script action execution result.
    :vartype execution_summary: list[~azure.mgmt.hdinsight.models.ScriptActionExecutionSummary]
    :ivar debug_information: The script action execution debug information.
    :vartype debug_information: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'roles': {'required': True},
        'application_name': {'readonly': True},
        'script_execution_id': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'status': {'readonly': True},
        'operation': {'readonly': True},
        'execution_summary': {'readonly': True},
        'debug_information': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
        'application_name': {'key': 'applicationName', 'type': 'str'},
        'script_execution_id': {'key': 'scriptExecutionId', 'type': 'long'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'execution_summary': {'key': 'executionSummary', 'type': '[ScriptActionExecutionSummary]'},
        'debug_information': {'key': 'debugInformation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuntimeScriptActionDetail, self).__init__(**kwargs)
        self.script_execution_id = None
        self.start_time = None
        self.end_time = None
        self.status = None
        self.operation = None
        self.execution_summary = None
        self.debug_information = None


class ScriptAction(msrest.serialization.Model):
    """Describes a script action on role on the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the script action.
    :type name: str
    :param uri: Required. The URI to the script.
    :type uri: str
    :param parameters: Required. The parameters for the script provided.
    :type parameters: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptAction, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.uri = kwargs['uri']
        self.parameters = kwargs['parameters']


class ScriptActionExecutionHistoryList(msrest.serialization.Model):
    """The list script execution history response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of persisted script action details for the cluster.
    :vartype value: list[~azure.mgmt.hdinsight.models.RuntimeScriptActionDetail]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuntimeScriptActionDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptActionExecutionHistoryList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ScriptActionExecutionSummary(msrest.serialization.Model):
    """The execution summary of a script action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of script action execution.
    :vartype status: str
    :ivar instance_count: The instance count for a given script action execution status.
    :vartype instance_count: int
    """

    _validation = {
        'status': {'readonly': True},
        'instance_count': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptActionExecutionSummary, self).__init__(**kwargs)
        self.status = None
        self.instance_count = None


class ScriptActionPersistedGetResponseSpec(msrest.serialization.Model):
    """The persisted script action for cluster.

    :param name: The name of script action.
    :type name: str
    :param uri: The URI to the script.
    :type uri: str
    :param parameters: The parameters for the script provided.
    :type parameters: str
    :param roles: The list of roles where script will be executed.
    :type roles: list[str]
    :param application_name: The application name for the script action.
    :type application_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
        'application_name': {'key': 'applicationName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptActionPersistedGetResponseSpec, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.uri = kwargs.get('uri', None)
        self.parameters = kwargs.get('parameters', None)
        self.roles = kwargs.get('roles', None)
        self.application_name = kwargs.get('application_name', None)


class ScriptActionsList(msrest.serialization.Model):
    """The persisted script action for the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of persisted script action details for the cluster.
    :type value: list[~azure.mgmt.hdinsight.models.RuntimeScriptActionDetail]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuntimeScriptActionDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScriptActionsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class SecurityProfile(msrest.serialization.Model):
    """The security profile which contains Ssh public key for the HDInsight cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar directory_type: The directory type. Default value: "ActiveDirectory".
    :vartype directory_type: str
    :param domain: The organization's active directory domain.
    :type domain: str
    :param organizational_unit_dn: The organizational unit within the Active Directory to place the
     cluster and service accounts.
    :type organizational_unit_dn: str
    :param ldaps_urls: The LDAPS protocol URLs to communicate with the Active Directory.
    :type ldaps_urls: list[str]
    :param domain_username: The domain user account that will have admin privileges on the cluster.
    :type domain_username: str
    :param domain_user_password: The domain admin password.
    :type domain_user_password: str
    :param cluster_users_group_d_ns: Optional. The Distinguished Names for cluster user groups.
    :type cluster_users_group_d_ns: list[str]
    :param aadds_resource_id: The resource ID of the user's Azure Active Directory Domain Service.
    :type aadds_resource_id: str
    :param msi_resource_id: User assigned identity that has permissions to read and create
     cluster-related artifacts in the user's AADDS.
    :type msi_resource_id: str
    """

    _validation = {
        'directory_type': {'constant': True},
    }

    _attribute_map = {
        'directory_type': {'key': 'directoryType', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'organizational_unit_dn': {'key': 'organizationalUnitDN', 'type': 'str'},
        'ldaps_urls': {'key': 'ldapsUrls', 'type': '[str]'},
        'domain_username': {'key': 'domainUsername', 'type': 'str'},
        'domain_user_password': {'key': 'domainUserPassword', 'type': 'str'},
        'cluster_users_group_d_ns': {'key': 'clusterUsersGroupDNs', 'type': '[str]'},
        'aadds_resource_id': {'key': 'aaddsResourceId', 'type': 'str'},
        'msi_resource_id': {'key': 'msiResourceId', 'type': 'str'},
    }

    directory_type = "ActiveDirectory"

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityProfile, self).__init__(**kwargs)
        self.domain = kwargs.get('domain', None)
        self.organizational_unit_dn = kwargs.get('organizational_unit_dn', None)
        self.ldaps_urls = kwargs.get('ldaps_urls', None)
        self.domain_username = kwargs.get('domain_username', None)
        self.domain_user_password = kwargs.get('domain_user_password', None)
        self.cluster_users_group_d_ns = kwargs.get('cluster_users_group_d_ns', None)
        self.aadds_resource_id = kwargs.get('aadds_resource_id', None)
        self.msi_resource_id = kwargs.get('msi_resource_id', None)


class ServiceSpecification(msrest.serialization.Model):
    """The specification of the service.

    :param metric_specifications: The metric specifications.
    :type metric_specifications: list[~azure.mgmt.hdinsight.models.MetricSpecifications]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecifications]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class SshProfile(msrest.serialization.Model):
    """The list of SSH public keys.

    :param public_keys: The list of SSH public keys.
    :type public_keys: list[~azure.mgmt.hdinsight.models.SshPublicKey]
    """

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[SshPublicKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshProfile, self).__init__(**kwargs)
        self.public_keys = kwargs.get('public_keys', None)


class SshPublicKey(msrest.serialization.Model):
    """The SSH public key for the cluster nodes.

    :param certificate_data: The certificate for SSH.
    :type certificate_data: str
    """

    _attribute_map = {
        'certificate_data': {'key': 'certificateData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SshPublicKey, self).__init__(**kwargs)
        self.certificate_data = kwargs.get('certificate_data', None)


class StorageAccount(msrest.serialization.Model):
    """The storage Account.

    :param name: The name of the storage account.
    :type name: str
    :param is_default: Whether or not the storage account is the default storage account.
    :type is_default: bool
    :param container: The container in the storage account, only to be specified for WASB storage
     accounts.
    :type container: str
    :param file_system: The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
    :type file_system: str
    :param key: The storage account access key.
    :type key: str
    :param resource_id: The resource ID of storage account, only to be specified for Azure Data
     Lake Storage Gen 2.
    :type resource_id: str
    :param msi_resource_id: The managed identity (MSI) that is allowed to access the storage
     account, only to be specified for Azure Data Lake Storage Gen 2.
    :type msi_resource_id: str
    :param saskey: The shared access signature key.
    :type saskey: str
    :param fileshare: The file share name.
    :type fileshare: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'container': {'key': 'container', 'type': 'str'},
        'file_system': {'key': 'fileSystem', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'msi_resource_id': {'key': 'msiResourceId', 'type': 'str'},
        'saskey': {'key': 'saskey', 'type': 'str'},
        'fileshare': {'key': 'fileshare', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccount, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_default = kwargs.get('is_default', None)
        self.container = kwargs.get('container', None)
        self.file_system = kwargs.get('file_system', None)
        self.key = kwargs.get('key', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.msi_resource_id = kwargs.get('msi_resource_id', None)
        self.saskey = kwargs.get('saskey', None)
        self.fileshare = kwargs.get('fileshare', None)


class StorageProfile(msrest.serialization.Model):
    """The storage profile.

    :param storageaccounts: The list of storage accounts in the cluster.
    :type storageaccounts: list[~azure.mgmt.hdinsight.models.StorageAccount]
    """

    _attribute_map = {
        'storageaccounts': {'key': 'storageaccounts', 'type': '[StorageAccount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.storageaccounts = kwargs.get('storageaccounts', None)


class UpdateClusterIdentityCertificateParameters(msrest.serialization.Model):
    """The update cluster identity certificate request parameters.

    :param application_id: The application id.
    :type application_id: str
    :param certificate: The certificate in base64 encoded format.
    :type certificate: str
    :param certificate_password: The password of the certificate.
    :type certificate_password: str
    """

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
        'certificate_password': {'key': 'certificatePassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateClusterIdentityCertificateParameters, self).__init__(**kwargs)
        self.application_id = kwargs.get('application_id', None)
        self.certificate = kwargs.get('certificate', None)
        self.certificate_password = kwargs.get('certificate_password', None)


class UpdateGatewaySettingsParameters(msrest.serialization.Model):
    """The update gateway settings request parameters.

    :param is_credential_enabled: Indicates whether or not the gateway settings based authorization
     is enabled.
    :type is_credential_enabled: bool
    :param user_name: The gateway settings user name.
    :type user_name: str
    :param password: The gateway settings user password.
    :type password: str
    """

    _attribute_map = {
        'is_credential_enabled': {'key': 'restAuthCredential\\.isEnabled', 'type': 'bool'},
        'user_name': {'key': 'restAuthCredential\\.username', 'type': 'str'},
        'password': {'key': 'restAuthCredential\\.password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateGatewaySettingsParameters, self).__init__(**kwargs)
        self.is_credential_enabled = kwargs.get('is_credential_enabled', True)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)


class Usage(msrest.serialization.Model):
    """The details about the usage of a particular limited resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param unit: The type of measurement for usage.
    :type unit: str
    :param current_value: The current usage.
    :type current_value: long
    :param limit: The maximum allowed usage.
    :type limit: long
    :ivar name: The details about the localizable name of the used resource.
    :vartype name: ~azure.mgmt.hdinsight.models.LocalizedName
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'LocalizedName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = None


class UsagesListResult(msrest.serialization.Model):
    """The response for the operation to get regional usages for a subscription.

    :param value: The list of usages.
    :type value: list[~azure.mgmt.hdinsight.models.Usage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ValidationErrorInfo(msrest.serialization.Model):
    """The validation error information.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    :param error_resource: The error resource.
    :type error_resource: str
    :param message_arguments: The message arguments.
    :type message_arguments: list[str]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'error_resource': {'key': 'errorResource', 'type': 'str'},
        'message_arguments': {'key': 'messageArguments', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationErrorInfo, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.error_resource = kwargs.get('error_resource', None)
        self.message_arguments = kwargs.get('message_arguments', None)


class VersionsCapability(msrest.serialization.Model):
    """The version capability.

    :param available: The list of version capabilities.
    :type available: list[~azure.mgmt.hdinsight.models.VersionSpec]
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': '[VersionSpec]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VersionsCapability, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)


class VersionSpec(msrest.serialization.Model):
    """The version properties.

    :param friendly_name: The friendly name.
    :type friendly_name: str
    :param display_name: The display name.
    :type display_name: str
    :param is_default: Whether or not the version is the default version.
    :type is_default: bool
    :param component_versions: The component version property.
    :type component_versions: dict[str, str]
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'component_versions': {'key': 'componentVersions', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VersionSpec, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.is_default = kwargs.get('is_default', None)
        self.component_versions = kwargs.get('component_versions', None)


class VirtualNetworkProfile(msrest.serialization.Model):
    """The virtual network properties.

    :param id: The ID of the virtual network.
    :type id: str
    :param subnet: The name of the subnet.
    :type subnet: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.subnet = kwargs.get('subnet', None)


class VmSizeCompatibilityFilter(msrest.serialization.Model):
    """The virtual machine type compatibility filter.

    :param filter_mode: The mode for the filter.
    :type filter_mode: str
    :param regions: The list of regions.
    :type regions: list[str]
    :param cluster_flavors: The list of cluster types available.
    :type cluster_flavors: list[str]
    :param node_types: The list of node types.
    :type node_types: list[str]
    :param cluster_versions: The list of cluster versions.
    :type cluster_versions: list[str]
    :param os_type: The list of OS types.
    :type os_type: list[str]
    :param vm_sizes: The list of virtual machine sizes.
    :type vm_sizes: list[str]
    :param esp_applied: Whether apply for ESP cluster. 'true' means only for ESP, 'false' means
     only for non-ESP, null or empty string or others mean for both.
    :type esp_applied: str
    :param compute_isolation_supported: Whether support compute isolation. 'true' means only for
     ComputeIsolationEnabled, 'false' means only for regular cluster.
    :type compute_isolation_supported: str
    """

    _attribute_map = {
        'filter_mode': {'key': 'FilterMode', 'type': 'str'},
        'regions': {'key': 'Regions', 'type': '[str]'},
        'cluster_flavors': {'key': 'ClusterFlavors', 'type': '[str]'},
        'node_types': {'key': 'NodeTypes', 'type': '[str]'},
        'cluster_versions': {'key': 'ClusterVersions', 'type': '[str]'},
        'os_type': {'key': 'OsType', 'type': '[str]'},
        'vm_sizes': {'key': 'VMSizes', 'type': '[str]'},
        'esp_applied': {'key': 'ESPApplied', 'type': 'str'},
        'compute_isolation_supported': {'key': 'ComputeIsolationSupported', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmSizeCompatibilityFilter, self).__init__(**kwargs)
        self.filter_mode = kwargs.get('filter_mode', None)
        self.regions = kwargs.get('regions', None)
        self.cluster_flavors = kwargs.get('cluster_flavors', None)
        self.node_types = kwargs.get('node_types', None)
        self.cluster_versions = kwargs.get('cluster_versions', None)
        self.os_type = kwargs.get('os_type', None)
        self.vm_sizes = kwargs.get('vm_sizes', None)
        self.esp_applied = kwargs.get('esp_applied', None)
        self.compute_isolation_supported = kwargs.get('compute_isolation_supported', None)


class VmSizeCompatibilityFilterV2(msrest.serialization.Model):
    """This class represent a single filter object that defines a multidimensional set. The dimensions of this set are Regions, ClusterFlavors, NodeTypes and ClusterVersions. The constraint should be defined based on the following: FilterMode (Exclude vs Include), VMSizes (the vm sizes in affect of exclusion/inclusion) and the ordering of the Filters. Later filters override previous settings if conflicted.

    :param filter_mode: The filtering mode. Effectively this can enabling or disabling the VM sizes
     in a particular set. Possible values include: "Exclude", "Include", "Recommend", "Default".
    :type filter_mode: str or ~azure.mgmt.hdinsight.models.FilterMode
    :param regions: The list of regions under the effect of the filter.
    :type regions: list[str]
    :param cluster_flavors: The list of cluster flavors under the effect of the filter.
    :type cluster_flavors: list[str]
    :param node_types: The list of node types affected by the filter.
    :type node_types: list[str]
    :param cluster_versions: The list of cluster versions affected in Major.Minor format.
    :type cluster_versions: list[str]
    :param os_type: The OSType affected, Windows or Linux.
    :type os_type: list[str or ~azure.mgmt.hdinsight.models.OSType]
    :param vm_sizes: The list of virtual machine sizes to include or exclude.
    :type vm_sizes: list[str]
    """

    _attribute_map = {
        'filter_mode': {'key': 'filterMode', 'type': 'str'},
        'regions': {'key': 'regions', 'type': '[str]'},
        'cluster_flavors': {'key': 'clusterFlavors', 'type': '[str]'},
        'node_types': {'key': 'nodeTypes', 'type': '[str]'},
        'cluster_versions': {'key': 'clusterVersions', 'type': '[str]'},
        'os_type': {'key': 'osType', 'type': '[str]'},
        'vm_sizes': {'key': 'vmSizes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmSizeCompatibilityFilterV2, self).__init__(**kwargs)
        self.filter_mode = kwargs.get('filter_mode', None)
        self.regions = kwargs.get('regions', None)
        self.cluster_flavors = kwargs.get('cluster_flavors', None)
        self.node_types = kwargs.get('node_types', None)
        self.cluster_versions = kwargs.get('cluster_versions', None)
        self.os_type = kwargs.get('os_type', None)
        self.vm_sizes = kwargs.get('vm_sizes', None)


class VmSizeProperty(msrest.serialization.Model):
    """The vm size property.

    :param name: The vm size name.
    :type name: str
    :param cores: The number of cores that the vm size has.
    :type cores: int
    :param data_disk_storage_tier: The data disk storage tier of the vm size.
    :type data_disk_storage_tier: str
    :param label: The label of the vm size.
    :type label: str
    :param max_data_disk_count: The max data disk count of the vm size.
    :type max_data_disk_count: long
    :param memory_in_mb: The memory whose unit is MB of the vm size.
    :type memory_in_mb: long
    :param supported_by_virtual_machines: This indicates this vm size is supported by virtual
     machines or not.
    :type supported_by_virtual_machines: bool
    :param supported_by_web_worker_roles: The indicates this vm size is supported by web worker
     roles or not.
    :type supported_by_web_worker_roles: bool
    :param virtual_machine_resource_disk_size_in_mb: The virtual machine resource disk size whose
     unit is MB of the vm size.
    :type virtual_machine_resource_disk_size_in_mb: long
    :param web_worker_resource_disk_size_in_mb: The web worker resource disk size whose unit is MB
     of the vm size.
    :type web_worker_resource_disk_size_in_mb: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'cores': {'key': 'cores', 'type': 'int'},
        'data_disk_storage_tier': {'key': 'dataDiskStorageTier', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'max_data_disk_count': {'key': 'maxDataDiskCount', 'type': 'long'},
        'memory_in_mb': {'key': 'memoryInMb', 'type': 'long'},
        'supported_by_virtual_machines': {'key': 'supportedByVirtualMachines', 'type': 'bool'},
        'supported_by_web_worker_roles': {'key': 'supportedByWebWorkerRoles', 'type': 'bool'},
        'virtual_machine_resource_disk_size_in_mb': {'key': 'virtualMachineResourceDiskSizeInMb', 'type': 'long'},
        'web_worker_resource_disk_size_in_mb': {'key': 'webWorkerResourceDiskSizeInMb', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmSizeProperty, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.cores = kwargs.get('cores', None)
        self.data_disk_storage_tier = kwargs.get('data_disk_storage_tier', None)
        self.label = kwargs.get('label', None)
        self.max_data_disk_count = kwargs.get('max_data_disk_count', None)
        self.memory_in_mb = kwargs.get('memory_in_mb', None)
        self.supported_by_virtual_machines = kwargs.get('supported_by_virtual_machines', None)
        self.supported_by_web_worker_roles = kwargs.get('supported_by_web_worker_roles', None)
        self.virtual_machine_resource_disk_size_in_mb = kwargs.get('virtual_machine_resource_disk_size_in_mb', None)
        self.web_worker_resource_disk_size_in_mb = kwargs.get('web_worker_resource_disk_size_in_mb', None)


class VmSizesCapability(msrest.serialization.Model):
    """The virtual machine sizes capability.

    :param available: The list of virtual machine size capabilities.
    :type available: list[str]
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmSizesCapability, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)
