from starkware.crypto.signature.signature import FIELD_PRIME
from starkware.storage.storage import HASH_BYTES

STARKNET_LANG_DIRECTIVE = "starknet"

FIELD_SIZE = FIELD_PRIME
FIELD_SIZE_BITS = 251
ADDRESS_BITS = FIELD_SIZE_BITS
CONTRACT_ADDRESS_BITS = ADDRESS_BITS

FELT_LOWER_BOUND = 0
FELT_UPPER_BOUND = FIELD_SIZE
BLOCK_HASH_LOWER_BOUND = 0
BLOCK_HASH_UPPER_BOUND = FIELD_SIZE
# Address 0 is reserved to distinguish an external transaction from an inner (L2<>L2) one.
CONTRACT_ADDRESS_LOWER_BOUND = 1
CONTRACT_ADDRESS_UPPER_BOUND = 2 ** CONTRACT_ADDRESS_BITS
CONTRACT_ADDRESS_SALT_LOWER_BOUND = FELT_LOWER_BOUND
CONTRACT_ADDRESS_SALT_UPPER_BOUND = FELT_UPPER_BOUND
CONTRACT_HASH_BYTES = HASH_BYTES
CONTRACT_HASH_UPPER_BOUND = FIELD_SIZE
CONTRACT_STATES_COMMITMENT_TREE_HEIGHT = FIELD_SIZE_BITS
ENTRY_POINT_OFFSET_LOWER_BOUND = 0
ENTRY_POINT_OFFSET_UPPER_BOUND = FIELD_SIZE
ENTRY_POINT_SELECTOR_LOWER_BOUND = 0
ENTRY_POINT_SELECTOR_UPPER_BOUND = FIELD_SIZE
# Default hash to fill the parent_hash field of the first block in the sequence.
GENESIS_PARENT_BLOCK_HASH = 0
MAX_MESSAGE_TO_L1_LENGTH = 100
MAX_CALLDATA_LENGTH = 2 ** 30
SYSCALL_SELECTOR_UPPER_BOUND = FIELD_SIZE
TRANSACTION_COMMITMENT_TREE_HEIGHT = 64
TRANSACTION_HASH_LOWER_BOUND = 0
TRANSACTION_HASH_UPPER_BOUND = FIELD_SIZE
ADDRESS_LOWER_BOUND = 0
ADDRESS_UPPER_BOUND = 2 ** ADDRESS_BITS
