r"""

Beamline optics
---------------

The images below are produced by the scripts in
`\\examples\\withRaycing\\02_Balder_BL\\`.
The examples show the scans of various optical elements at Balder@MaxIV
beamline. The source is a multipole conventional wiggler.

Diamond filter of varying thickness
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Shown are i) intensity downstream of the filter and its energy spectrum ii)
absorbed power in the filter with its energy spectrum and power density
isolines at 85% and 95% of the maximum.

.. image:: _images/filterThicknessI.swf
   :width: 300
   :height: 205
.. image:: _images/zoomIcon.png
   :width: 20
   :target: _images/filterThicknessI.swf
.. image:: _images/filterThicknessP.swf
   :width: 300
   :height: 205
.. image:: _images/zoomIcon.png
   :width: 20
   :target: _images/filterThicknessP.swf

White-beam collimating mirror at varying pitch angle
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

+-------------------------------+---------------------+---------------------+
|                               |      bare Si        |      Ir coating     |
+===============================+=====================+=====================+
| flux downstream of the mirror |    |vcmSi-FSM|      |    |vcmIr-FSM|      |
| with its energy spectrum      |    |vcmSi-FSMZ|     |    |vcmIr-FSMZ|     |
+-------------------------------+---------------------+---------------------+
| absorbed power in the mirror  |                     |                     |
| with its energy spectrum and  | |vcmSi-FootprintP|  | |vcmIr-FootprintP|  |
| power density isolines at 90% | |vcmSi-FootprintPZ| | |vcmIr-FootprintPZ| |
| of the maximum                |                     |                     |
+-------------------------------+---------------------+---------------------+

.. |vcmSi-FSM| image:: _images/vcmSi-FSM.swf
   :width: 300
   :height: 205
.. |vcmSi-FSMZ| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/vcmSi-FSM.swf
.. |vcmSi-FootprintP| image:: _images/vcmSi-FootprintP.swf
   :width: 310
   :height: 205
.. |vcmSi-FootprintPZ| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/vcmSi-FootprintP.swf
.. |vcmIr-FSM| image:: _images/vcmIr-FSM.swf
   :width: 300
   :height: 205
.. |vcmIr-FSMZ| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/vcmIr-FSM.swf
.. |vcmIr-FootprintP| image:: _images/vcmIr-FootprintP.swf
   :width: 310
   :height: 205
.. |vcmIr-FootprintPZ| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/vcmIr-FootprintP.swf

Bending of collimating mirror
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Shown are i) image downstream of the DCM and ii) image at the sample.

.. image:: _images/vcmR-DCM.swf
   :width: 312
   :height: 205
.. image:: _images/zoomIcon.png
   :width: 20
   :target: _images/vcmR-DCM.swf
.. image:: _images/vcmR-Sample.swf
   :width: 256
   :height: 205
.. image:: _images/zoomIcon.png
   :width: 20
   :target: _images/vcmR-Sample.swf

Bending of focusing mirror
~~~~~~~~~~~~~~~~~~~~~~~~~~

Shown is the image at the sample position.

.. image:: _images/vfmR-Sample.swf
   :width: 256
   :height: 206
.. image:: _images/zoomIcon.png
   :width: 20
   :target: _images/vfmR-Sample.swf

Both mirrors (collimating + focusing) at varying pitch angle
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
The sagittal radius of the focusing toroid mirror is optimal at 2 mrad pitch
angle.

.. image:: _images/pitch-Sample.swf
   :width: 226
   :height: 206
.. image:: _images/zoomIcon.png
   :width: 20
   :target: _images/pitch-Sample.swf

Scanning of Double Crystal Monochromator
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

+--------------------+--------------------+
|  |Si111| |Si111Z|  |  |Si311| |Si311Z|  |
+--------------------+--------------------+

.. |Si111| image:: _images/Si111.swf
   :width: 312
   :height: 205
.. |Si111Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/Si111.swf
.. |Si311| image:: _images/Si311.swf
   :width: 312
   :height: 205
.. |Si311Z| image:: _images/zoomIcon.png
   :width: 20
   :target: _images/Si311.swf
"""
pass
