# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: SKU of the application gateway resource.
    :type sku: ~azure.mgmt.network.v2019_02_01.models.ApplicationGatewaySku
    :param ssl_policy: SSL policy of the application gateway resource.
    :type ssl_policy:
     ~azure.mgmt.network.v2019_02_01.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway
     resource. Possible values include: 'Stopped', 'Starting', 'Running',
     'Stopping'
    :vartype operational_state: str or
     ~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayOperationalState
    :param gateway_ip_configurations: Subnets of the application gateway
     resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type gateway_ip_configurations:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayIPConfiguration]
    :param authentication_certificates: Authentication certificates of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type authentication_certificates:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayAuthenticationCertificate]
    :param trusted_root_certificates: Trusted Root certificates of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type trusted_root_certificates:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayTrustedRootCertificate]
    :param ssl_certificates: SSL certificates of the application gateway
     resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type ssl_certificates:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewaySslCertificate]
    :param frontend_ip_configurations: Frontend IP addresses of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayFrontendIPConfiguration]
    :param frontend_ports: Frontend ports of the application gateway resource.
     For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type frontend_ports:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayFrontendPort]
    :param probes: Probes of the application gateway resource.
    :type probes:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayProbe]
    :param backend_address_pools: Backend address pool of the application
     gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type backend_address_pools:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayBackendAddressPool]
    :param backend_http_settings_collection: Backend http settings of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayBackendHttpSettings]
    :param http_listeners: Http listeners of the application gateway resource.
     For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type http_listeners:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayHttpListener]
    :param url_path_maps: URL path map of the application gateway resource.
     For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type url_path_maps:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayUrlPathMap]
    :param request_routing_rules: Request routing rules of the application
     gateway resource.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayRequestRoutingRule]
    :param rewrite_rule_sets: Rewrite rules for the application gateway
     resource.
    :type rewrite_rule_sets:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayRewriteRuleSet]
    :param redirect_configurations: Redirect configurations of the application
     gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type redirect_configurations:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayRedirectConfiguration]
    :param web_application_firewall_configuration: Web application firewall
     configuration.
    :type web_application_firewall_configuration:
     ~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :param firewall_policy: Reference of the FirewallPolicy resource.
    :type firewall_policy: ~azure.mgmt.network.v2019_02_01.models.SubResource
    :param enable_http2: Whether HTTP2 is enabled on the application gateway
     resource.
    :type enable_http2: bool
    :param enable_fips: Whether FIPS is enabled on the application gateway
     resource.
    :type enable_fips: bool
    :param autoscale_configuration: Autoscale Configuration.
    :type autoscale_configuration:
     ~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayAutoscaleConfiguration
    :param resource_guid: Resource GUID property of the application gateway
     resource.
    :type resource_guid: str
    :param provisioning_state: Provisioning state of the application gateway
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param custom_error_configurations: Custom error configurations of the
     application gateway resource.
    :type custom_error_configurations:
     list[~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayCustomError]
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param zones: A list of availability zones denoting where the resource
     needs to come from.
    :type zones: list[str]
    :param identity: The identity of the application gateway, if configured.
    :type identity:
     ~azure.mgmt.network.v2019_02_01.models.ManagedServiceIdentity
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operational_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku'},
        'ssl_policy': {'key': 'properties.sslPolicy', 'type': 'ApplicationGatewaySslPolicy'},
        'operational_state': {'key': 'properties.operationalState', 'type': 'str'},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[ApplicationGatewayAuthenticationCertificate]'},
        'trusted_root_certificates': {'key': 'properties.trustedRootCertificates', 'type': '[ApplicationGatewayTrustedRootCertificate]'},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]'},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]'},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]'},
        'rewrite_rule_sets': {'key': 'properties.rewriteRuleSets', 'type': '[ApplicationGatewayRewriteRuleSet]'},
        'redirect_configurations': {'key': 'properties.redirectConfigurations', 'type': '[ApplicationGatewayRedirectConfiguration]'},
        'web_application_firewall_configuration': {'key': 'properties.webApplicationFirewallConfiguration', 'type': 'ApplicationGatewayWebApplicationFirewallConfiguration'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'enable_http2': {'key': 'properties.enableHttp2', 'type': 'bool'},
        'enable_fips': {'key': 'properties.enableFips', 'type': 'bool'},
        'autoscale_configuration': {'key': 'properties.autoscaleConfiguration', 'type': 'ApplicationGatewayAutoscaleConfiguration'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'custom_error_configurations': {'key': 'properties.customErrorConfigurations', 'type': '[ApplicationGatewayCustomError]'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, sku=None, ssl_policy=None, gateway_ip_configurations=None, authentication_certificates=None, trusted_root_certificates=None, ssl_certificates=None, frontend_ip_configurations=None, frontend_ports=None, probes=None, backend_address_pools=None, backend_http_settings_collection=None, http_listeners=None, url_path_maps=None, request_routing_rules=None, rewrite_rule_sets=None, redirect_configurations=None, web_application_firewall_configuration=None, firewall_policy=None, enable_http2: bool=None, enable_fips: bool=None, autoscale_configuration=None, resource_guid: str=None, provisioning_state: str=None, custom_error_configurations=None, etag: str=None, zones=None, identity=None, **kwargs) -> None:
        super(ApplicationGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.ssl_policy = ssl_policy
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.rewrite_rule_sets = rewrite_rule_sets
        self.redirect_configurations = redirect_configurations
        self.web_application_firewall_configuration = web_application_firewall_configuration
        self.firewall_policy = firewall_policy
        self.enable_http2 = enable_http2
        self.enable_fips = enable_fips
        self.autoscale_configuration = autoscale_configuration
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
        self.custom_error_configurations = custom_error_configurations
        self.etag = etag
        self.zones = zones
        self.identity = identity
