# This file auto-generated by `generate_schema_interface.py`.
# Do not modify this file directly.

import traitlets as T
from ..baseobject import BaseObject
from .config import Config
from .data import Data
from .transform import Transform
from .unitspec import UnitSpec


class LayerSpec(BaseObject):
    """Wrapper for Vega-Lite LayerSpec definition.
    
    Attributes
    ----------
    config: Config
        Configuration object.
    data: Data
        An object describing the data source.
    description: Unicode
        An optional description of this mark for commenting purpose.
    layers: List(UnitSpec)
        Unit specs that will be layered.
    name: Unicode
        Name of the visualization for later reference.
    transform: Transform
        An object describing filter and new field calculation.
    """
    config = T.Instance(Config, allow_none=True, default_value=None, help="""Configuration object.""")
    data = T.Instance(Data, allow_none=True, default_value=None, help="""An object describing the data source.""")
    description = T.Unicode(allow_none=True, default_value=None, help="""An optional description of this mark for commenting purpose.""")
    layers = T.List(T.Instance(UnitSpec), allow_none=True, default_value=None, help="""Unit specs that will be layered.""")
    name = T.Unicode(allow_none=True, default_value=None, help="""Name of the visualization for later reference.""")
    transform = T.Instance(Transform, allow_none=True, default_value=None, help="""An object describing filter and new field calculation.""")
    
    def __init__(self, config=None, data=None, description=None, layers=None, name=None, transform=None, **kwargs):
        kwds = dict(config=config, data=data, description=description, layers=layers, name=name, transform=transform)
        kwargs.update({k:v for k, v in kwds.items() if v is not None})
        super(LayerSpec, self).__init__(**kwargs)